/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.common.ability.impl;

import com.alibaba.boot.hsf.annotation.HSFProvider;
import com.alibaba.fastjson.JSON;
import com.tydic.fsc.bo.FscOrderItemDetailBO;
import com.tydic.fsc.common.ability.api.FscOrderItemDetailQueryAbilityService;
import com.tydic.fsc.common.ability.bo.FscOrderItemDetailQueryAbilityReqBO;
import com.tydic.fsc.common.ability.bo.FscOrderItemDetailQueryAbilityRspBO;
import com.tydic.fsc.dao.FscOrderItemMapper;
import com.tydic.fsc.dao.FscOrderMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.FscOrderItemPO;
import com.tydic.fsc.po.FscOrderPO;
import com.tydic.fsc.utils.BigDecimalConvert;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Collection;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;

@HSFProvider(serviceVersion="1.0.0", serviceGroup="FSC_GROUP_DEV", serviceInterface=FscOrderItemDetailQueryAbilityService.class)
public class FscOrderItemDetailQueryAbilityServiceImpl
implements FscOrderItemDetailQueryAbilityService {
    @Autowired
    private FscOrderItemMapper fscOrderItemMapper;
    @Autowired
    private FscOrderMapper fscOrderMapper;

    @BigDecimalConvert(value=2)
    public FscOrderItemDetailQueryAbilityRspBO queryOrderItemDetail(FscOrderItemDetailQueryAbilityReqBO reqBO) {
        if (null == reqBO) {
            throw new FscBusinessException("191000", "\u5165\u53c2\u5bf9\u8c61\u4e3a\u7a7a");
        }
        FscOrderItemPO fscOrderItemPO = new FscOrderItemPO();
        if (null != reqBO.getFscOrderId()) {
            fscOrderItemPO.setFscOrderId(reqBO.getFscOrderId());
        }
        if (!CollectionUtils.isEmpty((Collection)reqBO.getFscOrderIdList())) {
            fscOrderItemPO.setFscOrderIdList(reqBO.getFscOrderIdList());
        }
        List fscOrderItemPOS = this.fscOrderItemMapper.getList(fscOrderItemPO);
        List fscOrderItemDetailBOS = JSON.parseArray((String)JSON.toJSONString((Object)fscOrderItemPOS), FscOrderItemDetailBO.class);
        FscOrderPO fscOrderPO = new FscOrderPO();
        fscOrderPO.setFscOrderIds(reqBO.getFscOrderIdList());
        List fscOrderList = this.fscOrderMapper.getList(fscOrderPO);
        for (FscOrderItemDetailBO fscOrderItemDetailBO : fscOrderItemDetailBOS) {
            for (FscOrderPO orderPO : fscOrderList) {
                if (!orderPO.getFscOrderId().equals(fscOrderItemDetailBO.getFscOrderId())) continue;
                fscOrderItemDetailBO.setOrderNo(orderPO.getOrderNo());
                fscOrderItemDetailBO.setOrderDesc(orderPO.getOrderDesc());
                fscOrderItemDetailBO.setPurchaserName(orderPO.getPurchaserName());
                fscOrderItemDetailBO.setTaxCode(fscOrderItemDetailBO.getTaxCode());
                String productId = fscOrderItemDetailBO.getOrderItemId() + "-" + fscOrderItemDetailBO.getId();
                fscOrderItemDetailBO.setProductId(productId);
                String spec = fscOrderItemDetailBO.getSpec();
                String model = fscOrderItemDetailBO.getModel();
                String specModel = spec + "," + model;
                if (specModel.trim().equals(",")) {
                    specModel = "";
                }
                fscOrderItemDetailBO.setSpecModel(specModel);
                BigDecimal untaxPrice = fscOrderItemDetailBO.getUntaxAmt().divide(fscOrderItemDetailBO.getNum(), 3, RoundingMode.HALF_UP);
                fscOrderItemDetailBO.setUntaxPrice(untaxPrice);
            }
        }
        FscOrderItemDetailQueryAbilityRspBO fscOrderItemDetailQueryAbilityRspBO = new FscOrderItemDetailQueryAbilityRspBO();
        fscOrderItemDetailQueryAbilityRspBO.setFscOrderItemDetailBOS(fscOrderItemDetailBOS);
        return fscOrderItemDetailQueryAbilityRspBO;
    }
}

