/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.common.ability.impl;

import com.alibaba.boot.hsf.annotation.HSFProvider;
import com.alibaba.fastjson.JSON;
import com.tydic.fsc.bo.FscMerchantPayeeChannelDataBO;
import com.tydic.fsc.bo.FscPayChannelListQueryDataBo;
import com.tydic.fsc.busibase.atom.api.FscMerchantPayeeChannelAtomService;
import com.tydic.fsc.busibase.atom.bo.FscMerchantPayeeChannelAtomReqBO;
import com.tydic.fsc.busibase.atom.bo.FscMerchantPayeeChannelAtomRspBO;
import com.tydic.fsc.busibase.external.api.pay.FscPayTransPayInsService;
import com.tydic.fsc.busibase.external.api.pay.bo.FscPayTransPayInsReqBo;
import com.tydic.fsc.busibase.external.api.pay.bo.FscPayTransPayInsRspBo;
import com.tydic.fsc.common.ability.api.FscPayChannelListQueryAbilityService;
import com.tydic.fsc.common.ability.bo.FscPayChannelListQueryAbilityReqBO;
import com.tydic.fsc.common.ability.bo.FscPayChannelListQueryAbilityRspBO;
import com.tydic.fsc.util.FscRspUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@HSFProvider(serviceVersion="1.0.0", serviceGroup="FSC_GROUP_DEV", serviceInterface=FscPayChannelListQueryAbilityService.class)
public class FscPayChannelListQueryAbilityServiceImpl
implements FscPayChannelListQueryAbilityService {
    private static final Logger log = LoggerFactory.getLogger(FscPayChannelListQueryAbilityServiceImpl.class);
    @Autowired
    private FscMerchantPayeeChannelAtomService fscMerchantPayeeChannelAtomService;
    @Autowired
    private FscPayTransPayInsService fscPayTransPayInsService;

    public FscPayChannelListQueryAbilityRspBO query(FscPayChannelListQueryAbilityReqBO reqBo) {
        if (log.isDebugEnabled()) {
            log.debug("===\u7ed3\u7b97\u652f\u4ed8\u6e20\u9053\u5217\u8868\u67e5\u8be2\uff0c\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)reqBo));
        }
        FscPayChannelListQueryAbilityRspBO retBo = (FscPayChannelListQueryAbilityRspBO)FscRspUtil.getSuccessRspBo(FscPayChannelListQueryAbilityRspBO.class);
        retBo.setPageNo(reqBo.getPageNo());
        if (StringUtils.isEmpty((Object)reqBo.getMerchantId())) {
            log.error("\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027\uff1a\u5546\u6237Id[merchantId]\uff0c\u4e0d\u80fd\u4e3a\u7a7a");
            retBo.setRespCode("191130");
            retBo.setRespDesc("\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027\uff1a\u5546\u6237Id[merchantId]\uff0c\u4e0d\u80fd\u4e3a\u7a7a");
            return retBo;
        }
        ArrayList<FscPayChannelListQueryDataBo> rows = new ArrayList<FscPayChannelListQueryDataBo>();
        FscMerchantPayeeChannelAtomReqBO atomReqBo = new FscMerchantPayeeChannelAtomReqBO();
        BeanUtils.copyProperties((Object)reqBo, (Object)atomReqBo);
        FscMerchantPayeeChannelAtomRspBO atomRetBo = this.fscMerchantPayeeChannelAtomService.queryPage(atomReqBo);
        BeanUtils.copyProperties((Object)atomRetBo, (Object)retBo);
        if (CollectionUtils.isEmpty((Collection)atomRetBo.getRows())) {
            return retBo;
        }
        List channelDataBos = atomRetBo.getRows();
        List paymentInsId = channelDataBos.stream().map(item -> Long.valueOf(item.getPayChannel())).collect(Collectors.toList());
        FscPayTransPayInsReqBo transReqBo = new FscPayTransPayInsReqBo();
        transReqBo.setPaymentInsId(paymentInsId);
        FscPayTransPayInsRspBo transRetBo = this.fscPayTransPayInsService.tranPayIns(transReqBo);
        if (!"0000".equals(transRetBo.getRespCode())) {
            BeanUtils.copyProperties((Object)transRetBo, (Object)retBo);
            return retBo;
        }
        Map payInsMap = transRetBo.getPayInsMap();
        Map payMethodMap = transRetBo.getPayMethodMap();
        if (!CollectionUtils.isEmpty((Collection)channelDataBos)) {
            for (FscMerchantPayeeChannelDataBO dataBo : channelDataBos) {
                FscPayChannelListQueryDataBo queryDataBo = new FscPayChannelListQueryDataBo();
                BeanUtils.copyProperties((Object)dataBo, (Object)queryDataBo);
                queryDataBo.setPayChannelStr((String)payInsMap.get(queryDataBo.getPayChannel()));
                String[] payMethodStr = queryDataBo.getPayMethod().split(",");
                StringBuilder payMethodBuilder = new StringBuilder();
                for (int i = 0; i < payMethodStr.length; ++i) {
                    payMethodBuilder.append((String)payMethodMap.get(payMethodStr[i]));
                    if (i == payMethodStr.length - 1) continue;
                    payMethodBuilder.append(",");
                }
                queryDataBo.setPayMethodStr(payMethodBuilder.toString());
                rows.add(queryDataBo);
            }
        }
        retBo.setRows(rows);
        if (log.isDebugEnabled()) {
            log.debug("===\u7ed3\u7b97\u652f\u4ed8\u6e20\u9053\u5217\u8868\u67e5\u8be2\uff0c\u51fa\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)retBo));
        }
        return retBo;
    }
}

