/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.common.ability.impl;

import com.alibaba.boot.hsf.annotation.HSFProvider;
import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.db.Page;
import com.tydic.fsc.bo.FscStockBO;
import com.tydic.fsc.common.ability.api.FscStockListQryAbilityService;
import com.tydic.fsc.common.ability.bo.FscStockListQryAbilityReqBO;
import com.tydic.fsc.common.ability.bo.FscStockListQryAbilityRspBO;
import com.tydic.fsc.dao.FscStockMapper;
import com.tydic.fsc.po.FscStockPO;
import com.tydic.fsc.utils.BigDecimalConvert;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;

@HSFProvider(serviceVersion="1.0.0", serviceGroup="FSC_GROUP_DEV", serviceInterface=FscStockListQryAbilityService.class)
public class FscStockListQryAbilityServiceImpl
implements FscStockListQryAbilityService {
    @Autowired
    private FscStockMapper fscStockMapper;

    @BigDecimalConvert(value=2)
    public FscStockListQryAbilityRspBO qryStockList(FscStockListQryAbilityReqBO reqBO) {
        FscStockPO fscStockPO = (FscStockPO)JSON.parseObject((String)JSON.toJSONString((Object)reqBO), FscStockPO.class);
        fscStockPO.setOrderNo(reqBO.getFscOrderNo());
        Page page = new Page();
        page.setPageNo(reqBO.getPageNo().intValue());
        page.setPageSize(reqBO.getPageSize().intValue());
        List fscStockPageList = this.fscStockMapper.getListPage(fscStockPO, page);
        if (CollectionUtils.isEmpty((Collection)fscStockPageList)) {
            return new FscStockListQryAbilityRspBO();
        }
        List fscStockBOList = JSON.parseArray((String)JSON.toJSONString((Object)fscStockPageList), FscStockBO.class);
        Map<Long, FscStockPO> fscStockMap = fscStockPageList.stream().collect(Collectors.toMap(FscStockPO::getId, m -> m));
        for (FscStockBO fscStockBO : fscStockBOList) {
            fscStockBO.setFscOrderNo(fscStockMap.get(fscStockBO.getId()).getOrderNo());
        }
        FscStockListQryAbilityRspBO rspBO = new FscStockListQryAbilityRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        rspBO.setRows(fscStockBOList);
        rspBO.setPageNo(reqBO.getPageNo());
        rspBO.setRecordsTotal(Integer.valueOf(page.getTotalCount()));
        rspBO.setTotal(Integer.valueOf(page.getTotalCount()));
        return rspBO;
    }
}

