/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.common.busi.impl;

import cn.hutool.core.convert.Convert;
import com.tydic.fsc.bo.FscMerchantConfDataBO;
import com.tydic.fsc.busibase.external.api.bo.FscUmcGetSignContractApplyDetailReqBo;
import com.tydic.fsc.busibase.external.api.bo.FscUmcGetSignContractApplyDetailRspBo;
import com.tydic.fsc.busibase.external.api.umc.FscUmcGetSignContractApplyDetailService;
import com.tydic.fsc.common.ability.bo.FscMerchantConfBatchQueryReqDataBO;
import com.tydic.fsc.common.busi.api.FscMerchantConfBatchQueryBusiService;
import com.tydic.fsc.common.busi.bo.FscMerchantConfBatchQueryBusiReqBO;
import com.tydic.fsc.common.busi.bo.FscMerchantConfBatchQueryBusiRspBO;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscMerchantMapper;
import com.tydic.fsc.dao.FscSkuCategoryMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.FscMerchantPO;
import com.tydic.fsc.po.FscSkuCategoryPO;
import com.tydic.fsc.util.FscRspUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service(value="fscMerchantConfBatchQueryBusiService")
public class FscMerchantConfBatchQueryBusiServiceImpl
implements FscMerchantConfBatchQueryBusiService {
    private static final Logger log = LoggerFactory.getLogger(FscMerchantConfBatchQueryBusiServiceImpl.class);
    @Autowired
    private FscMerchantMapper fscMerchantMapper;
    @Autowired
    private FscSkuCategoryMapper fscSkuCategoryMapper;
    @Autowired
    private FscUmcGetSignContractApplyDetailService fscUmcGetSignContractApplyDetailService;

    @Override
    public FscMerchantConfBatchQueryBusiRspBO queryConfBatch(FscMerchantConfBatchQueryBusiReqBO reqBO) {
        FscMerchantConfBatchQueryBusiRspBO retBo = (FscMerchantConfBatchQueryBusiRspBO)FscRspUtil.getSuccessRspBo(FscMerchantConfBatchQueryBusiRspBO.class);
        ArrayList<FscMerchantConfDataBO> config = new ArrayList<FscMerchantConfDataBO>();
        retBo.setConfig(config);
        List<FscMerchantConfBatchQueryReqDataBO> queryParams = reqBO.getQueryParams();
        ArrayList<FscMerchantPO> queryPos = new ArrayList<FscMerchantPO>();
        for (FscMerchantConfBatchQueryReqDataBO param : queryParams) {
            FscMerchantPO queryPo = new FscMerchantPO();
            queryPo.setOrgId(param.getSupOrgId());
            queryPo.setStatus(FscConstants.MerchantStatus.VALID);
            queryPo.setDelFlag(FscConstants.MerchantDeleteFlag.NO);
            queryPo.setExceptionFlag(FscConstants.MerchantIsException.MERCHANT_NOT_EXCEPTION);
            queryPos.add(queryPo);
        }
        List resultPos = this.fscMerchantMapper.selectModelSettleBatch(queryPos);
        if (CollectionUtils.isEmpty((Collection)resultPos)) {
            log.info("\u6279\u91cf\u67e5\u8be2\u4e3b\u5546\u6237\u7ed3\u679c\u4e3a\u7a7a");
            retBo.setRespDesc("\u6279\u91cf\u67e5\u8be2\u4e3b\u5546\u6237\u7ed3\u679c\u4e3a\u7a7a");
            return retBo;
        }
        Map<Long, FscMerchantPO> mainMerchantMap = resultPos.stream().collect(Collectors.toMap(FscMerchantPO::getOrgId, item -> item));
        for (FscMerchantConfBatchQueryReqDataBO param : queryParams) {
            FscMerchantConfDataBO configData = new FscMerchantConfDataBO();
            BeanUtils.copyProperties((Object)param, (Object)configData);
            FscMerchantPO mainMerchant = mainMerchantMap.get(param.getSupOrgId());
            if (null == mainMerchant) {
                configData.setFailReason("\u672a\u67e5\u8be2\u5230\u673a\u6784[" + param.getSupOrgId() + "]\u7684\u5546\u6237\u4fe1\u606f");
                continue;
            }
            configData.setModelSettle(mainMerchant.getModelSettle());
            this.qryExtConfig(param, configData, mainMerchant);
            config.add(configData);
        }
        return retBo;
    }

    private void qryExtConfig(FscMerchantConfBatchQueryReqDataBO param, FscMerchantConfDataBO configData, FscMerchantPO mainMerchant) {
        if (FscConstants.MerchantAllowException.YES.equals(mainMerchant.getModelAllowExceptionFlag()) && null != param.getPurOrgId()) {
            FscMerchantPO queryModelPo = new FscMerchantPO();
            queryModelPo.setOrgId(param.getSupOrgId());
            queryModelPo.setParentId(mainMerchant.getMerchantId());
            queryModelPo.setDelFlag(FscConstants.MerchantDeleteFlag.NO);
            queryModelPo.setStatus(FscConstants.MerchantStatus.DRAFT);
            queryModelPo.setExceptionFlag(FscConstants.MerchantIsException.MERCHANT_IS_EXCEPTION);
            queryModelPo.setModelObjId(param.getPurOrgId());
            FscMerchantPO fscMerchantPO = this.fscMerchantMapper.getModelBy(queryModelPo);
            if (null == fscMerchantPO && !StringUtils.isEmpty((Object)param.getUserIdentity())) {
                queryModelPo.setModelObjId(null);
                queryModelPo.setModelUserIdentity(Convert.toInt((Object)param.getUserIdentity()));
                fscMerchantPO = this.fscMerchantMapper.getModelBy(queryModelPo);
            }
            if (null != fscMerchantPO) {
                if (FscConstants.MerchantModelSceneRange.CONTRACT.equals(fscMerchantPO.getModelSceneRange())) {
                    List itemCatIds;
                    FscUmcGetSignContractApplyDetailReqBo fscUmcGetSignContractApplyDetailReqBo = new FscUmcGetSignContractApplyDetailReqBo();
                    fscUmcGetSignContractApplyDetailReqBo.setApplyId(fscMerchantPO.getModelContractId());
                    FscUmcGetSignContractApplyDetailRspBo signContractApplyDetail = this.fscUmcGetSignContractApplyDetailService.getSignContractApplyDetail(fscUmcGetSignContractApplyDetailReqBo);
                    if (!"0000".equals(signContractApplyDetail.getRespCode())) {
                        throw new FscBusinessException(signContractApplyDetail.getRespCode(), signContractApplyDetail.getRespDesc());
                    }
                    if (!CollectionUtils.isEmpty((Collection)signContractApplyDetail.getSignSalesCategoryApplies()) && (itemCatIds = signContractApplyDetail.getSignSalesCategoryApplies().stream().map(applyBo -> Convert.toStr((Object)applyBo.getItemCatId())).distinct().collect(Collectors.toList())).contains(param.getCommodityTypeId())) {
                        configData.setModelSettle(fscMerchantPO.getModelSettle());
                    }
                } else {
                    List itemCatIds;
                    FscSkuCategoryPO fscSkuCategoryPO = new FscSkuCategoryPO();
                    fscSkuCategoryPO.setMerchantId(fscMerchantPO.getMerchantId());
                    List skuCategoryList = this.fscSkuCategoryMapper.getList(fscSkuCategoryPO);
                    if (!CollectionUtils.isEmpty((Collection)skuCategoryList) && (itemCatIds = skuCategoryList.stream().map(FscSkuCategoryPO::getCategoryTreePath).collect(Collectors.toList())).contains(param.getCommodityTypeId())) {
                        configData.setModelSettle(fscMerchantPO.getModelSettle());
                    }
                }
            }
        }
    }
}

