/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.common.atom.impl;

import cn.hutool.core.convert.Convert;
import com.ohaotian.plugin.common.util.DateUtils;
import com.tydic.fsc.busibase.atom.api.FscOrderCancelAtomService;
import com.tydic.fsc.busibase.atom.api.FscOrderInfoPushAtomService;
import com.tydic.fsc.busibase.atom.api.FscOrderStatusFlowAtomService;
import com.tydic.fsc.busibase.atom.bo.FscInvoiceBO;
import com.tydic.fsc.busibase.atom.bo.FscOrderInfoPushAtomReqBO;
import com.tydic.fsc.busibase.atom.bo.FscOrderStatusFlowAtomReqBO;
import com.tydic.fsc.busibase.atom.bo.FscOrderStatusFlowAtomRspBO;
import com.tydic.fsc.common.atom.api.FscComOrderApprovalAtomService;
import com.tydic.fsc.common.atom.bo.FscComOrderApprovalAtomReqBO;
import com.tydic.fsc.common.atom.bo.FscComOrderApprovalAtomRspBO;
import com.tydic.fsc.constants.FscBillStatus;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscAttachmentMapper;
import com.tydic.fsc.dao.FscInvoiceMapper;
import com.tydic.fsc.dao.FscOrderInvoiceMapper;
import com.tydic.fsc.dao.FscOrderMapper;
import com.tydic.fsc.dao.FscOrderPayItemMapper;
import com.tydic.fsc.dao.FscShouldPayMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.FscAttachmentPO;
import com.tydic.fsc.po.FscInvoicePO;
import com.tydic.fsc.po.FscOrderInvoicePO;
import com.tydic.fsc.po.FscOrderPO;
import com.tydic.fsc.po.FscOrderPayItemPO;
import com.tydic.fsc.po.FscShouldPayPO;
import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class FscComOrderApprovalAtomServiceImpl
implements FscComOrderApprovalAtomService {
    private static final Logger log = LoggerFactory.getLogger(FscComOrderApprovalAtomServiceImpl.class);
    public static final String BUSI_NAME = "\u4e3b\u5355\u5ba1\u6279";
    public static final String BUSI_CODE = "1009";
    @Autowired
    private FscOrderStatusFlowAtomService fscOrderStatusFlowAtomService;
    @Autowired
    private FscOrderMapper fscOrderMapper;
    @Autowired
    private FscOrderCancelAtomService fscOrderCancelAtomService;
    @Autowired
    private FscShouldPayMapper fscShouldPayMapper;
    @Autowired
    private FscOrderPayItemMapper fscOrderPayItemMapper;
    @Autowired
    private FscOrderInvoiceMapper fscOrderInvoiceMapper;
    @Autowired
    private FscInvoiceMapper fscInvoiceMapper;
    @Autowired
    private FscAttachmentMapper fscAttachmentMapper;
    @Autowired
    private FscOrderInfoPushAtomService fscOrderInfoPushAtomService;
    public static final Integer PASS = 1;
    @Value(value="${fscEnableSynToSwitch:false}")
    private Boolean fscEnableSynToSwitch;

    @Override
    public FscComOrderApprovalAtomRspBO dealOrderApproval(FscComOrderApprovalAtomReqBO reqBO) {
        FscOrderPO fscOrderPo = new FscOrderPO();
        fscOrderPo.setFscOrderId(reqBO.getOrderId());
        FscOrderPO fscOrder = this.fscOrderMapper.getModelBy(fscOrderPo);
        if (!FscBillStatus.TO_BE_APPROVAL.getCode().equals(fscOrder.getOrderState())) {
            throw new FscBusinessException("191124", "\u5f53\u524d\u7ed3\u7b97\u5355\u4e0d\u4e3a\u5f85\u5ba1\u6279\u72b6\u6001");
        }
        reqBO.setOrderFlow(fscOrder.getOrderFlow());
        reqBO.setOrderState(fscOrder.getOrderState());
        reqBO.setActualAmount(fscOrder.getActualAmount());
        reqBO.setFscOrder(fscOrder);
        HashMap<String, Object> paramMap = new HashMap<String, Object>(4);
        if (PASS.equals(reqBO.getAuditResult())) {
            if (null != reqBO.getActualAmount() && BigDecimal.ZERO.compareTo(reqBO.getActualAmount()) == 0) {
                paramMap.put("orderFinish", "1");
                paramMap.put("auditResult", FscConstants.AuditResultFlagKey.COMPLETED);
            } else {
                paramMap.put("auditResult", FscConstants.AuditResultFlagKey.PASS);
            }
        } else {
            paramMap.put("auditResult", FscConstants.AuditResultFlagKey.REFUSE);
        }
        FscOrderStatusFlowAtomReqBO flowAtomReqBO = new FscOrderStatusFlowAtomReqBO();
        flowAtomReqBO.setOrderId(reqBO.getOrderId());
        flowAtomReqBO.setCurStatus(reqBO.getOrderState());
        flowAtomReqBO.setBusiName(BUSI_NAME);
        flowAtomReqBO.setBusiCode(BUSI_CODE);
        flowAtomReqBO.setParamMap(paramMap);
        flowAtomReqBO.setUserId(reqBO.getUserId());
        flowAtomReqBO.setUserName(reqBO.getUserName());
        FscOrderStatusFlowAtomRspBO flowAtomRspBO = this.fscOrderStatusFlowAtomService.dealStatusFlow(flowAtomReqBO);
        if (!"0000".equals(flowAtomRspBO.getRespCode())) {
            throw new FscBusinessException("193108", flowAtomRspBO.getRespDesc());
        }
        if (!PASS.equals(reqBO.getAuditResult())) {
            reqBO.setOrderState(FscBillStatus.MAIN_ORDER_CANCELLATION.getCode());
            this.dismissalProcess(reqBO);
        } else {
            if (this.fscEnableSynToSwitch.booleanValue()) {
                this.pushFscOrder(reqBO.getOrderId());
            }
            this.updateMaxConfirmTime(reqBO);
        }
        return new FscComOrderApprovalAtomRspBO();
    }

    private void pushFscOrder(Long orderId) {
        FscOrderInfoPushAtomReqBO qryOrderInfoAtomReqBO = new FscOrderInfoPushAtomReqBO();
        qryOrderInfoAtomReqBO.setFscOrderId(orderId);
        qryOrderInfoAtomReqBO.setSendService(this.getClass().getName());
        this.setFscOrderInfo(orderId, qryOrderInfoAtomReqBO);
        this.fscOrderInfoPushAtomService.dealPushFscOrderInfo(qryOrderInfoAtomReqBO);
    }

    private void setFscOrderInfo(Long fscOrderId, FscOrderInfoPushAtomReqBO fscOrderInfoPushAtomReqBO) {
        FscOrderPO fscOrderWhere = new FscOrderPO();
        fscOrderWhere.setFscOrderId(fscOrderId);
        FscOrderPO fscOrderPO = this.fscOrderMapper.getModelBy(fscOrderWhere);
        fscOrderInfoPushAtomReqBO.setFscOrderId(fscOrderPO.getFscOrderId());
        fscOrderInfoPushAtomReqBO.setTotalCharge(fscOrderPO.getTotalCharge());
        fscOrderInfoPushAtomReqBO.setSupplierId(fscOrderPO.getSupplierId());
        fscOrderInfoPushAtomReqBO.setSupplierName(fscOrderPO.getSupplierName());
        fscOrderInfoPushAtomReqBO.setPurchaserId(fscOrderPO.getPurchaserId());
        fscOrderInfoPushAtomReqBO.setPurchaserName(fscOrderPO.getPurchaserName());
        FscInvoicePO fscInvoiceWhere = new FscInvoicePO();
        fscInvoiceWhere.setFscOrderId(fscOrderId);
        List fscInvoiceList = this.fscInvoiceMapper.getList(fscInvoiceWhere);
        List fscInvoiceBOList = fscInvoiceList.stream().map(e -> {
            FscInvoiceBO fscInvoiceBO = new FscInvoiceBO();
            fscInvoiceBO.setInvoiceCode(e.getInvoiceCode());
            fscInvoiceBO.setInvoiceNo(e.getInvoiceNo());
            fscInvoiceBO.setBillDate(e.getBillDate());
            fscInvoiceBO.setBuyName(e.getBuyName());
            fscInvoiceBO.setAmt(e.getAmt());
            fscInvoiceBO.setUntaxAmt(e.getUntaxAmt());
            fscInvoiceBO.setTaxAmt(e.getTaxAmt());
            return fscInvoiceBO;
        }).collect(Collectors.toList());
        fscOrderInfoPushAtomReqBO.setFscExtInvoiceBOList(fscInvoiceBOList);
    }

    private void updateMaxConfirmTime(FscComOrderApprovalAtomReqBO reqBO) {
        if (!FscConstants.OrderFlow.INVOICE.equals(reqBO.getFscOrder().getOrderFlow()) && !FscConstants.OrderFlow.PAY.equals(reqBO.getFscOrder().getOrderFlow())) {
            FscOrderPO fscOrder = new FscOrderPO();
            fscOrder.setFscOrderId(reqBO.getFscOrder().getFscOrderId());
            fscOrder.setCreditConfirmDueDate(DateUtils.getDate((Date)new Date(), (Integer)Convert.toInt((Object)reqBO.getFscOrder().getCreditConfirmDueDay(), (Integer)1)));
            this.fscOrderMapper.updateById(fscOrder);
        }
    }

    private void dismissalProcess(FscComOrderApprovalAtomReqBO reqBO) {
        if (FscConstants.OrderFlow.PAY.equals(reqBO.getOrderFlow())) {
            this.paymentRejectionProcess(reqBO);
        } else if (FscConstants.OrderFlow.MONTH_SERVICE_FEE.equals(reqBO.getOrderFlow()) || FscConstants.OrderFlow.YEAR_ACCEPT_SERVICE_FEE.equals(reqBO.getOrderFlow()) || FscConstants.OrderFlow.YEAR_ORDER_SERVICE_FEE.equals(reqBO.getOrderFlow()) || FscConstants.OrderFlow.PL_SERVICE_FEE.equals(reqBO.getOrderFlow())) {
            this.serviceFeeRejectionProcess(reqBO);
        } else if (FscConstants.OrderFlow.INVOICE.equals(reqBO.getOrderFlow())) {
            FscOrderInvoicePO fscOrderInvoicePo = new FscOrderInvoicePO();
            fscOrderInvoicePo.setFscOrderId(reqBO.getOrderId());
            this.fscOrderInvoiceMapper.updateSignInfo(fscOrderInvoicePo);
            FscInvoicePO fscInvoicePOwhere = new FscInvoicePO();
            fscInvoicePOwhere.setFscOrderId(reqBO.getOrderId());
            FscInvoicePO fscInvoicePOSet = new FscInvoicePO();
            fscInvoicePOSet.setDelFlag(FscConstants.YesOrNoEnum.YES.getCode());
            this.fscInvoiceMapper.updateBy(fscInvoicePOSet, fscInvoicePOwhere);
            FscAttachmentPO fscAttachmentPoWhere = new FscAttachmentPO();
            fscAttachmentPoWhere.setFscOrderId(reqBO.getOrderId());
            FscAttachmentPO fscAttachmentPoSet = new FscAttachmentPO();
            fscAttachmentPoSet.setDelFlag(FscConstants.YesOrNoEnum.YES.getCode());
            this.fscAttachmentMapper.updateBy(fscAttachmentPoSet, fscAttachmentPoWhere);
        }
    }

    private void serviceFeeRejectionProcess(FscComOrderApprovalAtomReqBO reqBO) {
        FscOrderPO set = new FscOrderPO();
        set.setCreditAmount(BigDecimal.ZERO);
        set.setFscOrderId(reqBO.getOrderId());
        int i = this.fscOrderMapper.updateByOrderId(set);
        if (i != 1) {
            throw new FscBusinessException("193108", "\u66f4\u65b0\u6570\u636e\u5e93\u51fa\u9519");
        }
    }

    private void paymentRejectionProcess(FscComOrderApprovalAtomReqBO reqBO) {
        FscOrderPayItemPO fscOrderPayItemPo = new FscOrderPayItemPO();
        fscOrderPayItemPo.setFscOrderId(reqBO.getOrderId());
        List fscOrderPayItemPos = this.fscOrderPayItemMapper.getList(fscOrderPayItemPo);
        Date now = new Date();
        for (FscOrderPayItemPO orderPayItemPo : fscOrderPayItemPos) {
            FscShouldPayPO fscShouldPayPO = new FscShouldPayPO();
            fscShouldPayPO.setShouldPayId(orderPayItemPo.getShouldPayId());
            fscShouldPayPO.setPayAmt(orderPayItemPo.getPayAmount());
            fscShouldPayPO.setUpdateTime(now);
            fscShouldPayPO.setUpdateOperId(Convert.toStr((Object)reqBO.getUserId()));
            fscShouldPayPO.setUpdateOperName(reqBO.getName());
            int i = this.fscShouldPayMapper.updatePayingAmt(fscShouldPayPO);
            if (i == 1) continue;
            throw new FscBusinessException("193108", "\u66f4\u65b0\u6570\u636e\u5e93\u51fa\u9519");
        }
    }
}

