/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.common.ability.impl;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.db.Page;
import com.tydic.fsc.bo.FscCashierDataBO;
import com.tydic.fsc.common.ability.api.FscCashierPageQryAbilityService;
import com.tydic.fsc.common.ability.bo.FscCashierPageQryAbilityReqBO;
import com.tydic.fsc.common.ability.bo.FscCashierPageQryAbilityRspBO;
import com.tydic.fsc.dao.FscDicDictionaryMapper;
import com.tydic.fsc.po.FscDicDictionaryPO;
import com.tydic.fsc.util.FscRspUtil;
import com.tydic.payment.pay.atom.CashierTemplateAtomService;
import com.tydic.payment.pay.dao.po.CashierTemplatePageReqPO;
import com.tydic.payment.pay.dao.po.CashierTemplatePo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.fsc.common.ability.api.FscCashierPageQryAbilityService"})
public class FscCashierPageQryAbilityServiceImpl
implements FscCashierPageQryAbilityService {
    private static final Logger log = LoggerFactory.getLogger(FscCashierPageQryAbilityServiceImpl.class);
    @Autowired
    private CashierTemplateAtomService cashierTemplateAtomService;
    @Autowired
    private FscDicDictionaryMapper fscDicDictionaryMapper;

    @PostMapping(value={"queryCashier"})
    public FscCashierPageQryAbilityRspBO queryCashier(@RequestBody FscCashierPageQryAbilityReqBO reqBO) {
        if (log.isDebugEnabled()) {
            log.debug("\u6536\u94f6\u53f0\u5206\u9875\u67e5\u8be2\u5f00\u59cb\uff1a{}", (Object)JSON.toJSONString((Object)reqBO));
        }
        FscCashierPageQryAbilityRspBO retBo = (FscCashierPageQryAbilityRspBO)FscRspUtil.getSuccessRspBo(FscCashierPageQryAbilityRspBO.class);
        ArrayList<FscCashierDataBO> rows = new ArrayList<FscCashierDataBO>();
        retBo.setRows(rows);
        retBo.setPageNo(reqBO.getPageNo());
        Page page = new Page(reqBO.getPageNo().intValue(), reqBO.getPageSize().intValue());
        CashierTemplatePageReqPO qryPo = new CashierTemplatePageReqPO();
        BeanUtils.copyProperties((Object)reqBO, (Object)qryPo);
        if (!StringUtils.isEmpty((Object)reqBO.getCreateOperName())) {
            qryPo.setCreateOperId(reqBO.getCreateOperName());
        }
        if (!StringUtils.isEmpty((Object)reqBO.getUpdateOperName())) {
            qryPo.setUpdateOperId(reqBO.getUpdateOperName());
        }
        if (!CollectionUtils.isEmpty((Collection)reqBO.getCashierId())) {
            qryPo.setCashierId(reqBO.getCashierId().stream().map(item -> Long.valueOf(item)).collect(Collectors.toList()));
        }
        List cashierPoList = this.cashierTemplateAtomService.queryCashierTemplateBetweenTimeWithPage(qryPo, page, reqBO.getCreateTimeStart(), reqBO.getCreateTimeEnd(), reqBO.getUpdateTimeStart(), reqBO.getUpdateTimeEnd());
        retBo.setRecordsTotal(Integer.valueOf(page.getTotalCount()));
        retBo.setTotal(Integer.valueOf(page.getTotalPages()));
        if (CollectionUtils.isEmpty((Collection)cashierPoList)) {
            return retBo;
        }
        Map<String, Map<String, String>> dicMap = this.getDicMap();
        for (CashierTemplatePo templatePo : cashierPoList) {
            FscCashierDataBO dataBo = new FscCashierDataBO();
            BeanUtils.copyProperties((Object)templatePo, (Object)dataBo);
            dataBo.setCreateOperName(templatePo.getCreateOperId());
            dataBo.setUpdateOperName(templatePo.getUpdateOperId());
            dataBo.setFlagDesc(dicMap.get("CASHIER_TEMPLATE_FLAG").get(templatePo.getFlag()));
            dataBo.setReqWayDesc(dicMap.get("CASHIER_REQ_WAY").get(templatePo.getReqWay()));
            rows.add(dataBo);
        }
        if (log.isDebugEnabled()) {
            log.debug("\u6536\u94f6\u53f0\u5206\u9875\u67e5\u8be2\u7ed3\u675f\uff1a{}", (Object)JSON.toJSONString((Object)retBo));
        }
        return retBo;
    }

    private Map<String, Map<String, String>> getDicMap() {
        HashMap<String, Map<String, String>> dicMap = new HashMap<String, Map<String, String>>(16);
        ArrayList<String> dicPCodes = new ArrayList<String>();
        dicPCodes.add("CASHIER_REQ_WAY");
        dicPCodes.add("CASHIER_TEMPLATE_FLAG");
        FscDicDictionaryPO queryPo = new FscDicDictionaryPO();
        queryPo.setSysCode("FSC");
        for (String pCode : dicPCodes) {
            queryPo.setPCode(pCode);
            List dicDictionaryPos = this.fscDicDictionaryMapper.getListByCondition(queryPo);
            Map<String, String> map = dicDictionaryPos.stream().collect(Collectors.toMap(FscDicDictionaryPO::getCode, fscDicDictionaryPO -> fscDicDictionaryPO.getTitle()));
            dicMap.put(pCode, map);
        }
        return dicMap;
    }

    private Page<CashierTemplatePageReqPO> getPage(FscCashierPageQryAbilityReqBO reqBo) {
        Page page;
        if (reqBo.getPageNo() > 1) {
            page = new Page(reqBo.getPageNo().intValue(), reqBo.getPageSize().intValue());
        } else {
            page = new Page();
            BeanUtils.copyProperties((Object)reqBo, (Object)page);
            if (page.getPageNo() < 1) {
                page.setPageNo(1);
            }
            if (page.getPageSize() < 1) {
                page.setPageSize(10);
            }
        }
        return page;
    }
}

