/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.common.ability.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import com.ohaotian.plugin.mq.proxy.ProxySendResult;
import com.tydic.fsc.busibase.busi.api.FscOrderFailLogUpdateBusiService;
import com.tydic.fsc.busibase.busi.bo.FscOrderFailLogUpdateBusiReqBO;
import com.tydic.fsc.common.ability.api.FscComOrderSyncAbilityService;
import com.tydic.fsc.common.ability.bo.FscComOrderListSyncAbilityReqBO;
import com.tydic.fsc.common.consumer.bo.FscSyncReqBO;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscOrderMapper;
import com.tydic.fsc.po.FscOrderPO;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class FscComOrderSyncAbilityServiceImpl
implements FscComOrderSyncAbilityService {
    @Autowired
    private FscOrderMapper fscOrderMapper;
    @Resource(name="fscSyncOrderListMqServiceProvider")
    private ProxyMessageProducer fscSyncOrderListMqServiceProvider;
    @Value(value="${es.FSC_SYNC_TOPIC}")
    private String topic;
    @Value(value="${es.FSC_SYNC_TAG}")
    private String tag;
    @Autowired
    private FscOrderFailLogUpdateBusiService fscOrderFailLogUpdateBusiService;

    public void dealComOrderSyncEs(FscComOrderListSyncAbilityReqBO reqBO) {
        FscSyncReqBO fscSyncReqBO = new FscSyncReqBO();
        fscSyncReqBO.setFscOrderId(reqBO.getFscOrderId());
        fscSyncReqBO.setCreateTime(reqBO.getCreateTime());
        fscSyncReqBO.setSendService(reqBO.getSendService());
        ProxySendResult proxySendResult = this.fscSyncOrderListMqServiceProvider.send(new ProxyMessage(this.topic, this.tag, JSONObject.toJSONString((Object)fscSyncReqBO)));
        if (!"SEND_OK".equals(proxySendResult.getStatus())) {
            this.writeFailLog(reqBO, JSONObject.toJSONString((Object)proxySendResult));
        }
    }

    private void writeFailLog(FscComOrderListSyncAbilityReqBO reqBO, String errDesc) {
        FscOrderFailLogUpdateBusiReqBO fscOrderFailLogUpdateBusiReqBO = new FscOrderFailLogUpdateBusiReqBO();
        fscOrderFailLogUpdateBusiReqBO.setObjId(reqBO.getFscOrderId());
        fscOrderFailLogUpdateBusiReqBO.setBusiFailDesc(errDesc);
        fscOrderFailLogUpdateBusiReqBO.setBusiType(FscConstants.FscOrderFailRetansBusiType.FSC_ORDER_SYNC_ES);
        this.fscOrderFailLogUpdateBusiService.dealInsert(fscOrderFailLogUpdateBusiReqBO);
    }

    public void syncAllComOrderList() {
        FscOrderPO fscOrderPO = new FscOrderPO();
        List fscOrderList = this.fscOrderMapper.getList(fscOrderPO);
        if (!CollectionUtils.isEmpty((Collection)fscOrderList)) {
            for (FscOrderPO orderPO : fscOrderList) {
                FscSyncReqBO fscSyncReqBO = new FscSyncReqBO();
                fscSyncReqBO.setFscOrderId(orderPO.getFscOrderId());
                ProxySendResult proxySendResult = this.fscSyncOrderListMqServiceProvider.send(new ProxyMessage(this.topic, this.tag, JSONObject.toJSONString((Object)fscSyncReqBO)));
                if ("SEND_OK".equals(proxySendResult.getStatus())) continue;
                FscComOrderListSyncAbilityReqBO fscComOrderListSyncAbilityReqBO = new FscComOrderListSyncAbilityReqBO();
                fscComOrderListSyncAbilityReqBO.setFscOrderId(orderPO.getFscOrderId());
                this.writeFailLog(fscComOrderListSyncAbilityReqBO, JSON.toJSONString((Object)proxySendResult));
            }
        }
    }
}

