/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.common.ability.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.tydic.fsc.busibase.atom.api.FscOrderInfoPushAtomService;
import com.tydic.fsc.busibase.atom.bo.FscOrderInfoPushAtomReqBO;
import com.tydic.fsc.busibase.busi.api.FscSystemBusiLogBusiService;
import com.tydic.fsc.busibase.busi.bo.FscSystemBusiLogBusiServiceReqBo;
import com.tydic.fsc.common.ability.api.FscOrderInfoPushAbilityService;
import com.tydic.fsc.common.ability.bo.FscOrderInfoPushAbilityReqBO;
import com.tydic.fsc.common.ability.bo.FscOrderInfoPushAbilityRspBO;
import com.tydic.fsc.common.ability.bo.FscOrderInfoPushBO;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.exception.FscBusinessException;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.fsc.common.ability.api.FscOrderInfoPushAbilityService"})
public class FscOrderInfoPushAbilityServiceImpl
implements FscOrderInfoPushAbilityService {
    private static final Logger log = LoggerFactory.getLogger(FscOrderInfoPushAbilityServiceImpl.class);
    @Autowired
    private FscOrderInfoPushAtomService fscOrderInfoPushAtomService;
    @Autowired
    private FscSystemBusiLogBusiService fscSystemBusiLogBusiService;
    @Value(value="${systemBusiLog.failureCount:10}")
    private Integer failureCount;

    @PostMapping(value={"dealFscOrderInfoPush"})
    public FscOrderInfoPushAbilityRspBO dealFscOrderInfoPush(@RequestBody FscOrderInfoPushAbilityReqBO reqBO) {
        this.check(reqBO);
        List orderInfoPushList = reqBO.getFscOrderInfoPushList().stream().filter(e -> ObjectUtil.isNotEmpty((Object)e.getFscOrderId())).collect(Collectors.toList());
        if (CollectionUtil.isNotEmpty(orderInfoPushList)) {
            for (FscOrderInfoPushBO fscOrderInfoPushBO : orderInfoPushList) {
                if (fscOrderInfoPushBO.getFailureCount() >= this.failureCount) {
                    FscSystemBusiLogBusiServiceReqBo reqBo = new FscSystemBusiLogBusiServiceReqBo();
                    reqBo.setLogId(fscOrderInfoPushBO.getLogId());
                    reqBo.setDelFlag(FscConstants.DicDelFlag.YES);
                    this.fscSystemBusiLogBusiService.updateSystemBusiLog(reqBo);
                    continue;
                }
                this.fscOrderInfoPushAtomService.dealPushFscOrderInfo((FscOrderInfoPushAtomReqBO)JSON.parseObject((String)JSON.toJSONString((Object)fscOrderInfoPushBO), FscOrderInfoPushAtomReqBO.class));
            }
        }
        FscOrderInfoPushAbilityRspBO rspBO = new FscOrderInfoPushAbilityRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private void check(FscOrderInfoPushAbilityReqBO reqBO) {
        if (CollectionUtil.isEmpty((Collection)reqBO.getFscOrderInfoPushList())) {
            throw new FscBusinessException("191000", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[fscOrderInfoPushList]\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

