/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.common.ability.impl;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.db.Page;
import com.tydic.fsc.bo.FscComPayLogBo;
import com.tydic.fsc.busibase.busi.api.FscDictionaryBusiService;
import com.tydic.fsc.common.ability.api.FscAccountPayDetailListQueryAbilityService;
import com.tydic.fsc.common.ability.bo.FscAccountPayDetailListQueryAbilityReqBO;
import com.tydic.fsc.common.ability.bo.FscAccountPayDetailListQueryAbilityRspBO;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscPayLogMapper;
import com.tydic.fsc.dao.FscShouldPayMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.FscPayLogPO;
import com.tydic.fsc.po.FscShouldPayPO;
import com.tydic.fsc.utils.BigDecimalConvert;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.fsc.common.ability.api.FscAccountPayDetailListQueryAbilityService"})
public class FscAccountPayDetailListQueryAbilityServiceImpl
implements FscAccountPayDetailListQueryAbilityService {
    @Autowired
    private FscPayLogMapper fscPayLogMapper;
    @Autowired
    private FscShouldPayMapper fscShouldPayMapper;
    @Autowired
    private FscDictionaryBusiService fscDictionaryBusiService;

    @BigDecimalConvert(value=2)
    @PostMapping(value={"qryAccountPayDetailList"})
    public FscAccountPayDetailListQueryAbilityRspBO qryAccountPayDetailList(@RequestBody FscAccountPayDetailListQueryAbilityReqBO reqBO) {
        this.val(reqBO);
        Page page = new Page();
        page.setPageNo(reqBO.getPageNo().intValue());
        page.setPageSize(reqBO.getPageSize().intValue());
        FscPayLogPO fscPayLogPO = new FscPayLogPO();
        fscPayLogPO.setBusiCategory(reqBO.getBusiCategory());
        fscPayLogPO.setBusiOrderNo(reqBO.getBusiOrderNo());
        fscPayLogPO.setIsCredit(reqBO.getIsCredit());
        fscPayLogPO.setBusiTimeStart(reqBO.getBusiTimeBegin());
        fscPayLogPO.setBusiTimeEnd(reqBO.getBusiTimeEnd());
        fscPayLogPO.setAccountId(reqBO.getAccountId());
        fscPayLogPO.setCompanyIdWeb(reqBO.getOrgIdWeb());
        fscPayLogPO.setIds(reqBO.getPayLogIds());
        fscPayLogPO.setOrderBy("a.create_time desc");
        List fscPayLogPOList = this.fscPayLogMapper.getPayLogListPage(fscPayLogPO, page);
        if (CollectionUtils.isEmpty((Collection)fscPayLogPOList)) {
            return new FscAccountPayDetailListQueryAbilityRspBO();
        }
        Map<Long, Integer> shouldPayMap = this.getShouldPayMap(fscPayLogPOList);
        Map fscBusiCategoryMap = this.fscDictionaryBusiService.queryBypCodeBackMap("PAY_LOG_BUSI_CATEGORY");
        Map fscIsCreditMap = this.fscDictionaryBusiService.queryBypCodeBackMap("PAY_LOG_IS_CREDIT");
        List fscComPayLogBos = JSON.parseArray((String)JSON.toJSONString((Object)fscPayLogPOList), FscComPayLogBo.class);
        for (FscComPayLogBo fscComPayLogBo : fscComPayLogBos) {
            fscComPayLogBo.setBusiCategoryStr((String)fscBusiCategoryMap.get(fscComPayLogBo.getBusiCategory().toString()));
            fscComPayLogBo.setIsCreaditStr((String)fscIsCreditMap.get(fscComPayLogBo.getIsCredit().toString()));
            if (fscComPayLogBo.getOrgId().equals(reqBO.getOrgIdWeb())) {
                BigDecimal busiAmount = fscComPayLogBo.getBusiAmount();
                BigDecimal busiAmt = busiAmount.multiply(BigDecimal.valueOf(-1L));
                fscComPayLogBo.setBusiAmount(busiAmt);
            }
            if (null != fscComPayLogBo.getShouldPayId()) {
                fscComPayLogBo.setObjectType(shouldPayMap.get(fscComPayLogBo.getShouldPayId()));
                continue;
            }
            fscComPayLogBo.setObjectType(FscConstants.ShouldObjectType.SALE_ORDER);
        }
        FscAccountPayDetailListQueryAbilityRspBO rspBO = new FscAccountPayDetailListQueryAbilityRspBO();
        rspBO.setRows(fscComPayLogBos);
        rspBO.setPageNo(reqBO.getPageNo());
        rspBO.setRecordsTotal(Integer.valueOf(page.getTotalCount()));
        rspBO.setTotal(Integer.valueOf(page.getTotalCount()));
        return rspBO;
    }

    private Map<Long, Integer> getShouldPayMap(List<FscPayLogPO> fscPayLogPOList) {
        List shouldPayIds = fscPayLogPOList.stream().filter(fscPayLogPO -> null != fscPayLogPO.getShouldPayId()).map(FscPayLogPO::getShouldPayId).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(shouldPayIds)) {
            return new HashMap<Long, Integer>(0);
        }
        FscShouldPayPO fscShouldPayPO = new FscShouldPayPO();
        fscShouldPayPO.setShouldPayIds(shouldPayIds);
        List fscShouldPayMapperList = this.fscShouldPayMapper.getList(fscShouldPayPO);
        return fscShouldPayMapperList.stream().collect(Collectors.toMap(FscShouldPayPO::getShouldPayId, FscShouldPayPO::getObjectType));
    }

    private void val(FscAccountPayDetailListQueryAbilityReqBO reqBO) {
        if (null == reqBO) {
            throw new FscBusinessException("191000", "\u5165\u53c2\u5bf9\u8c61\u4e3a\u7a7a");
        }
        if (null == reqBO.getOrgIdWeb()) {
            throw new FscBusinessException("191000", "\u5165\u53c2[orgIdWeb]\u4e3a\u7a7a");
        }
    }
}

