/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.common.consumer;

import cn.hutool.core.exceptions.ExceptionUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.ohaotian.plugin.mq.proxy.DefaultProxyMessageConfig;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageConsumer;
import com.ohaotian.plugin.mq.proxy.status.ProxyConsumerStatus;
import com.tydic.fsc.base.FscRspBaseBO;
import com.tydic.fsc.busibase.busi.api.FscOrderFailLogUpdateBusiService;
import com.tydic.fsc.busibase.busi.api.FscSystemBusiLogBusiService;
import com.tydic.fsc.busibase.busi.bo.FscOrderFailLogUpdateBusiReqBO;
import com.tydic.fsc.busibase.busi.bo.FscSystemBusiLogBusiServiceReqBo;
import com.tydic.fsc.common.busi.api.FscComOrderSyncEsBusiService;
import com.tydic.fsc.common.busi.api.FscEsSyncComOrderListBusiService;
import com.tydic.fsc.common.busi.bo.FscComOrderListEsSyncRspBO;
import com.tydic.fsc.common.busi.bo.FscComOrderListQueryBusiReqBO;
import com.tydic.fsc.common.busi.bo.FscComOrderSyncRspBO;
import com.tydic.fsc.common.consumer.bo.FscSyncReqBO;
import com.tydic.fsc.constants.FscConstants;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class FscEsSyncServiceConsumer
extends DefaultProxyMessageConfig
implements ProxyMessageConsumer {
    private static final Logger log = LoggerFactory.getLogger(FscEsSyncServiceConsumer.class);
    @Autowired
    private FscComOrderSyncEsBusiService fscComOrderSyncEsBusiService;
    @Autowired
    private FscEsSyncComOrderListBusiService fscEsSyncComOrderListBusiService;
    @Autowired
    private FscOrderFailLogUpdateBusiService fscOrderFailLogUpdateBusiService;
    @Autowired
    private FscSystemBusiLogBusiService fscSystemBusiLogBusiService;

    public ProxyConsumerStatus onMessage(ProxyMessage proxyMessage) {
        JSONObject jsonObject = JSON.parseObject((String)proxyMessage.getContent());
        Date createTime = jsonObject.getDate("createTime");
        String sendService = jsonObject.getString("sendService");
        try {
            FscComOrderSyncRspBO fscComOrderSyncRspBO;
            log.debug("---------------ES\u540c\u6b65\u7d22\u5f15\u6d88\u8d39\u8005\u5f00\u59cb---------------");
            FscSyncReqBO fscSyncReqBO = (FscSyncReqBO)JSON.parseObject((String)proxyMessage.getContent(), (TypeReference)new TypeReference<FscSyncReqBO>(){}, (Feature[])new Feature[0]);
            log.debug("ES\u7ed3\u7b97\u5355\u4fe1\u606f\u7d22\u5f15\u540c\u6b65\u8f6c\u6362\u540e\u5f97\u5230\u7684\u6d88\u8d39\u8005\u53c2\u6570\u4e3a{}", (Object)JSON.toJSONString((Object)fscSyncReqBO));
            if (fscSyncReqBO.getFscOrderId() == null) {
                return ProxyConsumerStatus.CONSUME_SUCCESS;
            }
            if (fscSyncReqBO.getFscOrderId() == 0L) {
                log.error("ES\u7ed3\u7b97\u5355\u4fe1\u606f\u7d22\u5f15\u540c\u6b65\u5931\u8d25\uff01fscOrderId\u4e3a\u96f6,\u53c2\u6570\u4e3a\uff1a{}", (Object)fscSyncReqBO.getFscOrderId());
                return ProxyConsumerStatus.CONSUME_SUCCESS;
            }
            try {
                FscComOrderListQueryBusiReqBO fscComOrderListQueryBusiReqBO = (FscComOrderListQueryBusiReqBO)JSON.parseObject((String)JSON.toJSONString((Object)fscSyncReqBO), FscComOrderListQueryBusiReqBO.class);
                fscComOrderSyncRspBO = this.fscComOrderSyncEsBusiService.dealComOrderSyncEs(fscComOrderListQueryBusiReqBO);
                if ("0000".equals(fscComOrderSyncRspBO.getRespCode())) {
                    this.systemBusiLog(FscConstants.SystemLogFlag.SUCCESS, JSON.toJSONString((Object)fscComOrderListQueryBusiReqBO), JSON.toJSONString((Object)((Object)fscComOrderSyncRspBO)), createTime, null, sendService, "FscComOrderSyncEsBusiService");
                } else {
                    this.systemBusiLog(FscConstants.SystemLogFlag.FAIL, JSON.toJSONString((Object)fscComOrderListQueryBusiReqBO), JSON.toJSONString((Object)((Object)fscComOrderSyncRspBO)), createTime, fscComOrderSyncRspBO.getRespDesc(), sendService, "FscComOrderSyncEsBusiService");
                }
            }
            catch (Exception e) {
                this.systemBusiLog(FscConstants.SystemLogFlag.FAIL, proxyMessage.getContent(), null, createTime, ExceptionUtil.stacktraceToString((Throwable)e), sendService, "FscComOrderSyncEsBusiService");
                log.error("ES\u540c\u6b65\u67e5\u8be2\u5931\u8d25\uff0c\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)fscSyncReqBO));
                this.writeFailLog(fscSyncReqBO.getFscOrderId(), null);
                return ProxyConsumerStatus.CONSUME_SUCCESS;
            }
            if ("0000".equals(fscComOrderSyncRspBO.getRespCode())) {
                FscComOrderListEsSyncRspBO fscComOrderListEsSyncRspBO = this.fscEsSyncComOrderListBusiService.esSyncComOrderList(fscComOrderSyncRspBO.getFscComOrderListEsSyncReqBO());
                if (!"0000".equals(fscComOrderListEsSyncRspBO.getRespCode())) {
                    log.error("ES\u540c\u6b65\u5931\u8d25\uff0c\u539f\u56e0\uff1a{}", (Object)fscComOrderListEsSyncRspBO.getRespDesc());
                    this.writeFailLog(fscSyncReqBO.getFscOrderId(), fscComOrderListEsSyncRspBO);
                    this.systemBusiLog(FscConstants.SystemLogFlag.FAIL, JSON.toJSONString((Object)fscComOrderSyncRspBO.getFscComOrderListEsSyncReqBO()), JSON.toJSONString((Object)((Object)fscComOrderListEsSyncRspBO)), createTime, fscComOrderListEsSyncRspBO.getRespDesc(), sendService, "FscEsSyncComOrderListBusiService");
                    return ProxyConsumerStatus.CONSUME_SUCCESS;
                }
                this.systemBusiLog(FscConstants.SystemLogFlag.SUCCESS, JSON.toJSONString((Object)fscComOrderSyncRspBO.getFscComOrderListEsSyncReqBO()), JSON.toJSONString((Object)((Object)fscComOrderListEsSyncRspBO)), createTime, null, sendService, "FscEsSyncComOrderListBusiService");
                log.debug("---------------ES\u540c\u6b65\u7d22\u5f15\u6d88\u8d39\u8005\u7ed3\u675f---------------");
            }
            return ProxyConsumerStatus.CONSUME_SUCCESS;
        }
        catch (Exception e) {
            this.systemBusiLog(FscConstants.SystemLogFlag.FAIL, proxyMessage.getContent(), null, createTime, ExceptionUtil.stacktraceToString((Throwable)e), sendService, null);
            return ProxyConsumerStatus.CONSUME_SUCCESS;
        }
    }

    private void systemBusiLog(Integer logFlag, String reqStr, String rspStr, Date createTime, String failureReason, String sendService, String callService) {
        FscSystemBusiLogBusiServiceReqBo logBusiServiceReqBo = new FscSystemBusiLogBusiServiceReqBo();
        logBusiServiceReqBo.setSystemType(FscConstants.SystemType.INNER);
        logBusiServiceReqBo.setLogType(FscConstants.SystemLogType.FORWARD);
        logBusiServiceReqBo.setLogFlag(logFlag);
        logBusiServiceReqBo.setBusiType(FscConstants.SystemLogBusiType.SYNC_ES);
        logBusiServiceReqBo.setCallService(callService);
        logBusiServiceReqBo.setSendService(sendService);
        logBusiServiceReqBo.setReqParam(reqStr);
        logBusiServiceReqBo.setRspParam(rspStr);
        if (null == createTime) {
            logBusiServiceReqBo.setCreateTime(new Date());
        } else {
            logBusiServiceReqBo.setCreateTime(createTime);
        }
        logBusiServiceReqBo.setFailureReason(failureReason);
        this.fscSystemBusiLogBusiService.systemBusiLog(logBusiServiceReqBo);
    }

    private void writeFailLog(Long fscOrderId, FscRspBaseBO rspBO) {
        FscOrderFailLogUpdateBusiReqBO fscOrderFailLogUpdateBusiReqBO = new FscOrderFailLogUpdateBusiReqBO();
        fscOrderFailLogUpdateBusiReqBO.setObjId(fscOrderId);
        if (null != rspBO) {
            fscOrderFailLogUpdateBusiReqBO.setBusiFailDesc(rspBO.getRespDesc());
        }
        fscOrderFailLogUpdateBusiReqBO.setBusiType(FscConstants.FscOrderFailRetansBusiType.FSC_ORDER_SYNC_ES);
        this.fscOrderFailLogUpdateBusiService.dealInsert(fscOrderFailLogUpdateBusiReqBO);
    }
}

