/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.common.ability.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.ohaotian.plugin.db.Page;
import com.tydic.fsc.busibase.busi.api.FscDictionaryBusiService;
import com.tydic.fsc.common.ability.api.FscAccountCreditInfoListQueryAbilityService;
import com.tydic.fsc.common.ability.bo.FscAccountCreditInfoListQueryAbilityReqBO;
import com.tydic.fsc.common.ability.bo.FscAccountCreditInfoListQueryAbilityRspBO;
import com.tydic.fsc.common.ability.bo.FscAccountCreditInfoListRspBO;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.constants.MerchantPayRule;
import com.tydic.fsc.dao.FscMerchantMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.FscAccountCreditPO;
import com.tydic.fsc.utils.BigDecimalConvert;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.fsc.common.ability.api.FscAccountCreditInfoListQueryAbilityService"})
public class FscAccountCreditInfoListQueryAbilityServiceImpl
implements FscAccountCreditInfoListQueryAbilityService {
    @Autowired
    private FscMerchantMapper fscMerchantMapper;
    @Autowired
    private FscDictionaryBusiService fscDictionaryBusiService;

    @BigDecimalConvert(value=2)
    @PostMapping(value={"qryAccountCreditInfoList"})
    public FscAccountCreditInfoListQueryAbilityRspBO qryAccountCreditInfoList(@RequestBody FscAccountCreditInfoListQueryAbilityReqBO reqBO) {
        this.val(reqBO);
        Page page = new Page(reqBO.getPageNo().intValue(), reqBO.getPageSize().intValue());
        List parentIds = this.fscMerchantMapper.selectByPayObjId(reqBO.getPayObjId());
        FscAccountCreditPO fscAccountCredit = new FscAccountCreditPO();
        if (!CollectionUtils.isEmpty((Collection)parentIds)) {
            fscAccountCredit.setParentIds(parentIds);
        }
        fscAccountCredit.setPayObjId(reqBO.getPayObjId());
        fscAccountCredit.setOrgId(reqBO.getCreditOrgId());
        fscAccountCredit.setCreditOrgId(reqBO.getPayObjId());
        fscAccountCredit.setCreateTimeStart(reqBO.getBeginTime());
        fscAccountCredit.setCreateTimeEnd(reqBO.getEndTime());
        fscAccountCredit.setPayType(FscConstants.MerchantPayType.MERCHANT_PAY_TYPE_PERIOD);
        fscAccountCredit.setStatusList(Arrays.asList(FscConstants.MerchantStatus.VALID, FscConstants.MerchantStatus.INVALID, FscConstants.MerchantStatus.APPROVAL, FscConstants.MerchantStatus.FREEZE));
        List fscAccountCreditPos = this.fscMerchantMapper.selectCreditInfoPage(fscAccountCredit, page);
        String jsonString = JSON.toJSONString((Object)fscAccountCreditPos, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue});
        List rows = JSON.parseArray((String)jsonString, FscAccountCreditInfoListRspBO.class);
        Map payNodeRuleMap = this.fscDictionaryBusiService.queryBypCodeBackMap("MERCHANT_NODE_RULE");
        for (FscAccountCreditInfoListRspBO row : rows) {
            BigDecimal payBreakScale;
            if (null != row.getPayRule()) {
                row.setPayRuleStr(MerchantPayRule.getInstance((Integer)row.getPayRule()).getDescr());
                if (null != row.getPayNodeRule()) {
                    row.setPayNodeRuleStr((String)payNodeRuleMap.get(row.getPayNodeRule().toString()));
                }
            }
            if (null != (payBreakScale = row.getPayBreakScale())) {
                StringBuilder sb = new StringBuilder();
                sb.append("\u9a8c\u6536\u5355\u91d1\u989d * ").append(payBreakScale.setScale(2, 4).toString()).append("% * \u903e\u671f\u5929\u6570");
                row.setCalculationFormula(sb.toString());
            }
            row.setCreditDate(row.getCreateTime());
        }
        FscAccountCreditInfoListQueryAbilityRspBO rspBO = new FscAccountCreditInfoListQueryAbilityRspBO();
        rspBO.setRows(rows);
        rspBO.setPageNo(reqBO.getPageNo());
        rspBO.setRecordsTotal(Integer.valueOf(page.getTotalCount()));
        rspBO.setTotal(Integer.valueOf(page.getTotalPages()));
        return rspBO;
    }

    private void val(FscAccountCreditInfoListQueryAbilityReqBO reqBO) {
        if (null == reqBO.getPayObjId()) {
            throw new FscBusinessException("191000", "\u5165\u53c2[payObjId]\u4e3a\u7a7a");
        }
    }
}

