/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.common.busi.impl;

import cn.hutool.core.convert.Convert;
import com.alibaba.fastjson.JSONObject;
import com.tydic.fsc.busibase.external.api.auth.FscAuthGetUserByRoleAndOrgExtService;
import com.tydic.fsc.busibase.external.api.bo.FscAuthGetUserByRoleAndOrgReqBo;
import com.tydic.fsc.busibase.external.api.bo.FscAuthGetUserByRoleAndOrgRspBo;
import com.tydic.fsc.busibase.external.api.bo.FscNoticeReceiverBO;
import com.tydic.fsc.busibase.external.api.bo.FscNoticeSendExtReqBo;
import com.tydic.fsc.busibase.external.api.bo.FscNoticeSendExtRspBo;
import com.tydic.fsc.busibase.external.api.notice.FscNoticeSendExtService;
import com.tydic.fsc.common.busi.api.FscAccountShouldPaySuccessBusiService;
import com.tydic.fsc.common.busi.bo.FscAccountShouldPaySuccessBusiReqBo;
import com.tydic.fsc.common.busi.bo.FscAccountShouldPaySuccessBusiRspBo;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscOrderPayItemMapper;
import com.tydic.fsc.dao.FscShouldPayMapper;
import com.tydic.fsc.dao.FscTodoConfigMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.FscOrderPayItemPO;
import com.tydic.fsc.po.FscShouldPayPO;
import com.tydic.fsc.po.FscTodoConfigPO;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class FscAccountShouldPaySuccessBusiServiceImpl
implements FscAccountShouldPaySuccessBusiService {
    @Autowired
    private FscShouldPayMapper fscShouldPayMapper;
    @Autowired
    private FscTodoConfigMapper fscTodoConfigMapper;
    @Autowired
    private FscOrderPayItemMapper fscOrderPayItemMapper;
    @Autowired
    private FscAuthGetUserByRoleAndOrgExtService fscAuthGetUserByRoleAndOrgExtService;
    @Autowired
    private FscNoticeSendExtService fscNoticeSendExtService;
    @Value(value="${fsc.accountShouldPay.todoCode:9999}")
    private String todoCode;

    @Override
    public FscAccountShouldPaySuccessBusiRspBo dealAccountShouldPaySuccess(FscAccountShouldPaySuccessBusiReqBo reqBo) {
        this.sendNotice(reqBo);
        return new FscAccountShouldPaySuccessBusiRspBo();
    }

    private void sendNotice(FscAccountShouldPaySuccessBusiReqBo reqBo) {
        FscTodoConfigPO fscTodoConfigPO = new FscTodoConfigPO();
        fscTodoConfigPO.setTodoCode(this.todoCode);
        fscTodoConfigPO = this.fscTodoConfigMapper.getModelBy(fscTodoConfigPO);
        if (null == fscTodoConfigPO) {
            return;
        }
        FscOrderPayItemPO fscOrderPayItemPO = new FscOrderPayItemPO();
        fscOrderPayItemPO.setFscOrderIds(reqBo.getFscOrderIds());
        List orderPayItemPOS = this.fscOrderPayItemMapper.getList(fscOrderPayItemPO);
        if (CollectionUtils.isEmpty((Collection)orderPayItemPOS)) {
            return;
        }
        FscShouldPayPO fscShouldPayPO = new FscShouldPayPO();
        fscShouldPayPO.setShouldPayIds(orderPayItemPOS.stream().map(FscOrderPayItemPO::getShouldPayId).collect(Collectors.toList()));
        fscShouldPayPO.setShouldPayStatus(FscConstants.ShouldPayStatus.PAYED);
        fscShouldPayPO.setShouldPayType(FscConstants.ShouldPayType.PAYMENT_DAY_PAY);
        fscShouldPayPO.setObjectTypes(Arrays.asList(FscConstants.ShouldObjectType.CHECK_ORDER, FscConstants.ShouldObjectType.DELIVER_ORDER, FscConstants.ShouldObjectType.SIGN_INVOICE_ORDER));
        List fscShouldPayPOS = this.fscShouldPayMapper.getList(fscShouldPayPO);
        if (CollectionUtils.isEmpty((Collection)fscShouldPayPOS)) {
            return;
        }
        for (FscShouldPayPO shouldPayPO : fscShouldPayPOS) {
            List<FscNoticeReceiverBO> receiverBOS = this.getFscNoticeReceiverBOS(fscTodoConfigPO, shouldPayPO);
            if (!CollectionUtils.isNotEmpty(receiverBOS)) continue;
            this.sendNotice(shouldPayPO, fscTodoConfigPO, receiverBOS);
        }
    }

    private List<FscNoticeReceiverBO> getFscNoticeReceiverBOS(FscTodoConfigPO fscTodoConfigPO, FscShouldPayPO shouldPayPO) {
        FscAuthGetUserByRoleAndOrgReqBo fscAuthGetUserByRoleAndOrgReqBo = new FscAuthGetUserByRoleAndOrgReqBo();
        fscAuthGetUserByRoleAndOrgReqBo.setRoleCodes(Arrays.asList(fscTodoConfigPO.getRole().split(";")));
        fscAuthGetUserByRoleAndOrgReqBo.setLvOrgId(shouldPayPO.getPayerId());
        fscAuthGetUserByRoleAndOrgReqBo.setPageNo(Integer.valueOf(1));
        fscAuthGetUserByRoleAndOrgReqBo.setPageSize(Integer.valueOf(1000));
        fscAuthGetUserByRoleAndOrgReqBo.setLevelFlag(Integer.valueOf(1));
        FscAuthGetUserByRoleAndOrgRspBo userByRoleAndOrg = this.fscAuthGetUserByRoleAndOrgExtService.getUserByRoleAndOrg(fscAuthGetUserByRoleAndOrgReqBo);
        List<FscNoticeReceiverBO> receiverBOS = userByRoleAndOrg.getRows().stream().map(fscAuthByRoleAndOrgQryUserInfoBo -> {
            FscNoticeReceiverBO fscNoticeReceiverBO = new FscNoticeReceiverBO();
            fscNoticeReceiverBO.setReceiverId(Convert.toStr((Object)fscAuthByRoleAndOrgQryUserInfoBo.getUserId()));
            fscNoticeReceiverBO.setReceiverName(fscAuthByRoleAndOrgQryUserInfoBo.getCustName());
            return fscNoticeReceiverBO;
        }).collect(Collectors.toList());
        if (userByRoleAndOrg.getTotal() > 1) {
            for (int i = 0; i < userByRoleAndOrg.getTotal(); ++i) {
                fscAuthGetUserByRoleAndOrgReqBo.setPageNo(Integer.valueOf(i + 2));
                FscAuthGetUserByRoleAndOrgRspBo userByRoleAndOrgRspBo = this.fscAuthGetUserByRoleAndOrgExtService.getUserByRoleAndOrg(fscAuthGetUserByRoleAndOrgReqBo);
                receiverBOS.addAll(userByRoleAndOrgRspBo.getRows().stream().map(fscAuthByRoleAndOrgQryUserInfoBo -> {
                    FscNoticeReceiverBO fscNoticeReceiverBO = new FscNoticeReceiverBO();
                    fscNoticeReceiverBO.setReceiverId(Convert.toStr((Object)fscAuthByRoleAndOrgQryUserInfoBo.getUserId()));
                    fscNoticeReceiverBO.setReceiverName(fscAuthByRoleAndOrgQryUserInfoBo.getCustName());
                    return fscNoticeReceiverBO;
                }).collect(Collectors.toList()));
            }
        }
        return receiverBOS;
    }

    private void sendNotice(FscShouldPayPO shouldPayPO, FscTodoConfigPO fscTodoConfigPO, List<FscNoticeReceiverBO> receiverBOS) {
        FscNoticeSendExtReqBo fscNoticeSendExtReqBo = new FscNoticeSendExtReqBo();
        fscNoticeSendExtReqBo.setTaskCode(fscTodoConfigPO.getNoticeCode());
        fscNoticeSendExtReqBo.setSendId("1");
        fscNoticeSendExtReqBo.setSendName("\u7cfb\u7edf\u7ba1\u7406\u5458");
        fscNoticeSendExtReqBo.setReceivers(receiverBOS);
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("objectId", (Object)shouldPayPO.getObjectId());
        jsonObject.put("objectNo", (Object)shouldPayPO.getObjectNo());
        jsonObject.put("objectTypeStr", (Object)this.getObjectTypeStr(shouldPayPO));
        fscNoticeSendExtReqBo.setData(jsonObject.toJSONString());
        FscNoticeSendExtRspBo fscNoticeSendExtRspBo = this.fscNoticeSendExtService.sendNotice(fscNoticeSendExtReqBo);
        if (!"0000".equals(fscNoticeSendExtRspBo.getRespCode())) {
            throw new FscBusinessException(fscNoticeSendExtRspBo.getRespCode(), fscNoticeSendExtRspBo.getRespDesc());
        }
    }

    private String getObjectTypeStr(FscShouldPayPO shouldPayPO) {
        if (FscConstants.ShouldObjectType.CHECK_ORDER.equals(shouldPayPO.getObjectType())) {
            return "\u9a8c\u6536\u5355";
        }
        if (FscConstants.ShouldObjectType.DELIVER_ORDER.equals(shouldPayPO.getObjectType())) {
            return "\u53d1\u8d27\u5355";
        }
        return "\u7ed3\u7b97\u5355";
    }
}

