/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.service.ability.impl;

import com.alibaba.boot.hsf.annotation.HSFProvider;
import com.alibaba.fastjson.JSONObject;
import com.tydic.fsc.ability.api.FscComOrderSyncAbilityService;
import com.tydic.fsc.ability.api.FscPayBillAbilityService;
import com.tydic.fsc.ability.api.bo.FscComOrderListSyncAbilityReqBO;
import com.tydic.fsc.ability.api.bo.FscPayBillAbilityReqBO;
import com.tydic.fsc.ability.api.bo.FscPayBillAbilityRspBO;
import com.tydic.fsc.busi.api.bo.FscPayBillBusiReqBO;
import com.tydic.fsc.busi.api.bo.FscPayBillBusiRspBO;
import com.tydic.fsc.busi.api.bo.FscPayBillBusiService;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.util.FscDuplicateCommitLimit;
import java.util.Collection;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@HSFProvider(serviceVersion="1.0.0", serviceGroup="FSC_GROUP_DEV", serviceInterface=FscPayBillAbilityService.class)
public class FscPayBillAbilityServiceImpl
implements FscPayBillAbilityService {
    @Autowired
    private FscPayBillBusiService fscPayBillBusiService;
    @Autowired
    private FscComOrderSyncAbilityService fscComOrderSyncAbilityService;

    @FscDuplicateCommitLimit
    public FscPayBillAbilityRspBO dealPayBill(FscPayBillAbilityReqBO abilityReqBO) {
        this.validParam(abilityReqBO);
        FscPayBillBusiReqBO fscPayBillBusiReqBO = (FscPayBillBusiReqBO)JSONObject.parseObject((String)JSONObject.toJSONString((Object)abilityReqBO), FscPayBillBusiReqBO.class);
        FscPayBillBusiRspBO busiRspBO = this.fscPayBillBusiService.dealPayBill(fscPayBillBusiReqBO);
        if ("0000".equals(busiRspBO.getRespCode())) {
            abilityReqBO.getFscOrderIds().forEach(fscOrderId -> {
                FscComOrderListSyncAbilityReqBO fscComOrderListSyncAbilityReqBO = new FscComOrderListSyncAbilityReqBO();
                fscComOrderListSyncAbilityReqBO.setFscOrderId(fscOrderId);
                this.fscComOrderSyncAbilityService.dealComOrderSyncEs(fscComOrderListSyncAbilityReqBO);
            });
        }
        FscPayBillAbilityRspBO abilityRspBO = new FscPayBillAbilityRspBO();
        BeanUtils.copyProperties((Object)busiRspBO, (Object)abilityRspBO);
        return abilityRspBO;
    }

    private void validParam(FscPayBillAbilityReqBO abilityReqBO) {
        if (CollectionUtils.isEmpty((Collection)abilityReqBO.getFscOrderIds())) {
            throw new FscBusinessException("184000", "\u4e3b\u5355ID\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (null == abilityReqBO.getPayChannel()) {
            throw new FscBusinessException("184000", "\u652f\u4ed8\u6e20\u9053\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (null == abilityReqBO.getPayConfirmFlag()) {
            throw new FscBusinessException("184000", "\u662f\u5426\u9700\u8981\u786e\u8ba4\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (StringUtils.isEmpty((Object)abilityReqBO.getDetailName())) {
            throw new FscBusinessException("184000", "\u652f\u4ed8\u8bf7\u6c42\u63cf\u8ff0\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (!CollectionUtils.isEmpty((Collection)abilityReqBO.getFscAttachmentBOS())) {
            abilityReqBO.getFscAttachmentBOS().forEach(attachmentBO -> {
                if (null == attachmentBO.getAttachmentType()) {
                    throw new FscBusinessException("184000", "\u9644\u4ef6\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                }
                if (StringUtils.isEmpty((Object)attachmentBO.getAttachmentName())) {
                    throw new FscBusinessException("184000", "\u9644\u4ef6\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                }
                if (StringUtils.isEmpty((Object)attachmentBO.getAttachmentUrl())) {
                    throw new FscBusinessException("184000", "\u9644\u4ef6\u5730\u5740\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                }
            });
        }
    }
}

