/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.service.atom.impl;

import com.tydic.fsc.atom.api.FscDealPaySuccessAtomService;
import com.tydic.fsc.atom.api.FscOrderStatusFlowAtomService;
import com.tydic.fsc.atom.api.bo.FscDealPaySuccessAtomReqBO;
import com.tydic.fsc.atom.api.bo.FscDealPaySuccessAtomRspBO;
import com.tydic.fsc.atom.api.bo.FscOrderStatusFlowAtomReqBO;
import com.tydic.fsc.atom.api.bo.FscOrderStatusFlowAtomRspBO;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscOrderMapper;
import com.tydic.fsc.dao.FscOrderPayItemMapper;
import com.tydic.fsc.dao.FscShouldPayMapper;
import com.tydic.fsc.dao.po.FscOrderPO;
import com.tydic.fsc.dao.po.FscOrderPayItemPO;
import com.tydic.fsc.dao.po.FscOrderShouldPayItemPO;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.external.api.bo.FscUocProOrderPaymentCallbackAbilityReqBO;
import com.tydic.fsc.external.api.uoc.FscUocProOrderPaymentCallbackAbilityService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class FscDealPaySuccessAtomServiceImpl
implements FscDealPaySuccessAtomService {
    @Autowired
    private FscOrderPayItemMapper fscOrderPayItemMapper;
    @Autowired
    private FscShouldPayMapper fscShouldPayMapper;
    @Autowired
    private FscOrderStatusFlowAtomService fscOrderStatusFlowAtomService;
    @Autowired
    private FscOrderMapper fscOrderMapper;
    @Autowired
    private FscUocProOrderPaymentCallbackAbilityService fscUocProOrderPaymentCallbackAbilityService;

    public FscDealPaySuccessAtomRspBO dealPaySuccess(FscDealPaySuccessAtomReqBO atomReqBO) {
        FscOrderPayItemPO fscOrderPayItemPO = new FscOrderPayItemPO();
        fscOrderPayItemPO.setFscOrderIds(atomReqBO.getPayFscOrderId());
        List pos = this.fscOrderPayItemMapper.getListForDealPaySuccess(fscOrderPayItemPO);
        HashSet shouldPayIdSet = new HashSet();
        pos.forEach(fscOrderPayItemPO1 -> {
            shouldPayIdSet.add(fscOrderPayItemPO1.getShouldPayId());
            int count = this.fscShouldPayMapper.updateByPaySuccess(fscOrderPayItemPO1.getShouldPayId(), fscOrderPayItemPO1.getPayAmount());
            if (count != 1) {
                throw new FscBusinessException("184000", "\u66f4\u65b0\u5e94\u4ed8\u4fe1\u606f\u4ed8\u6b3e\u4e2d\u91d1\u989d\u5931\u8d25\uff01");
            }
        });
        this.fscShouldPayMapper.updateShouldPayStatusForPartPay(shouldPayIdSet);
        this.fscShouldPayMapper.updateShouldPayStatusForPaied(shouldPayIdSet);
        List<Long> resultFscOrderIds = this.updateFscOrderAndOrder(pos, atomReqBO);
        FscDealPaySuccessAtomRspBO atomRspBO = new FscDealPaySuccessAtomRspBO();
        atomRspBO.setResultFscOrderIds(resultFscOrderIds);
        atomRspBO.setRespCode("0000");
        atomRspBO.setRespDesc("\u539f\u5b50\u670d\u52a1\u5904\u7406\u6210\u529f");
        return atomRspBO;
    }

    private List<Long> updateFscOrderAndOrder(List<FscOrderShouldPayItemPO> pos, FscDealPaySuccessAtomReqBO atomReqBO) {
        ArrayList<Long> resultFscOrderIds = new ArrayList<Long>();
        HashMap payFscOrderIdMap = new HashMap();
        pos.forEach(fscOrderShouldPayItemPO -> {
            if (FscConstants.ShouldObjectType.PURCHASE_ORDER.equals(fscOrderShouldPayItemPO.getObjectType()) || FscConstants.ShouldObjectType.SALE_ORDER.equals(fscOrderShouldPayItemPO.getObjectType()) || FscConstants.ShouldObjectType.CHECK_ORDER.equals(fscOrderShouldPayItemPO.getObjectType()) || FscConstants.ShouldObjectType.DELIVER_ORDER.equals(fscOrderShouldPayItemPO.getObjectType())) {
                FscUocProOrderPaymentCallbackAbilityReqBO fscUocProOrderPaymentCallbackAbilityReqBO = new FscUocProOrderPaymentCallbackAbilityReqBO();
                fscUocProOrderPaymentCallbackAbilityReqBO.setFscShouldPayId(fscOrderShouldPayItemPO.getShouldPayId());
                fscUocProOrderPaymentCallbackAbilityReqBO.setObjectId(fscOrderShouldPayItemPO.getObjectId());
                fscUocProOrderPaymentCallbackAbilityReqBO.setOrderId(fscOrderShouldPayItemPO.getOrderId());
                fscUocProOrderPaymentCallbackAbilityReqBO.setShouldPayMoney(fscOrderShouldPayItemPO.getPayAmount());
                fscUocProOrderPaymentCallbackAbilityReqBO.setPayMod(Integer.valueOf(Integer.parseInt(fscOrderShouldPayItemPO.getPayMethod())));
                this.fscUocProOrderPaymentCallbackAbilityService.dealOrderPaymentCallback(fscUocProOrderPaymentCallbackAbilityReqBO);
            } else if (FscConstants.ShouldPayStatus.PAYED.equals(fscOrderShouldPayItemPO.getShouldPayStatus())) {
                HashSet<Long> fscOrderId = (HashSet<Long>)payFscOrderIdMap.get(fscOrderShouldPayItemPO.getFscOrderId());
                if (fscOrderId == null) {
                    fscOrderId = new HashSet<Long>();
                    payFscOrderIdMap.put(fscOrderShouldPayItemPO.getFscOrderId(), fscOrderId);
                }
                fscOrderId.add(fscOrderShouldPayItemPO.getObjectId());
            }
        });
        if (payFscOrderIdMap.size() > 0) {
            FscOrderPO fscOrderPO = new FscOrderPO();
            fscOrderPO.setFscOrderIds(new ArrayList(payFscOrderIdMap.keySet()));
            List fscOrderPOs = this.fscOrderMapper.getList(fscOrderPO);
            fscOrderPOs.forEach(fscOrderPO1 -> {
                FscOrderPO set = new FscOrderPO();
                set.setPayConfirmId(fscOrderPO1.getPayConfirmId());
                set.setPayConfirmName(fscOrderPO1.getPayConfirmName());
                set.setPayConfirmTime(fscOrderPO1.getPayConfirmTime());
                set.setPayTime(fscOrderPO1.getPayTime());
                set.setPayOperName(fscOrderPO1.getPayOperName());
                set.setPayerName(fscOrderPO1.getPayerName());
                set.setPayerId(fscOrderPO1.getPayerId());
                set.setPayeeBankName(fscOrderPO1.getPayeeBankName());
                set.setPayeeBankAccount(fscOrderPO1.getPayeeBankAccount());
                set.setPayeeAccountName(fscOrderPO1.getPayeeAccountName());
                set.setPayeeName(fscOrderPO1.getPayeeName());
                set.setPayeeId(fscOrderPO1.getPayeeId());
                set.setShouldPayType(fscOrderPO1.getShouldPayType());
                set.setPayType(fscOrderPO1.getPayType());
                set.setPayMethod(fscOrderPO1.getPayMethod());
                set.setPayChannel(fscOrderPO1.getPayChannel());
                set.setPayOperId(fscOrderPO1.getPayOperId());
                FscOrderPO where = new FscOrderPO();
                ArrayList fscOrderIds = new ArrayList((Collection)payFscOrderIdMap.get(fscOrderPO1.getFscOrderId()));
                where.setFscOrderIds(fscOrderIds);
                this.fscOrderMapper.updateBy(set, where);
                for (Long fscOrderId : fscOrderIds) {
                    this.invokeFscOrderStatusFlow(fscOrderId, atomReqBO.getParamMap(), FscConstants.FscServiceOrderState.TO_PAY);
                    resultFscOrderIds.add(fscOrderPO1.getFscOrderId());
                }
            });
        }
        return resultFscOrderIds;
    }

    private void invokeFscOrderStatusFlow(Long fscOrderId, Map<String, Object> paramMap, Integer curStatus) {
        FscOrderStatusFlowAtomReqBO fscOrderStatusFlowAtomReqBO = new FscOrderStatusFlowAtomReqBO();
        fscOrderStatusFlowAtomReqBO.setOrderId(fscOrderId);
        fscOrderStatusFlowAtomReqBO.setParamMap(paramMap);
        fscOrderStatusFlowAtomReqBO.setCurStatus(curStatus);
        FscOrderStatusFlowAtomRspBO atomRspBO = this.fscOrderStatusFlowAtomService.dealStatusFlow(fscOrderStatusFlowAtomReqBO);
        if (!"0000".equals(atomRspBO.getRespCode())) {
            throw new FscBusinessException(atomRspBO.getRespCode(), atomRspBO.getRespDesc());
        }
    }
}

