/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.service.busi.impl;

import com.tydic.fsc.ability.api.FscComOrderSyncAbilityService;
import com.tydic.fsc.atom.api.FscDealPaySuccessAtomService;
import com.tydic.fsc.atom.api.FscOrderStatusFlowAtomService;
import com.tydic.fsc.atom.api.bo.FscDealPaySuccessAtomReqBO;
import com.tydic.fsc.atom.api.bo.FscDealPaySuccessAtomRspBO;
import com.tydic.fsc.atom.api.bo.FscOrderStatusFlowAtomReqBO;
import com.tydic.fsc.atom.api.bo.FscOrderStatusFlowAtomRspBO;
import com.tydic.fsc.busi.api.FscPayBillCallbackBusiService;
import com.tydic.fsc.busi.api.bo.FscPayBillCallbackBusiReqBO;
import com.tydic.fsc.busi.api.bo.FscPayBillCallbackBusiRspBO;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscPayOrderMapper;
import com.tydic.fsc.dao.FscPayRelationMapper;
import com.tydic.fsc.dao.po.FscPayOrderPO;
import com.tydic.fsc.dao.po.FscPayRelationPO;
import com.tydic.fsc.exception.FscBusinessException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class FscPayBillCallbackBusiServiceImpl
implements FscPayBillCallbackBusiService {
    @Autowired
    private FscPayOrderMapper fscPayOrderMapper;
    @Autowired
    private FscPayRelationMapper fscPayRelationMapper;
    @Autowired
    private FscDealPaySuccessAtomService fscDealPaySuccessAtomService;
    @Autowired
    private FscOrderStatusFlowAtomService fscOrderStatusFlowAtomService;
    @Autowired
    private FscComOrderSyncAbilityService fscComOrderSyncAbilityService;

    public FscPayBillCallbackBusiRspBO dealPayBillCallback(FscPayBillCallbackBusiReqBO busiReqBO) {
        ArrayList<Long> resultFscOrderIds = new ArrayList<Long>();
        Long payOrderId = Long.parseLong(busiReqBO.getFscPayCallbackContentBO().getOutOrderId());
        this.updatePayOrder(payOrderId);
        List<Long> payFscOrderId = this.getFscOrderId(payOrderId);
        this.invokeFscOrderStatusFlow(payFscOrderId);
        List<Long> temp = this.updateFscOrderOrOrder(payFscOrderId);
        resultFscOrderIds.addAll(payFscOrderId);
        if (!CollectionUtils.isEmpty(temp)) {
            resultFscOrderIds.addAll(temp);
        }
        FscPayBillCallbackBusiRspBO busiRspBO = new FscPayBillCallbackBusiRspBO();
        busiRspBO.setResultFscOrderIds(resultFscOrderIds);
        busiRspBO.setRespCode("0000");
        busiRspBO.setRespDesc("\u652f\u4ed8\u56de\u8c03\u6210\u529f");
        return busiRspBO;
    }

    private List<Long> updateFscOrderOrOrder(List<Long> payFscOrderId) {
        FscDealPaySuccessAtomReqBO fscDealPaySuccessAtomReqBO = new FscDealPaySuccessAtomReqBO();
        fscDealPaySuccessAtomReqBO.setPayFscOrderId(payFscOrderId);
        HashMap<String, Integer> paramMap = new HashMap<String, Integer>();
        paramMap.put("confirmFlag", FscConstants.ProcessParam.confirmFlag0);
        fscDealPaySuccessAtomReqBO.setParamMap(paramMap);
        FscDealPaySuccessAtomRspBO atomRspBO = this.fscDealPaySuccessAtomService.dealPaySuccess(fscDealPaySuccessAtomReqBO);
        if (!"0000".equals(atomRspBO.getRespCode())) {
            throw new FscBusinessException(atomRspBO.getRespCode(), atomRspBO.getRespDesc());
        }
        return atomRspBO.getResultFscOrderIds();
    }

    private void updatePayOrder(Long payOrderId) {
        FscPayOrderPO fscPayOrderPO = new FscPayOrderPO();
        fscPayOrderPO.setPayStatus(FscConstants.PayOrderPayStatus.PAIED);
        fscPayOrderPO.setUpdateTime(new Date());
        fscPayOrderPO.setPayOrderId(payOrderId);
        int count = this.fscPayOrderMapper.updateById(fscPayOrderPO);
        if (count != 1) {
            throw new FscBusinessException("184000", "\u652f\u4ed8\u5355\u4e0d\u5b58\u5728\uff01");
        }
    }

    private List<Long> getFscOrderId(Long payOrderId) {
        FscPayRelationPO fscPayRelationPO = new FscPayRelationPO();
        fscPayRelationPO.setPayOrderId(payOrderId);
        List pos = this.fscPayRelationMapper.getList(fscPayRelationPO);
        ArrayList<Long> fscOrderIds = new ArrayList<Long>();
        pos.forEach(fscPayRelationPO1 -> fscOrderIds.add(fscPayRelationPO1.getFscOrderId()));
        return fscOrderIds;
    }

    private void invokeFscOrderStatusFlow(List<Long> payFscOrderId) {
        FscOrderStatusFlowAtomReqBO fscOrderStatusFlowAtomReqBO = new FscOrderStatusFlowAtomReqBO();
        HashMap<String, Integer> paramMap = new HashMap<String, Integer>();
        paramMap.put("confirmFlag", FscConstants.ProcessParam.confirmFlag0);
        payFscOrderId.forEach(fscOrderId -> {
            fscOrderStatusFlowAtomReqBO.setCurStatus(FscConstants.FscPayOrderState.TO_PAY);
            fscOrderStatusFlowAtomReqBO.setOrderId(fscOrderId);
            fscOrderStatusFlowAtomReqBO.setParamMap(paramMap);
            FscOrderStatusFlowAtomRspBO atomRspBO = this.fscOrderStatusFlowAtomService.dealStatusFlow(fscOrderStatusFlowAtomReqBO);
            if (!"0000".equals(atomRspBO.getRespCode())) {
                throw new FscBusinessException(atomRspBO.getRespCode(), atomRspBO.getRespDesc());
            }
        });
    }
}

