/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.service.busi.impl;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.fsc.atom.api.FscOrderStatusStartAtomService;
import com.tydic.fsc.atom.api.bo.FscOrderStatusStartAtomReqBO;
import com.tydic.fsc.atom.api.bo.FscOrderStatusStartAtomRspBO;
import com.tydic.fsc.busi.api.FscPayBillCreateBusiService;
import com.tydic.fsc.busi.api.bo.FscPayBillCreateBusiReqBO;
import com.tydic.fsc.busi.api.bo.FscPayBillCreateBusiRspBO;
import com.tydic.fsc.common.bo.FscOrderPayItemBO;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscOrderMapper;
import com.tydic.fsc.dao.FscOrderPayItemMapper;
import com.tydic.fsc.dao.FscShouldPayMapper;
import com.tydic.fsc.dao.po.FscOrderPO;
import com.tydic.fsc.dao.po.FscOrderPayItemPO;
import com.tydic.fsc.dao.po.FscShouldPayPO;
import com.tydic.fsc.enums.FscShouldPayNoEnum;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.plugin.encoded.service.EncodedSerialGetService;
import com.tydic.plugin.encoded.service.bo.EncodedSerialGetServiceReqBO;
import com.tydic.uac.ability.UacNoTaskAuditCreateAbilityService;
import com.tydic.uac.ability.bo.UacNoTaskAuditCreateInfoReqBO;
import com.tydic.uac.ability.bo.UacNoTaskAuditCreateReqBO;
import com.tydic.uac.ability.bo.UacNoTaskAuditCreateRspBO;
import com.tydic.uac.bo.common.ApprovalObjBO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class FscPayBillCreateBusiServiceImpl
implements FscPayBillCreateBusiService {
    @Autowired
    private FscOrderMapper fscOrderMapper;
    @Autowired
    private FscShouldPayMapper fscShouldPayMapper;
    @Autowired
    private FscOrderPayItemMapper fscOrderPayItemMapper;
    @Autowired
    private UacNoTaskAuditCreateAbilityService uacNoTaskAuditCreateAbilityService;
    @Autowired
    private FscOrderStatusStartAtomService fscOrderStatusStartAtomService;
    @Autowired
    private EncodedSerialGetService encodedSerialGetService;

    public FscPayBillCreateBusiRspBO dealPayBillCreate(FscPayBillCreateBusiReqBO busiReqBO) {
        FscPayBillCreateBusiRspBO busiRspBO = new FscPayBillCreateBusiRspBO();
        Long fscOrderId = Sequence.getInstance().nextId();
        List<FscOrderPayItemPO> fscOrderPayItemPOs = null;
        if (!CollectionUtils.isEmpty((Collection)busiReqBO.getFscOrderPayItemBOS())) {
            fscOrderPayItemPOs = this.updateShouldPay(busiReqBO, fscOrderId);
            if (busiReqBO.getPayFscOrderId() != null) {
                busiRspBO.setFscOrderId(busiReqBO.getPayFscOrderId());
                return busiRspBO;
            }
        } else {
            fscOrderPayItemPOs = this.insertShouldPay(busiReqBO, fscOrderId);
        }
        this.fscOrderPayItemMapper.insertBatch(fscOrderPayItemPOs);
        this.insertOrder(busiReqBO, fscOrderId);
        this.invokeUacNoTask(busiReqBO, fscOrderId);
        busiRspBO.setFscOrderId(fscOrderId);
        busiRspBO.setRespCode("0000");
        busiRspBO.setRespDesc("\u4ed8\u6b3e\u7533\u8bf7\u5355\u521b\u5efa\u6210\u529f");
        return busiRspBO;
    }

    private void invokeUacNoTask(FscPayBillCreateBusiReqBO busiReqBO, Long fscOrderId) {
        UacNoTaskAuditCreateReqBO uacNoTaskAuditCreateReqBO = new UacNoTaskAuditCreateReqBO();
        uacNoTaskAuditCreateReqBO.setCreateOperId(busiReqBO.getUserId().toString());
        uacNoTaskAuditCreateReqBO.setCreateOperName(busiReqBO.getName());
        uacNoTaskAuditCreateReqBO.setCreateOperDept(busiReqBO.getOrgName());
        uacNoTaskAuditCreateReqBO.setIsSaveCreateLog(Boolean.valueOf(true));
        uacNoTaskAuditCreateReqBO.setMenuId("fscPayApplyOrder");
        uacNoTaskAuditCreateReqBO.setOrgId(busiReqBO.getOrgId().toString());
        ArrayList<UacNoTaskAuditCreateInfoReqBO> createBusiReqBO = new ArrayList<UacNoTaskAuditCreateInfoReqBO>();
        UacNoTaskAuditCreateInfoReqBO uacNoTaskAuditCreateInfoReqBO = new UacNoTaskAuditCreateInfoReqBO();
        uacNoTaskAuditCreateInfoReqBO.setObjType(FscConstants.AuditObjType.PAY_APPLY_ORDER);
        uacNoTaskAuditCreateInfoReqBO.setObjNum("1");
        uacNoTaskAuditCreateInfoReqBO.setOrderId(fscOrderId);
        createBusiReqBO.add(uacNoTaskAuditCreateInfoReqBO);
        ArrayList<ApprovalObjBO> approvalObjInfo = new ArrayList<ApprovalObjBO>();
        ApprovalObjBO approvalObjBO = new ApprovalObjBO();
        approvalObjBO.setObjId(fscOrderId.toString());
        approvalObjBO.setObjName("\u4ed8\u6b3e\u7533\u8bf7\u5355");
        approvalObjBO.setObjType(FscConstants.AuditObjType.PAY_APPLY_ORDER);
        approvalObjInfo.add(approvalObjBO);
        uacNoTaskAuditCreateInfoReqBO.setApprovalObjInfo(approvalObjInfo);
        uacNoTaskAuditCreateReqBO.setCreateBusiReqBO(createBusiReqBO);
        UacNoTaskAuditCreateRspBO uacNoTaskAuditCreateRspBO = this.uacNoTaskAuditCreateAbilityService.auditOrderCreate(uacNoTaskAuditCreateReqBO);
        if (!"0000".equals(uacNoTaskAuditCreateRspBO.getRespCode())) {
            throw new FscBusinessException(uacNoTaskAuditCreateRspBO.getRespCode(), uacNoTaskAuditCreateRspBO.getRespDesc());
        }
        FscOrderStatusStartAtomReqBO fscOrderStatusStartAtomReqBO = (FscOrderStatusStartAtomReqBO)JSON.parseObject((String)JSON.toJSONString((Object)busiReqBO), FscOrderStatusStartAtomReqBO.class);
        if (!uacNoTaskAuditCreateRspBO.getNotFindFlag().booleanValue() && uacNoTaskAuditCreateRspBO.getFinish().booleanValue()) {
            HashMap<String, Integer> paramMap = new HashMap<String, Integer>();
            paramMap.put("auditFlag", FscConstants.ProcessParam.auditFlag);
            fscOrderStatusStartAtomReqBO.setParamMap(paramMap);
        }
        fscOrderStatusStartAtomReqBO.setOrderId(fscOrderId);
        fscOrderStatusStartAtomReqBO.setOrderFlow(FscConstants.OrderFlow.PAY);
        fscOrderStatusStartAtomReqBO.setOperId(busiReqBO.getUserName());
        FscOrderStatusStartAtomRspBO fscOrderStatusStartAtomRspBO = this.fscOrderStatusStartAtomService.dealStatusStart(fscOrderStatusStartAtomReqBO);
        if (!"0000".equals(fscOrderStatusStartAtomRspBO.getRespCode())) {
            throw new FscBusinessException(fscOrderStatusStartAtomRspBO.getRespCode(), fscOrderStatusStartAtomRspBO.getRespDesc());
        }
    }

    private void insertOrder(FscPayBillCreateBusiReqBO busiReqBO, Long fscOrderId) {
        FscOrderPO fscOrderPO = new FscOrderPO();
        fscOrderPO.setFscOrderId(fscOrderId);
        fscOrderPO.setOrderFlow(FscConstants.OrderFlow.PAY);
        EncodedSerialGetServiceReqBO encodedSerialGetServiceReqBO = new EncodedSerialGetServiceReqBO();
        encodedSerialGetServiceReqBO.setCenter("FSC");
        encodedSerialGetServiceReqBO.setEncodedRuleCode("PAYMENT_REQUEST_NO");
        encodedSerialGetServiceReqBO.setNum(Integer.valueOf(1));
        encodedSerialGetServiceReqBO.setOrgType("-1");
        fscOrderPO.setOrderNo("\u4ed8\u6b3e\u5355\u53f7");
        fscOrderPO.setPayerId(busiReqBO.getPayerId());
        fscOrderPO.setPayerName(busiReqBO.getPayerName());
        fscOrderPO.setPayeeId(busiReqBO.getPayeeId());
        fscOrderPO.setPayeeName(busiReqBO.getPayeeName());
        fscOrderPO.setPayeeBankAccount(busiReqBO.getPayeeBankAccount());
        fscOrderPO.setPayeeBankName(busiReqBO.getPayeeBankName());
        fscOrderPO.setPayMethod(busiReqBO.getPayMethod());
        fscOrderPO.setPayType(busiReqBO.getPayType());
        fscOrderPO.setShouldPayType(busiReqBO.getShouldPayType());
        fscOrderPO.setPayChannel(busiReqBO.getPayChannel());
        fscOrderPO.setCreateOperId(busiReqBO.getUserId());
        fscOrderPO.setCreateOperName(busiReqBO.getName());
        fscOrderPO.setCreateTime(new Date());
        fscOrderPO.setCreateCompanyId(busiReqBO.getCompanyId());
        fscOrderPO.setCreateCompanyName(busiReqBO.getCompanyName());
        fscOrderPO.setCreateOrgId(busiReqBO.getOrgId());
        fscOrderPO.setCreateOrgName(busiReqBO.getOrgName());
        fscOrderPO.setTotalCharge(busiReqBO.getTotalAmount());
        this.fscOrderMapper.insert(fscOrderPO);
    }

    private List<FscOrderPayItemPO> updateShouldPay(FscPayBillCreateBusiReqBO busiReqBO, Long fscOrderId) {
        FscShouldPayPO fscShouldPayPO1 = new FscShouldPayPO();
        ArrayList shouldPayIds = new ArrayList();
        busiReqBO.getFscOrderPayItemBOS().forEach(fscOrderPayItemBO -> shouldPayIds.add(fscOrderPayItemBO.getShouldPayId()));
        fscShouldPayPO1.setShouldPayIds(shouldPayIds);
        List poResult = this.fscShouldPayMapper.getList(fscShouldPayPO1);
        if (CollectionUtils.isEmpty((Collection)poResult)) {
            throw new FscBusinessException("188673", "\u5e94\u4ed8\u4fe1\u606f\u4e0d\u5b58\u5728\uff01");
        }
        HashSet shouldPayType = new HashSet();
        HashSet payerIds = new HashSet();
        HashSet payeeIds = new HashSet();
        HashSet contractNos = new HashSet();
        HashSet payType = new HashSet();
        poResult.forEach(fscShouldPayPO -> {
            if (null != fscShouldPayPO.getShouldPayType()) {
                shouldPayType.add(fscShouldPayPO.getShouldPayType());
                busiReqBO.setShouldPayType(fscShouldPayPO.getShouldPayType());
            }
            if (null != fscShouldPayPO.getPayerId()) {
                payerIds.add(fscShouldPayPO.getPayerId());
                busiReqBO.setPayerId(fscShouldPayPO.getPayerId());
                busiReqBO.setPayerName(fscShouldPayPO.getPayerName());
            }
            if (null != fscShouldPayPO.getPayeeId()) {
                payeeIds.add(fscShouldPayPO.getPayeeId());
                busiReqBO.setPayeeId(fscShouldPayPO.getPayeeId());
                busiReqBO.setPayeeName(fscShouldPayPO.getPayeeName());
            }
            if (null != fscShouldPayPO.getPayType()) {
                payType.add(fscShouldPayPO.getPayType());
                busiReqBO.setPayType(fscShouldPayPO.getPayType());
            }
            if (StringUtils.hasText((String)fscShouldPayPO.getContractNo())) {
                contractNos.add(fscShouldPayPO.getContractNo());
                busiReqBO.setContractNo(fscShouldPayPO.getContractNo());
            }
        });
        if (shouldPayType.size() > 1) {
            throw new FscBusinessException("188673", "\u5e94\u4ed8\u7c7b\u578b\u5fc5\u987b\u552f\u4e00\uff01");
        }
        if (payerIds.size() > 1) {
            throw new FscBusinessException("188673", "\u4ed8\u6b3e\u65b9\u5fc5\u987b\u552f\u4e00\uff01");
        }
        if (payeeIds.size() > 1) {
            throw new FscBusinessException("188673", "\u6536\u6b3e\u65b9\u5fc5\u987b\u552f\u4e00\uff01");
        }
        if (payType.size() > 1) {
            throw new FscBusinessException("188673", "\u4ed8\u6b3e\u65b9\u5f0f\u5fc5\u987b\u552f\u4e00\uff01");
        }
        if (contractNos.size() > 1) {
            throw new FscBusinessException("188673", "\u5408\u540c\u7f16\u53f7\u5fc5\u987b\u552f\u4e00\uff01");
        }
        if (!FscConstants.ShouldPayType.PAYMENT_DAY_PAY.equals(busiReqBO.getShouldPayType())) {
            FscOrderPayItemPO fscOrderPayItemPO = new FscOrderPayItemPO();
            fscOrderPayItemPO.setShouldPayIds(shouldPayIds);
            List itemPOS = this.fscOrderPayItemMapper.getList(fscOrderPayItemPO);
            if (!CollectionUtils.isEmpty((Collection)itemPOS) && itemPOS.size() == shouldPayIds.size()) {
                HashSet payFscOrderIds = new HashSet();
                itemPOS.forEach(fscOrderPayItemPO1 -> payFscOrderIds.add(fscOrderPayItemPO1.getFscOrderId()));
                if (payFscOrderIds.size() == 1) {
                    FscOrderPO fscOrderPO = new FscOrderPO();
                    fscOrderPO.setFscOrderId((Long)payFscOrderIds.iterator().next());
                    fscOrderPO.setOrderState(FscConstants.FscPayOrderState.TO_PAY);
                    FscOrderPO po = this.fscOrderMapper.getModelBy(fscOrderPO);
                    if (po != null) {
                        busiReqBO.setPayFscOrderId(po.getFscOrderId());
                        return null;
                    }
                    throw new FscBusinessException("188673", "\u5f53\u524d\u5e94\u4ed8\u4fe1\u606f\u5df2\u5b58\u5728\u4ed8\u6b3e\u7533\u8bf7\u5355\uff0c\u4e14\u4e0d\u662f\u5f85\u4ed8\u6b3e\u72b6\u6001\uff01");
                }
                throw new FscBusinessException("188673", "\u5f53\u524d\u5e94\u4ed8\u4fe1\u606f\u5b58\u5728\u591a\u4e2a\u4ed8\u6b3e\u7533\u8bf7\u5355\uff0c\u8bf7\u5230\u4ed8\u6b3e\u7533\u8bf7\u9875\u9762\u8fdb\u884c\u652f\u4ed8\uff01");
            }
        }
        ArrayList<FscOrderPayItemPO> fscOrderPayItemPOs = new ArrayList<FscOrderPayItemPO>();
        BigDecimal totalAmount = new BigDecimal(0);
        for (FscOrderPayItemBO fscOrderPayItemBO2 : busiReqBO.getFscOrderPayItemBOS()) {
            FscShouldPayPO fscShouldPayPO2 = new FscShouldPayPO();
            fscShouldPayPO2.setShouldPayId(fscOrderPayItemBO2.getShouldPayId());
            fscShouldPayPO2.setPayAmount(fscOrderPayItemBO2.getPayAmount());
            int count = this.fscShouldPayMapper.updateAmount(fscShouldPayPO2);
            if (count != 1) {
                throw new FscBusinessException("188673", "\u4ed8\u6b3e\u91d1\u989d\u5927\u4e8e\u5f85\u4ed8\u91d1\u989d\uff01");
            }
            FscOrderPayItemPO po = new FscOrderPayItemPO();
            po.setFscOrderId(fscOrderId);
            po.setOrderPayItemId(Long.valueOf(Sequence.getInstance().nextId()));
            po.setShouldPayId(fscOrderPayItemBO2.getShouldPayId());
            po.setPayAmount(fscOrderPayItemBO2.getPayAmount());
            fscOrderPayItemPOs.add(po);
            totalAmount = totalAmount.add(fscOrderPayItemBO2.getPayAmount());
        }
        busiReqBO.setTotalAmount(totalAmount);
        return fscOrderPayItemPOs;
    }

    private List<FscOrderPayItemPO> insertShouldPay(FscPayBillCreateBusiReqBO busiReqBO, Long fscOrderId) {
        List fscShouldPayPOS = JSON.parseArray((String)JSON.toJSONString((Object)busiReqBO.getFscShouldPayBOS()), FscShouldPayPO.class);
        ArrayList<FscOrderPayItemPO> fscOrderPayItemPOs = new ArrayList<FscOrderPayItemPO>();
        BigDecimal totalAmount = new BigDecimal(0);
        Object serialNoList = null;
        if (FscShouldPayNoEnum.getInstance((Integer)((FscShouldPayPO)fscShouldPayPOS.get(0)).getShouldPayType()) == null) {
            throw new FscBusinessException("184000", "\u5e94\u4ed8\u7c7b\u578b\u6ca1\u5b9a\u4e49\u679a\u4e3e");
        }
        EncodedSerialGetServiceReqBO encodedSerialGetServiceReqBO = new EncodedSerialGetServiceReqBO();
        encodedSerialGetServiceReqBO.setCenter("FSC");
        encodedSerialGetServiceReqBO.setNum(Integer.valueOf(fscShouldPayPOS.size()));
        encodedSerialGetServiceReqBO.setOrgType("-1");
        encodedSerialGetServiceReqBO.setEncodedRuleCode(FscShouldPayNoEnum.getInstance((Integer)((FscShouldPayPO)fscShouldPayPOS.get(0)).getShouldPayType()).getDescr());
        for (int i = 0; i < fscShouldPayPOS.size(); ++i) {
            FscShouldPayPO fscShouldPayPO = (FscShouldPayPO)fscShouldPayPOS.get(i);
            Long shouldPayId = Sequence.getInstance().nextId();
            fscShouldPayPO.setShouldPayId(shouldPayId);
            fscShouldPayPO.setCreateId(busiReqBO.getUserId());
            fscShouldPayPO.setCreateName(busiReqBO.getName());
            fscShouldPayPO.setCreateAccount(busiReqBO.getUserName());
            fscShouldPayPO.setCreateTime(new Date());
            fscShouldPayPO.setCreateCompanyId(busiReqBO.getCompanyId());
            fscShouldPayPO.setCreateCompanyName(busiReqBO.getCompanyName());
            fscShouldPayPO.setCreateOrgId(busiReqBO.getOrgId());
            fscShouldPayPO.setCreateOrgName(busiReqBO.getOrgName());
            fscShouldPayPO.setPayingAmount(fscShouldPayPO.getShouldPayAmount());
            fscShouldPayPO.setPaidAmount(new BigDecimal(0));
            fscShouldPayPO.setToPayAmount(new BigDecimal(0));
            fscShouldPayPO.setShouldPayNo("serialNoList.get(i)");
            fscShouldPayPO.setPenalty(new BigDecimal(0));
            fscShouldPayPO.setOriginalAmount(fscShouldPayPO.getShouldPayAmount());
            fscShouldPayPO.setShouldPayStatus(FscConstants.ShouldPayStatus.TO_PAY);
            FscOrderPayItemPO po = new FscOrderPayItemPO();
            po.setFscOrderId(fscOrderId);
            po.setOrderPayItemId(Long.valueOf(Sequence.getInstance().nextId()));
            po.setShouldPayId(shouldPayId);
            po.setPayAmount(fscShouldPayPO.getShouldPayAmount());
            fscOrderPayItemPOs.add(po);
            totalAmount = totalAmount.add(fscShouldPayPO.getShouldPayAmount());
        }
        busiReqBO.setTotalAmount(totalAmount);
        this.fscShouldPayMapper.insertBatch(fscShouldPayPOS);
        return fscOrderPayItemPOs;
    }
}

