/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.service.busi.impl;

import com.alibaba.fastjson.JSON;
import com.tydic.fsc.ability.api.FscComOrderSyncAbilityService;
import com.tydic.fsc.atom.api.FscDealPaySuccessAtomService;
import com.tydic.fsc.atom.api.FscOrderStatusFlowAtomService;
import com.tydic.fsc.atom.api.bo.FscDealPaySuccessAtomReqBO;
import com.tydic.fsc.atom.api.bo.FscDealPaySuccessAtomRspBO;
import com.tydic.fsc.atom.api.bo.FscOrderStatusFlowAtomReqBO;
import com.tydic.fsc.atom.api.bo.FscOrderStatusFlowAtomRspBO;
import com.tydic.fsc.busi.api.FscPayConfirmBusiService;
import com.tydic.fsc.busi.api.bo.FscPayConfirmBusiReqBO;
import com.tydic.fsc.busi.api.bo.FscPayConfirmBusiRspBO;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscOrderMapper;
import com.tydic.fsc.dao.po.FscOrderPO;
import com.tydic.fsc.exception.FscBusinessException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class FscPayConfirmBusiServiceImpl
implements FscPayConfirmBusiService {
    @Autowired
    private FscDealPaySuccessAtomService fscDealPaySuccessAtomService;
    @Autowired
    private FscOrderMapper fscOrderMapper;
    @Autowired
    private FscOrderStatusFlowAtomService fscOrderStatusFlowAtomService;
    @Autowired
    private FscComOrderSyncAbilityService fscComOrderSyncAbilityService;

    public FscPayConfirmBusiRspBO dealPayConfirm(FscPayConfirmBusiReqBO busiReqBO) {
        ArrayList resultFscOrderIds = new ArrayList();
        FscOrderPO set = new FscOrderPO();
        set.setPayConfirmId(busiReqBO.getUserName());
        set.setPayConfirmName(busiReqBO.getName());
        set.setPayConfirmTime(new Date());
        FscOrderPO where = new FscOrderPO();
        where.setFscOrderIds(busiReqBO.getFscOrderIds());
        this.fscOrderMapper.updateBy(set, where);
        this.invokeFscOrderStatusFlow(busiReqBO);
        if (busiReqBO.getPayFlag().booleanValue()) {
            FscDealPaySuccessAtomReqBO fscDealPaySuccessAtomReqBO = new FscDealPaySuccessAtomReqBO();
            fscDealPaySuccessAtomReqBO.setPayFscOrderId(busiReqBO.getFscOrderIds());
            FscDealPaySuccessAtomRspBO atomRspBO = this.fscDealPaySuccessAtomService.dealPaySuccess(fscDealPaySuccessAtomReqBO);
            if (!"0000".equals(atomRspBO.getRespCode())) {
                throw new FscBusinessException(atomRspBO.getRespCode(), atomRspBO.getRespDesc());
            }
            if (!CollectionUtils.isEmpty((Collection)atomRspBO.getResultFscOrderIds())) {
                resultFscOrderIds.addAll(atomRspBO.getResultFscOrderIds());
            }
        }
        resultFscOrderIds.addAll(busiReqBO.getFscOrderIds());
        FscPayConfirmBusiRspBO busiRspBO = new FscPayConfirmBusiRspBO();
        busiRspBO.setResultFscOrderIds(resultFscOrderIds);
        return busiRspBO;
    }

    private void invokeFscOrderStatusFlow(FscPayConfirmBusiReqBO busiReqBO) {
        FscOrderStatusFlowAtomReqBO fscOrderStatusFlowAtomReqBO = (FscOrderStatusFlowAtomReqBO)JSON.parseObject((String)JSON.toJSONString((Object)busiReqBO), FscOrderStatusFlowAtomReqBO.class);
        HashMap<String, Integer> paramMap = new HashMap<String, Integer>();
        if (busiReqBO.getPayFlag().booleanValue()) {
            paramMap.put("payFlag", FscConstants.ProcessParam.payFlag1);
        } else {
            paramMap.put("payFlag", FscConstants.ProcessParam.payFlag0);
        }
        busiReqBO.getFscOrderIds().forEach(fscOrderId -> {
            fscOrderStatusFlowAtomReqBO.setCurStatus(FscConstants.FscPayOrderState.PAIED_TO_COMFIR);
            fscOrderStatusFlowAtomReqBO.setOrderId(fscOrderId);
            fscOrderStatusFlowAtomReqBO.setParamMap(paramMap);
            FscOrderStatusFlowAtomRspBO atomRspBO = this.fscOrderStatusFlowAtomService.dealStatusFlow(fscOrderStatusFlowAtomReqBO);
            if (!"0000".equals(atomRspBO.getRespCode())) {
                throw new FscBusinessException(atomRspBO.getRespCode(), atomRspBO.getRespDesc());
            }
        });
    }
}

