/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.service.busi.impl;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.fsc.atom.api.FscOrderStatusStartAtomService;
import com.tydic.fsc.atom.api.bo.FscOrderStatusStartAtomReqBO;
import com.tydic.fsc.atom.api.bo.FscOrderStatusStartAtomRspBO;
import com.tydic.fsc.busi.api.FscPayServiceBillCreateBusiService;
import com.tydic.fsc.busi.api.bo.FscPayServiceBillCreateBusiReqBO;
import com.tydic.fsc.busi.api.bo.FscPayServiceBillCreateBusiRspBO;
import com.tydic.fsc.common.bo.RelOrderBO;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscOrderInvoiceMapper;
import com.tydic.fsc.dao.FscOrderMapper;
import com.tydic.fsc.dao.FscOrderRelationMapper;
import com.tydic.fsc.dao.po.FscOrderInvoicePO;
import com.tydic.fsc.dao.po.FscOrderPO;
import com.tydic.fsc.dao.po.FscOrderRelationPO;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.external.api.bo.FscUocOrderRelUpdateReqBO;
import com.tydic.fsc.external.api.bo.FscUocOrderRelUpdateRspBO;
import com.tydic.fsc.external.api.uoc.FscUocOrderRelUpdateAbilityService;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class FscPayServiceBillCreateBusiServiceImpl
implements FscPayServiceBillCreateBusiService {
    @Autowired
    private FscOrderMapper fscOrderMapper;
    @Autowired
    private FscOrderInvoiceMapper fscOrderInvoiceMapper;
    @Autowired
    private FscOrderRelationMapper fscOrderRelationMapper;
    private static final String BUSI_NAME = "\u670d\u52a1\u8d39\u4e3b\u5355\u521b\u5efa";
    @Autowired
    private FscUocOrderRelUpdateAbilityService fscUocOrderRelUpdateAbilityService;
    @Autowired
    private FscOrderStatusStartAtomService fscOrderStatusStartAtomService;

    public FscPayServiceBillCreateBusiRspBO dealPayServiceOrdCreate(FscPayServiceBillCreateBusiReqBO reqBO) {
        Long fscOrderId = Sequence.getInstance().nextId();
        this.insertOrder(reqBO, fscOrderId);
        this.insertOrderInvoice(reqBO, fscOrderId);
        this.insertOrderRelation(reqBO, fscOrderId);
        FscOrderStatusStartAtomReqBO fscOrderStatusStartAtomReqBO = new FscOrderStatusStartAtomReqBO();
        fscOrderStatusStartAtomReqBO.setOrderId(fscOrderId);
        fscOrderStatusStartAtomReqBO.setOrderFlow(FscConstants.OrderFlow.MONTH_SERVICE_FEE);
        fscOrderStatusStartAtomReqBO.setBusiName(BUSI_NAME);
        HashMap<String, Integer> paramMap = new HashMap<String, Integer>(4);
        paramMap.put("processFlag", FscConstants.ServiceFeeProcessFlag.UNDO);
        fscOrderStatusStartAtomReqBO.setOperId(reqBO.getUserId().toString());
        fscOrderStatusStartAtomReqBO.setParamMap(paramMap);
        FscOrderStatusStartAtomRspBO fscOrderStatusStartAtomRspBO = this.fscOrderStatusStartAtomService.dealStatusStart(fscOrderStatusStartAtomReqBO);
        if (!"0000".equals(fscOrderStatusStartAtomRspBO.getRespCode())) {
            throw new FscBusinessException("188682", fscOrderStatusStartAtomRspBO.getRespDesc());
        }
        for (RelOrderBO relOrderBO : reqBO.getRelOrderBOList()) {
            FscUocOrderRelUpdateReqBO uocOrderRelUpdateReqBo = new FscUocOrderRelUpdateReqBO();
            uocOrderRelUpdateReqBo.setOrderId(relOrderBO.getOrderId());
            uocOrderRelUpdateReqBo.setInspectionVoucherId(relOrderBO.getAcceptOrderId());
            uocOrderRelUpdateReqBo.setRelType(FscConstants.FscRelType.SERVICE_INVOICE);
            uocOrderRelUpdateReqBo.setRelState(FscConstants.FscRelStatus.COMMITTED);
            FscUocOrderRelUpdateRspBO fscUocOrderRelUpdateRspBO = this.fscUocOrderRelUpdateAbilityService.dealRelUpdate(uocOrderRelUpdateReqBo);
            if ("0000".equals(fscUocOrderRelUpdateRspBO.getRespCode())) continue;
            throw new FscBusinessException("188682", fscUocOrderRelUpdateRspBO.getRespDesc());
        }
        return new FscPayServiceBillCreateBusiRspBO();
    }

    private void insertOrder(FscPayServiceBillCreateBusiReqBO busiReqBO, Long fscOrderId) {
        FscOrderPO fscOrderPO = (FscOrderPO)JSON.parseObject((String)JSON.toJSONString((Object)busiReqBO), FscOrderPO.class);
        fscOrderPO.setFscOrderId(fscOrderId);
        fscOrderPO.setOrderFlow(FscConstants.OrderFlow.MONTH_SERVICE_FEE);
        fscOrderPO.setPayerId(busiReqBO.getSupplierId());
        fscOrderPO.setPayeeId(busiReqBO.getProOrgId());
        fscOrderPO.setPayeeBankAccount(busiReqBO.getAccount());
        fscOrderPO.setShouldPayType(FscConstants.ShouldPayType.DEAL_PAY);
        fscOrderPO.setCreateOperId(busiReqBO.getUserId());
        fscOrderPO.setCreateOperName(busiReqBO.getName());
        fscOrderPO.setCreateTime(new Date());
        fscOrderPO.setCreateCompanyId(busiReqBO.getCompanyId());
        fscOrderPO.setCreateCompanyName(busiReqBO.getCompanyName());
        fscOrderPO.setCreateOrgId(busiReqBO.getOrgId());
        fscOrderPO.setCreateOrgName(busiReqBO.getOrgName());
        fscOrderPO.setTotalCharge(busiReqBO.getTotalCharge());
        int insert = this.fscOrderMapper.insert(fscOrderPO);
        if (insert != 1) {
            throw new FscBusinessException("188682", "\u670d\u52a1\u8d39\u4e3b\u5355\u521b\u5efa----\u751f\u6210\u4ed8\u6b3e\u4e3b\u5355\u5931\u8d25");
        }
    }

    private void insertOrderInvoice(FscPayServiceBillCreateBusiReqBO busiReqBO, Long fscOrderId) {
        FscOrderInvoicePO fscOrderInvoicePO = (FscOrderInvoicePO)JSON.parseObject((String)JSON.toJSONString((Object)busiReqBO), FscOrderInvoicePO.class);
        fscOrderInvoicePO.setFscOrderId(fscOrderId);
        fscOrderInvoicePO.setBillOperId(busiReqBO.getUserId().toString());
        fscOrderInvoicePO.setBillOperName(busiReqBO.getUserName());
        fscOrderInvoicePO.setBillTime(new Date());
        int insert = this.fscOrderInvoiceMapper.insert(fscOrderInvoicePO);
        if (insert != 1) {
            throw new FscBusinessException("188682", "\u670d\u52a1\u8d39\u4e3b\u5355\u521b\u5efa----\u751f\u6210\u53d1\u7968\u4fe1\u606f\u5931\u8d25");
        }
    }

    private void insertOrderRelation(FscPayServiceBillCreateBusiReqBO busiReqBO, Long fscOrderId) {
        List relOrderBOList = busiReqBO.getRelOrderBOList();
        List fscOrderRelationPOS = JSON.parseArray((String)JSON.toJSONString((Object)busiReqBO.getRelOrderBOList()), FscOrderRelationPO.class);
        for (FscOrderRelationPO fscOrderRelationPO : fscOrderRelationPOS) {
            Long id = Sequence.getInstance().nextId();
            fscOrderRelationPO.setId(id);
            fscOrderRelationPO.setFscOrderId(fscOrderId);
            fscOrderRelationPO.setOrderNo(busiReqBO.getOrderNo());
        }
        this.fscOrderRelationMapper.insertBatch(fscOrderRelationPOS);
    }
}

