/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.service.busi.impl;

import com.alibaba.fastjson.JSON;
import com.tydic.fsc.atom.api.FscOrderStatusFlowAtomService;
import com.tydic.fsc.atom.api.bo.FscOrderStatusFlowAtomReqBO;
import com.tydic.fsc.atom.api.bo.FscOrderStatusFlowAtomRspBO;
import com.tydic.fsc.busi.api.FscPayServiceBillProcessBusiService;
import com.tydic.fsc.busi.api.bo.FscPayServiceBillProcessBusiReqBO;
import com.tydic.fsc.busi.api.bo.FscPayServiceBillProcessBusiRspBO;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscOrderMapper;
import com.tydic.fsc.dao.po.FscOrderPO;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.uac.ability.UacNoTaskAuditCreateAbilityService;
import com.tydic.uac.ability.bo.UacNoTaskAuditCreateInfoReqBO;
import com.tydic.uac.ability.bo.UacNoTaskAuditCreateReqBO;
import com.tydic.uac.ability.bo.UacNoTaskAuditCreateRspBO;
import com.tydic.uac.bo.common.ApprovalObjBO;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class FscPayServiceBillProcessBusiServiceImpl
implements FscPayServiceBillProcessBusiService {
    @Autowired
    private FscOrderMapper fscOrderMapper;
    @Autowired
    private UacNoTaskAuditCreateAbilityService uacNoTaskAuditCreateAbilityService;
    @Autowired
    private FscOrderStatusFlowAtomService fscOrderStatusFlowAtomService;

    public FscPayServiceBillProcessBusiRspBO dealPayServiceBillProcess(FscPayServiceBillProcessBusiReqBO busiReqBO) {
        this.updateOrder(busiReqBO);
        this.invokeUacNoTask(busiReqBO);
        return new FscPayServiceBillProcessBusiRspBO();
    }

    private void updateOrder(FscPayServiceBillProcessBusiReqBO busiReqBO) {
        FscOrderPO fscOrderPO = new FscOrderPO();
        fscOrderPO.setFscOrderId(busiReqBO.getFscOrderId());
        FscOrderPO rspPo = this.fscOrderMapper.getModelBy(fscOrderPO);
        if (busiReqBO.getCreditAmount().compareTo(rspPo.getTotalCharge()) == 1) {
            throw new FscBusinessException("184000", "\u51cf\u514d\u91d1\u989d\u4e0d\u80fd\u5927\u4e8e\u6536\u8d39\u91d1\u989d\uff01");
        }
        FscOrderPO set = new FscOrderPO();
        set.setDiscountOperId(busiReqBO.getUserName());
        set.setDiscountOperName(busiReqBO.getName());
        set.setDiscountOperTime(new Date());
        set.setCreditAmount(busiReqBO.getCreditAmount());
        set.setActualAmount(rspPo.getTotalCharge().subtract(busiReqBO.getCreditAmount()));
        FscOrderPO where = new FscOrderPO();
        where.setFscOrderId(busiReqBO.getFscOrderId());
        this.fscOrderMapper.updateBy(set, where);
    }

    private void invokeUacNoTask(FscPayServiceBillProcessBusiReqBO busiReqBO) {
        UacNoTaskAuditCreateReqBO uacNoTaskAuditCreateReqBO = new UacNoTaskAuditCreateReqBO();
        uacNoTaskAuditCreateReqBO.setCreateOperId(busiReqBO.getUserId().toString());
        uacNoTaskAuditCreateReqBO.setCreateOperName(busiReqBO.getName());
        uacNoTaskAuditCreateReqBO.setCreateOperDept(busiReqBO.getOrgName());
        uacNoTaskAuditCreateReqBO.setIsSaveCreateLog(Boolean.valueOf(true));
        uacNoTaskAuditCreateReqBO.setMenuId("fscServiceOrderProcess");
        uacNoTaskAuditCreateReqBO.setOrgId(busiReqBO.getOrgId().toString());
        ArrayList<UacNoTaskAuditCreateInfoReqBO> createBusiReqBO = new ArrayList<UacNoTaskAuditCreateInfoReqBO>();
        UacNoTaskAuditCreateInfoReqBO uacNoTaskAuditCreateInfoReqBO = new UacNoTaskAuditCreateInfoReqBO();
        uacNoTaskAuditCreateInfoReqBO.setObjType(FscConstants.AuditObjType.SERVICE_PROCESS_APPROVAL);
        uacNoTaskAuditCreateInfoReqBO.setObjNum("1");
        uacNoTaskAuditCreateInfoReqBO.setOrderId(busiReqBO.getFscOrderId());
        createBusiReqBO.add(uacNoTaskAuditCreateInfoReqBO);
        ArrayList<ApprovalObjBO> approvalObjInfo = new ArrayList<ApprovalObjBO>();
        ApprovalObjBO approvalObjBO = new ApprovalObjBO();
        approvalObjBO.setObjId(busiReqBO.getFscOrderId().toString());
        approvalObjBO.setObjName("\u670d\u52a1\u8d39\u51cf\u514d\u5904\u7406\u5355");
        approvalObjBO.setObjType(FscConstants.AuditObjType.SERVICE_PROCESS_APPROVAL);
        approvalObjInfo.add(approvalObjBO);
        uacNoTaskAuditCreateInfoReqBO.setApprovalObjInfo(approvalObjInfo);
        uacNoTaskAuditCreateReqBO.setCreateBusiReqBO(createBusiReqBO);
        UacNoTaskAuditCreateRspBO uacNoTaskAuditCreateRspBO = this.uacNoTaskAuditCreateAbilityService.auditOrderCreate(uacNoTaskAuditCreateReqBO);
        if (!"0000".equals(uacNoTaskAuditCreateRspBO.getRespCode())) {
            throw new FscBusinessException(uacNoTaskAuditCreateRspBO.getRespCode(), uacNoTaskAuditCreateRspBO.getRespDesc());
        }
        FscOrderStatusFlowAtomReqBO fscOrderStatusFlowAtomReqBO = (FscOrderStatusFlowAtomReqBO)JSON.parseObject((String)JSON.toJSONString((Object)busiReqBO), FscOrderStatusFlowAtomReqBO.class);
        if (!uacNoTaskAuditCreateRspBO.getNotFindFlag().booleanValue() && uacNoTaskAuditCreateRspBO.getFinish().booleanValue()) {
            HashMap<String, Integer> paramMap = new HashMap<String, Integer>();
            paramMap.put("auditFlag", FscConstants.ProcessParam.auditFlag);
            fscOrderStatusFlowAtomReqBO.setParamMap(paramMap);
        }
        fscOrderStatusFlowAtomReqBO.setCurStatus(FscConstants.FscServiceOrderState.TO_PROCESS);
        fscOrderStatusFlowAtomReqBO.setOrderId(busiReqBO.getFscOrderId());
        FscOrderStatusFlowAtomRspBO atomRspBO = this.fscOrderStatusFlowAtomService.dealStatusFlow(fscOrderStatusFlowAtomReqBO);
        if (!"0000".equals(atomRspBO.getRespCode())) {
            throw new FscBusinessException(atomRspBO.getRespCode(), atomRspBO.getRespDesc());
        }
    }
}

