/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.pay.ability.impl;

import com.alibaba.boot.hsf.annotation.HSFProvider;
import com.alibaba.fastjson.JSON;
import com.tydic.fsc.base.FscRspBaseBO;
import com.tydic.fsc.busibase.busi.api.FscOrderFailLogUpdateBusiService;
import com.tydic.fsc.busibase.busi.bo.FscOrderFailLogUpdateBusiReqBO;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscOrderFailLogMapper;
import com.tydic.fsc.pay.ability.api.FscPayOrderSyncRetransAbilityService;
import com.tydic.fsc.pay.ability.api.FscPayServiceBillCreateAbilityService;
import com.tydic.fsc.pay.ability.bo.FscPayOrderSyncRetransAbilityReqBO;
import com.tydic.fsc.pay.ability.bo.FscPayOrderSyncRetransAbilityRspBO;
import com.tydic.fsc.pay.ability.bo.FscPayServiceBillCreateAbilityReqBO;
import com.tydic.fsc.po.FscOrderFailLogPO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;

@HSFProvider(serviceVersion="1.0.0", serviceGroup="FSC_GROUP_DEV", serviceInterface=FscPayOrderSyncRetransAbilityService.class)
public class FscPayOrderSyncRetransAbilityServiceImpl
implements FscPayOrderSyncRetransAbilityService {
    @Autowired
    private FscOrderFailLogMapper fscOrderFailLogMapper;
    @Autowired
    private FscOrderFailLogUpdateBusiService fscOrderFailLogUpdateBusiService;
    @Autowired
    private FscPayServiceBillCreateAbilityService fscPayServiceBillCreateAbilityService;

    public FscPayOrderSyncRetransAbilityRspBO dealRetrans(FscPayOrderSyncRetransAbilityReqBO reqBO) {
        FscOrderFailLogPO fscOrderFailLogPO = (FscOrderFailLogPO)JSON.parseObject((String)JSON.toJSONString((Object)reqBO), FscOrderFailLogPO.class);
        fscOrderFailLogPO.setDealStatus(FscConstants.FscOrderFailRetransDealStatus.WAIT_DEAL);
        ArrayList<Integer> busiTypes = new ArrayList<Integer>();
        busiTypes.add(FscConstants.FscOrderFailRetansBusiType.FSC_PL_SERVICE_FEE_ORDER_CREATE_FAIL);
        fscOrderFailLogPO.setBusiTypes(busiTypes);
        List fscOrderFailLogPOS = this.fscOrderFailLogMapper.getList(fscOrderFailLogPO);
        if (!CollectionUtils.isEmpty((Collection)fscOrderFailLogPOS)) {
            for (FscOrderFailLogPO fscOrderFailLog : fscOrderFailLogPOS) {
                this.updateStatus(FscConstants.FscOrderFailRetransDealStatus.DEALLING, fscOrderFailLog.getId(), null);
                FscRspBaseBO fscRspBaseBO = null;
                if (FscConstants.FscOrderFailRetansBusiType.FSC_PL_SERVICE_FEE_ORDER_CREATE_FAIL.equals(fscOrderFailLog.getBusiType())) {
                    fscRspBaseBO = this.dealFailPayServiceOrderCreate(fscOrderFailLog);
                }
                if (null != fscRspBaseBO) {
                    this.updateStatus(this.getDealStatus(fscRspBaseBO), fscOrderFailLog.getId(), fscRspBaseBO.getRespDesc());
                    continue;
                }
                this.updateStatus(FscConstants.FscOrderFailRetransDealStatus.WAIT_DEAL, fscOrderFailLog.getId(), null);
            }
        }
        return new FscPayOrderSyncRetransAbilityRspBO();
    }

    private FscRspBaseBO dealFailPayServiceOrderCreate(FscOrderFailLogPO fscOrderFailLog) {
        return this.fscPayServiceBillCreateAbilityService.dealPayServiceOrdCreate((FscPayServiceBillCreateAbilityReqBO)JSON.parseObject((String)fscOrderFailLog.getBusiFailReq(), FscPayServiceBillCreateAbilityReqBO.class));
    }

    private void updateStatus(Integer status, Long id, String desc) {
        FscOrderFailLogUpdateBusiReqBO fscOrderFailLogUpdateBusiReqBO = new FscOrderFailLogUpdateBusiReqBO();
        fscOrderFailLogUpdateBusiReqBO.setId(id);
        fscOrderFailLogUpdateBusiReqBO.setDealStatus(status);
        fscOrderFailLogUpdateBusiReqBO.setDealResultDesc(desc);
        this.fscOrderFailLogUpdateBusiService.dealUpdate(fscOrderFailLogUpdateBusiReqBO);
    }

    private Integer getDealStatus(FscRspBaseBO fscRspBaseBO) {
        if ("0000".equals(fscRspBaseBO.getRespCode())) {
            return FscConstants.FscOrderFailRetransDealStatus.SUCCESS;
        }
        return FscConstants.FscOrderFailRetransDealStatus.FAIL;
    }
}

