/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.pay.busi.impl;

import com.tydic.fsc.busibase.atom.api.FscOrderStatusFlowAtomService;
import com.tydic.fsc.busibase.atom.bo.FscOrderStatusFlowAtomReqBO;
import com.tydic.fsc.busibase.atom.bo.FscOrderStatusFlowAtomRspBO;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscOrderMapper;
import com.tydic.fsc.dao.FscPayOrderMapper;
import com.tydic.fsc.dao.FscPayRelationMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.pay.atom.api.FscDealPaySuccessAtomService;
import com.tydic.fsc.pay.atom.bo.FscDealPaySuccessAtomReqBO;
import com.tydic.fsc.pay.atom.bo.FscDealPaySuccessAtomRspBO;
import com.tydic.fsc.pay.busi.api.FscPayBillCallbackBusiService;
import com.tydic.fsc.pay.busi.bo.FscPayBillCallbackBusiReqBO;
import com.tydic.fsc.pay.busi.bo.FscPayBillCallbackBusiRspBO;
import com.tydic.fsc.po.FscOrderPO;
import com.tydic.fsc.po.FscPayOrderPO;
import com.tydic.fsc.po.FscPayRelationPO;
import com.tydic.payment.bill.util.DateUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class FscPayBillCallbackBusiServiceImpl
implements FscPayBillCallbackBusiService {
    @Autowired
    private FscPayOrderMapper fscPayOrderMapper;
    @Autowired
    private FscPayRelationMapper fscPayRelationMapper;
    @Autowired
    private FscDealPaySuccessAtomService fscDealPaySuccessAtomService;
    @Autowired
    private FscOrderStatusFlowAtomService fscOrderStatusFlowAtomService;
    @Autowired
    private FscOrderMapper fscOrderMapper;

    @Override
    public FscPayBillCallbackBusiRspBO dealPayBillCallback(FscPayBillCallbackBusiReqBO busiReqBO) {
        Long payOrderId = Long.parseLong(busiReqBO.getFscPayCallbackContentBO().getOutOrderId());
        this.updatePayOrder(payOrderId, busiReqBO);
        List<Long> payFscOrderId = this.getFscOrderId(payOrderId);
        this.invokeFscOrderStatusFlow(payFscOrderId, busiReqBO);
        List<Long> temp = this.updateFscOrderOrOrder(payFscOrderId, busiReqBO);
        ArrayList<Long> resultFscOrderIds = new ArrayList<Long>(payFscOrderId);
        if (!CollectionUtils.isEmpty(temp)) {
            resultFscOrderIds.addAll(temp);
        }
        FscOrderPO set = new FscOrderPO();
        set.setPayOperId(busiReqBO.getFscPayCallbackContentBO().getCreateOperId());
        set.setPayOperName(busiReqBO.getFscPayCallbackContentBO().getCreatOperName());
        set.setPayTime(DateUtil.strToDateyyyyMMddHHmmss((String)busiReqBO.getFscPayCallbackContentBO().getTradeTime()));
        set.setTransactionId(busiReqBO.getFscPayCallbackContentBO().getPayNotifyTransId());
        set.setUpdateTime(new Date());
        FscOrderPO where = new FscOrderPO();
        where.setFscOrderIds(payFscOrderId);
        this.fscOrderMapper.updateBy(set, where);
        FscPayBillCallbackBusiRspBO busiRspBO = new FscPayBillCallbackBusiRspBO();
        busiRspBO.setResultFscOrderIds(resultFscOrderIds);
        busiRspBO.setRespCode("0000");
        busiRspBO.setRespDesc("\u652f\u4ed8\u56de\u8c03\u6210\u529f");
        return busiRspBO;
    }

    private List<Long> updateFscOrderOrOrder(List<Long> payFscOrderId, FscPayBillCallbackBusiReqBO busiReqBO) {
        FscDealPaySuccessAtomReqBO fscDealPaySuccessAtomReqBO = new FscDealPaySuccessAtomReqBO();
        fscDealPaySuccessAtomReqBO.setFscPayCallbackContentBO(busiReqBO.getFscPayCallbackContentBO());
        fscDealPaySuccessAtomReqBO.setPayFscOrderId(payFscOrderId);
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("confirmFlag", FscConstants.ProcessParam.confirmFlag0);
        fscDealPaySuccessAtomReqBO.setParamMap(paramMap);
        FscDealPaySuccessAtomRspBO atomRspBO = this.fscDealPaySuccessAtomService.dealPaySuccess(fscDealPaySuccessAtomReqBO);
        if (!"0000".equals(atomRspBO.getRespCode())) {
            throw new FscBusinessException("193201", atomRspBO.getRespDesc());
        }
        return atomRspBO.getResultFscOrderIds();
    }

    private void updatePayOrder(Long payOrderId, FscPayBillCallbackBusiReqBO busiReqBO) {
        FscPayOrderPO fscPayOrderPO = new FscPayOrderPO();
        if (!StringUtils.isBlank((CharSequence)busiReqBO.getFscPayCallbackContentBO().getResultCode()) && "FAIL".equals(busiReqBO.getFscPayCallbackContentBO().getResultCode())) {
            fscPayOrderPO.setPayStatus(FscConstants.PayOrderPayStatus.PAY_FAIL);
        } else {
            fscPayOrderPO.setPayStatus(FscConstants.PayOrderPayStatus.PAIED);
        }
        fscPayOrderPO.setUpdateTime(new Date());
        fscPayOrderPO.setPayOrderId(payOrderId);
        int count = this.fscPayOrderMapper.updateById(fscPayOrderPO);
        if (count != 1) {
            throw new FscBusinessException("193201", "\u652f\u4ed8\u5355\u4e0d\u5b58\u5728\uff01");
        }
    }

    private List<Long> getFscOrderId(Long payOrderId) {
        FscPayRelationPO fscPayRelationPO = new FscPayRelationPO();
        fscPayRelationPO.setPayOrderId(payOrderId);
        List pos = this.fscPayRelationMapper.getList(fscPayRelationPO);
        ArrayList<Long> fscOrderIds = new ArrayList<Long>();
        pos.forEach(fscPayRelationPO1 -> fscOrderIds.add(fscPayRelationPO1.getFscOrderId()));
        return fscOrderIds;
    }

    private void invokeFscOrderStatusFlow(List<Long> payFscOrderId, FscPayBillCallbackBusiReqBO busiReqBO) {
        FscOrderStatusFlowAtomReqBO fscOrderStatusFlowAtomReqBO = new FscOrderStatusFlowAtomReqBO();
        HashMap<String, Integer> paramMap = new HashMap<String, Integer>();
        if (!StringUtils.isBlank((CharSequence)busiReqBO.getFscPayCallbackContentBO().getResultCode()) && "FAIL".equals(busiReqBO.getFscPayCallbackContentBO().getResultCode())) {
            paramMap.put("confirmFlag", FscConstants.ProcessParam.confirmFlag3);
        } else {
            paramMap.put("confirmFlag", FscConstants.ProcessParam.confirmFlag0);
        }
        payFscOrderId.forEach(fscOrderId -> {
            fscOrderStatusFlowAtomReqBO.setCurStatus(FscConstants.FscPayOrderState.TO_PAY);
            fscOrderStatusFlowAtomReqBO.setOrderId(fscOrderId);
            fscOrderStatusFlowAtomReqBO.setParamMap(paramMap);
            FscOrderStatusFlowAtomRspBO atomRspBO = this.fscOrderStatusFlowAtomService.dealStatusFlow(fscOrderStatusFlowAtomReqBO);
            if (!"0000".equals(atomRspBO.getRespCode())) {
                throw new FscBusinessException("193201", atomRspBO.getRespDesc());
            }
        });
    }
}

