/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.pay.busi.impl;

import com.alibaba.fastjson.JSON;
import com.tydic.fsc.busibase.atom.api.FscOrderStatusFlowAtomService;
import com.tydic.fsc.busibase.atom.bo.FscOrderStatusFlowAtomReqBO;
import com.tydic.fsc.busibase.atom.bo.FscOrderStatusFlowAtomRspBO;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscOrderMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.pay.busi.api.FscPayServiceBillProcessBusiService;
import com.tydic.fsc.pay.busi.bo.FscPayServiceBillProcessBusiReqBO;
import com.tydic.fsc.pay.busi.bo.FscPayServiceBillProcessBusiRspBO;
import com.tydic.fsc.po.FscOrderPO;
import com.tydic.plugin.encoded.service.CfcEncodedSerialGetService;
import com.tydic.plugin.encoded.service.bo.CfcEncodedSerialGetServiceReqBO;
import com.tydic.plugin.encoded.service.bo.CfcEncodedSerialGetServiceRspBO;
import com.tydic.uac.ability.UacNoTaskAuditCreateAbilityService;
import com.tydic.uac.ability.bo.UacNoTaskAuditCreateInfoReqBO;
import com.tydic.uac.ability.bo.UacNoTaskAuditCreateReqBO;
import com.tydic.uac.ability.bo.UacNoTaskAuditCreateRspBO;
import com.tydic.uac.bo.common.ApprovalObjBO;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class FscPayServiceBillProcessBusiServiceImpl
implements FscPayServiceBillProcessBusiService {
    private static final Logger log = LoggerFactory.getLogger(FscPayServiceBillProcessBusiServiceImpl.class);
    @Autowired
    private FscOrderMapper fscOrderMapper;
    @Autowired
    private UacNoTaskAuditCreateAbilityService uacNoTaskAuditCreateAbilityService;
    @Autowired
    private FscOrderStatusFlowAtomService fscOrderStatusFlowAtomService;
    @Autowired
    private CfcEncodedSerialGetService encodedSerialGetService;

    @Override
    public FscPayServiceBillProcessBusiRspBO dealPayServiceBillProcess(FscPayServiceBillProcessBusiReqBO busiReqBO) {
        this.updateOrder(busiReqBO, busiReqBO.getFscOrderPO());
        this.invokeUacNoTask(busiReqBO);
        return new FscPayServiceBillProcessBusiRspBO();
    }

    private void updateOrder(FscPayServiceBillProcessBusiReqBO busiReqBO, FscOrderPO fscOrderPO) {
        if (busiReqBO.getCreditAmount().compareTo(fscOrderPO.getTotalCharge()) > 0) {
            throw new FscBusinessException("193208", "\u51cf\u514d\u91d1\u989d\u4e0d\u80fd\u5927\u4e8e\u6536\u8d39\u91d1\u989d\uff01");
        }
        CfcEncodedSerialGetServiceReqBO encodedSerialGetServiceReqBO = new CfcEncodedSerialGetServiceReqBO();
        encodedSerialGetServiceReqBO.setCenter("FSC");
        encodedSerialGetServiceReqBO.setNum(Integer.valueOf(1));
        encodedSerialGetServiceReqBO.setOrgType("-1");
        if (FscConstants.OrderFlow.MONTH_SERVICE_FEE.equals(fscOrderPO.getOrderFlow())) {
            encodedSerialGetServiceReqBO.setEncodedRuleCode("MONTH_DEAL_SERVICE_FEE_CREDIT_ORDER_NO");
        }
        if (FscConstants.OrderFlow.YEAR_ORDER_SERVICE_FEE.equals(fscOrderPO.getOrderFlow()) || FscConstants.OrderFlow.YEAR_ACCEPT_SERVICE_FEE.equals(fscOrderPO.getOrderFlow())) {
            encodedSerialGetServiceReqBO.setEncodedRuleCode("YEAR_DEAL_SERVICE_FEE_CREDIT_ORDER_NO");
        }
        if (FscConstants.OrderFlow.PL_SERVICE_FEE.equals(fscOrderPO.getOrderFlow())) {
            encodedSerialGetServiceReqBO.setEncodedRuleCode("PLATFORM_SERVICE_FEE_CREDIT_ORDER_NO");
        }
        CfcEncodedSerialGetServiceRspBO encodedSerialGetServiceRspBO = this.encodedSerialGetService.getEncodedSerial(encodedSerialGetServiceReqBO);
        FscOrderPO set = new FscOrderPO();
        set.setCreditNo((String)encodedSerialGetServiceRspBO.getSerialNoList().get(0));
        set.setDiscountOperId(busiReqBO.getUserName());
        set.setDiscountOperName(busiReqBO.getName());
        set.setDiscountOperTime(new Date());
        set.setCreditAmount(busiReqBO.getCreditAmount());
        set.setActualAmount(fscOrderPO.getTotalCharge().subtract(busiReqBO.getCreditAmount()));
        FscOrderPO where = new FscOrderPO();
        where.setFscOrderId(busiReqBO.getFscOrderId());
        this.fscOrderMapper.updateBy(set, where);
    }

    private void invokeUacNoTask(FscPayServiceBillProcessBusiReqBO busiReqBO) {
        UacNoTaskAuditCreateReqBO uacNoTaskAuditCreateReqBO = new UacNoTaskAuditCreateReqBO();
        uacNoTaskAuditCreateReqBO.setCreateOperId(busiReqBO.getUserId().toString());
        uacNoTaskAuditCreateReqBO.setCreateOperName(busiReqBO.getName());
        uacNoTaskAuditCreateReqBO.setCreateOperDept(busiReqBO.getOrgName());
        uacNoTaskAuditCreateReqBO.setIsSaveCreateLog(Boolean.valueOf(true));
        uacNoTaskAuditCreateReqBO.setMenuId("fscServiceOrderProcess");
        uacNoTaskAuditCreateReqBO.setOrgId(busiReqBO.getOrgId().toString());
        ArrayList<UacNoTaskAuditCreateInfoReqBO> createBusiReqBO = new ArrayList<UacNoTaskAuditCreateInfoReqBO>();
        UacNoTaskAuditCreateInfoReqBO uacNoTaskAuditCreateInfoReqBO = new UacNoTaskAuditCreateInfoReqBO();
        uacNoTaskAuditCreateInfoReqBO.setObjType(FscConstants.AuditObjType.SERVICE_PROCESS_APPROVAL);
        uacNoTaskAuditCreateInfoReqBO.setObjNum("1");
        uacNoTaskAuditCreateInfoReqBO.setOrderId(busiReqBO.getFscOrderId());
        createBusiReqBO.add(uacNoTaskAuditCreateInfoReqBO);
        ArrayList<ApprovalObjBO> approvalObjInfo = new ArrayList<ApprovalObjBO>();
        ApprovalObjBO approvalObjBO = new ApprovalObjBO();
        approvalObjBO.setObjId(busiReqBO.getFscOrderId().toString());
        approvalObjBO.setObjName("\u670d\u52a1\u8d39\u51cf\u514d\u5904\u7406\u5355");
        approvalObjBO.setObjType(FscConstants.AuditObjType.SERVICE_PROCESS_APPROVAL);
        approvalObjInfo.add(approvalObjBO);
        uacNoTaskAuditCreateInfoReqBO.setApprovalObjInfo(approvalObjInfo);
        uacNoTaskAuditCreateReqBO.setCreateBusiReqBO(createBusiReqBO);
        if (log.isDebugEnabled()) {
            log.debug("\u5ba1\u6279\u5355\u521b\u5efa\u5165\u53c2:{}", (Object)JSON.toJSONString((Object)uacNoTaskAuditCreateInfoReqBO));
        }
        UacNoTaskAuditCreateRspBO uacNoTaskAuditCreateRspBO = this.uacNoTaskAuditCreateAbilityService.auditOrderCreate(uacNoTaskAuditCreateReqBO);
        if (log.isDebugEnabled()) {
            log.debug("\u5ba1\u6279\u5355\u521b\u5efa\u51fa\u53c2:{}", (Object)JSON.toJSONString((Object)uacNoTaskAuditCreateRspBO));
        }
        if (!"0000".equals(uacNoTaskAuditCreateRspBO.getRespCode())) {
            throw new FscBusinessException("193208", uacNoTaskAuditCreateRspBO.getRespDesc());
        }
        FscOrderStatusFlowAtomReqBO fscOrderStatusFlowAtomReqBO = (FscOrderStatusFlowAtomReqBO)JSON.parseObject((String)JSON.toJSONString((Object)((Object)busiReqBO)), FscOrderStatusFlowAtomReqBO.class);
        HashMap<String, Integer> paramMap = new HashMap<String, Integer>();
        paramMap.put("auditFlag", FscConstants.ProcessParam.auditFlag);
        if (uacNoTaskAuditCreateRspBO.getNotFindFlag().booleanValue()) {
            paramMap.put("auditFlag", FscConstants.ProcessParam.auditFlag2);
        }
        if (uacNoTaskAuditCreateRspBO.getFinish().booleanValue()) {
            paramMap.put("auditFlag", FscConstants.ProcessParam.auditFlag2);
        }
        fscOrderStatusFlowAtomReqBO.setParamMap(paramMap);
        fscOrderStatusFlowAtomReqBO.setCurStatus(FscConstants.FscServiceOrderState.TO_PROCESS);
        fscOrderStatusFlowAtomReqBO.setOrderId(busiReqBO.getFscOrderId());
        FscOrderStatusFlowAtomRspBO atomRspBO = this.fscOrderStatusFlowAtomService.dealStatusFlow(fscOrderStatusFlowAtomReqBO);
        if (!"0000".equals(atomRspBO.getRespCode())) {
            throw new FscBusinessException("193208", atomRspBO.getRespDesc());
        }
    }
}

