/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.pay.ability.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import com.tydic.fsc.bo.FscAuditBaseBo;
import com.tydic.fsc.common.ability.api.FscComOrderSyncAbilityService;
import com.tydic.fsc.common.ability.bo.FscComOrderListSyncAbilityReqBO;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.pay.ability.api.FscPayBillCreateAbilityService;
import com.tydic.fsc.pay.ability.bo.FscPayBillCreateAbilityReqBO;
import com.tydic.fsc.pay.ability.bo.FscPayBillCreateAbilityRspBO;
import com.tydic.fsc.pay.busi.api.FscPayBillCreateBusiService;
import com.tydic.fsc.pay.busi.bo.FscPayBillCreateBusiReqBO;
import com.tydic.fsc.pay.busi.bo.FscPayBillCreateBusiRspBO;
import com.tydic.fsc.utils.BigDecimalConvert;
import com.tydic.osworkflow.approve.ability.EacProjectAbilityService;
import com.tydic.osworkflow.approve.ability.bo.EacStartProjectAbilityReqBO;
import com.tydic.osworkflow.approve.ability.bo.EacStartProjectAbilityRspBO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.fsc.pay.ability.api.FscPayBillCreateAbilityService"})
public class FscPayBillCreateAbilityServiceImpl
implements FscPayBillCreateAbilityService {
    private static final Logger log = LoggerFactory.getLogger(FscPayBillCreateAbilityServiceImpl.class);
    @Autowired
    private FscPayBillCreateBusiService fscPayBillCreateBusiService;
    @Autowired
    private FscComOrderSyncAbilityService fscComOrderSyncAbilityService;
    @Resource(name="fscTodoSyncProvider")
    private ProxyMessageProducer fscTodoSyncProvider;
    @Value(value="${FSC_TODO_SYNC_TOPIC:FSC_TODO_SYNC_TOPIC}")
    private String fscTodoSyncTopic;
    @Value(value="${FSC_TODO_SYNC_TAG:FSC_TODO_SYNC_TAG}")
    private String fscTodoSyncTag;
    @Resource(name="fscOrderPayStatusSyncServiceProvider")
    private ProxyMessageProducer fscOrderPayStatusSyncServiceProvider;
    @Value(value="${FSC_ORDER_PAY_STATUS_SYNC_ORDER_TOPIC:FSC_ORDER_PAY_STATUS_SYNC_ORDER_TOPIC}")
    private String fscOrderPayStatusSyncOrderTopic;
    @Value(value="${FSC_ORDER_PAY_STATUS_SYNC_ORDER_TAG:FSC_ORDER_PAY_STATUS_SYNC_ORDER_TAG}")
    private String fscOrderPayStatusSyncOrderTag;
    @Value(value="${process.sysCode}")
    private String processSysCode;
    @Autowired
    private EacProjectAbilityService eacProjectAbilityService;

    @BigDecimalConvert
    @PostMapping(value={"dealPayBillCreate"})
    public FscPayBillCreateAbilityRspBO dealPayBillCreate(@RequestBody FscPayBillCreateAbilityReqBO abilityReqBO) {
        this.validParam(abilityReqBO);
        FscPayBillCreateBusiReqBO fscPayBillCreateBusiReqBO = (FscPayBillCreateBusiReqBO)((Object)JSONObject.parseObject((String)JSONObject.toJSONString((Object)abilityReqBO), FscPayBillCreateBusiReqBO.class));
        FscPayBillCreateBusiRspBO busiRspBO = this.fscPayBillCreateBusiService.dealPayBillCreate(fscPayBillCreateBusiReqBO);
        if ("0000".equals(busiRspBO.getRespCode())) {
            if (busiRspBO.getIsStartAuditFlow().booleanValue()) {
                this.startAuditFlow(abilityReqBO, busiRspBO.getFscAuditBaseBo());
            }
            FscComOrderListSyncAbilityReqBO fscComOrderListSyncAbilityReqBO = new FscComOrderListSyncAbilityReqBO();
            fscComOrderListSyncAbilityReqBO.setFscOrderId(busiRspBO.getFscOrderId());
            this.fscComOrderSyncAbilityService.dealComOrderSyncEs(fscComOrderListSyncAbilityReqBO);
            if (!CollectionUtils.isEmpty(busiRspBO.getServiceFscOrderIds())) {
                for (Long serviceFscOrderId : busiRspBO.getServiceFscOrderIds()) {
                    this.syncServiceEs(serviceFscOrderId);
                }
            }
            if (null != busiRspBO.getFscTodoBO()) {
                JSONObject jsonObject = new JSONObject();
                jsonObject.put("newStatus", (Object)busiRspBO.getFscTodoBO().getNewStatus());
                jsonObject.put("fscOrderId", (Object)busiRspBO.getFscTodoBO().getFscOrderId());
                this.fscTodoSyncProvider.send(new ProxyMessage(this.fscTodoSyncTopic, this.fscTodoSyncTag, JSON.toJSONString((Object)jsonObject)));
            }
            ArrayList<Long> fscOrderIds = new ArrayList<Long>();
            fscOrderIds.add(busiRspBO.getFscOrderId());
            this.fscOrderPayStatusSyncServiceProvider.send(new ProxyMessage(this.fscOrderPayStatusSyncOrderTopic, this.fscOrderPayStatusSyncOrderTag, JSON.toJSONString(fscOrderIds)));
        }
        FscPayBillCreateAbilityRspBO abilityRspBO = new FscPayBillCreateAbilityRspBO();
        BeanUtils.copyProperties((Object)((Object)busiRspBO), (Object)abilityRspBO);
        return abilityRspBO;
    }

    private void syncServiceEs(Long serviceFscOrderId) {
        FscComOrderListSyncAbilityReqBO fscComOrderListSyncAbilityReqBO = new FscComOrderListSyncAbilityReqBO();
        fscComOrderListSyncAbilityReqBO.setFscOrderId(serviceFscOrderId);
        this.fscComOrderSyncAbilityService.dealComOrderSyncEs(fscComOrderListSyncAbilityReqBO);
    }

    private void startAuditFlow(FscPayBillCreateAbilityReqBO reqBO, FscAuditBaseBo fscAuditBaseBo) {
        EacStartProjectAbilityReqBO eacStartProjectAbilityReqBO = (EacStartProjectAbilityReqBO)JSON.parseObject((String)JSON.toJSONString((Object)reqBO), EacStartProjectAbilityReqBO.class);
        eacStartProjectAbilityReqBO.setSysCode(this.processSysCode);
        eacStartProjectAbilityReqBO.setProcDefKey(fscAuditBaseBo.getProcDefKey());
        eacStartProjectAbilityReqBO.setPartitionKey(fscAuditBaseBo.getPartitionKey());
        eacStartProjectAbilityReqBO.setVariables(fscAuditBaseBo.getVariables());
        eacStartProjectAbilityReqBO.setBusinessIdList(fscAuditBaseBo.getBusinessIdList());
        eacStartProjectAbilityReqBO.setUserName(reqBO.getName());
        log.info("\u8c03\u7528\u6d41\u7a0b\u5ba1\u6279\u542f\u52a8\u5165\u53c2\u4e3a\uff1a" + JSON.toJSONString((Object)eacStartProjectAbilityReqBO));
        EacStartProjectAbilityRspBO eacStartProjectAbilityRspBO = this.eacProjectAbilityService.startProjectByMq(eacStartProjectAbilityReqBO);
        log.info("\u8c03\u7528\u6d41\u7a0b\u5ba1\u6279\u542f\u52a8\u51fa\u53c2\u4e3a\uff1a" + JSON.toJSONString((Object)eacStartProjectAbilityRspBO));
        if (!"0000".equals(eacStartProjectAbilityRspBO.getRespCode())) {
            throw new ZTBusinessException("\u8c03\u7528\u6d41\u7a0b\u5ba1\u6279\u542f\u52a8\u5931\u8d25,\u5f02\u5e38\u7f16\u7801\u3010" + eacStartProjectAbilityRspBO.getRespCode() + "\u3011," + eacStartProjectAbilityRspBO.getRespDesc());
        }
    }

    private void validParam(FscPayBillCreateAbilityReqBO abilityReqBO) {
        if (CollectionUtils.isEmpty((Collection)abilityReqBO.getFscOrderPayItemBOS()) && CollectionUtils.isEmpty((Collection)abilityReqBO.getFscShouldPayBOS())) {
            throw new FscBusinessException("191000", "\u4e3b\u5355\u5e94\u4ed8\u660e\u7ec6\u548c\u5e94\u4ed8\u8bb0\u5f55\u4e0d\u80fd\u540c\u65f6\u4e3a\u7a7a");
        }
        if (!CollectionUtils.isEmpty((Collection)abilityReqBO.getFscOrderPayItemBOS())) {
            abilityReqBO.setFscShouldPayBOS(null);
            abilityReqBO.getFscOrderPayItemBOS().forEach(fscOrderPayItemBO -> {
                if (fscOrderPayItemBO.getPayAmount() == null) {
                    throw new FscBusinessException("191000", "\u4ed8\u6b3e\u91d1\u989d\u4e3a\u7a7a");
                }
                if (fscOrderPayItemBO.getShouldPayId() == null) {
                    throw new FscBusinessException("191000", "\u5e94\u4ed8ID\u4e3a\u7a7a");
                }
                if (BigDecimal.ZERO.compareTo(fscOrderPayItemBO.getPayAmount()) >= 0) {
                    throw new FscBusinessException("191000", "\u4ed8\u6b3e\u91d1\u989d\u5fc5\u987b\u5927\u4e8eO!");
                }
            });
            return;
        }
        if (abilityReqBO.getPayType() == null) {
            throw new FscBusinessException("191000", "\u4ed8\u6b3e\u65b9\u5f0f\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (abilityReqBO.getShouldPayType() == null) {
            throw new FscBusinessException("191000", "\u5e94\u4ed8\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (abilityReqBO.getPayeeId() == null) {
            throw new FscBusinessException("191000", "\u6536\u6b3e\u65b9ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (abilityReqBO.getPayerId() == null) {
            throw new FscBusinessException("191000", "\u4ed8\u6b3e\u65b9ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        abilityReqBO.getFscShouldPayBOS().forEach(fscShouldPayBO -> {
            if (StringUtils.isEmpty((Object)fscShouldPayBO.getObjectNo())) {
                throw new FscBusinessException("191000", "\u5165\u53c2\u5355\u636e\u7f16\u7801\u4e3a\u7a7a\uff01");
            }
            if (StringUtils.isEmpty((Object)fscShouldPayBO.getShouldPayAmount())) {
                throw new FscBusinessException("191000", "\u5165\u53c2\u5e94\u4ed8\u91d1\u989d\u4e3a\u7a7a\uff01");
            }
            if (null == fscShouldPayBO.getObjectId()) {
                throw new FscBusinessException("191000", "\u5355\u636eID\u4e3a\u7a7a\uff01");
            }
            if (StringUtils.isEmpty((Object)fscShouldPayBO.getObjectType())) {
                throw new FscBusinessException("191000", "\u5165\u53c2\u5355\u636e\u7c7b\u578b\u4e3a\u7a7a\uff01");
            }
            fscShouldPayBO.setPayeeId(abilityReqBO.getPayeeId());
            fscShouldPayBO.setPayeeName(abilityReqBO.getPayeeName());
            fscShouldPayBO.setPayerId(abilityReqBO.getPayerId());
            fscShouldPayBO.setPayerName(abilityReqBO.getPayerName());
            fscShouldPayBO.setContractNo(abilityReqBO.getContractNo());
            fscShouldPayBO.setPayType(abilityReqBO.getPayType());
            fscShouldPayBO.setShouldPayType(abilityReqBO.getShouldPayType());
        });
    }
}

