/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.pay.atom.impl;

import cn.hutool.core.convert.Convert;
import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.fsc.bo.AttachmentBO;
import com.tydic.fsc.bo.FscAuditBaseBo;
import com.tydic.fsc.bo.FscOrderPayItemBO;
import com.tydic.fsc.bo.FscTodoBO;
import com.tydic.fsc.busibase.atom.api.FscAuditOrderCreateAtomService;
import com.tydic.fsc.busibase.atom.api.FscOrderStatusStartAtomService;
import com.tydic.fsc.busibase.atom.api.FscPayRecordTodoDealAtomService;
import com.tydic.fsc.busibase.atom.bo.FscAuditOrderCreateAtomReqBO;
import com.tydic.fsc.busibase.atom.bo.FscAuditOrderCreateAtomRspBO;
import com.tydic.fsc.busibase.atom.bo.FscOrderStatusStartAtomReqBO;
import com.tydic.fsc.busibase.atom.bo.FscOrderStatusStartAtomRspBO;
import com.tydic.fsc.busibase.atom.bo.FscPayRecordInfoBO;
import com.tydic.fsc.busibase.atom.bo.FscPayRecordTodoDealAtomReqBo;
import com.tydic.fsc.busibase.atom.bo.FscPayRecordTodoDealAtomRspBo;
import com.tydic.fsc.busibase.external.api.bo.FscOsWorkFlowReqBO;
import com.tydic.fsc.busibase.external.api.bo.FscOsWorkFlowRspBO;
import com.tydic.fsc.busibase.external.api.osworkflow.FscOsworkflowWhetherChartAtomService;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.constants.FscShouldPayNoEnum;
import com.tydic.fsc.dao.FscAttachmentMapper;
import com.tydic.fsc.dao.FscOrderMapper;
import com.tydic.fsc.dao.FscOrderPayItemMapper;
import com.tydic.fsc.dao.FscShouldPayMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.pay.atom.api.FscPayBillCreateAtomService;
import com.tydic.fsc.pay.atom.bo.FscPayBillCreateAtomReqBO;
import com.tydic.fsc.pay.atom.bo.FscPayBillCreateAtomRspBO;
import com.tydic.fsc.po.FscAttachmentPO;
import com.tydic.fsc.po.FscOrderPO;
import com.tydic.fsc.po.FscOrderPayItemPO;
import com.tydic.fsc.po.FscShouldPayPO;
import com.tydic.osworkflow.approve.ability.EacProjectAbilityService;
import com.tydic.plugin.encoded.service.CfcEncodedSerialGetService;
import com.tydic.plugin.encoded.service.bo.CfcEncodedSerialGetServiceReqBO;
import com.tydic.plugin.encoded.service.bo.CfcEncodedSerialGetServiceRspBO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class FscPayBillCreateAtomServiceImpl
implements FscPayBillCreateAtomService {
    private static final Logger log = LoggerFactory.getLogger(FscPayBillCreateAtomServiceImpl.class);
    @Autowired
    private FscOrderMapper fscOrderMapper;
    @Autowired
    private FscShouldPayMapper fscShouldPayMapper;
    @Autowired
    private FscOrderPayItemMapper fscOrderPayItemMapper;
    @Autowired
    private FscAttachmentMapper fscAttachmentMapper;
    @Autowired
    private FscAuditOrderCreateAtomService fscAuditOrderCreateAtomService;
    @Autowired
    private FscOrderStatusStartAtomService fscOrderStatusStartAtomService;
    @Autowired
    private CfcEncodedSerialGetService encodedSerialGetService;
    @Value(value="${no.need.audit.key :noNeedAudit}")
    private String noNeedAudit;
    @Value(value="${process.sysCode}")
    private String processSysCode;
    @Autowired
    private FscPayRecordTodoDealAtomService fscPayRecordTodoDealAtomService;
    @Autowired
    private FscOsworkflowWhetherChartAtomService fscOsworkflowWhetherChartAtomService;
    @Autowired
    private EacProjectAbilityService eacProjectAbilityService;

    @Override
    public FscPayBillCreateAtomRspBO dealPayBillCreate(FscPayBillCreateAtomReqBO atomReqBO) {
        FscPayBillCreateAtomRspBO atomRspBO = new FscPayBillCreateAtomRspBO();
        Long fscOrderId = Sequence.getInstance().nextId();
        List<FscOrderPayItemPO> fscOrderPayItemPOs = null;
        if (!CollectionUtils.isEmpty(atomReqBO.getFscOrderPayItemBOS())) {
            fscOrderPayItemPOs = this.updateShouldPay(atomReqBO, fscOrderId, atomRspBO);
            if (atomReqBO.getPayFscOrderId() != null) {
                atomRspBO.setFscOrderId(atomReqBO.getPayFscOrderId());
                return atomRspBO;
            }
        } else {
            fscOrderPayItemPOs = this.insertShouldPay(atomReqBO, fscOrderId);
        }
        this.fscOrderPayItemMapper.insertBatch(fscOrderPayItemPOs);
        this.insertOrder(atomReqBO, fscOrderId);
        this.invokeUacNoTask(atomReqBO, fscOrderId, atomRspBO);
        atomRspBO.setFscOrderId(fscOrderId);
        atomRspBO.setRespCode("0000");
        atomRspBO.setRespDesc("\u4ed8\u6b3e\u7533\u8bf7\u5355\u521b\u5efa\u6210\u529f");
        return atomRspBO;
    }

    private void invokeUacNoTask(FscPayBillCreateAtomReqBO busiReqBO, Long fscOrderId, FscPayBillCreateAtomRspBO rspBO) {
        FscOrderStatusStartAtomReqBO fscOrderStatusStartAtomReqBO = (FscOrderStatusStartAtomReqBO)JSON.parseObject((String)JSON.toJSONString((Object)((Object)busiReqBO)), FscOrderStatusStartAtomReqBO.class);
        HashMap<String, Integer> paramMap = new HashMap<String, Integer>();
        paramMap.put("auditFlag", FscConstants.ProcessParam.auditFlag2);
        if (busiReqBO.getQueryAuditFlag().booleanValue()) {
            String createFscProcessKey = "FSC_PAY_AUDIT";
            if (!this.qryAuditFlow(this.processSysCode, createFscProcessKey)) {
                paramMap.put("auditFlag", FscConstants.ProcessParam.auditFlag2);
            } else {
                paramMap.put("auditFlag", FscConstants.ProcessParam.auditFlag);
                FscAuditOrderCreateAtomReqBO fscAuditOrderCreateAtomReqBO = new FscAuditOrderCreateAtomReqBO();
                fscAuditOrderCreateAtomReqBO.setOrderId(fscOrderId);
                fscAuditOrderCreateAtomReqBO.setObjId(fscOrderId);
                fscAuditOrderCreateAtomReqBO.setObjType(FscConstants.OBJ_TYPE.FSC_ORDER);
                fscAuditOrderCreateAtomReqBO.setObjBusiType(FscConstants.AuditObjType.PAY_APPLY_ORDER);
                fscAuditOrderCreateAtomReqBO.setUserId(busiReqBO.getUserId());
                fscAuditOrderCreateAtomReqBO.setUserName(busiReqBO.getName());
                FscAuditOrderCreateAtomRspBO atomRspBO = this.fscAuditOrderCreateAtomService.dealAuditOrderCreate(fscAuditOrderCreateAtomReqBO);
                this.startAuditFlow(fscOrderId, createFscProcessKey, atomRspBO, rspBO);
            }
        }
        fscOrderStatusStartAtomReqBO.setParamMap(paramMap);
        fscOrderStatusStartAtomReqBO.setOrderId(fscOrderId);
        fscOrderStatusStartAtomReqBO.setOrderFlow(FscConstants.OrderFlow.PAY);
        fscOrderStatusStartAtomReqBO.setOperId(busiReqBO.getUserName());
        FscOrderStatusStartAtomRspBO fscOrderStatusStartAtomRspBO = this.fscOrderStatusStartAtomService.dealStatusStart(fscOrderStatusStartAtomReqBO);
        if (!"0000".equals(fscOrderStatusStartAtomRspBO.getRespCode())) {
            throw new FscBusinessException("194203", fscOrderStatusStartAtomRspBO.getRespDesc());
        }
        FscTodoBO fscTodoBO = new FscTodoBO();
        fscTodoBO.setNewStatus(fscOrderStatusStartAtomRspBO.getNewStatus());
        fscTodoBO.setFscOrderId(fscOrderId);
        rspBO.setFscTodoBO(fscTodoBO);
    }

    private void startAuditFlow(Long fscOrderId, String createFscProcessKey, FscAuditOrderCreateAtomRspBO atomRspBO, FscPayBillCreateAtomRspBO rspBO) {
        FscAuditBaseBo fscAuditBaseBo = new FscAuditBaseBo();
        fscAuditBaseBo.setProcDefKey(createFscProcessKey);
        fscAuditBaseBo.setPartitionKey(fscOrderId.toString());
        HashMap<String, Long> variables = new HashMap<String, Long>();
        variables.put("auditId", atomRspBO.getAuditOrderId());
        fscAuditBaseBo.setVariables(variables);
        ArrayList<String> strings = new ArrayList<String>();
        strings.add(fscOrderId.toString());
        fscAuditBaseBo.setBusinessIdList(strings);
        rspBO.setIsStartAuditFlow(true);
        rspBO.setFscAuditBaseBo(fscAuditBaseBo);
    }

    private void insertOrder(FscPayBillCreateAtomReqBO busiReqBO, Long fscOrderId) {
        FscOrderPO fscOrderPO = new FscOrderPO();
        fscOrderPO.setFscOrderId(fscOrderId);
        fscOrderPO.setOrderFlow(FscConstants.OrderFlow.PAY);
        CfcEncodedSerialGetServiceReqBO encodedSerialGetServiceReqBO = new CfcEncodedSerialGetServiceReqBO();
        encodedSerialGetServiceReqBO.setCenter("FSC");
        encodedSerialGetServiceReqBO.setEncodedRuleCode("PAYMENT_REQUEST_NO");
        encodedSerialGetServiceReqBO.setNum(Integer.valueOf(1));
        encodedSerialGetServiceReqBO.setOrgType("-1");
        CfcEncodedSerialGetServiceRspBO encodedSerialGetServiceRspBO = this.encodedSerialGetService.getEncodedSerial(encodedSerialGetServiceReqBO);
        fscOrderPO.setOrderNo((String)encodedSerialGetServiceRspBO.getSerialNoList().get(0));
        fscOrderPO.setPayerId(busiReqBO.getPayerId());
        fscOrderPO.setPayerName(busiReqBO.getPayerName());
        fscOrderPO.setPayeeId(busiReqBO.getPayeeId());
        fscOrderPO.setPayeeName(busiReqBO.getPayeeName());
        fscOrderPO.setPayeeBankAccount(busiReqBO.getPayeeBankAccount());
        fscOrderPO.setPayeeBankName(busiReqBO.getPayeeBankName());
        fscOrderPO.setPayeeAccountName(busiReqBO.getPayeeAccountName());
        fscOrderPO.setPayMethod(busiReqBO.getPayMethod());
        fscOrderPO.setPayType(busiReqBO.getPayType());
        fscOrderPO.setShouldPayType(busiReqBO.getShouldPayType());
        fscOrderPO.setPayChannel(busiReqBO.getPayChannel());
        fscOrderPO.setCreateOperId(busiReqBO.getUserId());
        fscOrderPO.setCreateOperName(busiReqBO.getName());
        fscOrderPO.setCreateTime(new Date());
        fscOrderPO.setCreateCompanyId(busiReqBO.getCompanyId());
        fscOrderPO.setCreateCompanyName(busiReqBO.getCompanyName());
        fscOrderPO.setCreateOrgId(busiReqBO.getOrgId());
        fscOrderPO.setCreateOrgName(busiReqBO.getOrgName());
        fscOrderPO.setTotalCharge(busiReqBO.getTotalAmount());
        fscOrderPO.setContractNo(busiReqBO.getContractNo());
        fscOrderPO.setContractId(busiReqBO.getContractId());
        fscOrderPO.setBusiCategory(FscConstants.FscOrderBusiCategory.PAY);
        if ("3".equals(busiReqBO.getPayChannel())) {
            if (null != busiReqBO.getUserId()) {
                fscOrderPO.setPayOperId(busiReqBO.getUserId().toString());
            }
            fscOrderPO.setPayOperName(busiReqBO.getName());
        }
        this.fscOrderMapper.insert(fscOrderPO);
        if ("3".equals(busiReqBO.getPayChannel()) && !CollectionUtils.isEmpty(busiReqBO.getFscAttachmentBOS())) {
            ArrayList<FscAttachmentPO> fscAttachmentPOS = new ArrayList<FscAttachmentPO>();
            for (AttachmentBO fscAttachmentBO : busiReqBO.getFscAttachmentBOS()) {
                FscAttachmentPO fscAttachmentPO = new FscAttachmentPO();
                fscAttachmentPO.setFscOrderId(fscOrderPO.getFscOrderId());
                fscAttachmentPO.setAttachmentId(Long.valueOf(Sequence.getInstance().nextId()));
                fscAttachmentPO.setAttachmentName(fscAttachmentBO.getAttachmentName());
                fscAttachmentPO.setAttachmentType(fscAttachmentBO.getAttachmentType());
                fscAttachmentPO.setAttachmentUrl(fscAttachmentBO.getAttachmentUrl());
                fscAttachmentPOS.add(fscAttachmentPO);
            }
            this.fscAttachmentMapper.insertBatch(fscAttachmentPOS);
        }
    }

    private List<FscOrderPayItemPO> updateShouldPay(FscPayBillCreateAtomReqBO busiReqBO, Long fscOrderId, FscPayBillCreateAtomRspBO atomRspBO) {
        FscShouldPayPO fscShouldPayPO1 = new FscShouldPayPO();
        ArrayList shouldPayIds = new ArrayList();
        busiReqBO.getFscOrderPayItemBOS().forEach(fscOrderPayItemBO -> shouldPayIds.add(fscOrderPayItemBO.getShouldPayId()));
        fscShouldPayPO1.setShouldPayIds(shouldPayIds);
        List poResult = this.fscShouldPayMapper.getList(fscShouldPayPO1);
        if (CollectionUtils.isEmpty((Collection)poResult)) {
            throw new FscBusinessException("194203", "\u5e94\u4ed8\u4fe1\u606f\u4e0d\u5b58\u5728\uff01");
        }
        ArrayList<Long> serviceFscOrderId = new ArrayList<Long>();
        HashSet shouldPayType = new HashSet();
        HashSet payerIds = new HashSet();
        HashSet payeeIds = new HashSet();
        HashSet contractNos = new HashSet();
        HashSet payType = new HashSet();
        poResult.forEach(fscShouldPayPO -> {
            if (null != fscShouldPayPO.getShouldPayType()) {
                shouldPayType.add(fscShouldPayPO.getShouldPayType());
                busiReqBO.setShouldPayType(fscShouldPayPO.getShouldPayType());
            }
            if (null != fscShouldPayPO.getPayerId()) {
                payerIds.add(fscShouldPayPO.getPayerId());
                busiReqBO.setPayerId(fscShouldPayPO.getPayerId());
                busiReqBO.setPayerName(fscShouldPayPO.getPayerName());
            }
            if (null != fscShouldPayPO.getPayeeId()) {
                payeeIds.add(fscShouldPayPO.getPayeeId());
                busiReqBO.setPayeeId(fscShouldPayPO.getPayeeId());
                busiReqBO.setPayeeName(fscShouldPayPO.getPayeeName());
            }
            if (null != fscShouldPayPO.getPayType()) {
                payType.add(fscShouldPayPO.getPayType());
                busiReqBO.setPayType(fscShouldPayPO.getPayType());
            }
            if (StringUtils.hasText((String)fscShouldPayPO.getContractNo())) {
                contractNos.add(fscShouldPayPO.getContractNo());
                busiReqBO.setContractNo(fscShouldPayPO.getContractNo());
            }
            if (fscShouldPayPO.getContractId() != null) {
                busiReqBO.setContractId(fscShouldPayPO.getContractId());
            }
            if (FscConstants.ShouldObjectType.DEAL_ORDER.equals(fscShouldPayPO.getShouldPayType()) || FscConstants.ShouldObjectType.USR_ORDER.equals(fscShouldPayPO.getShouldPayType())) {
                serviceFscOrderId.add(fscShouldPayPO.getObjectId());
            }
        });
        if (shouldPayType.size() > 1) {
            throw new FscBusinessException("194203", "\u5e94\u4ed8\u7c7b\u578b\u5fc5\u987b\u552f\u4e00\uff01");
        }
        if (payerIds.size() > 1) {
            throw new FscBusinessException("194203", "\u4ed8\u6b3e\u65b9\u5fc5\u987b\u552f\u4e00\uff01");
        }
        if (payeeIds.size() > 1) {
            throw new FscBusinessException("194203", "\u6536\u6b3e\u65b9\u5fc5\u987b\u552f\u4e00\uff01");
        }
        if (payType.size() > 1) {
            throw new FscBusinessException("194203", "\u4ed8\u6b3e\u65b9\u5f0f\u5fc5\u987b\u552f\u4e00\uff01");
        }
        if (contractNos.size() > 1) {
            throw new FscBusinessException("194203", "\u5408\u540c\u7f16\u53f7\u5fc5\u987b\u552f\u4e00\uff01");
        }
        if (!FscConstants.ShouldPayType.PAYMENT_DAY_PAY.equals(busiReqBO.getShouldPayType())) {
            FscOrderPayItemPO fscOrderPayItemPO = new FscOrderPayItemPO();
            fscOrderPayItemPO.setShouldPayIds(shouldPayIds);
            List itemPOS = this.fscOrderPayItemMapper.getList(fscOrderPayItemPO);
            if (!CollectionUtils.isEmpty((Collection)itemPOS) && itemPOS.size() == shouldPayIds.size()) {
                HashSet payFscOrderIds = new HashSet();
                itemPOS.forEach(fscOrderPayItemPO1 -> payFscOrderIds.add(fscOrderPayItemPO1.getFscOrderId()));
                if (payFscOrderIds.size() == 1) {
                    FscOrderPO fscOrderPO = new FscOrderPO();
                    fscOrderPO.setFscOrderId((Long)payFscOrderIds.iterator().next());
                    fscOrderPO.setOrderState(FscConstants.FscPayOrderState.TO_PAY);
                    FscOrderPO po = this.fscOrderMapper.getModelBy(fscOrderPO);
                    if (po != null) {
                        busiReqBO.setPayFscOrderId(po.getFscOrderId());
                        FscOrderPO set = new FscOrderPO();
                        FscOrderPO where = new FscOrderPO();
                        set.setPayChannel(busiReqBO.getPayChannel());
                        set.setPayMethod(busiReqBO.getPayMethod());
                        where.setFscOrderId(po.getFscOrderId());
                        this.fscOrderMapper.updateBy(set, where);
                        return null;
                    }
                    throw new FscBusinessException("194203", "\u5f53\u524d\u5e94\u4ed8\u4fe1\u606f\u5df2\u5b58\u5728\u4ed8\u6b3e\u7533\u8bf7\u5355\uff0c\u4e14\u4e0d\u662f\u5f85\u4ed8\u6b3e\u72b6\u6001\uff01");
                }
                throw new FscBusinessException("194203", "\u5f53\u524d\u5e94\u4ed8\u4fe1\u606f\u5b58\u5728\u591a\u4e2a\u4ed8\u6b3e\u7533\u8bf7\u5355\uff0c\u8bf7\u5230\u4ed8\u6b3e\u7533\u8bf7\u9875\u9762\u8fdb\u884c\u652f\u4ed8\uff01");
            }
        }
        ArrayList<FscOrderPayItemPO> fscOrderPayItemPOs = new ArrayList<FscOrderPayItemPO>();
        BigDecimal totalAmount = new BigDecimal(0);
        Date now = new Date();
        for (FscOrderPayItemBO fscOrderPayItemBO2 : busiReqBO.getFscOrderPayItemBOS()) {
            FscShouldPayPO fscShouldPayPO2 = new FscShouldPayPO();
            fscShouldPayPO2.setShouldPayId(fscOrderPayItemBO2.getShouldPayId());
            fscShouldPayPO2.setPayAmount(fscOrderPayItemBO2.getPayAmount());
            fscShouldPayPO2.setUpdateTime(now);
            fscShouldPayPO2.setUpdateOperId(Convert.toStr((Object)busiReqBO.getUserId()));
            fscShouldPayPO2.setUpdateOperName(busiReqBO.getName());
            int count = this.fscShouldPayMapper.updateAmount(fscShouldPayPO2);
            if (count != 1) {
                throw new FscBusinessException("194203", "\u4ed8\u6b3e\u91d1\u989d\u5927\u4e8e\u5f85\u4ed8\u91d1\u989d\uff01");
            }
            FscOrderPayItemPO po = new FscOrderPayItemPO();
            po.setFscOrderId(fscOrderId);
            po.setOrderPayItemId(Long.valueOf(Sequence.getInstance().nextId()));
            po.setShouldPayId(fscOrderPayItemBO2.getShouldPayId());
            po.setPayAmount(fscOrderPayItemBO2.getPayAmount());
            if (FscConstants.IsSettlePay.ORDER.equals(busiReqBO.getIsOrderInitiate())) {
                po.setIsSettlePay(FscConstants.IsSettlePay.ORDER);
            } else {
                po.setIsSettlePay(FscConstants.IsSettlePay.SETTLE);
            }
            fscOrderPayItemPOs.add(po);
            totalAmount = totalAmount.add(fscOrderPayItemBO2.getPayAmount());
        }
        if (!CollectionUtils.isEmpty(serviceFscOrderId)) {
            FscOrderPO set = new FscOrderPO();
            set.setPayChannel(busiReqBO.getPayChannel());
            set.setPayMethod(busiReqBO.getPayMethod());
            set.setPayType(busiReqBO.getPayType());
            FscOrderPO where = new FscOrderPO();
            where.setFscOrderIds(serviceFscOrderId);
            this.fscOrderMapper.updateBy(set, where);
        }
        atomRspBO.setServiceFscOrderIds(serviceFscOrderId);
        busiReqBO.setTotalAmount(totalAmount);
        atomRspBO.setPayeeId((Long)payeeIds.iterator().next());
        atomRspBO.setPayerId((Long)payerIds.iterator().next());
        return fscOrderPayItemPOs;
    }

    private List<FscOrderPayItemPO> insertShouldPay(FscPayBillCreateAtomReqBO busiReqBO, Long fscOrderId) {
        List fscShouldPayPOS = JSON.parseArray((String)JSON.toJSONString(busiReqBO.getFscShouldPayBOS()), FscShouldPayPO.class);
        ArrayList<FscOrderPayItemPO> fscOrderPayItemPOs = new ArrayList<FscOrderPayItemPO>();
        BigDecimal totalAmount = new BigDecimal(0);
        List serialNoList = null;
        if (FscShouldPayNoEnum.getInstance((Integer)((FscShouldPayPO)fscShouldPayPOS.get(0)).getShouldPayType()) == null) {
            throw new FscBusinessException("194203", "\u5e94\u4ed8\u7c7b\u578b\u6ca1\u5b9a\u4e49\u679a\u4e3e");
        }
        CfcEncodedSerialGetServiceReqBO encodedSerialGetServiceReqBO = new CfcEncodedSerialGetServiceReqBO();
        encodedSerialGetServiceReqBO.setCenter("FSC");
        encodedSerialGetServiceReqBO.setNum(Integer.valueOf(fscShouldPayPOS.size()));
        encodedSerialGetServiceReqBO.setOrgType("-1");
        encodedSerialGetServiceReqBO.setEncodedRuleCode(FscShouldPayNoEnum.getInstance((Integer)((FscShouldPayPO)fscShouldPayPOS.get(0)).getShouldPayType()).getDescr());
        CfcEncodedSerialGetServiceRspBO encodedSerialGetServiceRspBO = this.encodedSerialGetService.getEncodedSerial(encodedSerialGetServiceReqBO);
        serialNoList = encodedSerialGetServiceRspBO.getSerialNoList();
        ArrayList<FscPayRecordInfoBO> fscPayRecordInfoBOS = new ArrayList<FscPayRecordInfoBO>(fscShouldPayPOS.size());
        for (int i = 0; i < fscShouldPayPOS.size(); ++i) {
            FscShouldPayPO fscShouldPayPO = (FscShouldPayPO)fscShouldPayPOS.get(i);
            Long shouldPayId = Sequence.getInstance().nextId();
            fscShouldPayPO.setShouldPayId(shouldPayId);
            fscShouldPayPO.setCreateId(busiReqBO.getUserId());
            fscShouldPayPO.setCreateName(busiReqBO.getName());
            fscShouldPayPO.setCreateAccount(busiReqBO.getUserName());
            fscShouldPayPO.setCreateTime(new Date());
            fscShouldPayPO.setCreateCompanyId(busiReqBO.getCompanyId());
            fscShouldPayPO.setCreateCompanyName(busiReqBO.getCompanyName());
            fscShouldPayPO.setCreateOrgId(busiReqBO.getOrgId());
            fscShouldPayPO.setCreateOrgName(busiReqBO.getOrgName());
            fscShouldPayPO.setPayingAmount(fscShouldPayPO.getShouldPayAmount());
            fscShouldPayPO.setPaidAmount(new BigDecimal(0));
            fscShouldPayPO.setToPayAmount(new BigDecimal(0));
            fscShouldPayPO.setShouldPayNo((String)serialNoList.get(i));
            fscShouldPayPO.setPenalty(new BigDecimal(0));
            fscShouldPayPO.setOriginalAmount(fscShouldPayPO.getShouldPayAmount());
            fscShouldPayPO.setShouldPayStatus(FscConstants.ShouldPayStatus.TO_PAY);
            FscOrderPayItemPO po = new FscOrderPayItemPO();
            po.setFscOrderId(fscOrderId);
            po.setOrderPayItemId(Long.valueOf(Sequence.getInstance().nextId()));
            po.setShouldPayId(shouldPayId);
            po.setPayAmount(fscShouldPayPO.getShouldPayAmount());
            if (FscConstants.IsSettlePay.ORDER.equals(busiReqBO.getIsOrderInitiate())) {
                po.setIsSettlePay(FscConstants.IsSettlePay.ORDER);
            } else {
                po.setIsSettlePay(FscConstants.IsSettlePay.SETTLE);
            }
            fscOrderPayItemPOs.add(po);
            totalAmount = totalAmount.add(fscShouldPayPO.getShouldPayAmount());
            FscPayRecordInfoBO fscPayRecordInfoBO = new FscPayRecordInfoBO();
            fscPayRecordInfoBO.setFscShouldPayId(fscShouldPayPO.getShouldPayId());
            fscPayRecordInfoBO.setFscShouldPayNo(fscShouldPayPO.getShouldPayNo());
            fscPayRecordInfoBO.setPayerId(fscShouldPayPO.getPayerId());
            fscPayRecordInfoBOS.add(fscPayRecordInfoBO);
        }
        busiReqBO.setTotalAmount(totalAmount);
        this.fscShouldPayMapper.insertBatch(fscShouldPayPOS);
        this.sendTodo(fscPayRecordInfoBOS);
        return fscOrderPayItemPOs;
    }

    private void sendTodo(List<FscPayRecordInfoBO> fscShouldPayPOS) {
        FscPayRecordTodoDealAtomReqBo fscPayRecordTodoDealAtomReqBo = new FscPayRecordTodoDealAtomReqBo();
        fscPayRecordTodoDealAtomReqBo.setFscShouldPayInfo(fscShouldPayPOS);
        FscPayRecordTodoDealAtomRspBo fscPayRecordTodoDealAtomRspBo = this.fscPayRecordTodoDealAtomService.sendPayRecordTodo(fscPayRecordTodoDealAtomReqBo);
        if (!"0000".equals(fscPayRecordTodoDealAtomRspBo.getRespCode())) {
            throw new FscBusinessException(fscPayRecordTodoDealAtomRspBo.getRespCode(), fscPayRecordTodoDealAtomRspBo.getRespDesc());
        }
    }

    private boolean qryAuditFlow(String sys_code, String extRegistAuditKey) {
        FscOsWorkFlowReqBO osWorkFlowReqBO = new FscOsWorkFlowReqBO();
        osWorkFlowReqBO.setSysCode(sys_code);
        osWorkFlowReqBO.setProcDefKey(extRegistAuditKey);
        FscOsWorkFlowRspBO osWorkflow = this.fscOsworkflowWhetherChartAtomService.findOsWorkflow(osWorkFlowReqBO);
        if (!"0000".equals(osWorkflow.getRespCode())) {
            throw new FscBusinessException(osWorkflow.getRespCode(), osWorkflow.getRespDesc());
        }
        return null != osWorkflow.getFindFlag() && osWorkflow.getFindFlag() != false;
    }
}

