/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.pay.busi.impl;

import cn.hutool.core.convert.Convert;
import cn.hutool.core.util.StrUtil;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.fsc.bo.FscCreditDeductAtomBO;
import com.tydic.fsc.busibase.atom.api.FscCreditDeductAtomService;
import com.tydic.fsc.busibase.atom.bo.FscCreditDeductAtomReqBO;
import com.tydic.fsc.busibase.atom.bo.FscCreditDeductAtomRspBO;
import com.tydic.fsc.busibase.external.api.bo.FscUocUpdateSaleOrderReturnPayResultAtomServiceReqBo;
import com.tydic.fsc.busibase.external.api.bo.FscUocUpdateSaleOrderReturnPayResultAtomServiceRspBo;
import com.tydic.fsc.busibase.external.api.pay.FscPayProRefundAtomService;
import com.tydic.fsc.busibase.external.api.pay.bo.FscPayProRefundAtomServiceReqBo;
import com.tydic.fsc.busibase.external.api.pay.bo.FscPayProRefundAtomServiceRspBo;
import com.tydic.fsc.busibase.external.api.uoc.FscUocUpdateSaleOrderReturnPayResultAtomService;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscCreditBalanceMapper;
import com.tydic.fsc.dao.FscMerchantMapper;
import com.tydic.fsc.dao.FscOrderMapper;
import com.tydic.fsc.dao.FscOrderPayItemMapper;
import com.tydic.fsc.dao.FscPayLogMapper;
import com.tydic.fsc.dao.FscPayOrderMapper;
import com.tydic.fsc.dao.FscPayRelationMapper;
import com.tydic.fsc.dao.FscShouldPayMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.pay.atom.api.FscCreatePayBackAtomService;
import com.tydic.fsc.pay.atom.bo.FscCreatePayBackAtomServiceReqBO;
import com.tydic.fsc.pay.atom.bo.FscCreatePayBackAtomServiceRspBO;
import com.tydic.fsc.pay.busi.api.FscCreatePayBackBusiService;
import com.tydic.fsc.pay.busi.bo.FscCreatePayBackBusiServiceReqBO;
import com.tydic.fsc.pay.busi.bo.FscCreatePayBackBusiServiceRspBO;
import com.tydic.fsc.po.FscCreditBalancePO;
import com.tydic.fsc.po.FscMerchantPO;
import com.tydic.fsc.po.FscOrderPO;
import com.tydic.fsc.po.FscOrderPayItemPO;
import com.tydic.fsc.po.FscPayLogPO;
import com.tydic.fsc.po.FscPayOrderPO;
import com.tydic.fsc.po.FscPayRelationPO;
import com.tydic.fsc.po.FscShouldPayPO;
import com.tydic.payment.pay.common.util.MoneyUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class FscCreatePayBackBusiServiceImpl
implements FscCreatePayBackBusiService {
    @Autowired
    private FscCreatePayBackAtomService fscCreatePayBackAtomService;
    @Autowired
    private FscPayRelationMapper fscPayRelationMapper;
    @Autowired
    private FscPayOrderMapper fscPayOrderMapper;
    @Autowired
    private FscShouldPayMapper fscShouldPayMapper;
    @Autowired
    private FscOrderPayItemMapper fscOrderPayItemMapper;
    @Autowired
    private FscOrderMapper fscOrderMapper;
    @Autowired
    private FscPayLogMapper fscPayLogMapper;
    @Autowired
    private FscCreditDeductAtomService fscCreditDeductAtomService;
    @Autowired
    private FscPayProRefundAtomService fscPayProRefundAtomService;
    @Autowired
    private FscMerchantMapper fscMerchantMapper;
    @Autowired
    private FscCreditBalanceMapper fscCreditBalanceMapper;
    @Autowired
    private FscUocUpdateSaleOrderReturnPayResultAtomService fscUocUpdateSaleOrderReturnPayResultAtomService;
    @Value(value="${pay.center.busi.code:D500}")
    private String payBusiCode;
    @Value(value="${fscPayRefundNotifyUrl:}")
    private String refundNotifyUrl;

    @Override
    public FscCreatePayBackBusiServiceRspBO dealPayBack(FscCreatePayBackBusiServiceReqBO reqBO) {
        FscCreatePayBackBusiServiceRspBO rspBo = new FscCreatePayBackBusiServiceRspBO();
        if (FscConstants.PAY_TYPE.PAY_BY_PERIOD.equals(reqBO.getPayType())) {
            this.dealPayMent(reqBO, rspBo);
        } else if (FscConstants.PAY_TYPE.ADVANCE_PAYMENT_PRORATED.equals(reqBO.getPayType())) {
            this.dealAcvance(reqBO, rspBo);
        }
        return rspBo;
    }

    private void dealAcvance(FscCreatePayBackBusiServiceReqBO reqBO, FscCreatePayBackBusiServiceRspBO rspBo) {
        FscOrderPayItemPO fscOrderPayItemPO = new FscOrderPayItemPO();
        fscOrderPayItemPO.setShouldPayId(reqBO.getShouldPayId());
        FscOrderPayItemPO fscOrderPayItem = this.fscOrderPayItemMapper.getModelBy(fscOrderPayItemPO);
        if (null == fscOrderPayItem) {
            this.updateShouldPayRefundAnt(reqBO, reqBO.getShouldPayId());
            this.dealRefundSuccess(reqBO, reqBO.getShouldPayId());
            return;
        }
        FscOrderPO fscOrderPO = new FscOrderPO();
        fscOrderPO.setFscOrderId(fscOrderPayItem.getFscOrderId());
        fscOrderPO = this.fscOrderMapper.getModelBy(fscOrderPO);
        if (!FscConstants.FscPayOrderState.PAIED.equals(fscOrderPO.getOrderState())) {
            this.updateOriFscPayOrder(rspBo, fscOrderPO);
            this.updateShouldPayRefundAnt(reqBO, reqBO.getShouldPayId());
            this.dealRefundSuccess(reqBO, reqBO.getShouldPayId());
        } else {
            FscCreatePayBackAtomServiceRspBO payBackOrder = this.createPayBackOrder(reqBO, fscOrderPO, reqBO.getShouldPayId());
            this.payBackOnline(fscOrderPO, payBackOrder, rspBo, reqBO, reqBO.getShouldPayId());
            rspBo.setIsStartPayBackFlow(true);
            rspBo.setFscPayBackOrderId(payBackOrder.getFscPayBackOrderId());
            rspBo.setIsSyncFscPaybackOrder(true);
        }
    }

    private void dealPayMent(FscCreatePayBackBusiServiceReqBO reqBO, FscCreatePayBackBusiServiceRspBO rspBo) {
        FscShouldPayPO fscShouldPayPO = new FscShouldPayPO();
        fscShouldPayPO.setShouldPayType(FscConstants.ShouldPayType.PAYMENT_DAY_PAY);
        fscShouldPayPO.setSaleVoucherId(reqBO.getSaleOrderId());
        fscShouldPayPO.setShouldPayId(reqBO.getShouldPayId());
        fscShouldPayPO.setPayeeId(reqBO.getPayBackOrgId());
        fscShouldPayPO.setPayerId(reqBO.getReceiverOrgId());
        FscShouldPayPO fscShouldPay = this.fscShouldPayMapper.getModelBy(fscShouldPayPO);
        if (null == fscShouldPay) {
            this.paymentRefund(reqBO);
            return;
        }
        FscOrderPayItemPO fscOrderPayItemPO = new FscOrderPayItemPO();
        fscOrderPayItemPO.setShouldPayId(fscShouldPay.getShouldPayId());
        FscOrderPayItemPO fscOrderPayItem = this.fscOrderPayItemMapper.getModelBy(fscOrderPayItemPO);
        if (null == fscOrderPayItem) {
            this.updateShouldPayRefundAnt(reqBO, fscShouldPay.getShouldPayId());
            this.paymentRefund(reqBO);
            this.dealRefundSuccess(reqBO, fscShouldPay.getShouldPayId());
            return;
        }
        FscOrderPO fscOrderPO = new FscOrderPO();
        fscOrderPO.setFscOrderId(fscOrderPayItem.getFscOrderId());
        fscOrderPO = this.fscOrderMapper.getModelBy(fscOrderPO);
        if (!FscConstants.FscPayOrderState.PAIED.equals(fscOrderPO.getOrderState())) {
            this.updateOriFscPayOrder(rspBo, fscOrderPO);
            this.updateShouldPayRefundAnt(reqBO, fscShouldPay.getShouldPayId());
            this.paymentRefund(reqBO);
            this.dealRefundSuccess(reqBO, fscShouldPay.getShouldPayId());
        } else {
            FscCreatePayBackAtomServiceRspBO payBackOrder = this.createPayBackOrder(reqBO, fscOrderPO, fscShouldPay.getShouldPayId());
            this.payBackOnline(fscOrderPO, payBackOrder, rspBo, reqBO, fscShouldPay.getShouldPayId());
            rspBo.setIsStartPayBackFlow(true);
            rspBo.setFscPayBackOrderId(payBackOrder.getFscPayBackOrderId());
            rspBo.setIsSyncFscPaybackOrder(true);
        }
    }

    private void updateOriFscPayOrder(FscCreatePayBackBusiServiceRspBO rspBo, FscOrderPO fscOrderPO) {
        if (!"3".equals(fscOrderPO.getPayChannel())) {
            FscPayRelationPO fscPayRelationPO = new FscPayRelationPO();
            fscPayRelationPO.setFscOrderId(fscOrderPO.getFscOrderId());
            List fscPayRelationPOS = this.fscPayRelationMapper.getList(fscPayRelationPO);
            if (CollectionUtils.isNotEmpty((Collection)fscPayRelationPOS)) {
                for (FscPayRelationPO payRelationPO : fscPayRelationPOS) {
                    FscPayOrderPO fscPayOrderPO = new FscPayOrderPO();
                    fscPayOrderPO.setPayOrderId(payRelationPO.getPayOrderId());
                    if (!FscConstants.PayOrderPayStatus.TO_PAY.equals((fscPayOrderPO = this.fscPayOrderMapper.getModelBy(fscPayOrderPO)).getPayStatus()) && !FscConstants.PayOrderPayStatus.PAYING.equals(fscPayOrderPO.getPayStatus())) continue;
                    throw new FscBusinessException("198888", StrUtil.format((CharSequence)"\u4ed8\u6b3e\u7533\u8bf7\u5355{}\u6b63\u5728\u4ed8\u6b3e\uff0c\u4e0d\u80fd\u8fdb\u884c\u8be5\u64cd\u4f5c", (Object[])new Object[]{fscOrderPO.getOrderNo()}));
                }
            }
        }
        FscOrderPO set = new FscOrderPO();
        set.setOrderState(FscConstants.FscPayOrderState.PAY_INVALID);
        set.setFscOrderId(fscOrderPO.getFscOrderId());
        this.fscOrderMapper.updateById(set);
        rspBo.setFscPayOrderId(fscOrderPO.getFscOrderId());
        rspBo.setIsSyncFscPayOrder(true);
    }

    private void updateShouldPayRefundAnt(FscCreatePayBackBusiServiceReqBO reqBO, Long fscShouldPayId) {
        FscShouldPayPO where = new FscShouldPayPO();
        where.setShouldPayId(fscShouldPayId);
        FscShouldPayPO set = new FscShouldPayPO();
        set.setBackAmount(reqBO.getPayBackAmount());
        set.setUpdateTime(new Date());
        set.setUpdateOperId(Convert.toStr((Object)reqBO.getUserId()));
        set.setUpdateOperName(reqBO.getName());
        this.fscShouldPayMapper.updateBy(set, where);
    }

    private void paymentRefund(FscCreatePayBackBusiServiceReqBO reqBO) {
        FscCreditDeductAtomReqBO fscCreditDeductAtomReqBO = new FscCreditDeductAtomReqBO();
        ArrayList<FscCreditDeductAtomBO> fscCreditDeductAtomBOS = new ArrayList<FscCreditDeductAtomBO>();
        FscCreditDeductAtomBO fscCreditDeductAtomBO = new FscCreditDeductAtomBO();
        fscCreditDeductAtomBO.setOrderType(FscConstants.CreditOrderType.ORDER);
        fscCreditDeductAtomBO.setAmount(reqBO.getPayBackAmount().negate());
        fscCreditDeductAtomBO.setOrderId(reqBO.getSaleOrderId());
        fscCreditDeductAtomBO.setOrderNo(reqBO.getSaleOrderNo());
        fscCreditDeductAtomReqBO.setBusiCategory(FscConstants.FscBusiCategory.ORDER_REFUND);
        fscCreditDeductAtomReqBO.setSupId(reqBO.getPayBackOrgId());
        fscCreditDeductAtomReqBO.setCreditOrgId(reqBO.getReceiverOrgId());
        fscCreditDeductAtomBOS.add(fscCreditDeductAtomBO);
        fscCreditDeductAtomReqBO.setFscCreditDeductAtomBOS(fscCreditDeductAtomBOS);
        fscCreditDeductAtomReqBO.setUserName(reqBO.getCreateOperName());
        FscCreditDeductAtomRspBO fscCreditDeductAtomRspBO = this.fscCreditDeductAtomService.dealAccountDeduct(fscCreditDeductAtomReqBO);
        if (!"0000".equals(fscCreditDeductAtomRspBO.getRespCode())) {
            throw new FscBusinessException(fscCreditDeductAtomRspBO.getRespCode(), fscCreditDeductAtomRspBO.getRespDesc());
        }
    }

    private void payBackOnline(FscOrderPO fscOrderPO, FscCreatePayBackAtomServiceRspBO payBackOrder, FscCreatePayBackBusiServiceRspBO rspBo, FscCreatePayBackBusiServiceReqBO reqBO, Long shouldPayId) {
        HashMap<String, Object> paramMap = new HashMap<String, Object>(4);
        if (!"3".equals(fscOrderPO.getPayChannel())) {
            FscPayProRefundAtomServiceReqBo fscPayProRefundAtomServiceReqBo = new FscPayProRefundAtomServiceReqBo();
            fscPayProRefundAtomServiceReqBo.setBusiCode(this.payBusiCode);
            fscPayProRefundAtomServiceReqBo.setNotifyUrl(this.refundNotifyUrl);
            fscPayProRefundAtomServiceReqBo.setOrderType(fscOrderPO.getTotalCharge().compareTo(reqBO.getPayBackAmount()) == 0 ? "02" : "06");
            fscPayProRefundAtomServiceReqBo.setRefundOutOrderId(Convert.toStr((Object)payBackOrder.getPayBackOrderId()));
            fscPayProRefundAtomServiceReqBo.setOriOutOrderId(Convert.toStr((Object)payBackOrder.getPayOrderId()));
            fscPayProRefundAtomServiceReqBo.setRefundFee(Convert.toStr((Object)MoneyUtils.yuanToFenToLong((BigDecimal)reqBO.getPayBackAmount())));
            FscPayProRefundAtomServiceRspBo fscPayProRefundAtomServiceRspBo = this.fscPayProRefundAtomService.payRefund(fscPayProRefundAtomServiceReqBo);
            if (!"0000".equals(fscPayProRefundAtomServiceRspBo.getRespCode())) {
                throw new FscBusinessException(fscPayProRefundAtomServiceRspBo.getRespCode(), fscPayProRefundAtomServiceRspBo.getRespDesc());
            }
            if ("SUCCESS".equals(fscPayProRefundAtomServiceRspBo.getResultCode())) {
                Date now = this.updatePayRefundTime(payBackOrder);
                this.createPayRefundLog(fscOrderPO, reqBO, now);
                paramMap.put("onlineFlag", FscConstants.OnlineFlag.OTHER);
                this.dealRefundSuccess(reqBO, shouldPayId);
            } else {
                paramMap.put("onlineFlag", FscConstants.OnlineFlag.YES);
            }
        } else {
            paramMap.put("onlineFlag", FscConstants.OnlineFlag.NO);
        }
        rspBo.setParamMap(paramMap);
    }

    private void dealRefundSuccess(FscCreatePayBackBusiServiceReqBO reqBO, Long shouldPayId) {
        FscUocUpdateSaleOrderReturnPayResultAtomServiceReqBo atomServiceReqBo = new FscUocUpdateSaleOrderReturnPayResultAtomServiceReqBo();
        atomServiceReqBo.setFscShouldPayId(shouldPayId);
        atomServiceReqBo.setSaleOrderId(reqBO.getSaleOrderId());
        atomServiceReqBo.setReturnPayResult(Boolean.valueOf(true));
        atomServiceReqBo.setPayBackAmount(reqBO.getPayBackAmount());
        FscUocUpdateSaleOrderReturnPayResultAtomServiceRspBo atomServiceRspBo = this.fscUocUpdateSaleOrderReturnPayResultAtomService.updateReturnPayResult(atomServiceReqBo);
        if (!"0000".equals(atomServiceRspBo.getRespCode())) {
            throw new FscBusinessException(atomServiceRspBo.getRespCode(), atomServiceRspBo.getRespDesc());
        }
    }

    private Date updatePayRefundTime(FscCreatePayBackAtomServiceRspBO payBackOrder) {
        Date now = new Date();
        FscOrderPO fscOrder = new FscOrderPO();
        fscOrder.setFscOrderId(payBackOrder.getFscPayBackOrderId());
        fscOrder.setPayTime(now);
        this.fscOrderMapper.updateById(fscOrder);
        return now;
    }

    private void createPayRefundLog(FscOrderPO fscOrderPO, FscCreatePayBackBusiServiceReqBO reqBO, Date now) {
        FscMerchantPO fscMerchantPo = new FscMerchantPO();
        fscMerchantPo.setOrgId(fscOrderPO.getPayeeId());
        fscMerchantPo.setExceptionFlag(FscConstants.MerchantIsException.MERCHANT_NOT_EXCEPTION);
        fscMerchantPo.setDelFlag(FscConstants.DicDelFlag.NO);
        FscMerchantPO fscMerchant = this.fscMerchantMapper.getModelBy(fscMerchantPo);
        FscCreditBalancePO fscCreditBalancePO = new FscCreditBalancePO();
        fscCreditBalancePO.setCreditOrgId(fscOrderPO.getPayerId());
        fscCreditBalancePO.setMerchantId(fscMerchant.getMerchantId());
        fscCreditBalancePO = this.fscCreditBalanceMapper.getModelBy(fscCreditBalancePO);
        FscPayLogPO fscPayLogPO = new FscPayLogPO();
        fscPayLogPO.setId(Long.valueOf(Sequence.getInstance().nextId()));
        fscPayLogPO.setAccountId(fscMerchant.getAccountId());
        fscPayLogPO.setOrgId(fscOrderPO.getPayeeId());
        fscPayLogPO.setPayeeId(fscOrderPO.getPayerId());
        fscPayLogPO.setUserName(reqBO.getCreateOperName());
        fscPayLogPO.setBusiTime(now);
        fscPayLogPO.setCreateTime(now);
        fscPayLogPO.setBusiAmount(reqBO.getPayBackAmount().negate());
        fscPayLogPO.setBusiCategory(FscConstants.FscBusiCategory.ORDER_REFUND);
        fscPayLogPO.setBusiOrderType(FscConstants.CreditOrderType.ORDER);
        fscPayLogPO.setBusiOrderId(reqBO.getSaleOrderId());
        fscPayLogPO.setBusiOrderNo(reqBO.getSaleOrderNo());
        if (FscConstants.PAY_TYPE.PAY_BY_PERIOD.equals(reqBO.getPayType())) {
            fscPayLogPO.setIsCredit(FscConstants.IS_CREDIT.YES);
            if (null != fscCreditBalancePO) {
                fscPayLogPO.setBusiBeforeAmount(fscCreditBalancePO.getAvailableAmount());
                fscPayLogPO.setBusiAfterAmount(fscCreditBalancePO.getAvailableAmount());
            } else {
                fscPayLogPO.setBusiBeforeAmount(fscMerchant.getPayCreditAmount());
                fscPayLogPO.setBusiAfterAmount(fscMerchant.getPayCreditAmount());
            }
        } else {
            fscPayLogPO.setIsCredit(FscConstants.IS_CREDIT.NO);
        }
        this.fscPayLogMapper.insert(fscPayLogPO);
    }

    private FscOrderPO getFscOrderPO(FscCreatePayBackBusiServiceReqBO reqBO) {
        FscOrderPayItemPO fscOrderPayItemPO = new FscOrderPayItemPO();
        fscOrderPayItemPO.setShouldPayId(reqBO.getShouldPayId());
        fscOrderPayItemPO = this.fscOrderPayItemMapper.getModelBy(fscOrderPayItemPO);
        FscOrderPO fscOrderPO = new FscOrderPO();
        fscOrderPO.setFscOrderId(fscOrderPayItemPO.getFscOrderId());
        fscOrderPO = this.fscOrderMapper.getModelBy(fscOrderPO);
        return fscOrderPO;
    }

    private FscCreatePayBackAtomServiceRspBO createPayBackOrder(FscCreatePayBackBusiServiceReqBO reqBO, FscOrderPO fscOrderPO, Long fscShouldPayId) {
        FscCreatePayBackAtomServiceReqBO fscCreatePayBackAtomServiceReqBO = new FscCreatePayBackAtomServiceReqBO();
        fscCreatePayBackAtomServiceReqBO.setPayType(reqBO.getPayType());
        if (!"3".equals(fscOrderPO.getPayChannel())) {
            FscPayRelationPO fscPayRelationPO = new FscPayRelationPO();
            fscPayRelationPO.setFscOrderId(fscOrderPO.getFscOrderId());
            fscPayRelationPO = this.fscPayRelationMapper.getModelBy(fscPayRelationPO);
            fscCreatePayBackAtomServiceReqBO.setPayOrderId(fscPayRelationPO.getPayOrderId());
        }
        fscCreatePayBackAtomServiceReqBO.setPayBackAmount(reqBO.getPayBackAmount());
        fscCreatePayBackAtomServiceReqBO.setPayerId(fscOrderPO.getPayeeId());
        fscCreatePayBackAtomServiceReqBO.setPayerName(fscOrderPO.getPayeeName());
        fscCreatePayBackAtomServiceReqBO.setPayeeId(fscOrderPO.getPayerId());
        fscCreatePayBackAtomServiceReqBO.setPayeeName(fscOrderPO.getPayerName());
        fscCreatePayBackAtomServiceReqBO.setFscPayOrderId(fscOrderPO.getFscOrderId());
        fscCreatePayBackAtomServiceReqBO.setFscPayOrderNo(fscOrderPO.getOrderNo());
        fscCreatePayBackAtomServiceReqBO.setPayMethod(fscOrderPO.getPayMethod());
        fscCreatePayBackAtomServiceReqBO.setPayChannel(fscOrderPO.getPayChannel());
        fscCreatePayBackAtomServiceReqBO.setCreateOperId(reqBO.getCreateOperId());
        fscCreatePayBackAtomServiceReqBO.setCreateOperName(reqBO.getCreateOperName());
        fscCreatePayBackAtomServiceReqBO.setCreateOrgId(reqBO.getCreateOrgId());
        fscCreatePayBackAtomServiceReqBO.setCreateOrgName(reqBO.getCreateOrgName());
        fscCreatePayBackAtomServiceReqBO.setCreateCompanyId(reqBO.getCreateCompanyId());
        fscCreatePayBackAtomServiceReqBO.setCreateCompanyName(reqBO.getCreateCompanyName());
        fscCreatePayBackAtomServiceReqBO.setSaleOrderId(reqBO.getSaleOrderId());
        fscCreatePayBackAtomServiceReqBO.setSaleOrderNo(reqBO.getSaleOrderNo());
        fscCreatePayBackAtomServiceReqBO.setTransactionId(fscOrderPO.getTransactionId());
        fscCreatePayBackAtomServiceReqBO.setShouldPayId(fscShouldPayId);
        fscCreatePayBackAtomServiceReqBO.setRefundObjId(reqBO.getRefundObjId());
        fscCreatePayBackAtomServiceReqBO.setRefundObjType(reqBO.getRefundObjType());
        return this.fscCreatePayBackAtomService.createPayBackOrder(fscCreatePayBackAtomServiceReqBO);
    }
}

