/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.pay.busi.impl;

import cn.hutool.core.convert.Convert;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.tydic.fsc.bo.FscAuditBaseBo;
import com.tydic.fsc.busibase.atom.api.FscAuditOrderCreateAtomService;
import com.tydic.fsc.busibase.atom.api.FscGeneralBusiRuleExecAtomService;
import com.tydic.fsc.busibase.atom.api.FscOrderStatusFlowAtomService;
import com.tydic.fsc.busibase.atom.bo.FscAuditOrderCreateAtomReqBO;
import com.tydic.fsc.busibase.atom.bo.FscAuditOrderCreateAtomRspBO;
import com.tydic.fsc.busibase.atom.bo.FscOrderStatusFlowAtomReqBO;
import com.tydic.fsc.busibase.atom.bo.FscOrderStatusFlowAtomRspBO;
import com.tydic.fsc.busibase.external.api.bo.FscOsWorkFlowReqBO;
import com.tydic.fsc.busibase.external.api.bo.FscOsWorkFlowRspBO;
import com.tydic.fsc.busibase.external.api.bo.FscVirgoEngineAtomServiceReqBo;
import com.tydic.fsc.busibase.external.api.bo.FscVirgoEngineAtomServiceRspBo;
import com.tydic.fsc.busibase.external.api.osworkflow.FscOsworkflowWhetherChartAtomService;
import com.tydic.fsc.busibase.external.api.virgo.FscVirgoEngineAtomService;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscOrderMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.pay.busi.api.FscPayServiceBillProcessBusiService;
import com.tydic.fsc.pay.busi.bo.FscPayServiceBillProcessBusiReqBO;
import com.tydic.fsc.pay.busi.bo.FscPayServiceBillProcessBusiRspBO;
import com.tydic.fsc.po.FscOrderPO;
import com.tydic.osworkflow.approve.ability.EacProjectAbilityService;
import com.tydic.plugin.encoded.service.CfcEncodedSerialGetService;
import com.tydic.plugin.encoded.service.bo.CfcEncodedSerialGetServiceReqBO;
import com.tydic.plugin.encoded.service.bo.CfcEncodedSerialGetServiceRspBO;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class FscPayServiceBillProcessBusiServiceImpl
implements FscPayServiceBillProcessBusiService {
    private static final Logger log = LoggerFactory.getLogger(FscPayServiceBillProcessBusiServiceImpl.class);
    @Autowired
    private FscOrderMapper fscOrderMapper;
    @Autowired
    private FscOrderStatusFlowAtomService fscOrderStatusFlowAtomService;
    @Autowired
    private CfcEncodedSerialGetService encodedSerialGetService;
    @Autowired
    private FscGeneralBusiRuleExecAtomService fscGeneralBusiRuleExecAtomService;
    @Value(value="${no.need.audit.key :noNeedAudit}")
    private String noNeedAudit;
    @Autowired
    private EacProjectAbilityService eacProjectAbilityService;
    @Value(value="${process.sysCode}")
    private String processSysCode;
    @Autowired
    private FscAuditOrderCreateAtomService fscAuditOrderCreateAtomService;
    @Autowired
    private FscOsworkflowWhetherChartAtomService fscOsworkflowWhetherChartAtomService;
    @Autowired
    private FscVirgoEngineAtomService fscVirgoEngineAtomService;

    @Override
    public FscPayServiceBillProcessBusiRspBO dealPayServiceBillProcess(FscPayServiceBillProcessBusiReqBO busiReqBO) {
        this.updateOrder(busiReqBO, busiReqBO.getFscOrderPO());
        FscPayServiceBillProcessBusiRspBO rspBO = new FscPayServiceBillProcessBusiRspBO();
        this.invokeUacNoTask(busiReqBO, busiReqBO.getFscOrderPO(), rspBO);
        return rspBO;
    }

    private void updateOrder(FscPayServiceBillProcessBusiReqBO busiReqBO, FscOrderPO fscOrderPO) {
        if (busiReqBO.getCreditAmount().compareTo(fscOrderPO.getTotalCharge()) > 0) {
            throw new FscBusinessException("193208", "\u51cf\u514d\u91d1\u989d\u4e0d\u80fd\u5927\u4e8e\u6536\u8d39\u91d1\u989d\uff01");
        }
        CfcEncodedSerialGetServiceReqBO encodedSerialGetServiceReqBO = new CfcEncodedSerialGetServiceReqBO();
        encodedSerialGetServiceReqBO.setCenter("FSC");
        encodedSerialGetServiceReqBO.setNum(Integer.valueOf(1));
        encodedSerialGetServiceReqBO.setOrgType("-1");
        if (FscConstants.OrderFlow.MONTH_SERVICE_FEE.equals(fscOrderPO.getOrderFlow())) {
            encodedSerialGetServiceReqBO.setEncodedRuleCode("MONTH_DEAL_SERVICE_FEE_CREDIT_ORDER_NO");
        }
        if (FscConstants.OrderFlow.YEAR_ORDER_SERVICE_FEE.equals(fscOrderPO.getOrderFlow()) || FscConstants.OrderFlow.YEAR_ACCEPT_SERVICE_FEE.equals(fscOrderPO.getOrderFlow())) {
            encodedSerialGetServiceReqBO.setEncodedRuleCode("YEAR_DEAL_SERVICE_FEE_CREDIT_ORDER_NO");
        }
        if (FscConstants.OrderFlow.PL_SERVICE_FEE.equals(fscOrderPO.getOrderFlow())) {
            encodedSerialGetServiceReqBO.setEncodedRuleCode("PLATFORM_SERVICE_FEE_CREDIT_ORDER_NO");
        }
        CfcEncodedSerialGetServiceRspBO encodedSerialGetServiceRspBO = this.encodedSerialGetService.getEncodedSerial(encodedSerialGetServiceReqBO);
        FscOrderPO set = new FscOrderPO();
        set.setCreditNo((String)encodedSerialGetServiceRspBO.getSerialNoList().get(0));
        set.setDiscountOperId(busiReqBO.getUserName());
        set.setDiscountOperName(busiReqBO.getName());
        set.setDiscountOperTime(new Date());
        set.setCreditAmount(busiReqBO.getCreditAmount());
        set.setActualAmount(fscOrderPO.getTotalCharge().subtract(busiReqBO.getCreditAmount()));
        FscOrderPO where = new FscOrderPO();
        where.setFscOrderId(busiReqBO.getFscOrderId());
        this.fscOrderMapper.updateBy(set, where);
    }

    private void invokeUacNoTask(FscPayServiceBillProcessBusiReqBO busiReqBO, FscOrderPO fscOrderPO, FscPayServiceBillProcessBusiRspBO rspBO) {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        String createEvaProcessKey = this.getBusinessKey(busiReqBO);
        if (busiReqBO.getCreditAmount().compareTo(fscOrderPO.getTotalCharge()) == 0) {
            paramMap.put("orderFinish", "1");
        } else if (!this.qryAuditFlow(this.processSysCode, createEvaProcessKey)) {
            paramMap.put("auditFlag", FscConstants.ProcessParam.auditFlag2);
        } else {
            paramMap.put("auditFlag", FscConstants.ProcessParam.auditFlag);
        }
        FscOrderStatusFlowAtomReqBO fscOrderStatusFlowAtomReqBO = (FscOrderStatusFlowAtomReqBO)JSON.parseObject((String)JSON.toJSONString((Object)((Object)busiReqBO)), FscOrderStatusFlowAtomReqBO.class);
        fscOrderStatusFlowAtomReqBO.setParamMap(paramMap);
        fscOrderStatusFlowAtomReqBO.setCurStatus(FscConstants.FscServiceOrderState.TO_PROCESS);
        fscOrderStatusFlowAtomReqBO.setOrderId(busiReqBO.getFscOrderId());
        FscOrderStatusFlowAtomRspBO atomRspBO1 = this.fscOrderStatusFlowAtomService.dealStatusFlow(fscOrderStatusFlowAtomReqBO);
        if (!"0000".equals(atomRspBO1.getRespCode())) {
            throw new FscBusinessException("193208", atomRspBO1.getRespDesc());
        }
        if (paramMap.get("auditFlag") != null && FscConstants.ProcessParam.auditFlag.equals(paramMap.get("auditFlag"))) {
            FscAuditOrderCreateAtomReqBO fscAuditOrderCreateAtomReqBO = new FscAuditOrderCreateAtomReqBO();
            fscAuditOrderCreateAtomReqBO.setOrderId(busiReqBO.getFscOrderId());
            fscAuditOrderCreateAtomReqBO.setObjId(busiReqBO.getFscOrderId());
            fscAuditOrderCreateAtomReqBO.setObjType(FscConstants.OBJ_TYPE.FSC_ORDER);
            if (FscConstants.OrderFlow.PL_SERVICE_FEE.equals(busiReqBO.getFscOrderPO().getOrderFlow())) {
                fscAuditOrderCreateAtomReqBO.setObjBusiType(FscConstants.AuditObjType.SERVICE_PROCESS_APPROVAL);
            }
            if (FscConstants.OrderFlow.MONTH_SERVICE_FEE.equals(busiReqBO.getFscOrderPO().getOrderFlow())) {
                fscAuditOrderCreateAtomReqBO.setObjBusiType(FscConstants.AuditObjType.SERVICE_CHARGE_APPROVAL);
            }
            if (FscConstants.OrderFlow.YEAR_ORDER_SERVICE_FEE.equals(busiReqBO.getFscOrderPO().getOrderFlow())) {
                fscAuditOrderCreateAtomReqBO.setObjBusiType(FscConstants.AuditObjType.SERVICE_CHARGE_APPROVAL);
            }
            if (FscConstants.OrderFlow.YEAR_ACCEPT_SERVICE_FEE.equals(busiReqBO.getFscOrderPO().getOrderFlow())) {
                fscAuditOrderCreateAtomReqBO.setObjBusiType(FscConstants.AuditObjType.SERVICE_CHARGE_APPROVAL);
            }
            fscAuditOrderCreateAtomReqBO.setUserId(busiReqBO.getUserId());
            fscAuditOrderCreateAtomReqBO.setUserName(busiReqBO.getName());
            FscAuditOrderCreateAtomRspBO atomRspBO = this.fscAuditOrderCreateAtomService.dealAuditOrderCreate(fscAuditOrderCreateAtomReqBO);
            this.startAuditFlow(busiReqBO, createEvaProcessKey, atomRspBO, rspBO);
        }
    }

    private void startAuditFlow(FscPayServiceBillProcessBusiReqBO busiReqBO, String createEvaProcessKey, FscAuditOrderCreateAtomRspBO atomRspBO, FscPayServiceBillProcessBusiRspBO rspBO) {
        FscAuditBaseBo fscAuditBaseBo = new FscAuditBaseBo();
        fscAuditBaseBo.setProcDefKey(createEvaProcessKey);
        fscAuditBaseBo.setPartitionKey(busiReqBO.getFscOrderId().toString());
        HashMap<String, Long> variables = new HashMap<String, Long>();
        variables.put("auditId", atomRspBO.getAuditOrderId());
        fscAuditBaseBo.setVariables(variables);
        ArrayList<String> strings = new ArrayList<String>();
        strings.add(busiReqBO.getFscOrderId().toString());
        fscAuditBaseBo.setBusinessIdList(strings);
        rspBO.setIsStartAuditFlow(true);
        rspBO.setFscAuditBaseBo(fscAuditBaseBo);
    }

    private boolean qryAuditFlow(String sys_code, String extRegistAuditKey) {
        FscOsWorkFlowReqBO osWorkFlowReqBO = new FscOsWorkFlowReqBO();
        osWorkFlowReqBO.setSysCode(sys_code);
        osWorkFlowReqBO.setProcDefKey(extRegistAuditKey);
        FscOsWorkFlowRspBO osWorkflow = this.fscOsworkflowWhetherChartAtomService.findOsWorkflow(osWorkFlowReqBO);
        if (!"0000".equals(osWorkflow.getRespCode())) {
            throw new FscBusinessException(osWorkflow.getRespCode(), osWorkflow.getRespDesc());
        }
        return osWorkflow.getFindFlag();
    }

    private String getBusinessKey(FscPayServiceBillProcessBusiReqBO reqBO) {
        FscVirgoEngineAtomServiceReqBo virgoEngineAtomServiceReqBo = new FscVirgoEngineAtomServiceReqBo();
        if (FscConstants.OrderFlow.PL_SERVICE_FEE.equals(reqBO.getFscOrderPO().getOrderFlow())) {
            virgoEngineAtomServiceReqBo.setBusiSceneCode("FSC_PL_FREE_AUDIT");
        } else {
            virgoEngineAtomServiceReqBo.setBusiSceneCode("FSC_SERVICE_FREE_AUDIT");
        }
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("orderFlow", (Object)Convert.toStr((Object)reqBO.getFscOrderPO().getOrderFlow()));
        jsonObject.put("supplierId", (Object)Convert.toStr((Object)reqBO.getFscOrderPO().getSupplierId()));
        virgoEngineAtomServiceReqBo.setParamJsonStr(JSON.toJSONString((Object)jsonObject));
        FscVirgoEngineAtomServiceRspBo fscVirgoEngineAtomServiceRspBo = this.fscVirgoEngineAtomService.virgo(virgoEngineAtomServiceReqBo);
        if (!"0000".equals(fscVirgoEngineAtomServiceRspBo.getRespCode())) {
            throw new FscBusinessException(fscVirgoEngineAtomServiceRspBo.getRespCode(), fscVirgoEngineAtomServiceRspBo.getRespDesc());
        }
        JSONObject returnJson = JSON.parseObject((String)fscVirgoEngineAtomServiceRspBo.getBusiRuleExecResult());
        return returnJson.getString("business");
    }
}

