/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.pay.ability.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import com.tydic.fsc.bo.FscAuditBaseBo;
import com.tydic.fsc.bo.FscOrderPayItemBO;
import com.tydic.fsc.common.ability.api.FscComOrderSyncAbilityService;
import com.tydic.fsc.common.ability.bo.FscComOrderListSyncAbilityReqBO;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscShouldPayMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.pay.ability.api.FscPayBillUpdateAbilityService;
import com.tydic.fsc.pay.ability.bo.FscPayBillUpdateAbilityReqBO;
import com.tydic.fsc.pay.ability.bo.FscPayBillUpdateAbilityRspBO;
import com.tydic.fsc.pay.busi.api.FscPayBillUpdateBusiService;
import com.tydic.fsc.pay.busi.bo.FscPayBillUpdateBusiReqBO;
import com.tydic.fsc.pay.busi.bo.FscPayBillUpdateBusiRspBO;
import com.tydic.fsc.po.FscShouldPayPO;
import com.tydic.fsc.utils.BigDecimalConvert;
import com.tydic.osworkflow.approve.ability.EacProjectAbilityService;
import com.tydic.osworkflow.approve.ability.bo.EacStartProjectAbilityReqBO;
import com.tydic.osworkflow.approve.ability.bo.EacStartProjectAbilityRspBO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.fsc.pay.ability.api.FscPayBillUpdateAbilityService"})
public class FscPayBillUpdateAbilityServiceImpl
implements FscPayBillUpdateAbilityService {
    private static final Logger log = LoggerFactory.getLogger(FscPayBillUpdateAbilityServiceImpl.class);
    @Autowired
    private FscPayBillUpdateBusiService fscPayBillUpdateBusiService;
    @Autowired
    private FscComOrderSyncAbilityService fscComOrderSyncAbilityService;
    @Autowired
    private FscShouldPayMapper fscShouldPayMapper;
    @Value(value="${process.sysCode}")
    private String processSysCode;
    @Resource(name="fscOrderPayStatusSyncServiceProvider")
    private ProxyMessageProducer fscOrderPayStatusSyncServiceProvider;
    @Value(value="${FSC_ORDER_PAY_STATUS_SYNC_ORDER_TOPIC:FSC_ORDER_PAY_STATUS_SYNC_ORDER_TOPIC}")
    private String fscOrderPayStatusSyncOrderTopic;
    @Value(value="${FSC_ORDER_PAY_STATUS_SYNC_ORDER_TAG:FSC_ORDER_PAY_STATUS_SYNC_ORDER_TAG}")
    private String fscOrderPayStatusSyncOrderTag;
    @Autowired
    private EacProjectAbilityService eacProjectAbilityService;

    @BigDecimalConvert(value=2)
    @PostMapping(value={"dealPayBillUpdate"})
    public FscPayBillUpdateAbilityRspBO dealPayBillUpdate(@RequestBody FscPayBillUpdateAbilityReqBO abilityReqBO) {
        if (abilityReqBO.getFscOrderId() == null) {
            throw new FscBusinessException("191000", "\u5165\u53c2fscOrderId\u4e0d\u80fd\u4e3a\u7a7a");
        }
        FscPayBillUpdateBusiReqBO fscPayBillUpdateBusiReqBO = (FscPayBillUpdateBusiReqBO)((Object)JSON.parseObject((String)JSON.toJSONString((Object)abilityReqBO), FscPayBillUpdateBusiReqBO.class));
        FscPayBillUpdateBusiRspBO busiRspBO = this.fscPayBillUpdateBusiService.dealPayBillUpdate(fscPayBillUpdateBusiReqBO);
        if ("0000".equals(busiRspBO.getRespCode())) {
            if (busiRspBO.getIsStartAuditFlow().booleanValue()) {
                this.startAuditFlow(abilityReqBO, busiRspBO.getFscAuditBaseBo());
            }
            FscComOrderListSyncAbilityReqBO fscComOrderListSyncAbilityReqBO = new FscComOrderListSyncAbilityReqBO();
            fscComOrderListSyncAbilityReqBO.setFscOrderId(abilityReqBO.getFscOrderId());
            fscComOrderListSyncAbilityReqBO.setCreateTime(new Date());
            fscComOrderListSyncAbilityReqBO.setSendService(this.getClass().getName());
            this.fscComOrderSyncAbilityService.dealComOrderSyncEs(fscComOrderListSyncAbilityReqBO);
            this.serviceFeeSync(abilityReqBO);
            ArrayList<Long> fscOrderIds = new ArrayList<Long>();
            fscOrderIds.add(abilityReqBO.getFscOrderId());
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("busiParam", fscOrderIds);
            jsonObject.put("createTime", (Object)new Date());
            jsonObject.put("sendService", (Object)this.getClass().getName());
            this.fscOrderPayStatusSyncServiceProvider.send(new ProxyMessage(this.fscOrderPayStatusSyncOrderTopic, this.fscOrderPayStatusSyncOrderTag, JSON.toJSONString((Object)jsonObject)));
        }
        return (FscPayBillUpdateAbilityRspBO)JSON.parseObject((String)JSON.toJSONString((Object)((Object)busiRspBO)), FscPayBillUpdateAbilityRspBO.class);
    }

    private void serviceFeeSync(FscPayBillUpdateAbilityReqBO abilityReqBO) {
        if (!CollectionUtils.isEmpty((Collection)abilityReqBO.getFscOrderPayItemBOS())) {
            FscShouldPayPO fscShouldPayPO = new FscShouldPayPO();
            fscShouldPayPO.setShouldPayIds(abilityReqBO.getFscOrderPayItemBOS().stream().map(FscOrderPayItemBO::getShouldPayId).collect(Collectors.toList()));
            List fscShouldPayPOS = this.fscShouldPayMapper.getList(fscShouldPayPO);
            if (!CollectionUtils.isEmpty((Collection)fscShouldPayPOS)) {
                List shouldPayPOS = fscShouldPayPOS.stream().filter(fscShouldPay -> FscConstants.ShouldObjectType.DEAL_ORDER.equals(fscShouldPay.getShouldPayType()) || FscConstants.ShouldObjectType.USR_ORDER.equals(fscShouldPay.getShouldPayType())).collect(Collectors.toList());
                for (FscShouldPayPO shouldPayPO : shouldPayPOS) {
                    FscComOrderListSyncAbilityReqBO fscComOrderListSyncAbilityReqBO = new FscComOrderListSyncAbilityReqBO();
                    fscComOrderListSyncAbilityReqBO.setFscOrderId(shouldPayPO.getObjectId());
                    fscComOrderListSyncAbilityReqBO.setCreateTime(new Date());
                    fscComOrderListSyncAbilityReqBO.setSendService(this.getClass().getName());
                    this.fscComOrderSyncAbilityService.dealComOrderSyncEs(fscComOrderListSyncAbilityReqBO);
                }
            }
        }
    }

    private void startAuditFlow(FscPayBillUpdateAbilityReqBO reqBO, FscAuditBaseBo fscAuditBaseBo) {
        EacStartProjectAbilityReqBO eacStartProjectAbilityReqBO = (EacStartProjectAbilityReqBO)JSON.parseObject((String)JSON.toJSONString((Object)reqBO), EacStartProjectAbilityReqBO.class);
        eacStartProjectAbilityReqBO.setSysCode(this.processSysCode);
        eacStartProjectAbilityReqBO.setProcDefKey(fscAuditBaseBo.getProcDefKey());
        eacStartProjectAbilityReqBO.setPartitionKey(fscAuditBaseBo.getPartitionKey());
        eacStartProjectAbilityReqBO.setVariables(fscAuditBaseBo.getVariables());
        eacStartProjectAbilityReqBO.setBusinessIdList(fscAuditBaseBo.getBusinessIdList());
        eacStartProjectAbilityReqBO.setUserName(reqBO.getName());
        log.info("\u8c03\u7528\u6d41\u7a0b\u5ba1\u6279\u542f\u52a8\u5165\u53c2\u4e3a\uff1a" + JSON.toJSONString((Object)eacStartProjectAbilityReqBO));
        EacStartProjectAbilityRspBO eacStartProjectAbilityRspBO = this.eacProjectAbilityService.startProjectByMq(eacStartProjectAbilityReqBO);
        log.info("\u8c03\u7528\u6d41\u7a0b\u5ba1\u6279\u542f\u52a8\u51fa\u53c2\u4e3a\uff1a" + JSON.toJSONString((Object)eacStartProjectAbilityRspBO));
        if (!"0000".equals(eacStartProjectAbilityRspBO.getRespCode())) {
            throw new ZTBusinessException("\u8c03\u7528\u6d41\u7a0b\u5ba1\u6279\u542f\u52a8\u5931\u8d25,\u5f02\u5e38\u7f16\u7801\u3010" + eacStartProjectAbilityRspBO.getRespCode() + "\u3011," + eacStartProjectAbilityRspBO.getRespDesc());
        }
    }
}

