/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.pay.ability.impl;

import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscOrderMapper;
import com.tydic.fsc.dao.FscPayLogMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.pay.ability.api.FscPayInfoBackAbilityService;
import com.tydic.fsc.pay.ability.bo.FscPayInfoBackAbilityReqBO;
import com.tydic.fsc.pay.ability.bo.FscPayInfoBackAbilityRspBO;
import com.tydic.fsc.pay.busi.api.FscPayInfoBackBusiService;
import com.tydic.fsc.pay.busi.bo.FscPayInfoBackBusiReqBO;
import com.tydic.fsc.pay.busi.bo.FscPayInfoBackBusiRspBO;
import com.tydic.fsc.po.FscOrderPO;
import com.tydic.fsc.po.FscPayLogPO;
import java.math.BigDecimal;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.fsc.pay.ability.api.FscPayInfoBackAbilityService"})
public class FscPayInfoBackAbilityServiceImpl
implements FscPayInfoBackAbilityService {
    @Autowired
    private FscPayInfoBackBusiService fscPayInfoBackBusiService;
    @Autowired
    private FscOrderMapper fscOrderMapper;
    @Autowired
    private FscPayLogMapper fscPayLogMapper;

    @PostMapping(value={"dealPayInfoBack"})
    public FscPayInfoBackAbilityRspBO dealPayInfoBack(@RequestBody FscPayInfoBackAbilityReqBO reqBO) {
        this.check(reqBO);
        FscPayInfoBackBusiRspBO fscPayInfoBackBusiRspBO = this.fscPayInfoBackBusiService.dealPayInfoBack((FscPayInfoBackBusiReqBO)((Object)JSON.parseObject((String)JSON.toJSONString((Object)reqBO), FscPayInfoBackBusiReqBO.class)));
        if (!"0000".equals(fscPayInfoBackBusiRspBO.getRespCode())) {
            throw new FscBusinessException(fscPayInfoBackBusiRspBO.getRespCode(), fscPayInfoBackBusiRspBO.getRespDesc());
        }
        FscOrderPO fscOrder = this.getFscOrder(reqBO);
        this.updatePayState(fscOrder);
        return (FscPayInfoBackAbilityRspBO)JSON.parseObject((String)JSON.toJSONString((Object)((Object)fscPayInfoBackBusiRspBO)), FscPayInfoBackAbilityRspBO.class);
    }

    private void check(FscPayInfoBackAbilityReqBO reqBO) {
        if (StrUtil.isEmpty((CharSequence)reqBO.getBusiOrderNo()) && ObjectUtil.isNull((Object)reqBO.getBusiOrderId())) {
            throw new FscBusinessException("191000", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[busiOrderNo]\u548c[busiOrderId]\u4e0d\u80fd\u540c\u65f6\u4e3a\u7a7a");
        }
    }

    private void updatePayState(FscOrderPO fscOrder) {
        FscPayLogPO fscPayLogWhere = new FscPayLogPO();
        fscPayLogWhere.setBusiOrderId(fscOrder.getFscOrderId());
        List fscPayLogList = this.fscPayLogMapper.getList(fscPayLogWhere);
        BigDecimal sum = fscPayLogList.stream().map(FscPayLogPO::getBusiAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
        if (sum.compareTo(fscOrder.getTotalCharge()) == 0) {
            FscOrderPO fscOrderSet = new FscOrderPO();
            fscOrderSet.setPayState(FscConstants.FscPayOrderState.PAIED);
            FscOrderPO fscOrderWhere = new FscOrderPO();
            fscOrderWhere.setFscOrderId(fscOrder.getFscOrderId());
            this.fscOrderMapper.updateBy(fscOrderSet, fscOrderWhere);
        }
    }

    private FscOrderPO getFscOrder(FscPayInfoBackAbilityReqBO reqBO) {
        FscOrderPO fscOrderPo = new FscOrderPO();
        fscOrderPo.setFscOrderId(reqBO.getBusiOrderId());
        fscOrderPo.setOrderNo(reqBO.getBusiOrderNo());
        return this.fscOrderMapper.getModelBy(fscOrderPo);
    }
}

