/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.pay.busi.impl;

import com.ohaotian.plugin.db.Sequence;
import com.tydic.fsc.busibase.atom.api.FscOrderStatusFlowAtomService;
import com.tydic.fsc.busibase.atom.bo.FscOrderStatusFlowAtomReqBO;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscAttachmentMapper;
import com.tydic.fsc.dao.FscOrderMapper;
import com.tydic.fsc.pay.busi.api.FscPayBackEnrolmentBusiService;
import com.tydic.fsc.pay.busi.bo.FscPayBackEnrolmentBusiServiceReqBO;
import com.tydic.fsc.pay.busi.bo.FscPayBackEnrolmentBusiServiceRspBO;
import com.tydic.fsc.po.FscAttachmentPO;
import com.tydic.fsc.po.FscOrderPO;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class FscPayBackEnrolmentBusiServiceImpl
implements FscPayBackEnrolmentBusiService {
    @Autowired
    private FscAttachmentMapper fscAttachmentMapper;
    @Autowired
    private FscOrderStatusFlowAtomService fscOrderStatusFlowAtomService;
    @Autowired
    private FscOrderMapper fscOrderMapper;

    @Override
    public FscPayBackEnrolmentBusiServiceRspBO dealPayBackEnrolment(FscPayBackEnrolmentBusiServiceReqBO reqBO) {
        List fscAttachmentPOS = reqBO.getAttachmentBos().stream().map(attachmentBO -> {
            FscAttachmentPO fscAttachmentPO = new FscAttachmentPO();
            fscAttachmentPO.setFscOrderId(reqBO.getFscOrderId());
            fscAttachmentPO.setObjId(reqBO.getFscOrderId());
            fscAttachmentPO.setObjType(FscConstants.OBJ_TYPE.FSC_ORDER);
            fscAttachmentPO.setAttachmentId(Long.valueOf(Sequence.getInstance().nextId()));
            fscAttachmentPO.setAttachmentName(attachmentBO.getAttachmentName());
            fscAttachmentPO.setAttachmentUrl(attachmentBO.getAttachmentUrl());
            fscAttachmentPO.setAttachmentType(FscConstants.AttachmentType.PAY_REFUND);
            return fscAttachmentPO;
        }).collect(Collectors.toList());
        this.fscAttachmentMapper.insertBatch(fscAttachmentPOS);
        FscOrderPO fscOrderPO = new FscOrderPO();
        fscOrderPO.setFscOrderId(reqBO.getFscOrderId());
        fscOrderPO.setPayTime(new Date());
        this.fscOrderMapper.updateById(fscOrderPO);
        FscOrderStatusFlowAtomReqBO fscOrderStatusFlowAtomReqBO = new FscOrderStatusFlowAtomReqBO();
        fscOrderStatusFlowAtomReqBO.setOrderId(reqBO.getFscOrderId());
        this.fscOrderStatusFlowAtomService.dealStatusFlow(fscOrderStatusFlowAtomReqBO);
        return new FscPayBackEnrolmentBusiServiceRspBO();
    }
}

