/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.pay.busi.impl;

import com.alibaba.fastjson.JSON;
import com.tydic.fsc.busibase.atom.api.FscPayRecordTodoDealAtomService;
import com.tydic.fsc.busibase.atom.bo.FscPayRecordInfoBO;
import com.tydic.fsc.busibase.atom.bo.FscPayRecordTodoDealAtomReqBo;
import com.tydic.fsc.busibase.atom.bo.FscPayRecordTodoDealAtomRspBo;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscOrderPayItemMapper;
import com.tydic.fsc.dao.FscShouldPayMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.pay.atom.api.FscPayBillAtomService;
import com.tydic.fsc.pay.atom.bo.FscPayBillAtomReqBO;
import com.tydic.fsc.pay.atom.bo.FscPayBillAtomRspBO;
import com.tydic.fsc.pay.busi.api.FscPayBillBusiService;
import com.tydic.fsc.pay.busi.bo.FscPayBillBusiReqBO;
import com.tydic.fsc.pay.busi.bo.FscPayBillBusiRspBO;
import com.tydic.fsc.po.FscOrderPayItemPO;
import com.tydic.fsc.po.FscShouldPayPO;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class FscPayBillBusiServiceImpl
implements FscPayBillBusiService {
    private static final Logger log = LoggerFactory.getLogger(FscPayBillBusiServiceImpl.class);
    @Autowired
    private FscPayBillAtomService fscPayBillAtomService;
    @Autowired
    private FscPayRecordTodoDealAtomService fscPayRecordTodoDealAtomService;
    @Autowired
    private FscShouldPayMapper fscShouldPayMapper;
    @Autowired
    private FscOrderPayItemMapper fscOrderPayItemMapper;

    @Override
    public FscPayBillBusiRspBO dealPayBill(FscPayBillBusiReqBO busiReqBO) {
        FscPayBillBusiRspBO busiRspBO = new FscPayBillBusiRspBO();
        FscPayBillAtomReqBO fscPayBillAtomReqBO = (FscPayBillAtomReqBO)((Object)JSON.parseObject((String)JSON.toJSONString((Object)((Object)busiReqBO)), FscPayBillAtomReqBO.class));
        FscPayBillAtomRspBO atomRspBO = this.fscPayBillAtomService.dealPayBill(fscPayBillAtomReqBO);
        if (!"0000".equals(atomRspBO.getRespCode())) {
            throw new FscBusinessException(atomRspBO.getRespCode(), atomRspBO.getRespDesc());
        }
        this.sendTodoDone(busiReqBO);
        busiRspBO.setResultFscOrderIds(atomRspBO.getResultFscOrderIds());
        busiRspBO.setUrl(atomRspBO.getUrl());
        busiRspBO.setBusiRspData(atomRspBO.getBusiRspData());
        busiRspBO.setRespCode("0000");
        busiRspBO.setRespDesc("\u652f\u4ed8\u8c03\u7528\u6210\u529f");
        return busiRspBO;
    }

    private void sendTodoDone(FscPayBillBusiReqBO busiReqBO) {
        FscOrderPayItemPO fscOrderPayItemPO = new FscOrderPayItemPO();
        fscOrderPayItemPO.setFscOrderIds(busiReqBO.getFscOrderIds());
        List fscOrderPayItemPOS = this.fscOrderPayItemMapper.getList(fscOrderPayItemPO);
        if (!CollectionUtils.isEmpty((Collection)fscOrderPayItemPOS)) {
            List<Long> shouldPayIds = fscOrderPayItemPOS.stream().map(FscOrderPayItemPO::getShouldPayId).collect(Collectors.toList());
            this.sendTodoDone(shouldPayIds, busiReqBO);
        }
    }

    private void sendTodoDone(List<Long> shouldPayIds, FscPayBillBusiReqBO busiReqBO) {
        FscShouldPayPO fscShouldPayPO = new FscShouldPayPO();
        fscShouldPayPO.setShouldPayIds(shouldPayIds);
        fscShouldPayPO.setShouldPayStatus(FscConstants.ShouldPayStatus.TO_PAY);
        List fscShouldPayList = this.fscShouldPayMapper.getList(fscShouldPayPO);
        if (!CollectionUtils.isEmpty((Collection)fscShouldPayList)) {
            FscPayRecordTodoDealAtomReqBo fscPayRecordTodoDealAtomReqBo = new FscPayRecordTodoDealAtomReqBo();
            if (null == busiReqBO.getUserId()) {
                fscPayRecordTodoDealAtomReqBo.setUserId(Long.valueOf(1L));
                fscPayRecordTodoDealAtomReqBo.setUserName("\u7cfb\u7edf\u7ba1\u7406\u5458");
            } else {
                fscPayRecordTodoDealAtomReqBo.setUserId(busiReqBO.getUserId());
                fscPayRecordTodoDealAtomReqBo.setUserName(busiReqBO.getUserName());
            }
            fscPayRecordTodoDealAtomReqBo.setFscShouldPayInfo(fscShouldPayList.stream().map(fscShouldPay -> {
                FscPayRecordInfoBO fscPayRecordInfoBO = new FscPayRecordInfoBO();
                fscPayRecordInfoBO.setFscShouldPayId(fscShouldPay.getShouldPayId());
                fscPayRecordInfoBO.setFscShouldPayNo(fscShouldPay.getShouldPayNo());
                fscPayRecordInfoBO.setShouldPayType(fscShouldPay.getShouldPayType());
                fscPayRecordInfoBO.setPayerId(fscShouldPay.getPayerId());
                return fscPayRecordInfoBO;
            }).collect(Collectors.toList()));
            FscPayRecordTodoDealAtomRspBo fscPayRecordTodoDealAtomRspBo = this.fscPayRecordTodoDealAtomService.sendPayRecordTodoDone(fscPayRecordTodoDealAtomReqBo);
            if (!"0000".equals(fscPayRecordTodoDealAtomRspBo.getRespCode())) {
                log.error("\u53d1\u9001\u5f85\u4ed8\u6b3e\u8bb0\u5f55\u5df2\u529e\u5931\u8d25\uff1a{}", (Object)fscPayRecordTodoDealAtomRspBo.getRespDesc());
            }
        }
    }
}

