/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.pay.busi.impl;

import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscOrderMapper;
import com.tydic.fsc.dao.FscPayLogMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.pay.busi.api.FscPayInfoBackBusiService;
import com.tydic.fsc.pay.busi.bo.FscPayInfoBackBusiReqBO;
import com.tydic.fsc.pay.busi.bo.FscPayInfoBackBusiRspBO;
import com.tydic.fsc.po.FscOrderPO;
import com.tydic.fsc.po.FscPayLogPO;
import java.util.Date;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class FscPayInfoBackBusiServiceImpl
implements FscPayInfoBackBusiService {
    @Autowired
    private FscPayLogMapper fscPayLogMapper;
    @Autowired
    private FscOrderMapper fscOrderMapper;

    @Override
    public FscPayInfoBackBusiRspBO dealPayInfoBack(FscPayInfoBackBusiReqBO reqBO) {
        FscOrderPO fscOrder = this.getFscOrder(reqBO);
        if (ObjectUtil.isNull((Object)fscOrder)) {
            throw new FscBusinessException("191037", "\u672a\u67e5\u8be2\u5230\u5bf9\u5e94\u7684\u7ed3\u7b97\u5355\u4fe1\u606f");
        }
        this.savePayInfoLog(reqBO, fscOrder);
        FscPayInfoBackBusiRspBO rspBO = new FscPayInfoBackBusiRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private FscOrderPO getFscOrder(FscPayInfoBackBusiReqBO reqBO) {
        FscOrderPO fscOrderPo = new FscOrderPO();
        fscOrderPo.setFscOrderId(reqBO.getBusiOrderId());
        fscOrderPo.setOrderNo(reqBO.getBusiOrderNo());
        return this.fscOrderMapper.getModelBy(fscOrderPo);
    }

    private void savePayInfoLog(FscPayInfoBackBusiReqBO reqBO, FscOrderPO fscOrder) {
        FscPayLogPO fscPayLogPO = (FscPayLogPO)JSON.parseObject((String)JSON.toJSONString((Object)((Object)reqBO)), FscPayLogPO.class);
        fscPayLogPO.setId(Long.valueOf(Sequence.getInstance().nextId()));
        if (StrUtil.isEmpty((CharSequence)fscPayLogPO.getBusiOrderNo())) {
            fscPayLogPO.setBusiOrderNo(fscOrder.getOrderNo());
        }
        if (ObjectUtil.isNull((Object)fscPayLogPO.getBusiOrderId())) {
            fscPayLogPO.setBusiOrderId(fscOrder.getFscOrderId());
        }
        fscPayLogPO.setBusiCategory(FscConstants.FscBusiCategory.PERIOD_PAY);
        fscPayLogPO.setBusiOrderType(FscConstants.CreditOrderType.FSC_ORDER);
        fscPayLogPO.setCreateTime(new Date());
        this.fscPayLogMapper.insert(fscPayLogPO);
    }
}

