/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.pay.busi.impl;

import cn.hutool.core.convert.Convert;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.fsc.busibase.atom.api.FscOrderStatusFlowAtomService;
import com.tydic.fsc.busibase.atom.bo.FscOrderStatusFlowAtomReqBO;
import com.tydic.fsc.busibase.external.api.bo.FscUocUpdateSaleOrderReturnPayResultAtomServiceReqBo;
import com.tydic.fsc.busibase.external.api.bo.FscUocUpdateSaleOrderReturnPayResultAtomServiceRspBo;
import com.tydic.fsc.busibase.external.api.uoc.FscUocUpdateSaleOrderReturnPayResultAtomService;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscCreditBalanceMapper;
import com.tydic.fsc.dao.FscMerchantMapper;
import com.tydic.fsc.dao.FscOrderMapper;
import com.tydic.fsc.dao.FscOrderPayBackRelationMapper;
import com.tydic.fsc.dao.FscPayLogMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.pay.busi.api.FscPayBackEnrolmentConfirmBusiService;
import com.tydic.fsc.pay.busi.bo.FscPayBackEnrolmentConfirmBusiServiceReqBO;
import com.tydic.fsc.pay.busi.bo.FscPayBackEnrolmentConfirmBusiServiceRspBO;
import com.tydic.fsc.po.FscCreditBalancePO;
import com.tydic.fsc.po.FscMerchantPO;
import com.tydic.fsc.po.FscOrderPO;
import com.tydic.fsc.po.FscOrderPayBackRelationPO;
import com.tydic.fsc.po.FscPayLogPO;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class FscPayBackEnrolmentConfirmBusiServiceImpl
implements FscPayBackEnrolmentConfirmBusiService {
    @Autowired
    private FscPayLogMapper fscPayLogMapper;
    @Autowired
    private FscOrderMapper fscOrderMapper;
    @Autowired
    private FscOrderPayBackRelationMapper fscOrderPayBackRelationMapper;
    @Autowired
    private FscMerchantMapper fscMerchantMapper;
    @Autowired
    private FscCreditBalanceMapper fscCreditBalanceMapper;
    @Autowired
    private FscOrderStatusFlowAtomService fscOrderStatusFlowAtomService;
    @Autowired
    private FscUocUpdateSaleOrderReturnPayResultAtomService fscUocUpdateSaleOrderReturnPayResultAtomService;

    @Override
    public FscPayBackEnrolmentConfirmBusiServiceRspBO dealPayBackEnrolmentConfirm(FscPayBackEnrolmentConfirmBusiServiceReqBO reqBO) {
        FscOrderPO fscOrder = new FscOrderPO();
        fscOrder.setFscOrderIds(reqBO.getFscOrderIds());
        List fscOrderPOS = this.fscOrderMapper.getList(fscOrder);
        FscMerchantPO fscMerchant = new FscMerchantPO();
        fscMerchant.setOrgIds(fscOrderPOS.stream().map(FscOrderPO::getPayerId).distinct().collect(Collectors.toList()));
        fscMerchant.setExceptionFlag(FscConstants.MerchantIsException.MERCHANT_NOT_EXCEPTION);
        fscMerchant.setDelFlag(FscConstants.DicDelFlag.NO);
        List fscMerchantList = this.fscMerchantMapper.getList(fscMerchant);
        Map<Long, FscMerchantPO> merchantPOMap = fscMerchantList.stream().collect(Collectors.toMap(FscMerchantPO::getOrgId, o -> o));
        FscOrderPayBackRelationPO fscOrderPayBackRelation = new FscOrderPayBackRelationPO();
        fscOrderPayBackRelation.setFscOrderIds(fscOrderPOS.stream().map(FscOrderPO::getFscOrderId).collect(Collectors.toList()));
        List orderPayBackRelationPOS = this.fscOrderPayBackRelationMapper.getList(fscOrderPayBackRelation);
        Map<Long, FscOrderPayBackRelationPO> payBackRelationPOMap = orderPayBackRelationPOS.stream().collect(Collectors.toMap(FscOrderPayBackRelationPO::getFscOrderId, o -> o));
        FscCreditBalancePO fscCreditBalance = new FscCreditBalancePO();
        fscCreditBalance.setCreditOrgIds(fscOrderPOS.stream().map(FscOrderPO::getPayeeId).collect(Collectors.toList()));
        List creditBalancePOS = this.fscCreditBalanceMapper.getList(fscCreditBalance);
        Map<String, FscCreditBalancePO> creditBalancePOMap = creditBalancePOS.stream().collect(Collectors.toMap(fscCreditBalancePO -> Convert.toStr((Object)fscCreditBalancePO.getMerchantId()) + Convert.toStr((Object)fscCreditBalancePO.getCreditOrgId()), o -> o));
        Date now = new Date();
        ArrayList<FscPayLogPO> fscPayLogPOS = new ArrayList<FscPayLogPO>();
        for (FscOrderPO fscOrderPO : fscOrderPOS) {
            FscMerchantPO fscMerchantPO = merchantPOMap.get(fscOrderPO.getPayerId());
            FscOrderPayBackRelationPO fscOrderPayBackRelationPO = payBackRelationPOMap.get(fscOrderPO.getFscOrderId());
            FscCreditBalancePO fscCreditBalancePO2 = creditBalancePOMap.get(Convert.toStr((Object)fscMerchantPO.getMerchantId()) + Convert.toStr((Object)fscOrderPO.getPayeeId()));
            FscPayLogPO fscPayLogPO = new FscPayLogPO();
            fscPayLogPO.setId(Long.valueOf(Sequence.getInstance().nextId()));
            fscPayLogPO.setAccountId(fscMerchantPO.getAccountId());
            fscPayLogPO.setOrgId(fscOrderPO.getPayerId());
            fscPayLogPO.setPayeeId(fscOrderPO.getPayeeId());
            fscPayLogPO.setUserName(fscOrderPO.getCreateOperName());
            fscPayLogPO.setBusiTime(now);
            fscPayLogPO.setCreateTime(now);
            fscPayLogPO.setBusiAmount(fscOrderPO.getTotalCharge().negate());
            fscPayLogPO.setBusiCategory(FscConstants.FscBusiCategory.ORDER_REFUND);
            fscPayLogPO.setBusiOrderType(FscConstants.CreditOrderType.ORDER);
            fscPayLogPO.setBusiOrderId(fscOrderPayBackRelationPO.getRefundOrderId());
            fscPayLogPO.setBusiOrderNo(fscOrderPayBackRelationPO.getRefundOrderNo());
            if (FscConstants.MerchantPayType.MERCHANT_PAY_TYPE_PERIOD.equals(fscOrderPO.getPayType())) {
                fscPayLogPO.setIsCredit(FscConstants.IS_CREDIT.YES);
                fscPayLogPO.setBusiBeforeAmount(fscCreditBalancePO2.getAvailableAmount());
                fscPayLogPO.setBusiAfterAmount(fscCreditBalancePO2.getAvailableAmount());
            } else {
                fscPayLogPO.setIsCredit(FscConstants.IS_CREDIT.NO);
            }
            fscPayLogPOS.add(fscPayLogPO);
            this.dealRefundSuccess(fscOrderPayBackRelationPO, fscOrderPO);
        }
        if (CollectionUtils.isNotEmpty(fscPayLogPOS)) {
            this.fscPayLogMapper.insertBatch(fscPayLogPOS);
        }
        this.dealFlowOrder(fscOrderPOS);
        return new FscPayBackEnrolmentConfirmBusiServiceRspBO();
    }

    private void dealRefundSuccess(FscOrderPayBackRelationPO fscOrderPayBackRelationPO, FscOrderPO fscOrderPO) {
        FscUocUpdateSaleOrderReturnPayResultAtomServiceReqBo atomServiceReqBo = new FscUocUpdateSaleOrderReturnPayResultAtomServiceReqBo();
        atomServiceReqBo.setFscShouldPayId(fscOrderPayBackRelationPO.getShouldPayId());
        atomServiceReqBo.setSaleOrderId(fscOrderPayBackRelationPO.getRefundOrderId());
        atomServiceReqBo.setReturnPayResult(Boolean.valueOf(true));
        atomServiceReqBo.setPayBackAmount(fscOrderPO.getTotalCharge());
        atomServiceReqBo.setRefundObjType(fscOrderPayBackRelationPO.getRefundObjType());
        atomServiceReqBo.setRefundObjId(fscOrderPayBackRelationPO.getRefundObjId());
        FscUocUpdateSaleOrderReturnPayResultAtomServiceRspBo atomServiceRspBo = this.fscUocUpdateSaleOrderReturnPayResultAtomService.updateReturnPayResult(atomServiceReqBo);
        if (!"0000".equals(atomServiceRspBo.getRespCode())) {
            throw new FscBusinessException(atomServiceRspBo.getRespCode(), atomServiceRspBo.getRespDesc());
        }
    }

    private void updatePayRefundTime(List<Long> fscOrderIds, Date now) {
        if (CollectionUtils.isNotEmpty(fscOrderIds)) {
            FscOrderPO fscOrderPO = new FscOrderPO();
            fscOrderPO.setPayTime(now);
            fscOrderPO.setFscOrderIds(fscOrderIds);
            this.fscOrderMapper.updateByIds(fscOrderPO);
        }
    }

    private void dealFlowOrder(List<FscOrderPO> fscOrderPOs) {
        for (FscOrderPO fscOrderPO : fscOrderPOs) {
            FscOrderStatusFlowAtomReqBO flowAtomReqBO = new FscOrderStatusFlowAtomReqBO();
            flowAtomReqBO.setOrderId(fscOrderPO.getFscOrderId());
            this.fscOrderStatusFlowAtomService.dealStatusFlow(flowAtomReqBO);
        }
    }
}

