/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.pay.ability.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.ohaotian.plugin.db.Sequence;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import com.tydic.fsc.bo.FscPayCallbackContentBO;
import com.tydic.fsc.common.ability.api.FscComOrderSyncAbilityService;
import com.tydic.fsc.common.ability.bo.FscComOrderListSyncAbilityReqBO;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscPayIntfLogMapper;
import com.tydic.fsc.pay.ability.api.FscPayBillCallbackAbilityService;
import com.tydic.fsc.pay.ability.bo.FscPayBillCallbackAbilityReqBO;
import com.tydic.fsc.pay.ability.bo.FscPayBillCallbackAbilityRspBO;
import com.tydic.fsc.pay.busi.api.FscPayBillCallbackBusiService;
import com.tydic.fsc.pay.busi.bo.FscPayBillCallbackBusiReqBO;
import com.tydic.fsc.pay.busi.bo.FscPayBillCallbackBusiRspBO;
import com.tydic.fsc.po.FscPayIntfLogPO;
import com.tydic.payment.pay.sdk.PayCenterUtils;
import java.util.Date;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.fsc.pay.ability.api.FscPayBillCallbackAbilityService"})
public class FscPayBillCallbackAbilityServiceImpl
implements FscPayBillCallbackAbilityService {
    private static final Logger log = LoggerFactory.getLogger(FscPayBillCallbackAbilityServiceImpl.class);
    @Value(value="${payPublicKey}")
    private String payPublicKey;
    @Autowired
    private FscPayBillCallbackBusiService fscPayBillCallbackBusiService;
    @Autowired
    private FscPayIntfLogMapper fscPayIntfLogMapper;
    @Autowired
    private FscComOrderSyncAbilityService fscComOrderSyncAbilityService;
    @Resource(name="fscOrderPayStatusSyncServiceProvider")
    private ProxyMessageProducer fscOrderPayStatusSyncServiceProvider;
    @Value(value="${FSC_ORDER_PAY_STATUS_SYNC_ORDER_TOPIC:FSC_ORDER_PAY_STATUS_SYNC_ORDER_TOPIC}")
    private String fscOrderPayStatusSyncOrderTopic;
    @Value(value="${FSC_ORDER_PAY_STATUS_SYNC_ORDER_TAG:FSC_ORDER_PAY_STATUS_SYNC_ORDER_TAG}")
    private String fscOrderPayStatusSyncOrderTag;
    @Resource(name="fscAccountShouldPayProvider")
    private ProxyMessageProducer fscAccountShouldPayProvider;
    @Value(value="${FSC_ACCOUNT_SHOULD_PAY_TOPIC:FSC_ACCOUNT_SHOULD_PAY_TOPIC}")
    private String fscAccountShouldPayTopic;
    @Value(value="${FSC_ACCOUNT_SHOULD_PAY_TAG:FSC_ACCOUNT_SHOULD_PAY_TAG}")
    private String fscAccountShouldPayTag;
    @Value(value="${payCallBackFail:}")
    private String payCallBackFailFlag;

    @PostMapping(value={"dealPayBillCallback"})
    public FscPayBillCallbackAbilityRspBO dealPayBillCallback(@RequestBody FscPayBillCallbackAbilityReqBO abilityReqBO) {
        FscPayCallbackContentBO fscPayCallbackContentBO;
        if (abilityReqBO.getOutOrderId() != null) {
            fscPayCallbackContentBO = new FscPayCallbackContentBO();
            fscPayCallbackContentBO.setOutOrderId(abilityReqBO.getOutOrderId().toString());
        } else {
            String content = PayCenterUtils.deCode((String)abilityReqBO.getContent(), (String)this.payPublicKey);
            fscPayCallbackContentBO = (FscPayCallbackContentBO)JSON.parseObject((String)content, FscPayCallbackContentBO.class);
            if ("payCallBackFailFlag".equals(this.payCallBackFailFlag)) {
                fscPayCallbackContentBO.setResultCode("FAIL");
                log.debug("\u6d4b\u8bd5\u5931\u8d25\u573a\u666f\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)fscPayCallbackContentBO, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}));
            }
        }
        FscPayBillCallbackBusiReqBO fscPayBillCallbackBusiReqBO = new FscPayBillCallbackBusiReqBO();
        fscPayBillCallbackBusiReqBO.setFscPayCallbackContentBO(fscPayCallbackContentBO);
        FscPayBillCallbackBusiRspBO busiRspBO = this.fscPayBillCallbackBusiService.dealPayBillCallback(fscPayBillCallbackBusiReqBO);
        if ("0000".equals(busiRspBO.getRespCode())) {
            busiRspBO.getResultFscOrderIds().forEach(fscOrderId -> {
                FscComOrderListSyncAbilityReqBO fscComOrderListSyncAbilityReqBO = new FscComOrderListSyncAbilityReqBO();
                fscComOrderListSyncAbilityReqBO.setFscOrderId(fscOrderId);
                this.fscComOrderSyncAbilityService.dealComOrderSyncEs(fscComOrderListSyncAbilityReqBO);
            });
            this.fscAccountShouldPayProvider.send(new ProxyMessage(this.fscAccountShouldPayTopic, this.fscAccountShouldPayTag, JSON.toJSONString(busiRspBO.getResultFscOrderIds())));
        }
        FscPayBillCallbackAbilityRspBO abilityRspBO = (FscPayBillCallbackAbilityRspBO)JSON.parseObject((String)JSON.toJSONString((Object)((Object)busiRspBO)), FscPayBillCallbackAbilityRspBO.class);
        FscPayIntfLogPO fscPayIntfLogPO = new FscPayIntfLogPO();
        fscPayIntfLogPO.setCreateTime(new Date());
        fscPayIntfLogPO.setReqJson(JSON.toJSONString((Object)abilityReqBO));
        fscPayIntfLogPO.setId(Long.valueOf(Sequence.getInstance().nextId()));
        fscPayIntfLogPO.setIntfResult(FscConstants.InfcProcessResult.SUCCESS);
        fscPayIntfLogPO.setSerialNo(fscPayCallbackContentBO.getOutOrderId());
        if ("0000".equals(busiRspBO.getRespCode())) {
            fscPayIntfLogPO.setBusiResult(FscConstants.InfcProcessResult.SUCCESS);
        } else {
            fscPayIntfLogPO.setBusiResult(FscConstants.InfcProcessResult.FAIL);
            fscPayIntfLogPO.setRspJson(JSON.toJSONString((Object)((Object)busiRspBO)));
        }
        fscPayIntfLogPO.setServiceCode("FscPayBillCallbackAbilityService");
        this.fscPayIntfLogMapper.insert(fscPayIntfLogPO);
        return abilityRspBO;
    }
}

