package com.tydic.service.course.impl;

import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.service.course.DemoCourseService;
import com.tydic.service.course.bo.DemoStudentQryBo;
import com.tydic.repository.dao.DemoCourseMapper;
import com.tydic.repository.dao.DemoCourseRelationMapper;
import com.tydic.repository.po.DemoCoursePO;
import com.tydic.repository.po.DemoCourseRelationPO;
import com.tydic.repository.util.Sequence;
import com.tydic.service.course.bo.DemoCourseBo;
import com.tydic.service.course.bo.DemoCourseQryReqBo;
import com.tydic.service.course.bo.DemoCourseQryRsqBo;
import com.tydic.service.course.bo.DemoCourseRelationBo;
import com.tydic.utils.JsonUtil;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.List;

@HTServiceImpl
public class DemoCourseServiceImpl implements DemoCourseService {

    @Autowired
    private DemoCourseMapper demoCourseMapper;
    @Autowired
    private DemoCourseRelationMapper demoCourseRelationMapper;

    @Override
    public DemoCourseQryRsqBo openCourse(DemoCourseQryReqBo demoCourseQryReqBo) {
        DemoCourseQryRsqBo rspBo = new DemoCourseQryRsqBo();

        DemoCoursePO insertDemoCoursePO = new DemoCoursePO();
        BeanUtils.copyProperties(demoCourseQryReqBo, insertDemoCoursePO);
        insertDemoCoursePO.setCourseNo("C" + Sequence.getInstance().nextId());
        demoCourseMapper.insert(insertDemoCoursePO);

        rspBo.setDemoCourse(JsonUtil.js(insertDemoCoursePO, DemoCourseBo.class));
        return rspBo;
    }

    @Override
    public DemoCourseQryRsqBo selectCourse(DemoCourseQryReqBo demoCourseQryReqBo) {
        DemoCourseQryRsqBo rspBo = new DemoCourseQryRsqBo();

        DemoStudentQryBo demoStudentQryBo = new DemoStudentQryBo();
        BeanUtils.copyProperties(demoCourseQryReqBo, demoStudentQryBo);

        DemoCoursePO selectDemoCoursePO = new DemoCoursePO();
        selectDemoCoursePO.setCourseNo(demoStudentQryBo.getCourseNo());
        List<DemoCoursePO> demoCoursePOList = demoCourseMapper.selectByCondition(selectDemoCoursePO);

        if (demoCoursePOList.size() == 1) {
            DemoCourseRelationPO insertDemoCourseRelationPO = new DemoCourseRelationPO();
            insertDemoCourseRelationPO.setCourseNo(demoCoursePOList.get(0).getCourseNo());
            insertDemoCourseRelationPO.setStudentNo(demoStudentQryBo.getStudentNo());
            insertDemoCourseRelationPO.setTeacherNo(demoCoursePOList.get(0).getTeacherNo());
            demoCourseRelationMapper.insert(insertDemoCourseRelationPO);
            rspBo.setDemoCourseRelation(JsonUtil.js(insertDemoCourseRelationPO, DemoCourseRelationBo.class));
            return rspBo;
        } else if (demoCoursePOList.size() > 1) {
            throw new ZTBusinessException("查询课程信息（单个）失败：存在多条对应的信息");
        } else {
            throw new ZTBusinessException("查询课程信息（单个）失败：不存在对应的信息");
        }
    }
}
