package com.tydic.repository.util;

import com.ohaotian.plugin.db.SnowFlake;

/**
 * 描述：使用SnowFlake算法用来生成64位的ID
 *
 * @author: yuhao
 * @date: 2019年3月6日 上午10:10:07
 */
public class Sequence {

    private static int MAX_ID_NUM = 1 << 12;

    private static SnowFlake snowFlake;

    private static Sequence ourInstance = new Sequence();

    public static Sequence getInstance() {
        return ourInstance;
    }

    private Sequence() {
        Sequence.snowFlake = new SnowFlake(RandomUtil.randomCenterId(), RandomUtil.randomMachineId());
    }

    /**
     * @return 返回64位大致有序的ID
     */
    public long nextId() {
        return Sequence.snowFlake.nextId();
    }

    /**
     * 批量获取ID。
     * <p>
     * 由于使用SnowFlake算法，同一毫秒内可以生成4096个ID，为了避免毫秒内重复，所以添加此限制。
     *
     * @param idNum 一次获取ID的数量
     * @return
     */
    public long[] nextIds(int idNum) {
        if (idNum > MAX_ID_NUM) {
            throw new IllegalArgumentException("The number of Id can't be greater than " + MAX_ID_NUM);
        }
        long[] ids = new long[idNum];
        for (int i = 0; i < idNum; i++) {
            ids[i] = Sequence.snowFlake.nextId();
        }
        return ids;
    }

}
