/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.boot.hsf.provider;

import com.alibaba.boot.hsf.HsfProperties;
import com.alibaba.boot.hsf.annotation.HSFProvider;
import com.alibaba.boot.hsf.consumer.HsfConsumerAutoConfiguration;
import com.alibaba.boot.hsf.provider.HsfProviderBeanDefinitionBuilder;
import com.alibaba.boot.hsf.utils.BeanNameUtils;
import com.alibaba.boot.hsf.utils.HsfPropertiesUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.BeanClassLoaderAware;
import org.springframework.beans.factory.BeanCreationException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.EnvironmentAware;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.ImportBeanDefinitionRegistrar;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.Environment;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.util.StringUtils;

@Configuration
@ConditionalOnProperty(name={"spring.hsf.enabled"}, matchIfMissing=true)
@EnableConfigurationProperties(value={HsfProperties.class})
@AutoConfigureBefore(value={HsfConsumerAutoConfiguration.class})
public class HsfProviderAnnotationRegistrar
implements ImportBeanDefinitionRegistrar,
EnvironmentAware,
BeanClassLoaderAware {
    private static final Logger logger = LoggerFactory.getLogger(HsfProviderAnnotationRegistrar.class);
    private ConfigurableEnvironment environment;
    private ClassLoader classLoader;
    private boolean inited = false;

    public void registerBeanDefinitions(AnnotationMetadata importingClassMetadata, BeanDefinitionRegistry registry) {
        HsfProperties hsfProperties = HsfPropertiesUtils.buildHsfProperties((ConfigurableEnvironment)this.environment);
        if (!hsfProperties.isEnabled()) {
            if (logger.isDebugEnabled()) {
                logger.debug("spring.hsf.enabled is false, so skip process @HSFProvider");
            }
        } else {
            String targetBeanName = BeanNameUtils.beanName((AnnotationMetadata)importingClassMetadata, (BeanDefinitionRegistry)registry);
            String beanName = targetBeanName + "#HSFProvider";
            String className = importingClassMetadata.getClassName();
            if (registry.containsBeanDefinition(beanName)) {
                logger.info("BeanDefinition with the same beanName already existed, please check your config! beanName:" + beanName);
                registry.removeBeanDefinition(beanName);
                return;
            }
            try {
                Class<?> targetClass = this.classLoader.loadClass(className);
                HSFProvider hsfProvider = (HSFProvider)AnnotationUtils.findAnnotation(targetClass, HSFProvider.class);
                this.configIfNecessary(hsfProperties);
                HsfProviderBeanDefinitionBuilder builder = new HsfProviderBeanDefinitionBuilder(targetBeanName, hsfProvider).clazz(targetClass).properties(hsfProperties);
                BeanDefinition beanDefinition = builder.build(registry);
                if (beanDefinition != null) {
                    registry.registerBeanDefinition(beanName, beanDefinition);
                    logger.info("[HSF Starter] register HSF provider bean: {}, targetClass: {}", (Object)beanName, (Object)className);
                }
            }
            catch (ClassNotFoundException var11) {
                throw new BeanCreationException("create hsf provider bean error! beanName:" + beanName, (Throwable)var11);
            }
        }
    }

    private void configIfNecessary(HsfProperties hsfProperties) {
        if (!this.inited) {
            this.configThreadPool(hsfProperties);
            this.inited = true;
        }
    }

    private void configThreadPool(HsfProperties hsfProperties) {
        int coreSize = hsfProperties.getCorePoolSize();
        int maxSize = hsfProperties.getMaxPoolSize();
        if (coreSize > 0 && maxSize >= coreSize) {
            if (StringUtils.isEmpty((Object)System.getProperty("hsf.server.min.poolsize"))) {
                System.setProperty("hsf.server.min.poolsize", "" + coreSize);
                logger.info("[HSF Starter] config HSF thread pool: core size = {}", (Object)coreSize);
            } else {
                logger.debug("[HSF Starter] System properties contains {}, skip setting thread pool core size.hsf.server.min.poolsize");
            }
            if (StringUtils.isEmpty((Object)System.getProperty("hsf.server.max.poolsize"))) {
                System.setProperty("hsf.server.max.poolsize", "" + maxSize);
                logger.info("[HSF Starter] config HSF thread pool: max size = {}", (Object)maxSize);
            } else {
                logger.debug("[HSF Starter] System properties contains {}, skip setting thread pool max sizehsf.server.min.poolsize");
            }
        }
    }

    public void setEnvironment(Environment environment) {
        this.environment = (ConfigurableEnvironment)environment;
    }

    public void setBeanClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }
}

