/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.inc.model.taskcommon.impl;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.inc.model.bidresult.sub.IncBidResult;
import com.tydic.dyc.inc.model.bidresult.sub.IncBidResultItem;
import com.tydic.dyc.inc.model.bidresult.sub.IncBidResultItemRela;
import com.tydic.dyc.inc.model.bidresult.sub.IncBidResultNotice;
import com.tydic.dyc.inc.model.inquiryorder.sub.IncOrder;
import com.tydic.dyc.inc.model.inquiryorder.sub.IncSupplier;
import com.tydic.dyc.inc.model.taskcommon.IncTaskCommonDo;
import com.tydic.dyc.inc.model.taskcommon.IncTaskCommonModel;
import com.tydic.dyc.inc.model.taskcommon.qrybo.IncApprovalObjQryBo;
import com.tydic.dyc.inc.model.taskcommon.sub.IncApprovalObj;
import com.tydic.dyc.inc.model.taskcommon.sub.IncOrderProcInst;
import com.tydic.dyc.inc.model.taskcommon.sub.IncOrderTaskDeal;
import com.tydic.dyc.inc.model.taskcommon.sub.IncOrderTaskInst;
import com.tydic.dyc.inc.model.taskcommon.sub.IncSyncEs;
import com.tydic.dyc.inc.repository.IncBidResultRepository;
import com.tydic.dyc.inc.repository.IncOrderRepository;
import com.tydic.dyc.inc.repository.IncTaskCommonRepository;
import com.tydic.dyc.inc.service.constants.IncConstants;
import com.tydic.dyc.inc.service.domainservice.inquiryorder.bo.IncCandidatesBO;
import com.tydic.dyc.inc.service.domainservice.inquiryorder.bo.IncFinishTaskInfoBo;
import com.tydic.dyc.inc.service.domainservice.inquiryorder.bo.IncTaskInfoBO;
import com.tydic.dyc.inc.utils.IdUtil;
import com.tydic.dyc.inc.utils.IncElasticsearchUtil;
import com.tydic.dyc.inc.virgo.IncInitConfig;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class IncTaskCommonModelImpl
implements IncTaskCommonModel {
    private static final Logger log = LoggerFactory.getLogger(IncTaskCommonModelImpl.class);
    @Value(value="${INC_ORDER_APPROVAL_INDEX_NAME:inc_order_audit}")
    private String INC_ORDER_APPROVAL_INDEX_NAME;
    @Autowired
    private IncTaskCommonRepository incTaskCommonRepository;
    @Autowired
    private IncInitConfig incInitConfig;
    @Autowired
    private IncOrderRepository incOrderRepository;
    @Autowired
    private IncBidResultRepository incBidResultRepository;
    @Autowired
    private IncElasticsearchUtil incElasticsearchUtil;

    @Override
    public IncTaskCommonDo dealTask(IncTaskCommonDo incTaskCommonDo) {
        List<IncTaskInfoBO> recallTaskInfos;
        IncOrderTaskInst UocOrderTaskInst2;
        List<IncTaskInfoBO> nextTaskInfos;
        log.info("\u8ba2\u5355\u5904\u7406\u4efb\u52a1\u6570\u636e\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)incTaskCommonDo));
        ArrayList<IncFinishTaskInfoBo> finishTaskInfoBos = new ArrayList<IncFinishTaskInfoBo>();
        ArrayList<IncSyncEs> updateIncOrderIdList = new ArrayList<IncSyncEs>();
        ArrayList<IncSyncEs> auditOrderTaskMainIdList = new ArrayList<IncSyncEs>();
        ArrayList<IncSyncEs> updateAuditOrderTaskMainIdList = new ArrayList<IncSyncEs>();
        ArrayList<IncSyncEs> deleteAuditOrderTaskMainIdList = new ArrayList<IncSyncEs>();
        ArrayList<IncSyncEs> bidResultIncOrderIdList = new ArrayList<IncSyncEs>();
        if (!CollectionUtils.isEmpty(incTaskCommonDo.getCompleteTaskInfos())) {
            incTaskCommonDo.getCompleteTaskInfos().forEach(completeTaskBo -> {
                IncOrderTaskInst qryInst = new IncOrderTaskInst();
                qryInst.setOrderId(incTaskCommonDo.getOrderId());
                qryInst.setTaskInstId(completeTaskBo.getTaskId());
                List<IncOrderTaskInst> uocOrderTaskInsts = this.incTaskCommonRepository.qryTaskInstList(qryInst);
                if (ObjectUtil.isEmpty(uocOrderTaskInsts)) {
                    throw new BaseBusinessException("100100", "\u4efb\u52a1\u5b9e\u4f8bid(" + completeTaskBo.getTaskId() + ")\u4e0d\u5b58\u5728");
                }
                if (uocOrderTaskInsts.size() != 1) {
                    throw new BaseBusinessException("100100", "\u4efb\u52a1\u5b9e\u4f8bid(" + completeTaskBo.getTaskId() + ")\u5b58\u5728\u591a\u6761\u6570\u636e");
                }
                if (IncConstants.PROC_TASK_FINISHED.FINISHED.equals(uocOrderTaskInsts.get(0).getFinishTag())) {
                    throw new BaseBusinessException("100100", "\u4efb\u52a1\u5b9e\u4f8bid(" + completeTaskBo.getTaskId() + ")\u5df2\u5b8c\u7ed3");
                }
                completeTaskBo.setBusiObjType(uocOrderTaskInsts.get(0).getObjType());
                completeTaskBo.setBusiObjId(uocOrderTaskInsts.get(0).getObjId());
                ArrayList<IncOrderTaskInst> updateList = new ArrayList<IncOrderTaskInst>();
                IncOrderTaskInst uocOrderTaskInst = new IncOrderTaskInst();
                updateList.add(uocOrderTaskInst);
                uocOrderTaskInst.setOrderId(incTaskCommonDo.getOrderId());
                uocOrderTaskInst.setTaskInstId(completeTaskBo.getTaskId());
                uocOrderTaskInst.setDealResult(completeTaskBo.getDealResult());
                uocOrderTaskInst.setDealRemark(completeTaskBo.getDealRemark());
                if (ObjectUtil.isNotNull((Object)incTaskCommonDo.getUserId())) {
                    uocOrderTaskInst.setDealOperId(incTaskCommonDo.getUserId() + "");
                }
                uocOrderTaskInst.setDealOperName(incTaskCommonDo.getUsername());
                if (completeTaskBo.getBusiObjType().equals(IncConstants.OBJ_TYPE.APPROVE)) {
                    IncSyncEs updateAuditOrderTaskMainId = new IncSyncEs();
                    updateAuditOrderTaskMainId.setUpdateAuditOrderTaskMainId(completeTaskBo.getTaskId());
                    updateAuditOrderTaskMainIdList.add(updateAuditOrderTaskMainId);
                }
                this.incTaskCommonRepository.updateToFinished(updateList);
                IncFinishTaskInfoBo bo = (IncFinishTaskInfoBo)JSON.parseObject((String)JSON.toJSONString((Object)completeTaskBo), IncFinishTaskInfoBo.class);
                bo.setDealOperId(incTaskCommonDo.getUserId() + "");
                bo.setDealOperName(incTaskCommonDo.getUsername());
                bo.setCenter("INC");
                finishTaskInfoBos.add(bo);
                if (completeTaskBo.getAuditStepFinish() != null && completeTaskBo.getAuditStepFinish().booleanValue()) {
                    IncOrderTaskInst UocOrderTaskInst2 = new IncOrderTaskInst();
                    UocOrderTaskInst2.setOrderId(incTaskCommonDo.getOrderId());
                    UocOrderTaskInst2.setProcState(uocOrderTaskInsts.get(0).getProcState());
                    UocOrderTaskInst2.setFinishTag(IncConstants.PROC_TASK_FINISHED.NO_FINISHED);
                    UocOrderTaskInst2.setProcInstId(uocOrderTaskInsts.get(0).getProcInstId());
                    List<IncSyncEs> deleteAuditOrderTaskMainIds = this.deleteProcTaskInst(UocOrderTaskInst2, finishTaskInfoBos);
                    deleteAuditOrderTaskMainIdList.addAll(deleteAuditOrderTaskMainIds);
                }
                if (null != completeTaskBo.getFinish() && completeTaskBo.getFinish().booleanValue() && completeTaskBo.getBusiObjType().equals(IncConstants.OBJ_TYPE.APPROVE)) {
                    IncApprovalObjQryBo selectuocApprovalObjQryBo = new IncApprovalObjQryBo();
                    selectuocApprovalObjQryBo.setAuditOrderId(uocOrderTaskInsts.get(0).getObjId());
                    selectuocApprovalObjQryBo.setOrderId(incTaskCommonDo.getOrderId());
                    List<IncApprovalObj> uocApprovalObjs = this.incTaskCommonRepository.qryApprovealObj(selectuocApprovalObjQryBo);
                    if (CollectionUtils.isEmpty(uocApprovalObjs)) {
                        throw new BaseBusinessException("100100", "\u67e5\u8be2\u5ba1\u6279\u4efb\u52a1\u5bf9\u8c61\u8868\u4e3a\u7a7a\uff01");
                    }
                    if (IncConstants.AUDIT_OBJ_BUSI_TYPE.INC_ORDER.equals(uocApprovalObjs.get(0).getObjBusiType())) {
                        if (IncConstants.APPROVE_RESULT.REJECT.equals(completeTaskBo.getDealResult())) {
                            IncOrder incOrder = new IncOrder();
                            incOrder.setIncOrderId(incTaskCommonDo.getOrderId());
                            incOrder.setIncOrderState("INC_AUDIT_REJECT");
                            incOrder.setUpdateOperId(incTaskCommonDo.getUserId() + "");
                            incOrder.setUpdateOperName(incTaskCommonDo.getUsername());
                            incOrder.setUpdateTime(new Date());
                            this.incOrderRepository.updateIncOrder(incOrder);
                            IncSyncEs updateIncOrderId = new IncSyncEs();
                            updateIncOrderId.setUpdateIncOrderId(incTaskCommonDo.getOrderId());
                            updateIncOrderIdList.add(updateIncOrderId);
                        }
                    } else {
                        Long incBidResultId = Long.valueOf(uocApprovalObjs.get(0).getObjId());
                        if (IncConstants.APPROVE_RESULT.APPROVED.equals(completeTaskBo.getDealResult())) {
                            this.doBidResultAuditApproved(incBidResultId, incTaskCommonDo);
                            IncSyncEs bidResultIncOrderId = new IncSyncEs();
                            bidResultIncOrderId.setBidResultIncOrderId(incTaskCommonDo.getOrderId());
                            bidResultIncOrderIdList.add(bidResultIncOrderId);
                        } else {
                            this.updateBidResultState(incBidResultId, incTaskCommonDo, "3");
                        }
                    }
                }
            });
        }
        if (ObjectUtil.isNotEmpty(nextTaskInfos = incTaskCommonDo.getNextTaskInfos())) {
            ArrayList<IncOrderTaskDeal> saveDealList = new ArrayList<IncOrderTaskDeal>();
            ArrayList<IncOrderTaskInst> saveList = new ArrayList<IncOrderTaskInst>();
            for (IncTaskInfoBO nextTaskInfo : nextTaskInfos) {
                if (IncConstants.OBJ_TYPE.ORDER.equals(nextTaskInfo.getBusiObjType())) {
                    IncSyncEs updateIncOrderId = new IncSyncEs();
                    updateIncOrderId.setUpdateIncOrderId(incTaskCommonDo.getOrderId());
                    updateIncOrderIdList.add(updateIncOrderId);
                }
                IncOrderProcInst qryInst = new IncOrderProcInst();
                qryInst.setProcInstId(nextTaskInfo.getProcInstId());
                qryInst.setOrderId(incTaskCommonDo.getOrderId());
                List<IncOrderProcInst> uocOrderProcInsts = this.incTaskCommonRepository.qryProcInsList(qryInst);
                if (ObjectUtil.isEmpty(uocOrderProcInsts)) {
                    IncOrderProcInst createSaleProcIns = new IncOrderProcInst();
                    createSaleProcIns.setProcInstId(nextTaskInfo.getProcInstId());
                    createSaleProcIns.setOrderId(incTaskCommonDo.getOrderId());
                    createSaleProcIns.setProcDefId(nextTaskInfo.getProcDefId());
                    createSaleProcIns.setObjId(nextTaskInfo.getBusiObjId());
                    createSaleProcIns.setObjType(nextTaskInfo.getBusiObjType());
                    createSaleProcIns.setFinishTag(IncConstants.PROC_TASK_FINISHED.NO_FINISHED);
                    createSaleProcIns.setId(IdUtil.nextId());
                    createSaleProcIns.setCreateTime(new Date());
                    this.incTaskCommonRepository.createProInst(createSaleProcIns);
                }
                IncOrderTaskInst taskBo = new IncOrderTaskInst();
                taskBo.setId(IdUtil.nextId());
                taskBo.setOrderId(incTaskCommonDo.getOrderId());
                taskBo.setTaskInstId(nextTaskInfo.getTaskId());
                taskBo.setObjId(nextTaskInfo.getBusiObjId());
                taskBo.setObjType(nextTaskInfo.getBusiObjType());
                taskBo.setProcState(nextTaskInfo.getStepId());
                taskBo.setFinishTag(IncConstants.PROC_TASK_FINISHED.NO_FINISHED);
                taskBo.setFormUrl(nextTaskInfo.getFormUrl());
                taskBo.setProcDefId(nextTaskInfo.getProcDefId());
                taskBo.setProcInstId(nextTaskInfo.getProcInstId());
                taskBo.setTaskSignTag(nextTaskInfo.getTaskSignTag());
                if (taskBo.getTaskSignTag() == null) {
                    taskBo.setTaskSignTag(IncConstants.TASK_SING_TAG.TACHE_TASK);
                }
                if (IncConstants.OBJ_TYPE.APPROVE.equals(nextTaskInfo.getBusiObjType())) {
                    IncSyncEs auditOrderTaskMainId = new IncSyncEs();
                    auditOrderTaskMainId.setAuditOrderTaskMainId(taskBo.getId());
                    auditOrderTaskMainIdList.add(auditOrderTaskMainId);
                }
                saveList.add(taskBo);
                String assignee = nextTaskInfo.getAssignee();
                List candidates = nextTaskInfo.getCandidates();
                if (ObjectUtil.isNotEmpty((Object)assignee)) {
                    IncOrderTaskDeal deal = this.assembleTaskDealObj(incTaskCommonDo, nextTaskInfo);
                    deal.setDealId(assignee);
                    deal.setDealClass("1");
                    deal.setDelTag(IncConstants.DELETE_TAG.NO_DEL);
                    saveDealList.add(deal);
                } else if (ObjectUtil.isNotEmpty((Object)candidates)) {
                    for (IncCandidatesBO candidate : candidates) {
                        IncOrderTaskDeal deal = this.assembleTaskDealObj(incTaskCommonDo, nextTaskInfo);
                        deal.setDealId(candidate.getCandidateId());
                        deal.setDealName(candidate.getCandidateName());
                        deal.setDealClass("2");
                        deal.setDelTag(IncConstants.DELETE_TAG.NO_DEL);
                        saveDealList.add(deal);
                    }
                }
                String state = this.incInitConfig.getStateByTachecode(nextTaskInfo.getStepId(), nextTaskInfo.getBusiObjType());
                this.updateState(incTaskCommonDo, nextTaskInfo, state);
                IncOrderTaskInst taskInst = new IncOrderTaskInst();
                taskInst.setOrderId(incTaskCommonDo.getOrderId());
                taskInst.setProcInstId(nextTaskInfo.getProcInstId());
                taskInst.setFinishTag(0);
                List<IncOrderTaskInst> taskInsts = this.incTaskCommonRepository.qryTaskInstList(taskInst);
                this.incTaskCommonRepository.updateToFinished(taskInsts);
            }
            if (ObjectUtil.isNotEmpty(saveDealList)) {
                this.incTaskCommonRepository.saveOrderTaskDealList(saveDealList);
            }
            this.saveProcTaskInst(saveList);
        }
        if (StringUtils.isNotBlank((CharSequence)incTaskCommonDo.getPreTaskId())) {
            UocOrderTaskInst2 = new IncOrderTaskInst();
            UocOrderTaskInst2.setOrderId(incTaskCommonDo.getOrderId());
            UocOrderTaskInst2.setTaskInstId(incTaskCommonDo.getPreTaskId());
            UocOrderTaskInst2.setFinishTag(IncConstants.PROC_TASK_FINISHED.NO_FINISHED);
            this.deleteProcTaskInst(UocOrderTaskInst2, finishTaskInfoBos);
        }
        if (StringUtils.isNotBlank((CharSequence)incTaskCommonDo.getReturnTaskId())) {
            UocOrderTaskInst2 = new IncOrderTaskInst();
            UocOrderTaskInst2.setOrderId(incTaskCommonDo.getOrderId());
            UocOrderTaskInst2.setTaskInstId(incTaskCommonDo.getReturnTaskId());
            UocOrderTaskInst2.setFinishTag(IncConstants.PROC_TASK_FINISHED.NO_FINISHED);
            this.deleteProcTaskInst(UocOrderTaskInst2, finishTaskInfoBos);
        }
        if (incTaskCommonDo.getUpdateTaskCandidate() != null && ObjectUtil.isNotEmpty((Object)incTaskCommonDo.getUpdateTaskCandidate().getTaskId())) {
            IncOrderTaskDeal uocOrderTaskDeal = new IncOrderTaskDeal();
            IncCandidatesBO uocCandidatesBO = (IncCandidatesBO)incTaskCommonDo.getUpdateTaskCandidate().getCandidates().get(0);
            uocOrderTaskDeal.setDealId(uocCandidatesBO.getCandidateId());
            uocOrderTaskDeal.setDealName(uocCandidatesBO.getCandidateName());
            uocOrderTaskDeal.setTaskInstId(incTaskCommonDo.getUpdateTaskCandidate().getTaskId());
            uocOrderTaskDeal.setOrderId(incTaskCommonDo.getOrderId());
            this.incTaskCommonRepository.updateTaskDeal(uocOrderTaskDeal);
        }
        if (ObjectUtil.isNotEmpty(recallTaskInfos = incTaskCommonDo.getRecallTaskInfos())) {
            log.info("\u8ba2\u5355\u5904\u7406\u64a4\u56de\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString(recallTaskInfos));
            for (IncTaskInfoBO recallTaskInfo : recallTaskInfos) {
                if (!ObjectUtil.isNotEmpty((Object)recallTaskInfo.getTaskId())) continue;
                IncOrderTaskInst deleteBo = new IncOrderTaskInst();
                deleteBo.setTaskInstId(recallTaskInfo.getTaskId());
                this.incTaskCommonRepository.deleteTaskInstByTaskId(deleteBo);
            }
        }
        IncTaskCommonDo rsp = new IncTaskCommonDo();
        rsp.setUpdateIncOrderIdList(updateIncOrderIdList);
        rsp.setAuditOrderTaskMainIdList(auditOrderTaskMainIdList);
        rsp.setUpdateAuditOrderTaskMainIdList(updateAuditOrderTaskMainIdList);
        rsp.setDeleteAuditOrderTaskMainIdList(deleteAuditOrderTaskMainIdList);
        rsp.setBidResultIncOrderIdList(bidResultIncOrderIdList);
        rsp.setFinishTaskInfoBos(finishTaskInfoBos);
        return rsp;
    }

    @Override
    public IncTaskInfoBO qryProcTaskInfo(IncApprovalObjQryBo qryBo) {
        return this.incTaskCommonRepository.qryProcTaskInfo(qryBo);
    }

    @Override
    public IncOrderTaskInst qryUnfinishedTask(IncApprovalObjQryBo qryBo) {
        return this.incTaskCommonRepository.qryUnfinishedTask(qryBo);
    }

    @Override
    public List<IncApprovalObj> qryApprovalObj(IncApprovalObjQryBo obj) {
        return this.incTaskCommonRepository.qryApprovealObj(obj);
    }

    private void doBidResultAuditApproved(Long incBidResultId, IncTaskCommonDo incTaskCommonDo) {
        IncBidResultItem incBidResultItem = new IncBidResultItem();
        incBidResultItem.setIncBidResultId(incBidResultId);
        List<IncBidResultItem> result = this.incBidResultRepository.getBidResultItemList(incBidResultItem);
        if (ObjectUtil.isEmpty(result)) {
            throw new BaseBusinessException("100100", "\u67e5\u8be2\u4f9b\u5e94\u5546\u4e2d\u6807\u7ed3\u679c\u5546\u54c1\u660e\u7ec6\u4e3a\u7a7a\uff01");
        }
        List<IncBidResultItemRela> incBidResultItemRelas = result.stream().map(bo -> {
            IncBidResultItemRela incBidResultItemRela = new IncBidResultItemRela();
            BeanUtils.copyProperties((Object)bo, (Object)incBidResultItemRela);
            incBidResultItemRela.setIncBidResultItemRelaId(IdUtil.nextId());
            incBidResultItemRela.setCreateOperId(incTaskCommonDo.getUserId() + "");
            incBidResultItemRela.setCreateOperName(incTaskCommonDo.getUsername());
            incBidResultItemRela.setCreateTime(new Date());
            return incBidResultItemRela;
        }).collect(Collectors.toList());
        this.incBidResultRepository.insertBidResultItemRelaBatch(incBidResultItemRelas);
        Map<Long, List<IncBidResultItem>> resultGroupBySupplier = result.stream().collect(Collectors.groupingBy(IncBidResultItem::getSupplierId));
        ArrayList<IncBidResultNotice> incBidResultNotices = new ArrayList<IncBidResultNotice>();
        for (Long supplierId : resultGroupBySupplier.keySet()) {
            IncBidResultNotice incBidResultNotice = new IncBidResultNotice();
            BeanUtils.copyProperties((Object)resultGroupBySupplier.get(supplierId).get(0), (Object)incBidResultNotice);
            incBidResultNotice.setIncBidResultNoticeId(IdUtil.nextId());
            incBidResultNotice.setBidResultNoticeSatte("1");
            incBidResultNotice.setCreateOperId(incTaskCommonDo.getUserId() + "");
            incBidResultNotice.setCreateOperName(incTaskCommonDo.getUsername());
            incBidResultNotice.setCreateTime(new Date());
            incBidResultNotices.add(incBidResultNotice);
        }
        IncSupplier incSupplier = new IncSupplier();
        incSupplier.setIncOrderId(incTaskCommonDo.getOrderId());
        List<IncSupplier> allSupplier = this.incOrderRepository.getIncSupplierList(incSupplier);
        if (ObjectUtil.isEmpty(allSupplier)) {
            throw new BaseBusinessException("100100", "\u67e5\u8be2\u53c2\u4e0e\u4f9b\u5e94\u5546\u7ed3\u679c\u4e3a\u7a7a\uff01");
        }
        List notBidSupplierList = allSupplier.stream().filter(bo -> !resultGroupBySupplier.containsKey(bo.getSupplierId())).collect(Collectors.toList());
        if (ObjectUtil.isNotEmpty(notBidSupplierList)) {
            for (IncSupplier notBidSuplier : notBidSupplierList) {
                IncBidResultNotice incBidResultNotice = new IncBidResultNotice();
                BeanUtils.copyProperties((Object)notBidSuplier, (Object)incBidResultNotice);
                incBidResultNotice.setIncBidResultNoticeId(IdUtil.nextId());
                incBidResultNotice.setIncBidResultId(null);
                incBidResultNotice.setBidResultNoticeSatte("1");
                incBidResultNotice.setCreateOperId(incTaskCommonDo.getUserId() + "");
                incBidResultNotice.setCreateOperName(incTaskCommonDo.getUsername());
                incBidResultNotice.setCreateTime(new Date());
                incBidResultNotices.add(incBidResultNotice);
            }
        }
        this.incBidResultRepository.intsertBidResultNoticeBatch(incBidResultNotices);
        this.updateBidResultState(incBidResultId, incTaskCommonDo, "4");
    }

    private void updateBidResultState(Long incBidResultId, IncTaskCommonDo incTaskCommonDo, String state) {
        IncBidResult incBidResult = new IncBidResult();
        incBidResult.setIncBidResultId(incBidResultId);
        incBidResult.setIncOrderId(incTaskCommonDo.getOrderId());
        incBidResult.setBigResultState(state);
        incBidResult.setUpdateOperId(incTaskCommonDo.getUserId() + "");
        incBidResult.setUpdateOperName(incTaskCommonDo.getUsername());
        incBidResult.setUpdateTime(new Date());
        this.incBidResultRepository.updateBidResult(incBidResult);
    }

    private void updateState(IncTaskCommonDo incTaskCommonDo, IncTaskInfoBO taskBo, String state) {
        if (ObjectUtil.isNotNull((Object)state)) {
            IncOrder incOrder = new IncOrder();
            incOrder.setIncOrderId(incTaskCommonDo.getOrderId());
            incOrder.setUpdateOperId(incTaskCommonDo.getUserId() + "");
            incOrder.setUpdateOperName(incTaskCommonDo.getUsername());
            incOrder.setUpdateTime(new Date());
            incOrder.setIncOrderState(state);
            this.incOrderRepository.updateIncOrder(incOrder);
        }
    }

    private List<IncSyncEs> deleteProcTaskInst(IncOrderTaskInst UocOrderTaskInst2, List<IncFinishTaskInfoBo> finishTaskInfoBos) {
        ArrayList<IncSyncEs> deleteAuditOrderTaskMainIdList = new ArrayList<IncSyncEs>();
        List<IncOrderTaskInst> taskInsts = this.incTaskCommonRepository.qryTaskInstList(UocOrderTaskInst2);
        if (!CollectionUtils.isEmpty(taskInsts)) {
            this.incTaskCommonRepository.saveProcTaskInstLog(taskInsts);
            ArrayList<Long> ids = new ArrayList<Long>();
            taskInsts.forEach(uocOrderTaskInst -> ids.add(uocOrderTaskInst.getId()));
            IncOrderTaskInst uocOrderTaskInst2 = new IncOrderTaskInst();
            uocOrderTaskInst2.setOrderId(UocOrderTaskInst2.getOrderId());
            uocOrderTaskInst2.setIds(ids);
            this.incTaskCommonRepository.deleteProcTaskInstByIds(uocOrderTaskInst2);
            taskInsts.forEach(uocOrderTaskInst1 -> {
                IncFinishTaskInfoBo bo = new IncFinishTaskInfoBo();
                bo.setProcInstId(uocOrderTaskInst1.getProcInstId());
                bo.setTaskId(uocOrderTaskInst1.getTaskInstId());
                bo.setBusiObjId(uocOrderTaskInst1.getObjId());
                bo.setBusiObjType(uocOrderTaskInst1.getObjType());
                bo.setDealResult(uocOrderTaskInst1.getDealResult());
                bo.setDealRemark(uocOrderTaskInst1.getDealRemark());
                bo.setDealOperId(uocOrderTaskInst1.getDealOperId());
                bo.setDealOperName(uocOrderTaskInst1.getDealOperName());
                bo.setCenter("INC");
                finishTaskInfoBos.add(bo);
                if (uocOrderTaskInst1.getObjType().equals(IncConstants.OBJ_TYPE.APPROVE)) {
                    IncSyncEs deleteAuditOrderTaskMainId = new IncSyncEs();
                    deleteAuditOrderTaskMainId.setDeleteAuditOrderTaskMainId(uocOrderTaskInst1.getTaskInstId());
                    deleteAuditOrderTaskMainIdList.add(deleteAuditOrderTaskMainId);
                }
            });
        }
        return deleteAuditOrderTaskMainIdList;
    }

    private IncOrderTaskDeal assembleTaskDealObj(IncTaskCommonDo uocCommonDo, IncTaskInfoBO nextTaskInfo) {
        IncOrderTaskDeal deal = new IncOrderTaskDeal();
        deal.setId(IdUtil.nextId());
        deal.setTaskInstId(nextTaskInfo.getTaskId());
        deal.setOrderId(uocCommonDo.getOrderId());
        deal.setObjId(nextTaskInfo.getBusiObjId());
        deal.setObjType(nextTaskInfo.getBusiObjType());
        return deal;
    }

    private void saveProcTaskInst(List<IncOrderTaskInst> saveTaskList) {
        Date createTime = new Date();
        if (ObjectUtil.isNotEmpty(saveTaskList)) {
            for (IncOrderTaskInst uocOrderTaskInst : saveTaskList) {
                uocOrderTaskInst.setCreateTime(createTime);
            }
            this.incTaskCommonRepository.saveProcTaskInst(saveTaskList);
        }
    }

    private void syncEsTaskState(String taskId) {
        StringBuilder queryBuilder = new StringBuilder();
        queryBuilder.append("{");
        queryBuilder.append("  \"script\": {");
        queryBuilder.append("    \"source\": \"ctx._source.finishTag = params.finishTag\",");
        queryBuilder.append("    \"params\": {");
        queryBuilder.append("      \"finishTag\": 2");
        queryBuilder.append("    }");
        queryBuilder.append("  },");
        queryBuilder.append("  \"query\": {");
        queryBuilder.append("    \"term\": {");
        queryBuilder.append("      \"taskInstId\": {");
        queryBuilder.append("        \"value\": ").append(taskId);
        queryBuilder.append("      }");
        queryBuilder.append("    }");
        queryBuilder.append("  }");
        queryBuilder.append("}");
        String query = queryBuilder.toString();
        this.incElasticsearchUtil.updateByQuery(this.INC_ORDER_APPROVAL_INDEX_NAME, "_doc", query);
    }
}

