/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.inc.service.bargain;

import cn.hutool.core.collection.CollectionUtil;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.dyc.inc.constants.IncBargainConstants;
import com.tydic.dyc.inc.model.bargain.IncBargainModel;
import com.tydic.dyc.inc.model.bargain.qrybo.IncBargainItemQryBO;
import com.tydic.dyc.inc.model.bargain.qrybo.IncBargainQryBO;
import com.tydic.dyc.inc.model.bargain.qrybo.IncBargainQuatationItemQryBO;
import com.tydic.dyc.inc.model.bargain.qrybo.IncBargainQuatationQryBO;
import com.tydic.dyc.inc.model.bargain.sub.IncBargain;
import com.tydic.dyc.inc.model.bargain.sub.IncBargainItem;
import com.tydic.dyc.inc.model.bargain.sub.IncBargainQuatation;
import com.tydic.dyc.inc.model.bargain.sub.IncBargainQuatationItem;
import com.tydic.dyc.inc.model.common.IncCommonModel;
import com.tydic.dyc.inc.model.common.sub.UocOrderTaskInst;
import com.tydic.dyc.inc.service.domainservice.bargain.IncBargainOverService;
import com.tydic.dyc.inc.service.domainservice.bargain.bo.IncBargainOverReqBO;
import com.tydic.dyc.inc.service.domainservice.bargain.bo.IncBargainOverRspBO;
import com.tydic.dyc.inc.utils.JsonRuUtil;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"INC_GROUP_DEV/2.0.0/com.tydic.dyc.inc.service.domainservice.bargain.IncBargainOverService"})
public class IncBargainOverServiceImpl
implements IncBargainOverService {
    @Autowired
    private IncBargainModel incBargainModel;
    @Autowired
    private IncCommonModel incCommonModel;

    @PostMapping(value={"bargainOver"})
    public IncBargainOverRspBO bargainOver(@RequestBody IncBargainOverReqBO reqBO) {
        this.validateParam(reqBO);
        IncBargain bargain = this.getBargain(reqBO);
        if (bargain == null) {
            throw new ZTBusinessException("\u672a\u83b7\u53d6\u5230\u8bae\u4ef7\u5355\u4fe1\u606f");
        }
        IncBargainQuatation quatation = this.getQuatation(bargain);
        if (quatation == null) {
            throw new ZTBusinessException("\u5f53\u524d\u8f6e\u6b21\u62a5\u4ef7\u5355\u72b6\u6001\u4e0d\u4e3a\u5df2\u62a5\u4ef7\u4e0d\u80fd\u5b8c\u6210\u8bae\u4ef7");
        }
        List<IncBargainQuatationItem> quatationItemList = this.getQuatationItemList(quatation);
        if (CollectionUtil.isEmpty(quatationItemList)) {
            throw new ZTBusinessException("\u62a5\u4ef7\u5355\u672a\u627e\u5230\u62a5\u4ef7\u660e\u7ec6");
        }
        this.updateQuatation(quatation);
        this.updateBargainItem(quatationItemList);
        this.updateBargain(reqBO);
        this.dealTask(reqBO);
        return JsonRuUtil.success(IncBargainOverRspBO.class);
    }

    private void dealTask(IncBargainOverReqBO reqBO) {
        UocOrderTaskInst taskInst = new UocOrderTaskInst();
        taskInst.setTaskInstId(reqBO.getTaskId());
        this.incCommonModel.dealTaskInst(taskInst);
    }

    private void updateBargain(IncBargainOverReqBO reqBO) {
        IncBargain set = new IncBargain();
        set.setBargainStatus("YJ_YJ_YJWC");
        IncBargainQryBO where = new IncBargainQryBO();
        where.setBargainId(reqBO.getBargainId());
        this.incBargainModel.updateBargain(set, where);
    }

    private void updateQuatation(IncBargainQuatation quatation) {
        IncBargainQuatation set = new IncBargainQuatation();
        set.setStatus(IncBargainConstants.QuatationStatus.QUOTATION_OVER);
        IncBargainQuatationQryBO where = new IncBargainQuatationQryBO();
        where.setQuatationId(quatation.getQuatationId());
        this.incBargainModel.updateQuatation(set, where);
    }

    private IncBargain getBargain(IncBargainOverReqBO reqBO) {
        IncBargain incBargain = new IncBargain();
        incBargain.setBargainId(reqBO.getBargainId());
        return this.incBargainModel.getBargainMain(incBargain);
    }

    private IncBargainQuatation getQuatation(IncBargain bargain) {
        IncBargainQuatationQryBO incBargainQuatationQryBO = new IncBargainQuatationQryBO();
        incBargainQuatationQryBO.setBargainId(bargain.getBargainId());
        incBargainQuatationQryBO.setVersion(bargain.getVersion());
        incBargainQuatationQryBO.setStatus(IncBargainConstants.QuatationStatus.HAVE_QUOTED_PRICE);
        return this.incBargainModel.getQuatation(incBargainQuatationQryBO);
    }

    private List<IncBargainQuatationItem> getQuatationItemList(IncBargainQuatation quatation) {
        IncBargainQuatationItemQryBO incBargainQuatationItemQryBO = new IncBargainQuatationItemQryBO();
        incBargainQuatationItemQryBO.setQuatationId(quatation.getQuatationId());
        return this.incBargainModel.getQuatationItemList(incBargainQuatationItemQryBO);
    }

    private void updateBargainItem(List<IncBargainQuatationItem> quatationItemList) {
        for (IncBargainQuatationItem item : quatationItemList) {
            IncBargainItem set = new IncBargainItem();
            set.setTransactionPrice(item.getExclusivePrice());
            IncBargainItemQryBO where = new IncBargainItemQryBO();
            where.setBargainItemId(item.getBargainItemId());
            this.incBargainModel.updateBargainItem(set, where);
        }
    }

    private void validateParam(IncBargainOverReqBO reqBO) {
        if (reqBO == null) {
            throw new ZTBusinessException("\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((String)reqBO.getTaskId())) {
            throw new ZTBusinessException("\u4efb\u52a1\u5b9e\u4f8bid\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBO.getBargainId() == null) {
            throw new ZTBusinessException("\u8bae\u4ef7\u5355id\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

