/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.inc.service.bargain;

import cn.hutool.core.collection.CollectionUtil;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.db.Page;
import com.tydic.dyc.inc.model.bargain.IncBargainModel;
import com.tydic.dyc.inc.model.bargain.qrybo.IncBargainItemQryBO;
import com.tydic.dyc.inc.model.bargain.qrybo.IncBargainQuatationItemQryBO;
import com.tydic.dyc.inc.model.bargain.sub.IncBargainItem;
import com.tydic.dyc.inc.model.bargain.sub.IncBargainQuatationItem;
import com.tydic.dyc.inc.service.domainservice.bargain.IncQryBargainItemListService;
import com.tydic.dyc.inc.service.domainservice.bargain.bo.IncBargainItemBO;
import com.tydic.dyc.inc.service.domainservice.bargain.bo.IncQryBargainItemListReqBO;
import com.tydic.dyc.inc.service.domainservice.bargain.bo.IncQryBargainItemListRspBO;
import com.tydic.dyc.inc.utils.JsonRuUtil;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"INC_GROUP_DEV/2.0.0/com.tydic.dyc.inc.service.domainservice.bargain.IncQryBargainItemListService"})
public class IncQryBargainItemListServiceImpl
implements IncQryBargainItemListService {
    @Autowired
    private IncBargainModel incBargainModel;

    @PostMapping(value={"qryBargainItemList"})
    public IncQryBargainItemListRspBO qryBargainItemList(@RequestBody IncQryBargainItemListReqBO reqBO) {
        this.validateParam(reqBO);
        Map<Long, IncBargainQuatationItem> quatationItemMap = this.getQuatationItem(reqBO);
        IncQryBargainItemListRspBO rspBO = JsonRuUtil.success(IncQryBargainItemListRspBO.class);
        IncBargainItemQryBO incBargainItemQryBO = new IncBargainItemQryBO();
        incBargainItemQryBO.setBargainId(reqBO.getBargainId());
        if (reqBO.getPageNo() == -1) {
            List<IncBargainItem> bargainItemList = this.incBargainModel.getBargainItemList(incBargainItemQryBO);
            List<IncBargainItemBO> bargainItemBOList = this.getBargainItemBO(quatationItemMap, bargainItemList);
            rspBO.setPageNo(1);
            rspBO.setTotal(1);
            rspBO.setRecordsTotal(bargainItemBOList.size());
            rspBO.setRows(bargainItemBOList);
        } else {
            Page incBargainItemPage = new Page();
            incBargainItemPage.setPageNo(reqBO.getPageNo());
            incBargainItemPage.setPageSize(reqBO.getPageSize());
            this.incBargainModel.getBargainItemPage(incBargainItemQryBO, (Page<IncBargainItem>)incBargainItemPage);
            List<IncBargainItemBO> bargainItemBOList = this.getBargainItemBO(quatationItemMap, incBargainItemPage.getResult());
            rspBO.setPageNo(1);
            rspBO.setTotal(incBargainItemPage.getTotalPages());
            rspBO.setRecordsTotal(incBargainItemPage.getTotalCount());
            rspBO.setRows(bargainItemBOList);
        }
        return rspBO;
    }

    private List<IncBargainItemBO> getBargainItemBO(Map<Long, IncBargainQuatationItem> quatationItemMap, List<IncBargainItem> bargainItemList) {
        List<IncBargainItemBO> bargainItemBOList = JsonRuUtil.jsl(bargainItemList, IncBargainItemBO.class);
        for (IncBargainItemBO bargainItem : bargainItemBOList) {
            IncBargainQuatationItem quatationItem = quatationItemMap.get(bargainItem.getBargainItemId());
            bargainItem.setExpectPrice(quatationItem.getExpectPrice());
            bargainItem.setTotalExpectPrice(bargainItem.getExpectPrice().multiply(bargainItem.getPurchaseCount()));
            if (quatationItem.getExclusivePrice() != null) {
                bargainItem.setExclusivePrice(quatationItem.getExclusivePrice());
                bargainItem.setTotalExclusivePrice(bargainItem.getPurchaseCount().multiply(bargainItem.getExclusivePrice()));
            }
            bargainItem.setTotalSalePrice(bargainItem.getPurchaseCount().multiply(bargainItem.getSalePrice()));
            bargainItem.setTotalPurchasePrice(bargainItem.getPurchaseCount().multiply(bargainItem.getPurchasePrice()));
        }
        return bargainItemBOList;
    }

    private Map<Long, IncBargainQuatationItem> getQuatationItem(IncQryBargainItemListReqBO reqBO) {
        IncBargainQuatationItemQryBO incBargainQuatationItemQryBO = new IncBargainQuatationItemQryBO();
        incBargainQuatationItemQryBO.setBargainId(reqBO.getBargainId());
        incBargainQuatationItemQryBO.setVersion(reqBO.getVersion());
        List<IncBargainQuatationItem> quatationItemList = this.incBargainModel.getQuatationItemList(incBargainQuatationItemQryBO);
        if (CollectionUtil.isEmpty(quatationItemList)) {
            throw new ZTBusinessException("\u8bae\u4ef7\u5355\u672a\u67e5\u8be2\u5230\u62a5\u4ef7\u660e\u7ec6");
        }
        return quatationItemList.stream().collect(Collectors.toMap(IncBargainQuatationItem::getBargainItemId, o -> o));
    }

    private void validateParam(IncQryBargainItemListReqBO reqBO) {
        if (reqBO == null) {
            throw new ZTBusinessException("\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBO.getBargainId() == null) {
            throw new ZTBusinessException("\u8bae\u4ef7\u5355id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBO.getVersion() == null) {
            throw new ZTBusinessException("\u8bae\u4ef7\u5355\u7248\u672c\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

