/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.inc.service.bargain;

import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.dyc.inc.constants.IncBargainConstants;
import com.tydic.dyc.inc.model.bargain.IncBargainModel;
import com.tydic.dyc.inc.model.bargain.qrybo.IncBargainQryBO;
import com.tydic.dyc.inc.model.bargain.qrybo.IncBargainQuatationQryBO;
import com.tydic.dyc.inc.model.bargain.sub.IncBargain;
import com.tydic.dyc.inc.model.bargain.sub.IncBargainQuatation;
import com.tydic.dyc.inc.model.common.IncCommonModel;
import com.tydic.dyc.inc.model.common.sub.UocOrderTaskInst;
import com.tydic.dyc.inc.service.domainservice.bargain.IncStopBargainService;
import com.tydic.dyc.inc.service.domainservice.bargain.bo.IncStopBargainReqBO;
import com.tydic.dyc.inc.service.domainservice.bargain.bo.IncStopBargainRspBO;
import com.tydic.dyc.inc.utils.JsonRuUtil;
import java.util.Date;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"INC_GROUP_DEV/2.0.0/com.tydic.dyc.inc.service.domainservice.bargain.IncStopBargainService"})
public class IncStopBargainServiceImpl
implements IncStopBargainService {
    @Autowired
    private IncBargainModel incBargainModel;
    @Autowired
    private IncCommonModel incCommonModel;

    @PostMapping(value={"stopBargain"})
    public IncStopBargainRspBO stopBargain(@RequestBody IncStopBargainReqBO reqBO) {
        this.validateParam(reqBO);
        IncBargain bargain = this.getBargain(reqBO);
        if (bargain == null) {
            throw new ZTBusinessException("\u672a\u83b7\u53d6\u5230\u8bae\u4ef7\u5355\u4fe1\u606f");
        }
        this.stopBargain(reqBO, bargain);
        this.dealTask(reqBO);
        return JsonRuUtil.success(IncStopBargainRspBO.class);
    }

    private void dealTask(IncStopBargainReqBO reqBO) {
        UocOrderTaskInst taskInst = new UocOrderTaskInst();
        taskInst.setTaskInstId(reqBO.getTaskId());
        this.incCommonModel.dealTaskInst(taskInst);
    }

    private void stopBargain(IncStopBargainReqBO reqBO, IncBargain bargain) {
        Date time = new Date();
        this.updateBargain(reqBO, time);
        this.updateQuatation(bargain, reqBO, time);
    }

    private void updateBargain(IncStopBargainReqBO reqBO, Date time) {
        IncBargain set = new IncBargain();
        set.setStopOperId(reqBO.getStopOperId());
        set.setStopOperName(reqBO.getStopOperName());
        set.setStopTime(time);
        set.setBargainStatus("YJ_YJ_ZZYJ");
        set.setStopReason(reqBO.getStopReason());
        IncBargainQryBO where = new IncBargainQryBO();
        where.setBargainId(reqBO.getBargainId());
        this.incBargainModel.updateBargain(set, where);
    }

    private void updateQuatation(IncBargain bargain, IncStopBargainReqBO reqBO, Date time) {
        IncBargainQuatation set = new IncBargainQuatation();
        set.setStatus(IncBargainConstants.QuatationStatus.STOP);
        set.setStopOperId(reqBO.getStopOperId());
        set.setStopOperName(reqBO.getStopOperName());
        set.setStopTime(time);
        IncBargainQuatationQryBO where = new IncBargainQuatationQryBO();
        where.setBargainId(bargain.getBargainId());
        where.setVersion(bargain.getVersion());
        this.incBargainModel.updateQuatation(set, where);
    }

    private IncBargain getBargain(IncStopBargainReqBO reqBO) {
        IncBargain incBargain = new IncBargain();
        incBargain.setBargainId(reqBO.getBargainId());
        return this.incBargainModel.getBargainMain(incBargain);
    }

    private void validateParam(IncStopBargainReqBO reqBO) {
        if (reqBO == null) {
            throw new ZTBusinessException("\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((String)reqBO.getTaskId())) {
            throw new ZTBusinessException("\u4efb\u52a1\u5b9e\u4f8bid\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBO.getBargainId() == null) {
            throw new ZTBusinessException("\u8bae\u4ef7\u5355id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((String)reqBO.getStopOperName())) {
            throw new ZTBusinessException("\u7ec8\u6b62\u4eba\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBO.getStopOperId() == null) {
            throw new ZTBusinessException("\u7ec8\u6b62\u4ebaid\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

