/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.inc.service.bidresult;

import cn.hutool.core.util.ObjectUtil;
import com.tydic.dyc.inc.model.bidresult.IncBidResultModel;
import com.tydic.dyc.inc.model.bidresult.sub.IncBidResult;
import com.tydic.dyc.inc.model.bidresult.sub.IncBidResultItem;
import com.tydic.dyc.inc.model.inquiryorder.IncOrderModel;
import com.tydic.dyc.inc.model.inquiryorder.sub.IncOrderAccessory;
import com.tydic.dyc.inc.service.constants.IncConstants;
import com.tydic.dyc.inc.service.domainservice.bidresult.IncSubmitBidResultService;
import com.tydic.dyc.inc.service.domainservice.bidresult.bo.IncBidResultItemBO;
import com.tydic.dyc.inc.service.domainservice.bidresult.bo.IncSubmitBidResultReqBO;
import com.tydic.dyc.inc.service.domainservice.bidresult.bo.IncSubmitBidResultRspBO;
import com.tydic.dyc.inc.service.domainservice.inquiryorder.bo.IncOrderAccessoryBO;
import com.tydic.dyc.inc.utils.IdUtil;
import com.tydic.dyc.inc.utils.IncRu;
import java.util.ArrayList;
import java.util.Date;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"INC_GROUP_DEV/2.0.0/com.tydic.dyc.inc.service.domainservice.bidresult.IncSubmitBidResultService"})
public class IncSubmitBidResultServiceImpl
implements IncSubmitBidResultService {
    @Autowired
    private IncBidResultModel incBidResultModel;
    @Autowired
    private IncOrderModel incOrderModel;

    @PostMapping(value={"submitBidResult"})
    public IncSubmitBidResultRspBO submitBidResult(@RequestBody IncSubmitBidResultReqBO reqBO) {
        IncSubmitBidResultRspBO rsp = IncRu.success(IncSubmitBidResultRspBO.class);
        Long incBidResultId = this.saveBidResult(reqBO);
        this.saveBidResultItem(reqBO, incBidResultId);
        if (ObjectUtil.isNotEmpty((Object)reqBO.getIncBidResultAccessoryBOList())) {
            this.insertAccessorys(reqBO, incBidResultId);
        }
        rsp.setIncBidResultId(incBidResultId);
        return rsp;
    }

    private void insertAccessorys(IncSubmitBidResultReqBO reqBO, Long incBidResultId) {
        ArrayList<IncOrderAccessory> incOrderAccessories = new ArrayList<IncOrderAccessory>();
        for (IncOrderAccessoryBO bo : reqBO.getIncBidResultAccessoryBOList()) {
            IncOrderAccessory incOrderAccessory = new IncOrderAccessory();
            BeanUtils.copyProperties((Object)bo, (Object)incOrderAccessory);
            incOrderAccessory.setId(IdUtil.nextId());
            incOrderAccessory.setObjId(incBidResultId);
            incOrderAccessory.setObjType(IncConstants.AccessoryObjType.RESULT);
            incOrderAccessory.setOrderId(reqBO.getIncOrderId());
            incOrderAccessory.setAttachmentType(IncConstants.AccessoryAttachmentType.RESULT);
            incOrderAccessory.setCreateOperId(reqBO.getUserId().toString());
            incOrderAccessory.setCreateTime(new Date());
            incOrderAccessories.add(incOrderAccessory);
        }
        this.incOrderModel.addOrderAccessoryBatch(incOrderAccessories);
    }

    private void saveBidResultItem(IncSubmitBidResultReqBO reqBO, Long incBidResultId) {
        IncBidResultItem deleteIncBidResultItem = new IncBidResultItem();
        deleteIncBidResultItem.setIncBidResultId(incBidResultId);
        this.incBidResultModel.deleteBidResultItem(deleteIncBidResultItem);
        ArrayList<IncBidResultItem> list = new ArrayList<IncBidResultItem>();
        for (IncBidResultItemBO bo : reqBO.getIncBidResultItemBOList()) {
            IncBidResultItem incBidResultItem = new IncBidResultItem();
            BeanUtils.copyProperties((Object)bo, (Object)incBidResultItem);
            incBidResultItem.setIncBidResultItemId(IdUtil.nextId());
            incBidResultItem.setIncBidResultId(incBidResultId);
            incBidResultItem.setCreateOperId(reqBO.getUserId() + "");
            incBidResultItem.setCreateOperName(reqBO.getName());
            incBidResultItem.setCreateTime(new Date());
            list.add(incBidResultItem);
        }
        this.incBidResultModel.insertBidResultItemBatch(list);
    }

    private Long saveBidResult(IncSubmitBidResultReqBO reqBO) {
        Long incBidResultId;
        if (ObjectUtil.isNotEmpty((Object)reqBO.getIncBidResultId())) {
            incBidResultId = reqBO.getIncBidResultId();
            IncBidResult incBidResult = new IncBidResult();
            incBidResult.setIncBidResultId(incBidResultId);
            incBidResult.setIncOrderId(reqBO.getIncOrderId());
            if (IncConstants.OperType.SAVE.equals(reqBO.getOperType())) {
                incBidResult.setBigResultState("1");
            } else {
                incBidResult.setBigResultState("2");
            }
            incBidResult.setRemark(reqBO.getRemark());
            incBidResult.setUpdateOperId(reqBO.getUserId() + "");
            incBidResult.setUpdateOperName(reqBO.getName());
            incBidResult.setUpdateTime(new Date());
            this.incBidResultModel.updateBidResult(incBidResult);
        } else {
            incBidResultId = IdUtil.nextId();
            IncBidResult incBidResult = new IncBidResult();
            incBidResult.setIncBidResultId(incBidResultId);
            incBidResult.setIncOrderId(reqBO.getIncOrderId());
            if (IncConstants.OperType.SAVE.equals(reqBO.getOperType())) {
                incBidResult.setBigResultState("1");
            } else {
                incBidResult.setBigResultState("2");
            }
            incBidResult.setRemark(reqBO.getRemark());
            incBidResult.setCreateOperId(reqBO.getUserId() + "");
            incBidResult.setCreateOperName(reqBO.getName());
            incBidResult.setCreateTime(new Date());
            this.incBidResultModel.insertBidResult(incBidResult);
        }
        return incBidResultId;
    }
}

