/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.inc.service.common;

import cn.hutool.core.util.ObjectUtil;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.inc.model.common.IncCommonModel;
import com.tydic.dyc.inc.model.common.sub.IncImportTemporary;
import com.tydic.dyc.inc.service.constants.IncConstants;
import com.tydic.dyc.inc.service.domainservice.common.IncBatchAddImportTemporaryService;
import com.tydic.dyc.inc.service.domainservice.common.bo.IncBatchAddImportTemporaryReqBO;
import com.tydic.dyc.inc.service.domainservice.common.bo.IncBatchAddImportTemporaryRspBO;
import com.tydic.dyc.inc.utils.IdUtil;
import com.tydic.dyc.inc.utils.IncRu;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"INC_GROUP_DEV/2.0.0/com.tydic.dyc.inc.service.domainservice.common.IncBatchAddImportTemporaryService"})
public class IncBatchAddImportTemporaryServiceImpl
implements IncBatchAddImportTemporaryService {
    @Autowired
    private IncCommonModel incCommonModel;

    @PostMapping(value={"batchAddImportTemporary"})
    public IncBatchAddImportTemporaryRspBO batchAddImportTemporary(@RequestBody IncBatchAddImportTemporaryReqBO reqBO) {
        if (ObjectUtil.isNotEmpty((Object)reqBO)) {
            throw new BaseBusinessException("100001", "\u6279\u91cf\u65b0\u589e\u5bfc\u5165\u4fe1\u606f\u5165\u53c2\u4e3a\u7a7a");
        }
        if (ObjectUtil.isNotEmpty((Object)reqBO.getList())) {
            throw new BaseBusinessException("100001", "\u6279\u91cf\u65b0\u589e\u5bfc\u5165\u4fe1\u606f\u5165\u53c2\u65b0\u589e\u96c6\u5408\u4e3a\u7a7a");
        }
        IncBatchAddImportTemporaryRspBO rspBO = IncRu.success(IncBatchAddImportTemporaryRspBO.class);
        List<IncImportTemporary> batchAddList = reqBO.getList().stream().map(item -> {
            IncImportTemporary add = IncRu.js(item, IncImportTemporary.class);
            add.setImportTemporaryId(IdUtil.nextId());
            add.setCreateOperId(reqBO.getUserId() + "");
            add.setCreateOperName(reqBO.getName());
            add.setCreateTime(new Date());
            add.setDelTag(IncConstants.DelTag.NO);
            return add;
        }).collect(Collectors.toList());
        this.incCommonModel.addIncImportTemporaryBatch(batchAddList);
        return rspBO;
    }
}

