/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.inc.service.inquiryorder;

import cn.hutool.core.util.ObjectUtil;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.inc.model.inquiryorder.IncOrderModel;
import com.tydic.dyc.inc.model.inquiryorder.sub.IncOrder;
import com.tydic.dyc.inc.model.inquiryorder.sub.IncOrderAccessory;
import com.tydic.dyc.inc.model.inquiryorder.sub.IncPerformanceInfo;
import com.tydic.dyc.inc.model.inquiryorder.sub.IncResultScope;
import com.tydic.dyc.inc.model.inquiryorder.sub.IncSupplier;
import com.tydic.dyc.inc.model.inquiryorder.sub.InsSkuItem;
import com.tydic.dyc.inc.service.constants.IncConstants;
import com.tydic.dyc.inc.service.domainservice.inquiryorder.IncChangeIncOrderService;
import com.tydic.dyc.inc.service.domainservice.inquiryorder.bo.IncChangeIncOrderReqBO;
import com.tydic.dyc.inc.service.domainservice.inquiryorder.bo.IncChangeIncOrderRspBO;
import com.tydic.dyc.inc.service.domainservice.inquiryorder.bo.IncOrderAccessoryBO;
import com.tydic.dyc.inc.service.domainservice.inquiryorder.bo.IncResultScopeBO;
import com.tydic.dyc.inc.service.domainservice.inquiryorder.bo.IncSkuItemBO;
import com.tydic.dyc.inc.service.domainservice.inquiryorder.bo.IncSupplierBO;
import com.tydic.dyc.inc.utils.IdUtil;
import com.tydic.dyc.inc.utils.IncRu;
import java.util.ArrayList;
import java.util.Date;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"INC_GROUP_DEV/2.0.0/com.tydic.dyc.inc.service.domainservice.inquiryorder.IncChangeIncOrderService"})
public class IncChangeIncOrderServiceImpl
implements IncChangeIncOrderService {
    @Autowired
    private IncOrderModel incOrderModel;

    @PostMapping(value={"changeIncOrder"})
    public IncChangeIncOrderRspBO changeIncOrder(@RequestBody IncChangeIncOrderReqBO reqBO) {
        IncChangeIncOrderRspBO rsp = IncRu.success(IncChangeIncOrderRspBO.class);
        IncOrder incOrder = new IncOrder();
        incOrder.setIncOrderId(reqBO.getIncOrderId());
        IncOrder result = this.incOrderModel.getIncOrder(incOrder);
        if (ObjectUtil.isEmpty((Object)result)) {
            throw new BaseBusinessException("100100", "\u8be2\u4ef7\u5355\u67e5\u8be2\u7ed3\u679c\u4e3a\u7a7a\uff01");
        }
        if (IncConstants.IncType.INQUIRY.equals(result.getIncType()) ? !"INC_TO_NOTIC".equals(reqBO.getIncOrderState()) : !"INC_TO_NOTIC".equals(reqBO.getIncOrderState())) {
            throw new BaseBusinessException("100100", "\u5f53\u524d\u8be2\u4ef7\u5355\u72b6\u6001\u4e0d\u5141\u8bb8\u53d8\u66f4\uff01");
        }
        Long newIncOrderId = IdUtil.nextId();
        this.changeInOrder(reqBO, newIncOrderId, result);
        this.changeSkuItems(reqBO, newIncOrderId);
        if (IncConstants.PurchaseModel.INVITE.equals(reqBO.getPurchaseModel())) {
            this.changeSupplier(reqBO, newIncOrderId);
        }
        this.changePerformanceInfo(reqBO, newIncOrderId);
        this.changeResultScopes(reqBO, newIncOrderId);
        if (ObjectUtil.isNotEmpty((Object)reqBO.getIncOrderAccessoryBOList())) {
            this.changeAccessorys(reqBO, newIncOrderId);
        }
        rsp.setUpdateIncOrderId(reqBO.getIncOrderId());
        rsp.setIncOrderId(newIncOrderId);
        return rsp;
    }

    private void changeAccessorys(IncChangeIncOrderReqBO reqBO, Long newIncOrderId) {
        ArrayList<IncOrderAccessory> incOrderAccessories = new ArrayList<IncOrderAccessory>();
        for (IncOrderAccessoryBO bo : reqBO.getIncOrderAccessoryBOList()) {
            IncOrderAccessory incOrderAccessory = new IncOrderAccessory();
            BeanUtils.copyProperties((Object)bo, (Object)incOrderAccessory);
            incOrderAccessory.setId(IdUtil.nextId());
            incOrderAccessory.setObjId(newIncOrderId);
            incOrderAccessory.setObjType(IncConstants.AccessoryObjType.INC);
            incOrderAccessory.setOrderId(newIncOrderId);
            incOrderAccessory.setAttachmentType(IncConstants.AccessoryAttachmentType.INC);
            incOrderAccessory.setCreateOperId(reqBO.getUserId().toString());
            incOrderAccessory.setCreateTime(new Date());
            incOrderAccessories.add(incOrderAccessory);
        }
        this.incOrderModel.addOrderAccessoryBatch(incOrderAccessories);
    }

    private void changeResultScopes(IncChangeIncOrderReqBO reqBO, Long newIncOrderId) {
        ArrayList<IncResultScope> incResultScopes = new ArrayList<IncResultScope>();
        for (IncResultScopeBO bo : reqBO.getIncResultScopeBOList()) {
            IncResultScope incResultScope = new IncResultScope();
            BeanUtils.copyProperties((Object)bo, (Object)incResultScope);
            incResultScope.setIncResultScopeId(IdUtil.nextId());
            incResultScope.setOrderId(newIncOrderId);
            incResultScope.setScopeType(IncConstants.TemplateScopeType.INC);
            incResultScope.setCreateOperId(reqBO.getUserId().toString());
            incResultScope.setCreateOperName(reqBO.getName());
            incResultScope.setCreateTime(new Date());
            incResultScopes.add(incResultScope);
        }
        this.incOrderModel.addIncResultScopeBatch(incResultScopes);
    }

    private void changePerformanceInfo(IncChangeIncOrderReqBO reqBO, Long newIncOrderId) {
        IncPerformanceInfo incPerformanceInfo = new IncPerformanceInfo();
        BeanUtils.copyProperties((Object)reqBO.getIncPerformanceInfoBO(), (Object)incPerformanceInfo);
        incPerformanceInfo.setIncPerformanceInfoId(IdUtil.nextId());
        incPerformanceInfo.setIncOrderId(newIncOrderId);
        incPerformanceInfo.setCreateOperId(reqBO.getUserId().toString());
        incPerformanceInfo.setCreateOperName(reqBO.getName());
        incPerformanceInfo.setCreateTime(new Date());
        this.incOrderModel.addIncPerformanceInfo(incPerformanceInfo);
    }

    private void changeSupplier(IncChangeIncOrderReqBO reqBO, Long newIncOrderId) {
        ArrayList<IncSupplier> incSuppliers = new ArrayList<IncSupplier>();
        for (IncSupplierBO bo : reqBO.getIncSupplierBOList()) {
            IncSupplier incSupplier = new IncSupplier();
            BeanUtils.copyProperties((Object)bo, (Object)incSupplier);
            incSupplier.setIncSupplierId(IdUtil.nextId());
            incSupplier.setIncOrderId(newIncOrderId);
            incSupplier.setCreateOperId(reqBO.getUserId().toString());
            incSupplier.setCreateOperName(reqBO.getName());
            incSupplier.setCreateTime(new Date());
            incSuppliers.add(incSupplier);
        }
        this.incOrderModel.addIncSupplierBatch(incSuppliers);
    }

    private void changeSkuItems(IncChangeIncOrderReqBO reqBO, Long newIncOrderId) {
        ArrayList<InsSkuItem> insSkuItems = new ArrayList<InsSkuItem>();
        for (IncSkuItemBO bo : reqBO.getIncSkuItemBOList()) {
            InsSkuItem insSkuItem = new InsSkuItem();
            BeanUtils.copyProperties((Object)bo, (Object)insSkuItem);
            insSkuItem.setInsSkuItemId(IdUtil.nextId());
            insSkuItem.setIncOrderId(newIncOrderId);
            insSkuItem.setCreateOperId(reqBO.getUserId().toString());
            insSkuItem.setCreateOperName(reqBO.getName());
            insSkuItem.setCreateTime(new Date());
            insSkuItems.add(insSkuItem);
        }
        this.incOrderModel.addIncSkuItemBatch(insSkuItems);
    }

    private void changeInOrder(IncChangeIncOrderReqBO reqBO, Long newIncOrderId, IncOrder result) {
        IncOrder oldIncOrder = new IncOrder();
        oldIncOrder.setIncOrderId(reqBO.getIncOrderId());
        if (IncConstants.IncType.INQUIRY.equals(result.getIncType())) {
            oldIncOrder.setIncOrderState("INC_HISTORY");
        } else {
            oldIncOrder.setIncOrderState("INC_HISTORY");
        }
        oldIncOrder.setUpdateOperId(reqBO.getUserId().toString());
        oldIncOrder.setUpdateOperName(reqBO.getName());
        oldIncOrder.setUpdateTime(new Date());
        this.incOrderModel.updateIncOrder(oldIncOrder);
        IncOrder incOrder = new IncOrder();
        BeanUtils.copyProperties((Object)reqBO, (Object)incOrder);
        incOrder.setIncOrderId(newIncOrderId);
        if (IncConstants.IncType.INQUIRY.equals(reqBO.getIncType())) {
            incOrder.setIncOrderState("INC_DRAFT");
        } else {
            incOrder.setIncOrderState("INC_DRAFT");
        }
        String versionNo = result.getVersionNo();
        Integer no = Integer.valueOf(versionNo.substring(1, versionNo.length() - 1));
        incOrder.setVersionNo("V0" + no);
        incOrder.setCreateOperId(reqBO.getUserId().toString());
        incOrder.setCreateOperName(reqBO.getName());
        incOrder.setCreateTime(new Date());
        incOrder.setCreateOrgId(reqBO.getOrgId().toString());
        incOrder.setCreateOrgName(reqBO.getOrgName());
        incOrder.setCreateOrgPath(reqBO.getOrgPath());
        this.incOrderModel.addIncOrder(incOrder);
    }
}

