/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.inc.service.inquiryorder;

import cn.hutool.core.util.ObjectUtil;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.inc.model.inquiryorder.IncNoticeModel;
import com.tydic.dyc.inc.model.inquiryorder.IncOrderDO;
import com.tydic.dyc.inc.model.inquiryorder.IncOrderModel;
import com.tydic.dyc.inc.model.inquiryorder.qrybo.IncNoticePublishQryBo;
import com.tydic.dyc.inc.model.inquiryorder.qrybo.IncOrderQryBO;
import com.tydic.dyc.inc.model.inquiryorder.qrybo.InsSkuItemQryBO;
import com.tydic.dyc.inc.model.inquiryorder.qrybo.InsSkuItemQryRspBO;
import com.tydic.dyc.inc.model.inquiryorder.sub.IncNoticeInfo;
import com.tydic.dyc.inc.model.inquiryorder.sub.InsSkuItem;
import com.tydic.dyc.inc.model.quotation.qryBo.IncQuatationQryBo;
import com.tydic.dyc.inc.model.quotation.sub.IncQuatation;
import com.tydic.dyc.inc.model.quotation.sub.IncQuatationSkuItem;
import com.tydic.dyc.inc.model.sysdictionary.IncSysDicDictionaryModel;
import com.tydic.dyc.inc.model.sysdictionary.SysDicDictionaryDo;
import com.tydic.dyc.inc.model.taskcommon.IncTaskCommonModel;
import com.tydic.dyc.inc.model.taskcommon.qrybo.IncApprovalObjQryBo;
import com.tydic.dyc.inc.model.taskcommon.sub.IncApprovalObj;
import com.tydic.dyc.inc.model.taskcommon.sub.IncOrderTaskInst;
import com.tydic.dyc.inc.service.constants.IncConstants;
import com.tydic.dyc.inc.service.domainservice.inquiryorder.IncQryIncOrderDetailService;
import com.tydic.dyc.inc.service.domainservice.inquiryorder.bo.IncBidResultBO;
import com.tydic.dyc.inc.service.domainservice.inquiryorder.bo.IncNoticeBO;
import com.tydic.dyc.inc.service.domainservice.inquiryorder.bo.IncOrderAccessoryBO;
import com.tydic.dyc.inc.service.domainservice.inquiryorder.bo.IncOrderBO;
import com.tydic.dyc.inc.service.domainservice.inquiryorder.bo.IncPerformanceInfoBO;
import com.tydic.dyc.inc.service.domainservice.inquiryorder.bo.IncQryOrderDetailReqBO;
import com.tydic.dyc.inc.service.domainservice.inquiryorder.bo.IncQryOrderDetailRspBO;
import com.tydic.dyc.inc.service.domainservice.inquiryorder.bo.IncQuatationBO;
import com.tydic.dyc.inc.service.domainservice.inquiryorder.bo.IncResultScopeBO;
import com.tydic.dyc.inc.service.domainservice.quotation.bo.IncQuatationSkuItemBO;
import com.tydic.dyc.inc.utils.IncRu;
import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"INC_GROUP_DEV/2.0.0/com.tydic.dyc.inc.service.domainservice.inquiryorder.IncQryIncOrderDetailService"})
public class IncQryIncOrderDetailServiceImpl
implements IncQryIncOrderDetailService {
    @Autowired
    private IncOrderModel incOrderModel;
    @Autowired
    private IncSysDicDictionaryModel incSysDicDictionaryModel;
    @Autowired
    private IncNoticeModel incNoticeModel;
    @Autowired
    private IncTaskCommonModel incTaskCommonModel;

    @PostMapping(value={"qryIncOrderDetail"})
    public IncQryOrderDetailRspBO qryIncOrderDetail(@RequestBody IncQryOrderDetailReqBO reqBO) {
        if (ObjectUtils.isEmpty((Object)reqBO)) {
            throw new BaseBusinessException("8888", "\u5165\u53c2\u4e3a\u7a7a");
        }
        if (ObjectUtils.isEmpty((Object)reqBO.getIncOrderId())) {
            throw new BaseBusinessException("8888", "\u5165\u53c2\u8be2\u4ef7\u5355ID\u4e3a\u7a7a");
        }
        IncQryOrderDetailRspBO rspBO = IncRu.success(IncQryOrderDetailRspBO.class);
        IncOrderQryBO qryBO = IncRu.js(reqBO, IncOrderQryBO.class);
        qryBO.setSupplierId(reqBO.getOrgId());
        IncOrderDO incOrderDO = this.incOrderModel.qryIncOrderDetail(qryBO);
        if (ObjectUtils.isEmpty((Object)incOrderDO)) {
            rspBO.setRespDesc("\u67e5\u8be2\u7ed3\u679c\u4e3a\u7a7a");
            return rspBO;
        }
        this.setRspBO(rspBO, incOrderDO, reqBO);
        return rspBO;
    }

    private void setRspBO(IncQryOrderDetailRspBO rspBO, IncOrderDO incOrderDO, IncQryOrderDetailReqBO reqBO) {
        IncOrderBO incOrderBO = IncRu.js(incOrderDO, IncOrderBO.class);
        Map<String, String> purchaseModelMap = this.incSysDicDictionaryModel.queryBypCodeBackMap(new SysDicDictionaryDo("INC_PRO", "PURCHASE_MODEL")).getMap();
        Map<String, String> isMissItemQuatationMap = this.incSysDicDictionaryModel.queryBypCodeBackMap(new SysDicDictionaryDo("INC_PRO", "IS_MISS_ITEM_QUATATION")).getMap();
        if (purchaseModelMap.containsKey(incOrderBO.getPurchaseModel() + "")) {
            if (IncConstants.IncType.INQUIRY.equals(incOrderBO.getIncType())) {
                incOrderBO.setPurchaseModelStr(purchaseModelMap.get(incOrderBO.getPurchaseModel() + "") + "\u8be2\u4ef7");
            } else if (IncConstants.IncType.BIDDING.equals(incOrderBO.getIncType())) {
                incOrderBO.setPurchaseModelStr(purchaseModelMap.get(incOrderBO.getPurchaseModel() + "") + "\u7ade\u4ef7");
            }
        }
        if (isMissItemQuatationMap.containsKey(incOrderBO.getIsMissItemQuatation() + "")) {
            incOrderBO.setIsMissItemQuatationStr(isMissItemQuatationMap.get(incOrderBO.getIsMissItemQuatation() + ""));
        }
        if (IncConstants.IncType.BIDDING.equals(incOrderBO.getIncType())) {
            Map<String, String> isDecreaseMap = this.incSysDicDictionaryModel.queryBypCodeBackMap(new SysDicDictionaryDo("INC_PRO", "IS_DECREASE")).getMap();
            Map<String, String> decreaseTypeMap = this.incSysDicDictionaryModel.queryBypCodeBackMap(new SysDicDictionaryDo("INC_PRO", "DECREASE_TYPE")).getMap();
            Map<String, String> isAutoDelayMap = this.incSysDicDictionaryModel.queryBypCodeBackMap(new SysDicDictionaryDo("INC_PRO", "IS_AUTO_DELAY")).getMap();
            if (isDecreaseMap.containsKey(incOrderBO.getIsDecrease() + "")) {
                incOrderBO.setIsDecreaseStr((String)isDecreaseMap.get(incOrderBO.getIsDecrease() + ""));
            }
            if (decreaseTypeMap.containsKey(incOrderBO.getDecreaseType() + "")) {
                incOrderBO.setDecreaseTypeStr(decreaseTypeMap.get(incOrderBO.getDecreaseType() + ""));
            }
            if (isAutoDelayMap.containsKey(incOrderBO.getIsAutoDelay() + "")) {
                incOrderBO.setIsAutoDelayStr(isAutoDelayMap.get(incOrderBO.getIsAutoDelay() + ""));
            }
        }
        if (ObjectUtil.isNotEmpty((Object)incOrderDO.getIncPerformanceInfo())) {
            rspBO.setIncPerformanceInfoBO(IncRu.js(incOrderDO.getIncPerformanceInfo(), IncPerformanceInfoBO.class));
        }
        if (ObjectUtil.isNotEmpty(incOrderDO.getIncResultScopeList())) {
            rspBO.setIncResultScopeBOS(IncRu.jsl(incOrderDO.getIncResultScopeList(), IncResultScopeBO.class));
        }
        if (ObjectUtil.isNotEmpty(incOrderDO.getIncQuotations())) {
            rspBO.setIncQuatationBOS(IncRu.jsl(incOrderDO.getIncQuotations(), IncQuatationBO.class));
            for (IncQuatationBO incQuatationBO : rspBO.getIncQuatationBOS()) {
                IncQuatationQryBo qryBo = new IncQuatationQryBo();
                qryBo.setIncQuatationId(incQuatationBO.getIncQuatationId());
                List<IncQuatationSkuItem> quatationSkuItems = this.incOrderModel.qryIncQuatationSkuItemList(qryBo);
                if (!ObjectUtil.isNotEmpty(quatationSkuItems)) continue;
                incQuatationBO.setIncQuatationSkuItemBOS(IncRu.jsl(quatationSkuItems, IncQuatationSkuItemBO.class));
            }
            incOrderBO.setNowQuatationNum(((IncQuatationBO)rspBO.getIncQuatationBOS().get(0)).getQuatationRound());
        }
        if (ObjectUtil.isNotEmpty(incOrderDO.getIncOrderAccessories())) {
            rspBO.setIncOrderAccessoryBOS(IncRu.jsl(incOrderDO.getIncOrderAccessories(), IncOrderAccessoryBO.class));
        }
        if (ObjectUtil.isNotEmpty(incOrderDO.getIncBidResults())) {
            rspBO.setIncBidResultBOS(IncRu.jsl(incOrderDO.getIncBidResults(), IncBidResultBO.class));
        }
        IncNoticePublishQryBo qryBo = new IncNoticePublishQryBo();
        qryBo.setIncOrderId(incOrderBO.getIncOrderId());
        IncNoticeInfo noticeInfo = this.incNoticeModel.qryIncNotice(qryBo);
        if (ObjectUtil.isNotEmpty((Object)noticeInfo)) {
            rspBO.setIncNoticeBO(IncRu.js(noticeInfo, IncNoticeBO.class));
        }
        IncOrderQryBO orderQryBO = new IncOrderQryBO();
        orderQryBO.setIncOrderId(incOrderDO.getIncOrderId());
        IncQuatation incQuatation = this.incOrderModel.qryIncMinQuatation(orderQryBO);
        if (ObjectUtil.isNotEmpty((Object)incQuatation)) {
            incOrderBO.setMinPriceSupId(incQuatation.getMinPriceSupId());
            incOrderBO.setMinPriceSupName(incQuatation.getMinPriceSupName());
            incOrderBO.setNowMinPrice(incQuatation.getNowMinPrice());
        }
        IncApprovalObjQryBo objQryBo = new IncApprovalObjQryBo();
        objQryBo.setOrderId(incOrderDO.getIncOrderId());
        IncOrderTaskInst orderTaskInst = this.incTaskCommonModel.qryUnfinishedTask(objQryBo);
        if (ObjectUtil.isNotEmpty((Object)orderTaskInst)) {
            incOrderBO.setTaskInstId(orderTaskInst.getTaskInstId());
            incOrderBO.setProcInstId(orderTaskInst.getProcInstId());
        }
        InsSkuItemQryBO itemQryBO = new InsSkuItemQryBO();
        itemQryBO.setIncOrderId(incOrderBO.getIncOrderId());
        InsSkuItemQryRspBO itemQryRspBO = this.incOrderModel.qryIncSkuItemList(itemQryBO);
        BigDecimal totalBidStartPrice = new BigDecimal(0);
        if (ObjectUtil.isNotEmpty((Object)((Object)itemQryRspBO))) {
            for (InsSkuItem skuItem : itemQryRspBO.getRows()) {
                if (!ObjectUtil.isNotEmpty((Object)skuItem.getBidStartPrice())) continue;
                totalBidStartPrice = totalBidStartPrice.add(skuItem.getPurchaseCount().multiply(skuItem.getBidStartPrice()));
            }
        }
        if (ObjectUtil.isNotEmpty((Object)reqBO.getAuditOrderId())) {
            IncApprovalObjQryBo approvalObjQryBo = new IncApprovalObjQryBo();
            approvalObjQryBo.setAuditOrderId(Long.valueOf(reqBO.getAuditOrderId()));
            List<IncApprovalObj> approvalObjList = this.incTaskCommonModel.qryApprovalObj(approvalObjQryBo);
            if (!CollectionUtils.isEmpty(approvalObjList)) {
                incOrderBO.setObjBusiType(approvalObjList.get(0).getObjBusiType());
            }
        }
        incOrderBO.setTotalBidStartPrice(totalBidStartPrice);
        rspBO.setIncOrderBO(incOrderBO);
    }
}

