/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.inc.service.inquiryorder;

import cn.hutool.core.util.ObjectUtil;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.inc.model.inquiryorder.IncOrderModel;
import com.tydic.dyc.inc.model.inquiryorder.sub.IncOrder;
import com.tydic.dyc.inc.service.constants.IncConstants;
import com.tydic.dyc.inc.service.domainservice.inquiryorder.IncSubmitIncOrderService;
import com.tydic.dyc.inc.service.domainservice.inquiryorder.bo.IncSubmitIncOrderReqBO;
import com.tydic.dyc.inc.service.domainservice.inquiryorder.bo.IncSubmitIncOrderRspBO;
import com.tydic.dyc.inc.utils.IncRu;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"INC_GROUP_DEV/2.0.0/com.tydic.dyc.inc.service.domainservice.inquiryorder.IncSubmitIncOrderService"})
public class IncSubmitIncOrderServiceImpl
implements IncSubmitIncOrderService {
    @Autowired
    private IncOrderModel incOrderModel;

    @PostMapping(value={"submitIncOrder"})
    public IncSubmitIncOrderRspBO submitIncOrder(@RequestBody IncSubmitIncOrderReqBO reqBO) {
        IncSubmitIncOrderRspBO rsp = IncRu.success(IncSubmitIncOrderRspBO.class);
        IncOrder incOrder = new IncOrder();
        incOrder.setIncOrderId(reqBO.getIncOrderId());
        IncOrder result = this.incOrderModel.getIncOrder(incOrder);
        if (ObjectUtil.isEmpty((Object)result)) {
            throw new BaseBusinessException("100100", "\u8be2\u4ef7\u5355\u67e5\u8be2\u7ed3\u679c\u4e3a\u7a7a\uff01");
        }
        if (IncConstants.IncType.INQUIRY.equals(result.getIncType()) ? !"INC_DRAFT".equals(result.getIncOrderState()) && !"INC_WITHDRAW".equals(result.getIncOrderState()) && !"INC_AUDIT_REJECT".equals(result.getIncOrderState()) : !"INC_DRAFT".equals(result.getIncOrderState()) && !"INC_WITHDRAW".equals(result.getIncOrderState()) && !"INC_AUDIT_REJECT".equals(result.getIncOrderState())) {
            throw new BaseBusinessException("100100", "\u5f53\u524d\u8be2\u4ef7\u5355\u72b6\u6001\u4e0d\u5141\u8bb8\u63d0\u4ea4\uff01");
        }
        rsp.setIncOrderId(result.getIncOrderId());
        rsp.setIncType(result.getIncType());
        return rsp;
    }
}

