/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.inc.service.inquiryorder;

import cn.hutool.core.util.ObjectUtil;
import com.tydic.dyc.inc.model.inquiryorder.IncOrderModel;
import com.tydic.dyc.inc.model.inquiryorder.sub.IncOrder;
import com.tydic.dyc.inc.model.inquiryorder.sub.IncOrderAccessory;
import com.tydic.dyc.inc.model.inquiryorder.sub.IncPerformanceInfo;
import com.tydic.dyc.inc.model.inquiryorder.sub.IncResultScope;
import com.tydic.dyc.inc.model.inquiryorder.sub.IncSupplier;
import com.tydic.dyc.inc.model.inquiryorder.sub.InsSkuItem;
import com.tydic.dyc.inc.service.constants.IncConstants;
import com.tydic.dyc.inc.service.domainservice.inquiryorder.IncUpdateIncOrderService;
import com.tydic.dyc.inc.service.domainservice.inquiryorder.bo.IncOrderAccessoryBO;
import com.tydic.dyc.inc.service.domainservice.inquiryorder.bo.IncResultScopeBO;
import com.tydic.dyc.inc.service.domainservice.inquiryorder.bo.IncSkuItemBO;
import com.tydic.dyc.inc.service.domainservice.inquiryorder.bo.IncSupplierBO;
import com.tydic.dyc.inc.service.domainservice.inquiryorder.bo.IncUpdateIncOrderReqBO;
import com.tydic.dyc.inc.service.domainservice.inquiryorder.bo.IncUpdateIncOrderRspBO;
import com.tydic.dyc.inc.utils.IdUtil;
import com.tydic.dyc.inc.utils.IncRu;
import java.util.ArrayList;
import java.util.Date;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"INC_GROUP_DEV/2.0.0/com.tydic.dyc.inc.service.domainservice.inquiryorder.IncUpdateIncOrderService"})
public class IncUpdateIncOrderServiceImpl
implements IncUpdateIncOrderService {
    @Autowired
    private IncOrderModel incOrderModel;

    @PostMapping(value={"updateIncOrder"})
    public IncUpdateIncOrderRspBO updateIncOrder(@RequestBody IncUpdateIncOrderReqBO reqBO) {
        IncUpdateIncOrderRspBO rsp = IncRu.success(IncUpdateIncOrderRspBO.class);
        this.updateInOrder(reqBO);
        this.updateSkuItems(reqBO);
        if (IncConstants.PurchaseModel.INVITE.equals(reqBO.getPurchaseModel()) && ObjectUtil.isNotEmpty((Object)reqBO.getIncSupplierBOList())) {
            this.updateSupplier(reqBO);
        }
        if (ObjectUtil.isNotNull((Object)reqBO.getIncPerformanceInfoBO())) {
            this.updatePerformanceInfo(reqBO);
        }
        this.updateResultScopes(reqBO);
        if (ObjectUtil.isNotEmpty((Object)reqBO.getIncOrderAccessoryBOList())) {
            this.updateAccessorys(reqBO);
        }
        rsp.setIncOrderId(reqBO.getIncOrderId());
        return rsp;
    }

    private void updateAccessorys(IncUpdateIncOrderReqBO reqBO) {
        IncOrderAccessory deleteIncOrderAccessory = new IncOrderAccessory();
        deleteIncOrderAccessory.setObjId(reqBO.getIncOrderId());
        deleteIncOrderAccessory.setObjType(IncConstants.AccessoryObjType.INC);
        deleteIncOrderAccessory.setAttachmentType(IncConstants.AccessoryAttachmentType.INC);
        this.incOrderModel.delteOrderAccessory(deleteIncOrderAccessory);
        ArrayList<IncOrderAccessory> incOrderAccessories = new ArrayList<IncOrderAccessory>();
        for (IncOrderAccessoryBO bo : reqBO.getIncOrderAccessoryBOList()) {
            IncOrderAccessory incOrderAccessory = new IncOrderAccessory();
            BeanUtils.copyProperties((Object)bo, (Object)incOrderAccessory);
            incOrderAccessory.setId(IdUtil.nextId());
            incOrderAccessory.setObjId(reqBO.getIncOrderId());
            incOrderAccessory.setObjType(IncConstants.AccessoryObjType.INC);
            incOrderAccessory.setOrderId(reqBO.getIncOrderId());
            incOrderAccessory.setAttachmentType(IncConstants.AccessoryAttachmentType.INC);
            incOrderAccessory.setCreateOperId(reqBO.getUserId().toString());
            incOrderAccessory.setCreateTime(new Date());
            incOrderAccessories.add(incOrderAccessory);
        }
        this.incOrderModel.addOrderAccessoryBatch(incOrderAccessories);
    }

    private void updateResultScopes(IncUpdateIncOrderReqBO reqBO) {
        IncResultScope deleteIncResultScope = new IncResultScope();
        deleteIncResultScope.setOrderId(reqBO.getIncOrderId());
        deleteIncResultScope.setScopeType(IncConstants.TemplateScopeType.INC);
        this.incOrderModel.deleteIncResultScope(deleteIncResultScope);
        ArrayList<IncResultScope> incResultScopes = new ArrayList<IncResultScope>();
        for (IncResultScopeBO bo : reqBO.getIncResultScopeBOList()) {
            IncResultScope incResultScope = new IncResultScope();
            BeanUtils.copyProperties((Object)bo, (Object)incResultScope);
            incResultScope.setIncResultScopeId(IdUtil.nextId());
            incResultScope.setOrderId(reqBO.getIncOrderId());
            incResultScope.setScopeType(IncConstants.TemplateScopeType.INC);
            incResultScope.setCreateOperId(reqBO.getUserId().toString());
            incResultScope.setCreateOperName(reqBO.getName());
            incResultScope.setCreateTime(new Date());
            incResultScopes.add(incResultScope);
        }
        this.incOrderModel.addIncResultScopeBatch(incResultScopes);
    }

    private void updatePerformanceInfo(IncUpdateIncOrderReqBO reqBO) {
        IncPerformanceInfo incPerformanceInfo = new IncPerformanceInfo();
        BeanUtils.copyProperties((Object)reqBO.getIncPerformanceInfoBO(), (Object)incPerformanceInfo);
        incPerformanceInfo.setIncOrderId(reqBO.getIncOrderId());
        incPerformanceInfo.setUpdateOperId(reqBO.getUserId().toString());
        incPerformanceInfo.setUpdateOperName(reqBO.getName());
        incPerformanceInfo.setUpdateTime(new Date());
        this.incOrderModel.updateIncPerformanceInfo(incPerformanceInfo);
    }

    private void updateSupplier(IncUpdateIncOrderReqBO reqBO) {
        IncSupplier deleteIncSupplier = new IncSupplier();
        deleteIncSupplier.setIncOrderId(reqBO.getIncOrderId());
        this.incOrderModel.deleteIncSupplier(deleteIncSupplier);
        ArrayList<IncSupplier> incSuppliers = new ArrayList<IncSupplier>();
        for (IncSupplierBO bo : reqBO.getIncSupplierBOList()) {
            IncSupplier incSupplier = new IncSupplier();
            BeanUtils.copyProperties((Object)bo, (Object)incSupplier);
            incSupplier.setIncSupplierId(IdUtil.nextId());
            incSupplier.setIncOrderId(reqBO.getIncOrderId());
            incSupplier.setCreateOperId(reqBO.getUserId().toString());
            incSupplier.setCreateOperName(reqBO.getName());
            incSupplier.setCreateTime(new Date());
            incSuppliers.add(incSupplier);
        }
        this.incOrderModel.addIncSupplierBatch(incSuppliers);
    }

    private void updateSkuItems(IncUpdateIncOrderReqBO reqBO) {
        InsSkuItem deleteInsSkuItem = new InsSkuItem();
        deleteInsSkuItem.setIncOrderId(reqBO.getIncOrderId());
        this.incOrderModel.deleteIncSkuItem(deleteInsSkuItem);
        ArrayList<InsSkuItem> insSkuItems = new ArrayList<InsSkuItem>();
        for (IncSkuItemBO bo : reqBO.getIncSkuItemBOList()) {
            InsSkuItem insSkuItem = new InsSkuItem();
            BeanUtils.copyProperties((Object)bo, (Object)insSkuItem);
            insSkuItem.setInsSkuItemId(IdUtil.nextId());
            insSkuItem.setIncOrderId(reqBO.getIncOrderId());
            insSkuItem.setCreateOperId(reqBO.getUserId().toString());
            insSkuItem.setCreateOperName(reqBO.getName());
            insSkuItem.setCreateTime(new Date());
            insSkuItems.add(insSkuItem);
        }
        this.incOrderModel.addIncSkuItemBatch(insSkuItems);
    }

    private void updateInOrder(IncUpdateIncOrderReqBO reqBO) {
        IncOrder incOrder = new IncOrder();
        BeanUtils.copyProperties((Object)reqBO, (Object)incOrder);
        incOrder.setIncOrderState(null);
        incOrder.setUpdateOperId(reqBO.getUserId().toString());
        incOrder.setUpdateOperName(reqBO.getName());
        incOrder.setUpdateTime(new Date());
        this.incOrderModel.updateIncOrder(incOrder);
    }
}

