/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.inc.service.quotation;

import cn.hutool.core.util.ObjectUtil;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.inc.model.inquiryorder.IncOrderDO;
import com.tydic.dyc.inc.model.inquiryorder.IncOrderModel;
import com.tydic.dyc.inc.model.inquiryorder.qrybo.IncOrderQryBO;
import com.tydic.dyc.inc.model.inquiryorder.sub.IncOrderAccessory;
import com.tydic.dyc.inc.model.inquiryorder.sub.IncSupplier;
import com.tydic.dyc.inc.model.quotation.IncQuatationModel;
import com.tydic.dyc.inc.model.quotation.sub.IncQuatation;
import com.tydic.dyc.inc.model.quotation.sub.IncQuatationSkuItem;
import com.tydic.dyc.inc.service.constants.IncConstants;
import com.tydic.dyc.inc.service.domainservice.inquiryorder.bo.IncOrderAccessoryBO;
import com.tydic.dyc.inc.service.domainservice.quotation.IncAddInquiryQuatationService;
import com.tydic.dyc.inc.service.domainservice.quotation.bo.IncAddInquiryQuatationReqBO;
import com.tydic.dyc.inc.service.domainservice.quotation.bo.IncAddInquiryQuatationRspBO;
import com.tydic.dyc.inc.service.domainservice.quotation.bo.IncQuatationSkuItemBO;
import com.tydic.dyc.inc.utils.IdUtil;
import com.tydic.dyc.inc.utils.IncRu;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"INC_GROUP_DEV/2.0.0/com.tydic.dyc.inc.service.domainservice.quotation.IncAddInquiryQuatationService"})
public class IncAddInquiryQuatationServiceImpl
implements IncAddInquiryQuatationService {
    @Autowired
    private IncQuatationModel incQuatationModel;
    @Autowired
    private IncOrderModel incOrderModel;

    @PostMapping(value={"addInquiryQuatation"})
    public IncAddInquiryQuatationRspBO addInquiryQuatation(@RequestBody IncAddInquiryQuatationReqBO reqBO) {
        IncAddInquiryQuatationRspBO rsp = IncRu.success(IncAddInquiryQuatationRspBO.class);
        IncOrderQryBO incOrderQryBO = new IncOrderQryBO();
        incOrderQryBO.setIncOrderId(reqBO.getIncOrderId());
        IncOrderDO incOrderDO = this.incOrderModel.qryIncOrderDetail(incOrderQryBO);
        if (ObjectUtil.isEmpty((Object)incOrderDO)) {
            throw new BaseBusinessException("100100", "\u8be2\u4ef7\u5355\u67e5\u8be2\u7ed3\u679c\u4e3a\u7a7a\uff01");
        }
        if (IncConstants.IncType.BIDDING.equals(incOrderDO.getIncType())) {
            throw new BaseBusinessException("100100", "\u8be5\u5355\u636e\u4e3a\u7ade\u4ef7\u5355\uff01");
        }
        Long incQuatationId = 1 == reqBO.getQuatationRound() ? this.doFristQuatation(reqBO, incOrderDO) : this.doTwoQuatation(reqBO);
        if (ObjectUtil.isNotEmpty((Object)reqBO.getIncQuatationAccessoryBOList())) {
            this.insertAccessorys(reqBO, incQuatationId);
        }
        rsp.setIncQuatationId(incQuatationId);
        return rsp;
    }

    private void insertAccessorys(IncAddInquiryQuatationReqBO reqBO, Long incQuatationId) {
        ArrayList<IncOrderAccessory> incOrderAccessories = new ArrayList<IncOrderAccessory>();
        for (IncOrderAccessoryBO bo : reqBO.getIncQuatationAccessoryBOList()) {
            IncOrderAccessory incOrderAccessory = new IncOrderAccessory();
            BeanUtils.copyProperties((Object)bo, (Object)incOrderAccessory);
            incOrderAccessory.setId(IdUtil.nextId());
            incOrderAccessory.setObjId(incQuatationId);
            incOrderAccessory.setObjType(IncConstants.AccessoryObjType.QUATATION);
            incOrderAccessory.setOrderId(reqBO.getIncOrderId());
            incOrderAccessory.setAttachmentType(IncConstants.AccessoryAttachmentType.QUATATION);
            incOrderAccessory.setCreateOperId(reqBO.getUserId().toString());
            incOrderAccessory.setCreateTime(new Date());
            incOrderAccessories.add(incOrderAccessory);
        }
        this.incOrderModel.addOrderAccessoryBatch(incOrderAccessories);
    }

    private Long doTwoQuatation(IncAddInquiryQuatationReqBO reqBO) {
        IncQuatation incQuatation = new IncQuatation();
        incQuatation.setIncOrderId(reqBO.getIncOrderId());
        incQuatation.setIncQuatationId(reqBO.getIncQuatationId());
        incQuatation.setQuatationRound(reqBO.getQuatationRound());
        List<IncQuatation> result = this.incQuatationModel.getQuatationList(incQuatation);
        if (ObjectUtil.isEmpty(result) || result.size() != 1) {
            throw new BaseBusinessException("100100", "\u67e5\u8be2\u62a5\u4ef7\u8868\u4e3a\u7a7a\u6216\u6570\u636e\u5b58\u5728\u591a\u6761\uff01");
        }
        if (new Date().getTime() >= result.get(0).getQuatationEndTime().getTime()) {
            throw new BaseBusinessException("100100", "\u5df2\u8fc7\u62a5\u4ef7\u622a\u6b62\u65f6\u95f4\uff0c\u4e0d\u5141\u8bb8\u62a5\u4ef7\uff01");
        }
        if ("1".equals(result.get(0).getQuatationState())) {
            this.updateQuatation(reqBO);
            this.updateQuatationItem(reqBO);
            this.saveQuatationItem(reqBO, reqBO.getIncQuatationId());
        } else {
            if ("3".equals(result.get(0).getQuatationState())) {
                this.updateQuatation(reqBO);
            }
            this.saveQuatationItem(reqBO, reqBO.getIncQuatationId());
        }
        return reqBO.getIncQuatationId();
    }

    private void updateQuatationItem(IncAddInquiryQuatationReqBO reqBO) {
        IncQuatation incQuatation = new IncQuatation();
        incQuatation.setIncOrderId(reqBO.getIncOrderId());
        incQuatation.setSupplierId(reqBO.getSupplierId());
        incQuatation.setQuatationRound(reqBO.getQuatationRound() - 1);
        List<IncQuatation> result = this.incQuatationModel.getQuatationList(incQuatation);
        if (ObjectUtil.isEmpty(result) || result.size() != 1) {
            throw new BaseBusinessException("100100", "\u67e5\u8be2\u62a5\u4ef7\u8868\u4e3a\u7a7a\u6216\u6570\u636e\u5b58\u5728\u591a\u6761\uff01");
        }
        IncQuatationSkuItem incQuatationSkuItem = new IncQuatationSkuItem();
        incQuatationSkuItem.setIncOrderId(reqBO.getIncOrderId());
        incQuatationSkuItem.setIncQuatationId(result.get(0).getIncQuatationId());
        incQuatationSkuItem.setQuatationSkuItemState("2");
        incQuatationSkuItem.setUpdateOperId(reqBO.getUserId() + "");
        incQuatationSkuItem.setUpdateOperName(reqBO.getName());
        incQuatationSkuItem.setUpdateTime(new Date());
        this.incQuatationModel.updateQuatationSkuItem(incQuatationSkuItem);
    }

    private void updateQuatation(IncAddInquiryQuatationReqBO reqBO) {
        IncQuatation incQuatation = new IncQuatation();
        incQuatation.setIncQuatationId(reqBO.getIncQuatationId());
        incQuatation.setIncOrderId(reqBO.getIncOrderId());
        incQuatation.setQuatationState("2");
        incQuatation.setWithdrawQuatationDesc(null);
        incQuatation.setUpdateOperId(reqBO.getUserId() + "");
        incQuatation.setUpdateOperName(reqBO.getName());
        incQuatation.setUpdateTime(new Date());
        this.incQuatationModel.updateQuatation(incQuatation);
    }

    private Long doFristQuatation(IncAddInquiryQuatationReqBO reqBO, IncOrderDO incOrderDO) {
        if (new Date().getTime() >= incOrderDO.getQuatationEndTime().getTime()) {
            throw new BaseBusinessException("100100", "\u5df2\u8fc7\u62a5\u4ef7\u622a\u6b62\u65f6\u95f4\uff0c\u4e0d\u5141\u8bb8\u62a5\u4ef7\uff01");
        }
        if (ObjectUtil.isEmpty((Object)reqBO.getIncQuatationId())) {
            this.checkOrAddSupplier(reqBO, incOrderDO);
            Long incQuatationId = this.saveQutation(reqBO, incOrderDO);
            this.saveQuatationItem(reqBO, incQuatationId);
            return incQuatationId;
        }
        this.saveQuatationItem(reqBO, reqBO.getIncQuatationId());
        return reqBO.getIncQuatationId();
    }

    private void saveQuatationItem(IncAddInquiryQuatationReqBO reqBO, Long incQuatationId) {
        IncQuatationSkuItem deleteIncQuatationSkuItem = new IncQuatationSkuItem();
        deleteIncQuatationSkuItem.setIncQuatationId(incQuatationId);
        this.incQuatationModel.deleteQuatationSkuItem(deleteIncQuatationSkuItem);
        ArrayList<IncQuatationSkuItem> list = new ArrayList<IncQuatationSkuItem>();
        for (IncQuatationSkuItemBO bo : reqBO.getIncQuatationSkuItemBOList()) {
            IncQuatationSkuItem incQuatationSkuItem = new IncQuatationSkuItem();
            BeanUtils.copyProperties((Object)bo, (Object)incQuatationSkuItem);
            incQuatationSkuItem.setIncQuatationSkuItemId(IdUtil.nextId());
            incQuatationSkuItem.setIncQuatationId(incQuatationId);
            incQuatationSkuItem.setIncOrderId(reqBO.getIncOrderId());
            incQuatationSkuItem.setQuatationSkuItemState("1");
            incQuatationSkuItem.setCreateOperId(reqBO.getUserId() + "");
            incQuatationSkuItem.setCreateOperName(reqBO.getName());
            incQuatationSkuItem.setCreateTime(new Date());
            list.add(incQuatationSkuItem);
        }
        this.incQuatationModel.insertQuatationSkuItemBatch(list);
    }

    private Long saveQutation(IncAddInquiryQuatationReqBO reqBO, IncOrderDO incOrderDO) {
        Long incQuatationId = IdUtil.nextId();
        IncQuatation incQuatation = new IncQuatation();
        BeanUtils.copyProperties((Object)reqBO, (Object)incQuatation);
        incQuatation.setIncQuatationId(incQuatationId);
        incQuatation.setQuatationState("2");
        incQuatation.setQuatationStartTime(incOrderDO.getQuatationStartTime());
        incQuatation.setQuatationEndTime(incOrderDO.getQuatationEndTime());
        incQuatation.setCreateOperId(reqBO.getUserId() + "");
        incQuatation.setCreateOperName(reqBO.getName());
        incQuatation.setCreateTime(new Date());
        this.incQuatationModel.insertQutation(incQuatation);
        return incQuatationId;
    }

    private void checkOrAddSupplier(IncAddInquiryQuatationReqBO reqBO, IncOrderDO incOrderDO) {
        if (IncConstants.PurchaseModel.INVITE.equals(incOrderDO.getPurchaseModel())) {
            IncSupplier incSupplier = new IncSupplier();
            incSupplier.setIncOrderId(reqBO.getIncOrderId());
            incSupplier.setSupplierId(reqBO.getSupplierId());
            List<IncSupplier> result = this.incOrderModel.getIncSupplierList(incSupplier);
            if (ObjectUtil.isEmpty(result) || result.size() != 1) {
                throw new BaseBusinessException("100100", "\u67e5\u8be2\u4f9b\u5e94\u5546\u8868\u4e3a\u7a7a\u6216\u6570\u636e\u5b58\u5728\u591a\u6761\uff01");
            }
            if (!"1".equals(result.get(0).getIncSupplierState())) {
                throw new BaseBusinessException("100100", "\u5f53\u524d\u4f9b\u5e94\u5546\u65e0\u6743\u62a5\u4ef7\uff01");
            }
        } else {
            IncSupplier incSupplier = new IncSupplier();
            incSupplier.setIncOrderId(reqBO.getIncOrderId());
            incSupplier.setSupplierId(reqBO.getSupplierId());
            List<IncSupplier> result = this.incOrderModel.getIncSupplierList(incSupplier);
            if (ObjectUtil.isNotEmpty(result)) {
                throw new BaseBusinessException("100100", "\u5f53\u524d\u4f9b\u5e94\u5546\u975e\u9996\u8f6e\u62a5\u4ef7\uff01");
            }
            ArrayList<IncSupplier> list = new ArrayList<IncSupplier>();
            IncSupplier addIncSupplier = new IncSupplier();
            BeanUtils.copyProperties((Object)reqBO, (Object)addIncSupplier);
            addIncSupplier.setIncSupplierId(IdUtil.nextId());
            addIncSupplier.setIncOrderId(reqBO.getIncOrderId());
            addIncSupplier.setCreateOperId(reqBO.getUserId().toString());
            addIncSupplier.setCreateOperName(reqBO.getName());
            addIncSupplier.setCreateTime(new Date());
            list.add(addIncSupplier);
            this.incOrderModel.addIncSupplierBatch(list);
        }
    }
}

