/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.inc.service.quotation;

import cn.hutool.core.util.ObjectUtil;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.dyc.base.utils.JUtil;
import com.tydic.dyc.inc.model.inquiryorder.IncOrderDO;
import com.tydic.dyc.inc.model.inquiryorder.IncOrderModel;
import com.tydic.dyc.inc.model.inquiryorder.qrybo.IncOrderQryBO;
import com.tydic.dyc.inc.model.quotation.IncQuatationModel;
import com.tydic.dyc.inc.model.quotation.qryBo.IncQuatationAddQryBo;
import com.tydic.dyc.inc.model.quotation.qryBo.IncQuatationQryBo;
import com.tydic.dyc.inc.service.domainservice.quotation.IncMultipleInitiateService;
import com.tydic.dyc.inc.service.domainservice.quotation.bo.IncMultipleInitiateReqBo;
import com.tydic.dyc.inc.service.domainservice.quotation.bo.IncMultipleInitiateRspBo;
import com.tydic.dyc.inc.service.domainservice.quotation.bo.IncMultipleInitiateSupplierBo;
import com.tydic.dyc.inc.utils.IncRu;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"INC_GROUP_DEV/2.0.0/com.tydic.dyc.inc.service.domainservice.quotation.IncMultipleInitiateService"})
public class IncMultipleInitiateServiceImpl
implements IncMultipleInitiateService {
    @Autowired
    private IncQuatationModel incQuatationModel;
    @Autowired
    private IncOrderModel incOrderModel;

    @PostMapping(value={"dealMultipleInitiate"})
    public IncMultipleInitiateRspBo dealMultipleInitiate(@RequestBody IncMultipleInitiateReqBo reqBo) {
        this.validate(reqBo);
        this.validateState(reqBo);
        List<IncQuatationQryBo> qryBos = this.compolentData(reqBo);
        IncQuatationAddQryBo js = (IncQuatationAddQryBo)((Object)JUtil.js((Object)reqBo, IncQuatationAddQryBo.class));
        js.setQuatationQryBoList(qryBos);
        try {
            this.incQuatationModel.addQuotations(js);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new ZTBusinessException("\u65b0\u589e\u62a5\u4ef7\u5931\u8d25 " + e.getMessage());
        }
        return IncRu.success(IncMultipleInitiateRspBo.class);
    }

    private void validateState(IncMultipleInitiateReqBo reqBo) {
        IncOrderQryBO incOrderQryBO = new IncOrderQryBO();
        incOrderQryBO.setIncOrderId(reqBo.getIncOrderId());
        IncOrderDO incOrderDO = this.incOrderModel.qryIncOrderDetail(incOrderQryBO);
        if (ObjectUtil.isEmpty((Object)incOrderDO)) {
            throw new ZTBusinessException("\u8be2\u4ef7\u5355\u67e5\u8be2\u7ed3\u679c\u4e3a\u7a7a\uff01");
        }
        if (!"INC_TWO_QUATATION".equals(incOrderDO.getIncOrderState())) {
            throw new ZTBusinessException("\u5f53\u524d\u8be2\u4ef7\u5355\u72b6\u6001\u4e0d\u5141\u8bb8\u591a\u8f6e\u62a5\u4ef7\uff01");
        }
    }

    private List<IncQuatationQryBo> compolentData(IncMultipleInitiateReqBo reqBo) {
        Date time = new Date();
        return reqBo.getInitiateSupplierBos().stream().map(e -> {
            IncQuatationQryBo qryBo = new IncQuatationQryBo();
            qryBo.setIncOrderId(reqBo.getIncOrderId());
            qryBo.setQuatationEndTime(reqBo.getQuatationEndTime());
            qryBo.setQuatationStartTime(time);
            qryBo.setSupplierId(e.getSupplierId());
            qryBo.setSupplierName(e.getSupplierName());
            qryBo.setQuatationRound(reqBo.getQuatationRound() + 1);
            qryBo.setQuatationState("1");
            qryBo.setCreateOperId(reqBo.getUserId().toString());
            qryBo.setCreateOperName(reqBo.getName());
            qryBo.setDelTag(0);
            qryBo.setCreateTime(time);
            qryBo.setUpdateOperId(reqBo.getUserId().toString());
            qryBo.setUpdateOperName(reqBo.getName());
            qryBo.setUpdateTime(time);
            return qryBo;
        }).collect(Collectors.toList());
    }

    private void validate(IncMultipleInitiateReqBo reqBo) {
        if (ObjectUtils.isEmpty((Object)reqBo.getIncOrderId())) {
            throw new ZTBusinessException("\u5165\u53c2 incOrderId \u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (ObjectUtils.isEmpty((Object)reqBo.getQuatationRound())) {
            throw new ZTBusinessException("\u5165\u53c2 quatationRound \u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (ObjectUtils.isEmpty((Object)reqBo.getQuatationEndTime())) {
            throw new ZTBusinessException("\u5165\u53c2 quatationEndTime \u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (CollectionUtils.isEmpty((Collection)reqBo.getInitiateSupplierBos())) {
            throw new ZTBusinessException("\u5165\u53c2 initiateSupplierBos \u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        for (IncMultipleInitiateSupplierBo supplierBo : reqBo.getInitiateSupplierBos()) {
            if (ObjectUtils.isEmpty((Object)supplierBo.getSupplierId())) {
                throw new ZTBusinessException("\u5165\u53c2 initiateSupplierBos -> supplierId \u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            if (!ObjectUtils.isEmpty((Object)supplierBo.getSupplierName())) continue;
            throw new ZTBusinessException("\u5165\u53c2 initiateSupplierBos -> supplierName \u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
    }
}

