/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.inc.service.quotation;

import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.dyc.base.utils.JUtil;
import com.tydic.dyc.inc.model.inquiryorder.IncOrderModel;
import com.tydic.dyc.inc.model.quotation.IncQuatationModel;
import com.tydic.dyc.inc.model.quotation.sub.IncBidResultQuotationSubBo;
import com.tydic.dyc.inc.model.quotation.sub.IncQuotationConfirmSkuItemSubBo;
import com.tydic.dyc.inc.model.quotation.sub.IncSupplierQuatationDetailListSubBo;
import com.tydic.dyc.inc.service.domainservice.quotation.IncQuotationConfirmListService;
import com.tydic.dyc.inc.service.domainservice.quotation.bo.IncQuotationConfirmListBo;
import com.tydic.dyc.inc.service.domainservice.quotation.bo.IncQuotationConfirmListReqBo;
import com.tydic.dyc.inc.service.domainservice.quotation.bo.IncQuotationConfirmListRspBo;
import com.tydic.dyc.inc.service.domainservice.quotation.bo.IncSkuItemJoinQuotationBo;
import com.tydic.dyc.inc.service.domainservice.quotation.bo.IncSupplierQuatationDetailListReqBo;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"INC_GROUP_DEV/2.0.0/com.tydic.dyc.inc.service.domainservice.quotation.IncQuotationConfirmListService"})
public class IncQuotationConfirmListServiceImpl
implements IncQuotationConfirmListService {
    @Autowired
    private IncQuatationModel incQuatationModel;
    @Autowired
    private IncOrderModel incOrderModel;

    @PostMapping(value={"quoConfirmList"})
    public IncQuotationConfirmListRspBo quoConfirmList(@RequestBody IncQuotationConfirmListReqBo reqBo) {
        IncQuotationConfirmSkuItemSubBo confirmSkuItemSubBo = this.incQuatationModel.qrySkuItemInfo(reqBo);
        IncQuotationConfirmListRspBo rspBo = (IncQuotationConfirmListRspBo)JUtil.js((Object)((Object)confirmSkuItemSubBo), IncQuotationConfirmListRspBo.class);
        rspBo.setRespCode("0000");
        if ("0000".equals(confirmSkuItemSubBo.getRespCode())) {
            List<IncBidResultQuotationSubBo> resultQuotationBos = new ArrayList<IncBidResultQuotationSubBo>();
            IncSupplierQuatationDetailListSubBo detailListSubBo = new IncSupplierQuatationDetailListSubBo();
            if (!CollectionUtils.isEmpty((Collection)confirmSkuItemSubBo.getRows())) {
                List<Long> quotationIds = this.selectSupplierNewQuotationIds(confirmSkuItemSubBo, reqBo);
                if (!CollectionUtils.isEmpty(quotationIds)) {
                    detailListSubBo = this.selectSupplierQuotationDetails(quotationIds);
                    resultQuotationBos = this.selectBidResultList(detailListSubBo);
                }
                this.compolentData(detailListSubBo, resultQuotationBos, confirmSkuItemSubBo, rspBo);
            }
            return rspBo;
        }
        throw new ZTBusinessException("\u67e5\u8be2\u5f02\u5e38" + confirmSkuItemSubBo.getMessage() + confirmSkuItemSubBo.getRespDesc());
    }

    private void compolentData(IncSupplierQuatationDetailListSubBo detailListSubBo, List<IncBidResultQuotationSubBo> resultQuotationBos, IncQuotationConfirmSkuItemSubBo confirmSkuItemSubBo, IncQuotationConfirmListRspBo rspBo) {
        List confirmListBos = JUtil.jsl((List)confirmSkuItemSubBo.getRows(), IncQuotationConfirmListBo.class);
        rspBo.setRows(confirmListBos);
        if (!CollectionUtils.isEmpty((Collection)detailListSubBo.getRows())) {
            for (IncQuotationConfirmListBo row : rspBo.getRows()) {
                Map<Long, List<IncSkuItemJoinQuotationBo>> supplierQuotationMap = detailListSubBo.getRows().stream().collect(Collectors.groupingBy(IncSkuItemJoinQuotationBo::getInsSkuItemId));
                if (!supplierQuotationMap.containsKey(row.getInsSkuItemId())) continue;
                List<IncSkuItemJoinQuotationBo> quotationBos = supplierQuotationMap.get(row.getInsSkuItemId());
                if (!CollectionUtils.isEmpty(resultQuotationBos)) {
                    for (IncSkuItemJoinQuotationBo quotationBo : quotationBos) {
                        Map<Long, List<IncBidResultQuotationSubBo>> bidResultMap = resultQuotationBos.stream().collect(Collectors.groupingBy(IncBidResultQuotationSubBo::getIncQuatationSkuItemId));
                        if (!bidResultMap.containsKey(quotationBo.getIncQuatationSkuItemId())) continue;
                        IncBidResultQuotationSubBo quotationSubBo = bidResultMap.get(quotationBo.getIncQuatationSkuItemId()).get(0);
                        quotationBo.setBidNum(quotationSubBo.getBidNum());
                        quotationBo.setBidProportion(quotationBo.getBidNum().divide(row.getPurchaseCount(), 4, RoundingMode.HALF_UP));
                    }
                }
                List quotaionSort = quotationBos.stream().sorted(Comparator.comparing(IncSkuItemJoinQuotationBo::getBidProportion)).collect(Collectors.toList());
                IntStream.range(0, quotaionSort.size()).forEach(i -> ((IncSkuItemJoinQuotationBo)quotaionSort.get(i)).setSort(Integer.valueOf(i + 1)));
                row.setQuotationBoList(quotaionSort);
            }
        }
    }

    private List<IncBidResultQuotationSubBo> selectBidResultList(IncSupplierQuatationDetailListSubBo detailListSubBo) {
        List<Long> incQuotationSkuItemIds = detailListSubBo.getRows().stream().map(e -> e.getIncQuatationSkuItemId()).collect(Collectors.toList());
        List<IncBidResultQuotationSubBo> resultQuotationBos = this.incQuatationModel.qryBidResultList(null, null, incQuotationSkuItemIds);
        return resultQuotationBos;
    }

    private IncSupplierQuatationDetailListSubBo selectSupplierQuotationDetails(List<Long> quotationIds) {
        IncSupplierQuatationDetailListReqBo detailListReqBo = new IncSupplierQuatationDetailListReqBo();
        detailListReqBo.setPageNo(-1);
        detailListReqBo.setPageSize(-1);
        detailListReqBo.setIncQuatationIds(quotationIds);
        IncSupplierQuatationDetailListSubBo detailListSubBo = this.incQuatationModel.supplierQuaDetailList(detailListReqBo);
        if (!"0000".equals(detailListSubBo.getRespCode())) {
            throw new ZTBusinessException("\u67e5\u8be2\u62a5\u4ef7\u4fe1\u606f\u5f02\u5e38" + detailListSubBo.getRespDesc() + detailListSubBo.getMessage());
        }
        return detailListSubBo;
    }

    private List<Long> selectSupplierNewQuotationIds(IncQuotationConfirmSkuItemSubBo confirmSkuItemSubBo, IncQuotationConfirmListReqBo reqBo) {
        List<Long> skuItemIds = confirmSkuItemSubBo.getRows().stream().map(e -> e.getInsSkuItemId()).collect(Collectors.toList());
        return this.incQuatationModel.qryQuotationListNew(reqBo.getIncOrderId(), skuItemIds);
    }
}

