/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.inc.utils;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.entity.ContentType;
import org.apache.http.nio.entity.NStringEntity;
import org.apache.http.util.EntityUtils;
import org.elasticsearch.action.admin.indices.create.CreateIndexRequest;
import org.elasticsearch.action.admin.indices.create.CreateIndexResponse;
import org.elasticsearch.action.admin.indices.delete.DeleteIndexRequest;
import org.elasticsearch.action.bulk.BulkRequest;
import org.elasticsearch.action.bulk.BulkResponse;
import org.elasticsearch.action.delete.DeleteRequest;
import org.elasticsearch.action.delete.DeleteResponse;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.index.IndexResponse;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.action.update.UpdateRequest;
import org.elasticsearch.action.update.UpdateResponse;
import org.elasticsearch.client.Request;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.Response;
import org.elasticsearch.client.RestClient;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.common.xcontent.XContentType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class IncElasticsearchUtil {
    private static final Logger log = LoggerFactory.getLogger(IncElasticsearchUtil.class);
    @Autowired
    private RestHighLevelClient client;
    private static RequestOptions options = RequestOptions.DEFAULT;
    private static ObjectMapper mapper = new ObjectMapper();
    private static final int batchSize = 1000;

    public String addData(String index, String type, String id, JSONObject object) {
        IndexRequest indexRequest = new IndexRequest();
        indexRequest.index(index);
        indexRequest.id(id);
        try {
            indexRequest.source(mapper.writeValueAsString((Object)object), XContentType.JSON);
            IndexResponse indexResponse = this.client.index(indexRequest, options);
            return indexResponse.getId();
        }
        catch (Exception e) {
            log.info("\u63d2\u5165\u6570\u636e\u5931\u8d25", (Throwable)e);
            return null;
        }
    }

    public void addBatch(String index, String type, List<Map<String, JSONObject>> list) {
        if (list.isEmpty()) {
            return;
        }
        int pages = (int)Math.ceil((double)list.size() / 1000.0);
        for (int i = 0; i < pages; ++i) {
            List<Map<String, JSONObject>> subList = this.subList(list, 1000, i);
            this.dealBatch(index, type, subList);
            log.info("\u6279\u91cf\u5904\u7406\u7b2c--" + i + "\u6b21,\u5171\u8ba1:" + subList.size() + "--\u6761...");
        }
        log.info("\u63d2\u5165\u5b8c\u6bd5\uff0c\u5171\u8ba1:" + list.size() + "--\u6761...");
    }

    public List<Map<String, JSONObject>> subList(List<Map<String, JSONObject>> dataList, int pageSize, int currentPage) {
        ArrayList<Map<String, JSONObject>> currentPageList = new ArrayList<Map<String, JSONObject>>();
        if (dataList != null && dataList.size() > 0) {
            int currIdx = currentPage > 0 ? currentPage * pageSize : 0;
            for (int i = 0; i < pageSize && i < dataList.size() - currIdx; ++i) {
                Map<String, JSONObject> map = dataList.get(currIdx + i);
                currentPageList.add(map);
            }
        }
        return currentPageList;
    }

    private void dealBatch(String index, String type, List<Map<String, JSONObject>> list) {
        BulkRequest request = new BulkRequest();
        list.forEach(map -> {
            for (Map.Entry entry : map.entrySet()) {
                IndexRequest indexRequest = new IndexRequest();
                indexRequest.index(index);
                indexRequest.id((String)entry.getKey());
                try {
                    indexRequest.source(mapper.writeValueAsString(entry.getValue()), XContentType.JSON);
                }
                catch (JsonProcessingException e) {
                    e.printStackTrace();
                }
                request.add(indexRequest);
            }
        });
        try {
            BulkResponse responses = this.client.bulk(request, options);
            if (responses.hasFailures()) {
                log.info("\u6279\u91cf\u63d2\u5165\u6709\u5931\u8d25\u6570\u636e!");
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            log.error("\u5546\u54c1\u4fe1\u606f\u540c\u6b65\u5931\u8d25\uff1a" + e.getMessage());
        }
    }

    public Boolean deleteDataByCondition(String endPoint, JSONObject qryJson) {
        boolean deleteResult = false;
        NStringEntity entity = new NStringEntity(qryJson.toJSONString(), ContentType.APPLICATION_JSON);
        try {
            JSONObject deleteResultJson;
            int deleteCount;
            Request request = new Request("POST", endPoint);
            request.setEntity((HttpEntity)entity);
            Response response = this.client.getLowLevelClient().performRequest(request);
            String result = EntityUtils.toString((HttpEntity)response.getEntity());
            if (StringUtils.isNotBlank((CharSequence)result) && (deleteCount = (deleteResultJson = JSONObject.parseObject((String)result)).getInteger("deleted").intValue()) > 0) {
                deleteResult = true;
            }
        }
        catch (IOException e) {
            log.error("\u6839\u636e\u6761\u4ef6\u5220\u9664ES\u6570\u636e\u5931\u8d25", (Throwable)e);
        }
        return deleteResult;
    }

    public Boolean updateData(String index, String type, String id, JSONObject qryJson) {
        boolean deleteResult = false;
        IndexRequest indexRequest = new IndexRequest();
        indexRequest.index(index);
        indexRequest.id(id);
        try {
            indexRequest.source(mapper.writeValueAsString((Object)qryJson), XContentType.JSON);
            UpdateRequest updateRequest = new UpdateRequest();
            updateRequest.index(index);
            updateRequest.id(id);
            updateRequest.doc(indexRequest);
            UpdateResponse rspose = this.client.update(updateRequest, options);
            log.info(JSONObject.toJSONString((Object)rspose));
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error("es \u66f4\u65b0\u5f02\u5e38\uff1a" + e.getMessage());
            return false;
        }
        return deleteResult;
    }

    public Boolean updateBatchData(String index, Map<Long, Map<String, Object>> maps) {
        boolean deleteResult = false;
        try {
            BulkRequest request = new BulkRequest();
            maps.forEach((id, map) -> request.add(new UpdateRequest(index, id.toString()).doc(map).upsert(new Object[0])));
            BulkResponse response = this.client.bulk(request, RequestOptions.DEFAULT);
            log.info(JSONObject.toJSONString((Object)response));
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error("es \u66f4\u65b0\u5f02\u5e38\uff1a" + e.getMessage());
            return false;
        }
        return deleteResult;
    }

    public Boolean deleteData(String index, String id) {
        boolean deleteResult = false;
        IndexRequest indexRequest = new IndexRequest();
        indexRequest.index(index);
        indexRequest.id(id);
        try {
            DeleteRequest deleteRequest = new DeleteRequest();
            deleteRequest.index(index);
            deleteRequest.id(id);
            DeleteResponse rspose = this.client.delete(deleteRequest, options);
            log.info(JSONObject.toJSONString((Object)rspose));
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error("es \u5220\u9664\u5f02\u5e38\uff1a" + e.getMessage());
            return false;
        }
        return deleteResult;
    }

    public Boolean deleteBatchData(String index, List<String> ids) {
        boolean deleteResult = false;
        try {
            BulkRequest request = new BulkRequest();
            for (String id : ids) {
                request.add(((DeleteRequest)new DeleteRequest().index(index)).id(id));
            }
            BulkResponse response = this.client.bulk(request, RequestOptions.DEFAULT);
            log.info(JSONObject.toJSONString((Object)response));
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error("es \u5220\u9664\u5f02\u5e38\uff1a" + e.getMessage());
            return false;
        }
        return deleteResult;
    }

    public String updateByQuery(String index, String type, String qryJson) {
        String endPoint = "/" + index + "/" + type + "/_update_by_query";
        log.debug("source---->" + qryJson);
        NStringEntity entity = new NStringEntity(qryJson, ContentType.APPLICATION_JSON);
        Request request = new Request("POST", endPoint);
        request.setEntity((HttpEntity)entity);
        try {
            Response response = this.client.getLowLevelClient().performRequest(request);
            String result = EntityUtils.toString((HttpEntity)response.getEntity());
            return result;
        }
        catch (Exception e) {
            log.error(e.getMessage());
            return "";
        }
    }

    public String doPostSendQuery(String index, String type, String qryJson) {
        String endPoint = "/" + index + "/" + type + "/_search";
        log.debug("source---->" + qryJson);
        NStringEntity entity = new NStringEntity(qryJson, ContentType.APPLICATION_JSON);
        Request request = new Request("POST", endPoint);
        request.setEntity((HttpEntity)entity);
        try {
            Response response = this.client.getLowLevelClient().performRequest(request);
            String result = EntityUtils.toString((HttpEntity)response.getEntity());
            return result;
        }
        catch (Exception e) {
            log.error(e.getMessage());
            return "";
        }
    }

    public void bulkPutIndex(String index, String type, List<Map<String, Object>> list, String id) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        int size = list.size();
        BulkRequest request = new BulkRequest();
        for (int i = 0; i < size; ++i) {
            Map<String, Object> map = list.get(i);
            if (!StringUtils.isEmpty((CharSequence)id)) {
                request.add(new IndexRequest(index, type, String.valueOf(map.get(id))).source(map, XContentType.JSON));
                continue;
            }
            if (map.containsKey("id")) {
                request.add(new IndexRequest(index, type, String.valueOf(map.remove("id"))).source(map, XContentType.JSON));
                continue;
            }
            request.add(new IndexRequest(index, type, null).source(map, XContentType.JSON));
        }
        try {
            this.client.bulk(request, options);
        }
        catch (IOException e) {
            log.error("\u6279\u91cf\u63d2\u5165es \u5931\u8d25\uff1a" + e.getMessage());
            e.printStackTrace();
        }
    }

    public RestClient getLowLevelClient() {
        return this.client.getLowLevelClient();
    }

    public String getIndexAnalyze(String index, String qryJson) {
        String endPoint = "/" + index + "/_analyze";
        log.debug("source---->" + qryJson);
        NStringEntity entity = new NStringEntity(qryJson, ContentType.APPLICATION_JSON);
        Request request = new Request("POST", endPoint);
        request.setEntity((HttpEntity)entity);
        try {
            Response response = this.client.getLowLevelClient().performRequest(request);
            String result = EntityUtils.toString((HttpEntity)response.getEntity());
            return result;
        }
        catch (Exception e) {
            log.error(e.getMessage());
            return "";
        }
    }

    public boolean deleteIndex(String index) {
        if (StringUtils.isBlank((CharSequence)index)) {
            log.info("\u5220\u9664\u7d22\u5f15\u5185\u5bb9\u4e3a\u7a7a");
            return false;
        }
        DeleteIndexRequest request = new DeleteIndexRequest(index);
        try {
            AcknowledgedResponse indexResponse = this.client.indices().delete(request, RequestOptions.DEFAULT);
            if (indexResponse.isAcknowledged()) {
                log.info("\u5220\u9664\u7d22\u5f15\u6210\u529f");
            } else {
                log.info("\u5220\u9664\u7d22\u5f15\u5931\u8d25");
            }
            return indexResponse.isAcknowledged();
        }
        catch (Exception e) {
            log.error("\u5220\u9664\u7d22\u5f15\u5931\u8d25", (Throwable)e);
            String exceptionStr = JSON.toJSONString((Object)e.getMessage());
            return exceptionStr.contains("index_not_found_exception");
        }
    }

    public boolean createIndex(String index) {
        CreateIndexRequest request = new CreateIndexRequest(index);
        try {
            CreateIndexResponse indexResponse = this.client.indices().create(request, RequestOptions.DEFAULT);
            if (indexResponse.isAcknowledged()) {
                log.info("\u521b\u5efa\u7d22\u5f15\u6210\u529f");
            } else {
                log.info("\u521b\u5efa\u7d22\u5f15\u5931\u8d25");
            }
            return indexResponse.isAcknowledged();
        }
        catch (IOException e) {
            log.error("\u521b\u5efa\u7d22\u5f15\u5931\u8d25", (Throwable)e);
            return false;
        }
    }

    public String addJsonData(String index, String id, String jsonStr) {
        IndexRequest indexRequest = new IndexRequest(index);
        indexRequest.id(id);
        try {
            indexRequest.source(jsonStr, XContentType.JSON);
            log.info("addJsonData\u4fdd\u5b58\u6570\u636e\uff1a" + jsonStr);
            IndexResponse indexResponse = this.client.index(indexRequest, RequestOptions.DEFAULT);
            log.info("addJsonData\u4fdd\u5b58\u6570\u636e \u65b0\u589e\u6210\u529f + \uff1a" + indexResponse.getId());
            return indexResponse.getId();
        }
        catch (Exception e) {
            log.error("\u63d2\u5165\u6570\u636e\u5931\u8d25", (Throwable)e);
            throw new ZTBusinessException("\u63d2\u5165\u6570\u636e\u5931\u8d25\uff1a" + e.getMessage());
        }
    }

    public boolean checkIndexExist(String index) {
        String ok = "OK";
        boolean checkResult = false;
        try {
            Request request = new Request("HEAD", index);
            Response response = this.client.getLowLevelClient().performRequest(request);
            if (ok.equals(response.getStatusLine().getReasonPhrase())) {
                checkResult = true;
            }
        }
        catch (IOException e) {
            log.error("\u68c0\u67e5\u7d22\u5f15\u5931\u8d25", (Throwable)e);
        }
        return checkResult;
    }

    public Boolean updateDataById(String endPoint, JSONObject updateJson, String id) {
        boolean updateREsult = false;
        String esUpdateStr = this.toEsUpdateStr(id, updateJson);
        log.info("esUpdate URL:{}", (Object)endPoint);
        log.info("esUpdateStrReq:{}", (Object)esUpdateStr);
        NStringEntity entity = new NStringEntity(esUpdateStr, ContentType.APPLICATION_JSON);
        try {
            JSONObject rspJsonObject;
            Request request = new Request("POST", endPoint);
            request.setEntity((HttpEntity)entity);
            Response response = this.client.getLowLevelClient().performRequest(request);
            String result = EntityUtils.toString((HttpEntity)response.getEntity());
            log.info("esUpdateStrRsp:{}", (Object)result);
            if (StringUtils.isNotBlank((CharSequence)result) && "1".equals((rspJsonObject = JSON.parseObject((String)result)).get((Object)"updated"))) {
                updateREsult = true;
            }
        }
        catch (IOException e) {
            log.error("\u6839\u636e\u6761\u4ef6\u66f4\u65b0ES\u6570\u636e\u5931\u8d25:{},\u66f4\u65b0\u8bed\u53e5:{}", (Object)e, (Object)esUpdateStr);
        }
        return updateREsult;
    }

    public String toEsUpdateStr(String id, JSONObject updateParams) {
        JSONObject term = new JSONObject();
        term.put("_id", (Object)id);
        JSONObject query = new JSONObject();
        query.put("term", (Object)term);
        JSONObject script = new JSONObject();
        script.put("source", (Object)this.getSource(updateParams));
        script.put("lang", (Object)"painless");
        script.put("params", (Object)updateParams);
        JSONObject esJsonObj = new JSONObject();
        esJsonObj.put("query", (Object)query);
        esJsonObj.put("script", (Object)script);
        return esJsonObj.toJSONString();
    }

    private String getSource(JSONObject updateParams) {
        StringBuilder stringBuilder = new StringBuilder();
        updateParams.keySet().forEach(key -> stringBuilder.append("ctx._source.").append((String)key).append("=").append("params.").append((String)key).append(";"));
        return stringBuilder.toString();
    }
}

